/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Collections;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlAlterViewAs;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterViewAsOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConvertUtils;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlAlterViewAsConverter
implements SqlNodeConverter<SqlAlterViewAs> {
    @Override
    public Operation convertSqlNode(SqlAlterViewAs alterView, SqlNodeConverter.ConvertContext context) {
        CatalogView oldView = SqlNodeConvertUtils.validateAlterView(alterView, context);
        SqlNode newQuery = alterView.getNewQuery();
        ObjectIdentifier viewIdentifier = context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])alterView.fullViewName()));
        CatalogView newView = SqlNodeConvertUtils.toCatalogView(newQuery, Collections.emptyList(), oldView.getOptions(), oldView.getComment(), context);
        return new AlterViewAsOperation(viewIdentifier, newView);
    }
}

