/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTableAdd;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropColumn;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropConstraint;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropPrimaryKey;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropWatermark;
import org.apache.flink.sql.parser.ddl.SqlAlterTableModify;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRenameColumn;
import org.apache.flink.sql.parser.ddl.SqlAlterTableSchema;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.ddl.position.SqlTableColumnPosition;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.ColumnReferenceFinder;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

public class AlterSchemaConverter {
    private static final String EX_MSG_PREFIX = "Failed to execute ALTER TABLE statement.\n";
    private final SqlValidator sqlValidator;
    private final Function<SqlNode, String> escapeExpression;
    private final CatalogManager catalogManager;

    AlterSchemaConverter(SqlValidator sqlValidator, Function<SqlNode, String> escapeExpression, CatalogManager catalogManager) {
        this.sqlValidator = sqlValidator;
        this.escapeExpression = escapeExpression;
        this.catalogManager = catalogManager;
    }

    public Operation convertAlterSchema(SqlAlterTableSchema alterTableSchema, ResolvedCatalogTable oldTable) {
        SchemaConverter converter = this.createSchemaConverter(alterTableSchema, oldTable);
        converter.updateColumn(alterTableSchema.getColumnPositions().getList());
        alterTableSchema.getWatermark().ifPresent(x$0 -> converter.updateWatermark(x$0));
        alterTableSchema.getDistribution().ifPresent(x$0 -> converter.updateDistribution(x$0));
        alterTableSchema.getFullConstraint().ifPresent(x$0 -> converter.updatePrimaryKey(x$0));
        return this.buildAlterTableChangeOperation(alterTableSchema, converter.changesCollector, converter.convert(), oldTable);
    }

    public Operation convertAlterSchema(SqlAlterTableRenameColumn renameColumn, ResolvedCatalogTable oldTable) {
        String oldColumnName = AlterSchemaConverter.getColumnName(renameColumn.getOldColumnIdentifier());
        String newColumnName = AlterSchemaConverter.getColumnName(renameColumn.getNewColumnIdentifier());
        ReferencesManager.create(oldTable).checkReferences(oldColumnName);
        if (oldTable.getResolvedSchema().getColumn(newColumnName).isPresent()) {
            throw new ValidationException(String.format("%sThe column `%s` already existed in table schema.", EX_MSG_PREFIX, newColumnName));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        this.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> {
            if (column.getName().equals(oldColumnName)) {
                this.buildNewColumnFromOldColumn((Schema.Builder)builder, (Schema.UnresolvedColumn)column, newColumnName);
            } else {
                builder.fromColumns(Collections.singletonList(column));
            }
        });
        this.buildUpdatedPrimaryKey(schemaBuilder, oldTable, pk -> pk.equals(oldColumnName) ? newColumnName : pk);
        this.buildUpdatedWatermark(schemaBuilder, oldTable);
        return this.buildAlterTableChangeOperation(renameColumn, Collections.singletonList(TableChange.modifyColumnName((Column)((Column)this.unwrap(oldTable.getResolvedSchema().getColumn(oldColumnName))), (String)newColumnName)), schemaBuilder.build(), oldTable);
    }

    public Operation convertAlterSchema(SqlAlterTableDropColumn dropColumn, ResolvedCatalogTable oldTable) {
        HashSet columnsToDrop = new HashSet();
        dropColumn.getColumnList().forEach(identifier -> {
            String name = AlterSchemaConverter.getColumnName((SqlIdentifier)identifier);
            if (!columnsToDrop.add(name)) {
                throw new ValidationException(String.format("%sDuplicate column `%s`.", EX_MSG_PREFIX, name));
            }
        });
        ReferencesManager referencesManager = ReferencesManager.create(oldTable);
        List sortedColumnsToDrop = columnsToDrop.stream().sorted(Comparator.comparingInt(col -> referencesManager.getColumnDependencyCount((String)col)).reversed()).collect(Collectors.toList());
        ArrayList<TableChange> tableChanges = new ArrayList<TableChange>(sortedColumnsToDrop.size());
        for (String columnToDrop : sortedColumnsToDrop) {
            referencesManager.dropColumn(columnToDrop);
            tableChanges.add((TableChange)TableChange.dropColumn((String)columnToDrop));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        this.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> {
            if (!columnsToDrop.contains(column.getName())) {
                builder.fromColumns(Collections.singletonList(column));
            }
        });
        this.buildUpdatedPrimaryKey(schemaBuilder, oldTable, Function.identity());
        this.buildUpdatedWatermark(schemaBuilder, oldTable);
        return this.buildAlterTableChangeOperation(dropColumn, tableChanges, schemaBuilder.build(), oldTable);
    }

    public Operation convertAlterSchema(SqlAlterTableDropPrimaryKey dropPrimaryKey, ResolvedCatalogTable oldTable) {
        Optional pkConstraint = oldTable.getResolvedSchema().getPrimaryKey();
        if (!pkConstraint.isPresent()) {
            throw new ValidationException(String.format("%sThe base table does not define any primary key.", EX_MSG_PREFIX));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        this.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> builder.fromColumns(Collections.singletonList(column)));
        this.buildUpdatedWatermark(schemaBuilder, oldTable);
        return this.buildAlterTableChangeOperation(dropPrimaryKey, Collections.singletonList(TableChange.dropConstraint((String)((UniqueConstraint)pkConstraint.get()).getName())), schemaBuilder.build(), oldTable);
    }

    public Operation convertAlterSchema(SqlAlterTableDropConstraint dropConstraint, ResolvedCatalogTable oldTable) {
        Optional pkConstraint = oldTable.getResolvedSchema().getPrimaryKey();
        if (!pkConstraint.isPresent()) {
            throw new ValidationException(String.format("%sThe base table does not define any primary key.", EX_MSG_PREFIX));
        }
        SqlIdentifier constraintIdentifier = dropConstraint.getConstraintName();
        String constraintName = ((UniqueConstraint)pkConstraint.get()).getName();
        if (constraintIdentifier != null && !constraintIdentifier.getSimple().equals(constraintName)) {
            throw new ValidationException(String.format("%sThe base table does not define a primary key constraint named '%s'. Available constraint name: ['%s'].", EX_MSG_PREFIX, constraintIdentifier.getSimple(), constraintName));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        this.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> builder.fromColumns(Collections.singletonList(column)));
        this.buildUpdatedWatermark(schemaBuilder, oldTable);
        return this.buildAlterTableChangeOperation(dropConstraint, Collections.singletonList(TableChange.dropConstraint((String)constraintName)), schemaBuilder.build(), oldTable);
    }

    public Operation convertAlterSchema(SqlAlterTableDropWatermark dropWatermark, ResolvedCatalogTable oldTable) {
        if (oldTable.getResolvedSchema().getWatermarkSpecs().isEmpty()) {
            throw new ValidationException(String.format("%sThe base table does not define any watermark strategy.", EX_MSG_PREFIX));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        this.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> builder.fromColumns(Collections.singletonList(column)));
        this.buildUpdatedPrimaryKey(schemaBuilder, oldTable, Function.identity());
        return this.buildAlterTableChangeOperation(dropWatermark, Collections.singletonList(TableChange.dropWatermark()), schemaBuilder.build(), oldTable);
    }

    private void buildUpdatedColumn(Schema.Builder builder, ResolvedCatalogTable oldTable, BiConsumer<Schema.Builder, Schema.UnresolvedColumn> columnConsumer) {
        oldTable.getUnresolvedSchema().getColumns().forEach(column -> columnConsumer.accept(builder, (Schema.UnresolvedColumn)column));
    }

    private void buildUpdatedPrimaryKey(Schema.Builder builder, ResolvedCatalogTable oldTable, Function<String, String> columnRenamer) {
        oldTable.getUnresolvedSchema().getPrimaryKey().ifPresent(pk -> {
            List oldPrimaryKeyNames = pk.getColumnNames();
            String constrainName = pk.getConstraintName();
            List newPrimaryKeyNames = oldPrimaryKeyNames.stream().map(columnRenamer).collect(Collectors.toList());
            builder.primaryKeyNamed(constrainName, newPrimaryKeyNames);
        });
    }

    private void buildUpdatedWatermark(Schema.Builder builder, ResolvedCatalogTable oldTable) {
        oldTable.getUnresolvedSchema().getWatermarkSpecs().forEach(watermarkSpec -> builder.watermark(watermarkSpec.getColumnName(), watermarkSpec.getWatermarkExpression()));
    }

    private void buildNewColumnFromOldColumn(Schema.Builder builder, Schema.UnresolvedColumn oldColumn, String columnName) {
        if (oldColumn instanceof Schema.UnresolvedComputedColumn) {
            builder.columnByExpression(columnName, ((Schema.UnresolvedComputedColumn)oldColumn).getExpression());
        } else if (oldColumn instanceof Schema.UnresolvedPhysicalColumn) {
            builder.column(columnName, ((Schema.UnresolvedPhysicalColumn)oldColumn).getDataType());
        } else if (oldColumn instanceof Schema.UnresolvedMetadataColumn) {
            Schema.UnresolvedMetadataColumn metadataColumn = (Schema.UnresolvedMetadataColumn)oldColumn;
            builder.columnByMetadata(columnName, metadataColumn.getDataType(), metadataColumn.getMetadataKey(), metadataColumn.isVirtual());
        }
        oldColumn.getComment().ifPresent(arg_0 -> ((Schema.Builder)builder).withComment(arg_0));
    }

    private Operation buildAlterTableChangeOperation(SqlAlterTable alterTable, List<TableChange> tableChanges, Schema newSchema, ResolvedCatalogTable oldTable) {
        CatalogTable.Builder builder = CatalogTable.newBuilder().schema(newSchema).comment(oldTable.getComment()).partitionKeys(oldTable.getPartitionKeys()).options(oldTable.getOptions());
        if (alterTable instanceof SqlAlterTableSchema) {
            ((SqlAlterTableSchema)alterTable).getDistribution().ifPresent(distribution -> builder.distribution(OperationConverterUtils.getDistributionFromSqlDistribution(distribution)));
        }
        return new AlterTableChangeOperation(this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])alterTable.fullTableName())), tableChanges, builder.build(), alterTable.ifTableExists());
    }

    private static String getColumnName(SqlIdentifier identifier) {
        if (!identifier.isSimple()) {
            throw new UnsupportedOperationException(String.format("%sAlter nested row type %s is not supported yet.", EX_MSG_PREFIX, identifier));
        }
        return identifier.getSimple();
    }

    private SchemaConverter createSchemaConverter(SqlAlterTableSchema alterTableSchema, ResolvedCatalogTable oldTable) {
        if (alterTableSchema instanceof SqlAlterTableAdd) {
            return new AddSchemaConverter(oldTable, oldTable.getUnresolvedSchema(), (FlinkTypeFactory)this.sqlValidator.getTypeFactory(), this.sqlValidator, this.escapeExpression, this.catalogManager.getSchemaResolver());
        }
        if (alterTableSchema instanceof SqlAlterTableModify) {
            return new ModifySchemaConverter(oldTable, (FlinkTypeFactory)this.sqlValidator.getTypeFactory(), this.sqlValidator, this.escapeExpression, this.catalogManager.getSchemaResolver());
        }
        throw new UnsupportedOperationException(String.format("Unsupported alter table schema class: %s", alterTableSchema.getClass().getCanonicalName()));
    }

    private <T> T unwrap(Optional<T> value) {
        return value.orElseThrow(() -> new TableException("The value should never be empty."));
    }

    private static class ReferencesManager {
        private final Set<String> columns;
        private final Map<String, Set<String>> columnToReferences;
        private final Map<String, Set<String>> columnToDependencies;
        private final Set<String> primaryKeys;
        private final Set<String> watermarkReferences;
        private final Set<String> partitionKeys;
        private final Set<String> distributionKeys;

        private ReferencesManager(Set<String> columns, Map<String, Set<String>> columnToReferences, Map<String, Set<String>> columnToDependencies, Set<String> primaryKeys, Set<String> watermarkReferences, Set<String> partitionKeys, Set<String> distributionKeys) {
            this.columns = columns;
            this.columnToReferences = columnToReferences;
            this.columnToDependencies = columnToDependencies;
            this.primaryKeys = primaryKeys;
            this.watermarkReferences = watermarkReferences;
            this.partitionKeys = partitionKeys;
            this.distributionKeys = distributionKeys;
        }

        static ReferencesManager create(ResolvedCatalogTable catalogTable) {
            HashMap<String, Set<String>> columnToReferences = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> columnToDependencies = new HashMap<String, Set<String>>();
            catalogTable.getResolvedSchema().getColumns().stream().filter(column -> column instanceof Column.ComputedColumn).forEach(column -> {
                Set<String> referencedColumns = ColumnReferenceFinder.findReferencedColumn(column.getName(), catalogTable.getResolvedSchema());
                for (String referencedColumn : referencedColumns) {
                    columnToReferences.computeIfAbsent(referencedColumn, key -> new HashSet()).add(column.getName());
                    columnToDependencies.computeIfAbsent(column.getName(), key -> new HashSet()).add(referencedColumn);
                }
            });
            return new ReferencesManager(new HashSet<String>(catalogTable.getResolvedSchema().getColumnNames()), columnToReferences, columnToDependencies, catalogTable.getResolvedSchema().getPrimaryKey().map(constraint -> new HashSet(constraint.getColumns())).orElse(new HashSet()), ColumnReferenceFinder.findWatermarkReferencedColumn(catalogTable.getResolvedSchema()), new HashSet<String>(catalogTable.getPartitionKeys()), new HashSet<String>(catalogTable.getDistribution().map(TableDistribution::getBucketKeys).orElse(Collections.emptyList())));
        }

        void dropColumn(String columnName) {
            this.checkReferences(columnName);
            if (this.primaryKeys.contains(columnName)) {
                throw new ValidationException(String.format("%sThe column %s is used as the primary key.", AlterSchemaConverter.EX_MSG_PREFIX, EncodingUtils.escapeIdentifier((String)columnName)));
            }
            this.columnToDependencies.getOrDefault(columnName, Collections.emptySet()).forEach(referredColumn -> this.columnToReferences.get(referredColumn).remove(columnName));
            this.columnToDependencies.remove(columnName);
            this.columns.remove(columnName);
        }

        int getColumnDependencyCount(String columnName) {
            return this.columnToDependencies.getOrDefault(columnName, Collections.emptySet()).size();
        }

        void checkReferences(String columnName) {
            if (!this.columns.contains(columnName)) {
                throw new ValidationException(String.format("%sThe column `%s` does not exist in the base table.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
            }
            if (this.columnToReferences.containsKey(columnName) && !this.columnToReferences.get(columnName).isEmpty()) {
                throw new ValidationException(String.format("%sThe column %s is referenced by computed column %s.", AlterSchemaConverter.EX_MSG_PREFIX, EncodingUtils.escapeIdentifier((String)columnName), this.columnToReferences.get(columnName).stream().map(EncodingUtils::escapeIdentifier).sorted().collect(Collectors.joining(", "))));
            }
            if (this.partitionKeys.contains(columnName)) {
                throw new ValidationException(String.format("%sThe column `%s` is used as the partition keys.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
            }
            if (this.watermarkReferences.contains(columnName)) {
                throw new ValidationException(String.format("%sThe column `%s` is referenced by watermark expression.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
            }
            if (this.distributionKeys.contains(columnName)) {
                throw new ValidationException(String.format("%sThe column `%s` is used as a distribution key.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
            }
        }
    }

    private class ModifySchemaConverter
    extends SchemaConverter {
        private final ResolvedCatalogTable oldTable;

        ModifySchemaConverter(ResolvedCatalogTable oldTable, FlinkTypeFactory typeFactory, SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions, SchemaResolver schemaResolver) {
            super(oldTable, oldTable.getUnresolvedSchema(), typeFactory, sqlValidator, escapeExpressions, schemaResolver);
            this.oldTable = oldTable;
        }

        @Override
        void updatePositionAndCollectColumnChange(SqlTableColumnPosition columnPosition, String columnName) {
            if (!this.sortedColumnNames.contains(columnName)) {
                throw new ValidationException(String.format("%sTry to modify a column `%s` which does not exist in the table.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
            }
            Column oldColumn = (Column)AlterSchemaConverter.this.unwrap(this.oldTable.getResolvedSchema().getColumn(columnName));
            if (columnPosition.isFirstColumn()) {
                this.sortedColumnNames.remove(columnName);
                this.sortedColumnNames.add(0, columnName);
                this.changeBuilders.add(schema -> OperationConverterUtils.buildModifyColumnChange(oldColumn, (Column)AlterSchemaConverter.this.unwrap(schema.getColumn(columnName)), TableChange.ColumnPosition.first()));
            } else if (columnPosition.isAfterReferencedColumn()) {
                String referenceName = this.getReferencedColumn(columnPosition);
                this.sortedColumnNames.remove(columnName);
                this.sortedColumnNames.add(this.sortedColumnNames.indexOf(referenceName) + 1, columnName);
                this.changeBuilders.add(schema -> OperationConverterUtils.buildModifyColumnChange(oldColumn, (Column)AlterSchemaConverter.this.unwrap(schema.getColumn(columnName)), TableChange.ColumnPosition.after((String)referenceName)));
            } else {
                this.changeBuilders.add(schema -> OperationConverterUtils.buildModifyColumnChange(oldColumn, (Column)AlterSchemaConverter.this.unwrap(schema.getColumn(columnName)), null));
            }
        }

        @Override
        void checkAndCollectPrimaryKeyChange() {
            if (this.primaryKey == null) {
                throw new ValidationException(String.format("%sThe base table does not define any primary key constraint. You might want to add a new one.", AlterSchemaConverter.EX_MSG_PREFIX));
            }
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.modify((UniqueConstraint)((UniqueConstraint)AlterSchemaConverter.this.unwrap(schema.getPrimaryKey())))));
        }

        @Override
        void checkAndCollectDistributionChange(TableDistribution newDistribution) {
            if (this.distribution == null) {
                throw new ValidationException(String.format("%sThe base table does not define any distribution. You might want to add a new one.", AlterSchemaConverter.EX_MSG_PREFIX));
            }
            this.changesCollector.add(TableChange.modify((TableDistribution)newDistribution));
        }

        @Override
        void checkAndCollectWatermarkChange() {
            if (this.watermarkSpec == null) {
                throw new ValidationException(String.format("%sThe base table does not define any watermark. You might want to add a new one.", AlterSchemaConverter.EX_MSG_PREFIX));
            }
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.modify((WatermarkSpec)((WatermarkSpec)schema.getWatermarkSpecs().get(0)))));
        }

        @Override
        @Nullable
        String getComment(SqlTableColumn column) {
            String comment = super.getComment(column);
            return comment == null ? (String)((Schema.UnresolvedColumn)this.columns.get(column.getName().getSimple())).getComment().orElse(null) : comment;
        }
    }

    private class AddSchemaConverter
    extends SchemaConverter {
        AddSchemaConverter(ResolvedCatalogTable oldTable, Schema oldSchema, FlinkTypeFactory typeFactory, SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions, SchemaResolver schemaResolver) {
            super(oldTable, oldSchema, typeFactory, sqlValidator, escapeExpressions, schemaResolver);
        }

        @Override
        void checkAndCollectPrimaryKeyChange() {
            if (this.primaryKey != null) {
                throw new ValidationException(String.format("%sThe base table has already defined the primary key constraint %s. You might want to drop it before adding a new one.", AlterSchemaConverter.EX_MSG_PREFIX, this.primaryKey.getColumnNames().stream().collect(Collectors.joining("`, `", "[`", "`]"))));
            }
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((UniqueConstraint)((UniqueConstraint)AlterSchemaConverter.this.unwrap(schema.getPrimaryKey())))));
        }

        @Override
        void checkAndCollectDistributionChange(TableDistribution newDistribution) {
            if (this.distribution != null) {
                throw new ValidationException(String.format("%sThe base table has already defined the distribution `%s`. You can modify it or drop it before adding a new one.", AlterSchemaConverter.EX_MSG_PREFIX, this.distribution));
            }
            this.changesCollector.add(TableChange.add((TableDistribution)newDistribution));
        }

        @Override
        void checkAndCollectWatermarkChange() {
            if (this.watermarkSpec != null) {
                throw new ValidationException(String.format("%sThe base table has already defined the watermark strategy `%s` AS %s. You might want to drop it before adding a new one.", AlterSchemaConverter.EX_MSG_PREFIX, this.watermarkSpec.getColumnName(), ((SqlCallExpression)this.watermarkSpec.getWatermarkExpression()).getSqlExpression()));
            }
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((WatermarkSpec)((WatermarkSpec)schema.getWatermarkSpecs().get(0)))));
        }

        @Override
        void updatePositionAndCollectColumnChange(SqlTableColumnPosition columnPosition, String columnName) {
            if (this.sortedColumnNames.contains(columnName)) {
                throw new ValidationException(String.format("%sTry to add a column `%s` which already exists in the table.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
            }
            if (columnPosition.isFirstColumn()) {
                this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((Column)((Column)AlterSchemaConverter.this.unwrap(schema.getColumn(columnName))), (TableChange.ColumnPosition)TableChange.ColumnPosition.first())));
                this.sortedColumnNames.add(0, columnName);
            } else if (columnPosition.isAfterReferencedColumn()) {
                String referenceName = this.getReferencedColumn(columnPosition);
                this.sortedColumnNames.add(this.sortedColumnNames.indexOf(referenceName) + 1, columnName);
                this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((Column)((Column)AlterSchemaConverter.this.unwrap(schema.getColumn(columnName))), (TableChange.ColumnPosition)TableChange.ColumnPosition.after((String)referenceName))));
            } else {
                this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((Column)((Column)AlterSchemaConverter.this.unwrap(schema.getColumn(columnName))))));
                this.sortedColumnNames.add(columnName);
            }
        }
    }

    private static abstract class SchemaConverter {
        List<String> sortedColumnNames = new ArrayList<String>();
        Set<String> alterColNames = new HashSet<String>();
        Map<String, Schema.UnresolvedColumn> columns = new HashMap<String, Schema.UnresolvedColumn>();
        @Nullable
        Schema.UnresolvedWatermarkSpec watermarkSpec = null;
        @Nullable
        TableDistribution distribution = null;
        @Nullable
        Schema.UnresolvedPrimaryKey primaryKey = null;
        Function<SqlNode, String> escapeExpressions;
        FlinkTypeFactory typeFactory;
        SqlValidator sqlValidator;
        SchemaResolver schemaResolver;
        List<TableChange> changesCollector;
        List<Function<ResolvedSchema, List<TableChange>>> changeBuilders = new ArrayList<Function<ResolvedSchema, List<TableChange>>>();

        SchemaConverter(ResolvedCatalogTable oldTable, Schema oldSchema, FlinkTypeFactory typeFactory, SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions, SchemaResolver schemaResolver) {
            this.typeFactory = typeFactory;
            this.sqlValidator = sqlValidator;
            this.escapeExpressions = escapeExpressions;
            this.schemaResolver = schemaResolver;
            this.changesCollector = new ArrayList<TableChange>();
            this.populateColumnsFromSourceTable(oldSchema);
            this.populatePrimaryKeyFromSourceTable(oldSchema);
            this.populateWatermarkFromSourceTable(oldSchema);
            this.populateDistributionFromSourceTable(oldTable);
        }

        private void populateColumnsFromSourceTable(Schema oldSchema) {
            oldSchema.getColumns().forEach(column -> {
                String name = column.getName();
                this.sortedColumnNames.add(name);
                this.columns.put(name, (Schema.UnresolvedColumn)column);
            });
        }

        private void populatePrimaryKeyFromSourceTable(Schema oldSchema) {
            if (oldSchema.getPrimaryKey().isPresent()) {
                this.primaryKey = (Schema.UnresolvedPrimaryKey)oldSchema.getPrimaryKey().get();
            }
        }

        private void populateDistributionFromSourceTable(ResolvedCatalogTable oldTable) {
            oldTable.getDistribution().ifPresent(distribution -> {
                this.distribution = distribution;
            });
        }

        private void populateWatermarkFromSourceTable(Schema oldSchema) {
            Iterator iterator = oldSchema.getWatermarkSpecs().iterator();
            while (iterator.hasNext()) {
                Schema.UnresolvedWatermarkSpec sourceWatermarkSpec;
                this.watermarkSpec = sourceWatermarkSpec = (Schema.UnresolvedWatermarkSpec)iterator.next();
            }
        }

        private void updateColumn(List<SqlNode> alterColumnPositions) {
            this.applyColumnPosition(alterColumnPositions);
            for (SqlNode sqlNode : alterColumnPositions) {
                Schema.UnresolvedComputedColumn newColumn;
                SqlTableColumnPosition alterColumnPos = (SqlTableColumnPosition)sqlNode;
                SqlTableColumn alterColumn = alterColumnPos.getColumn();
                if (alterColumn instanceof SqlTableColumn.SqlComputedColumn) {
                    newColumn = this.convertComputedColumn((SqlTableColumn.SqlComputedColumn)alterColumn);
                } else if (alterColumn instanceof SqlTableColumn.SqlMetadataColumn) {
                    newColumn = this.convertMetadataColumn((SqlTableColumn.SqlMetadataColumn)alterColumn);
                } else if (alterColumn instanceof SqlTableColumn.SqlRegularColumn) {
                    newColumn = this.convertPhysicalColumn((SqlTableColumn.SqlRegularColumn)alterColumn);
                } else {
                    throw new UnsupportedOperationException(String.format("Unsupported sql table column class: %s", alterColumn.getClass().getCanonicalName()));
                }
                this.columns.put(newColumn.getName(), (Schema.UnresolvedColumn)newColumn);
            }
        }

        private void updatePrimaryKey(SqlTableConstraint alterPrimaryKey) {
            this.checkAndCollectPrimaryKeyChange();
            List<String> primaryKeyColumns = Arrays.asList(alterPrimaryKey.getColumnNames());
            this.primaryKey = new Schema.UnresolvedPrimaryKey(alterPrimaryKey.getConstraintName().orElseGet(() -> primaryKeyColumns.stream().collect(Collectors.joining("_", "PK_", ""))), primaryKeyColumns);
        }

        private void updatePrimaryKeyNullability(String columnName) {
            Schema.UnresolvedColumn column = this.columns.get(columnName);
            if (column instanceof Schema.UnresolvedPhysicalColumn) {
                AbstractDataType oldType = ((Schema.UnresolvedPhysicalColumn)column).getDataType();
                this.columns.put(columnName, (Schema.UnresolvedColumn)new Schema.UnresolvedPhysicalColumn(columnName, oldType.notNull(), (String)column.getComment().orElse(null)));
            }
        }

        private void updateWatermark(SqlWatermark alterWatermarkSpec) {
            this.checkAndCollectWatermarkChange();
            SqlIdentifier eventTimeColumnName = alterWatermarkSpec.getEventTimeColumnName();
            if (!eventTimeColumnName.isSimple()) {
                throw new ValidationException(String.format("%sWatermark strategy on nested column is not supported yet.", AlterSchemaConverter.EX_MSG_PREFIX));
            }
            this.watermarkSpec = new Schema.UnresolvedWatermarkSpec(eventTimeColumnName.getSimple(), (Expression)new SqlCallExpression(this.escapeExpressions.apply(alterWatermarkSpec.getWatermarkStrategy())));
        }

        private void updateDistribution(SqlDistribution distribution) {
            TableDistribution tableDistribution = OperationConverterUtils.getDistributionFromSqlDistribution(distribution);
            this.checkAndCollectDistributionChange(tableDistribution);
            this.distribution = OperationConverterUtils.getDistributionFromSqlDistribution(distribution);
        }

        Schema.UnresolvedPhysicalColumn convertPhysicalColumn(SqlTableColumn.SqlRegularColumn physicalColumn) {
            DataType dataType = this.getDataType(physicalColumn.getType());
            return new Schema.UnresolvedPhysicalColumn(physicalColumn.getName().getSimple(), (AbstractDataType)dataType, this.getComment(physicalColumn));
        }

        private Schema.UnresolvedMetadataColumn convertMetadataColumn(SqlTableColumn.SqlMetadataColumn metadataColumn) {
            DataType dataType = this.getDataType(metadataColumn.getType());
            return new Schema.UnresolvedMetadataColumn(metadataColumn.getName().getSimple(), (AbstractDataType)dataType, (String)metadataColumn.getMetadataAlias().orElse(null), metadataColumn.isVirtual(), this.getComment(metadataColumn));
        }

        private Schema.UnresolvedComputedColumn convertComputedColumn(SqlTableColumn.SqlComputedColumn column) {
            return new Schema.UnresolvedComputedColumn(column.getName().getSimple(), (Expression)new SqlCallExpression(this.escapeExpressions.apply(column.getExpr())), this.getComment(column));
        }

        private DataType getDataType(SqlDataTypeSpec typeSpec) {
            RelDataType relType = typeSpec.deriveType(this.sqlValidator, typeSpec.getNullable() == null || typeSpec.getNullable() != false);
            return TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(relType));
        }

        @Nullable
        String getComment(SqlTableColumn column) {
            return OperationConverterUtils.getComment(column);
        }

        private void applyColumnPosition(List<SqlNode> alterColumns) {
            for (SqlNode alterColumn : alterColumns) {
                SqlTableColumnPosition columnPosition = (SqlTableColumnPosition)alterColumn;
                SqlTableColumn column = columnPosition.getColumn();
                String columnName = AlterSchemaConverter.getColumnName(column.getName());
                if (!this.alterColNames.add(columnName)) {
                    throw new ValidationException(String.format("%sEncounter duplicate column `%s`.", AlterSchemaConverter.EX_MSG_PREFIX, columnName));
                }
                this.updatePositionAndCollectColumnChange(columnPosition, columnName);
            }
        }

        protected String getReferencedColumn(SqlTableColumnPosition columnPosition) {
            SqlIdentifier referencedIdent = columnPosition.getAfterReferencedColumn();
            Preconditions.checkNotNull((Object)referencedIdent, (String)String.format("%sCould not refer to a null column", AlterSchemaConverter.EX_MSG_PREFIX));
            if (!referencedIdent.isSimple()) {
                throw new UnsupportedOperationException(String.format("%sAlter nested row type is not supported yet.", AlterSchemaConverter.EX_MSG_PREFIX));
            }
            String referencedName = referencedIdent.getSimple();
            if (!this.sortedColumnNames.contains(referencedName)) {
                throw new ValidationException(String.format("%sReferenced column `%s` by 'AFTER' does not exist in the table.", AlterSchemaConverter.EX_MSG_PREFIX, referencedName));
            }
            return referencedName;
        }

        private Schema convert() {
            Schema.Builder resultBuilder = Schema.newBuilder();
            if (this.primaryKey != null) {
                String constraintName = this.primaryKey.getConstraintName();
                List pkColumns = this.primaryKey.getColumnNames();
                pkColumns.forEach(this::updatePrimaryKeyNullability);
                if (constraintName != null) {
                    resultBuilder.primaryKeyNamed(constraintName, pkColumns);
                } else {
                    resultBuilder.primaryKey(pkColumns);
                }
            }
            ArrayList<Schema.UnresolvedColumn> newColumns = new ArrayList<Schema.UnresolvedColumn>();
            for (String column : this.sortedColumnNames) {
                newColumns.add(this.columns.get(column));
            }
            resultBuilder.fromColumns(newColumns);
            if (this.watermarkSpec != null) {
                resultBuilder.watermark(this.watermarkSpec.getColumnName(), this.watermarkSpec.getWatermarkExpression());
            }
            Schema updatedSchema = resultBuilder.build();
            try {
                ResolvedSchema resolvedSchema = this.schemaResolver.resolve(updatedSchema);
                this.changesCollector.addAll(this.changeBuilders.stream().flatMap(changeBuilder -> ((List)changeBuilder.apply(resolvedSchema)).stream()).collect(Collectors.toList()));
                return updatedSchema;
            }
            catch (Exception e) {
                throw new ValidationException(String.format("%s%s", AlterSchemaConverter.EX_MSG_PREFIX, e.getMessage()), (Throwable)e);
            }
        }

        abstract void updatePositionAndCollectColumnChange(SqlTableColumnPosition var1, String var2);

        abstract void checkAndCollectPrimaryKeyChange();

        abstract void checkAndCollectDistributionChange(TableDistribution var1);

        abstract void checkAndCollectWatermarkChange();
    }
}

