/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlShowProcedures
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW PROCEDURES", SqlKind.OTHER);
    @Nullable
    private final SqlIdentifier databaseName;
    @Nullable
    private final String preposition;
    private final boolean notLike;
    @Nullable
    private final String likeType;
    @Nullable
    private final SqlCharStringLiteral likeLiteral;

    public SqlShowProcedures(SqlParserPos pos, @Nullable String preposition, @Nullable SqlIdentifier databaseName, boolean notLike, @Nullable String likeType, @Nullable SqlCharStringLiteral likeLiteral) {
        super(pos);
        this.preposition = preposition;
        SqlIdentifier sqlIdentifier = this.databaseName = preposition != null ? Objects.requireNonNull(databaseName, "Database name must not be null.") : null;
        if (likeType != null) {
            this.likeType = likeType;
            this.likeLiteral = Objects.requireNonNull(likeLiteral, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.likeLiteral = null;
            this.notLike = false;
        }
    }

    public String getLikeSqlPattern() {
        return Objects.isNull(this.likeLiteral) ? null : this.likeLiteral.getValueAs(String.class);
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public String getLikeType() {
        return this.likeType;
    }

    public SqlCharStringLiteral getLikeLiteral() {
        return this.likeLiteral;
    }

    public String getPreposition() {
        return this.preposition;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Objects.isNull(this.databaseName) ? Collections.emptyList() : Collections.singletonList(this.databaseName);
    }

    public String[] fullDatabaseName() {
        return Objects.isNull(this.databaseName) ? new String[]{} : this.databaseName.names.toArray(new String[0]);
    }

    public boolean isWithLike() {
        return this.likeType != null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.preposition == null) {
            writer.keyword("SHOW PROCEDURES");
        } else if (this.databaseName != null) {
            writer.keyword("SHOW PROCEDURES " + this.preposition);
            this.databaseName.unparse(writer, leftPrec, rightPrec);
        }
        if (this.isWithLike()) {
            if (this.isNotLike()) {
                writer.keyword(String.format("NOT %s '%s'", this.likeType, this.getLikeSqlPattern()));
            } else {
                writer.keyword(String.format("%s '%s'", this.likeType, this.getLikeSqlPattern()));
            }
        }
    }
}

