/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTable;

public class SqlAlterMaterializedTableRefreshMode
extends SqlAlterMaterializedTable {
    private final SqlLiteral sqlRefreshMode;

    public SqlAlterMaterializedTableRefreshMode(SqlParserPos pos, SqlIdentifier tableName, SqlLiteral sqlRefreshMode) {
        super(pos, tableName);
        this.sqlRefreshMode = Objects.requireNonNull(sqlRefreshMode, "refreshMode should not be null");
    }

    public SqlLiteral getSqlRefreshMode() {
        return this.sqlRefreshMode;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.getTableName());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET REFRESH_MODE");
        writer.keyword("=");
        this.sqlRefreshMode.unparse(writer, leftPrec, rightPrec);
    }
}

