/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.cache.CacheBuilder;
import org.apache.flink.calcite.shaded.com.google.common.cache.CacheLoader;
import org.apache.flink.calcite.shaded.com.google.common.cache.LoadingCache;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;

public class SqlLibraryOperatorTableFactory {
    private final ImmutableList<Class> classes;
    public static final SqlLibraryOperatorTableFactory INSTANCE = new SqlLibraryOperatorTableFactory(SqlLibraryOperators.class);
    private final LoadingCache<ImmutableSet<SqlLibrary>, SqlOperatorTable> cache = CacheBuilder.newBuilder().build(CacheLoader.from(this::create));

    private SqlLibraryOperatorTableFactory(Class ... classes) {
        this.classes = ImmutableList.copyOf(classes);
    }

    private SqlOperatorTable create(ImmutableSet<SqlLibrary> librarySet) {
        ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
        boolean custom = false;
        boolean standard = false;
        block6: for (SqlLibrary library : librarySet) {
            switch (library) {
                case STANDARD: {
                    standard = true;
                    continue block6;
                }
                case SPATIAL: {
                    list.addAll(SqlOperatorTables.spatialInstance().getOperatorList());
                    continue block6;
                }
            }
            custom = true;
        }
        if (custom) {
            for (Class aClass : this.classes) {
                for (Field field : aClass.getFields()) {
                    try {
                        SqlOperator op;
                        if (!SqlOperator.class.isAssignableFrom(field.getType()) || !SqlLibraryOperatorTableFactory.operatorIsInLibrary((op = (SqlOperator)Objects.requireNonNull(field.get(this), () -> "null value of " + field + " for " + this)).getName(), field, librarySet)) continue;
                        list.add(op);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw Util.throwAsRuntime(Util.causeOrSelf(e));
                    }
                }
            }
        }
        SqlOperatorTable operatorTable = SqlOperatorTables.of(list);
        if (standard) {
            operatorTable = SqlOperatorTables.chain(SqlStdOperatorTable.instance(), operatorTable);
        }
        return operatorTable;
    }

    private static boolean operatorIsInLibrary(String operatorName, Field field, Set<SqlLibrary> seekLibrarySet) {
        LibraryOperator libraryOperator = field.getAnnotation(LibraryOperator.class);
        if (libraryOperator == null) {
            throw new AssertionError((Object)("Operator must have annotation: " + operatorName));
        }
        SqlLibrary[] librarySet = libraryOperator.libraries();
        if (librarySet.length <= 0) {
            throw new AssertionError((Object)("Operator must belong to at least one library: " + operatorName));
        }
        for (SqlLibrary library : librarySet) {
            if (!seekLibrarySet.contains((Object)library)) continue;
            return true;
        }
        return false;
    }

    public SqlOperatorTable getOperatorTable(SqlLibrary ... libraries) {
        return this.getOperatorTable(ImmutableSet.copyOf(libraries));
    }

    public SqlOperatorTable getOperatorTable(Iterable<SqlLibrary> librarySet) {
        try {
            return this.cache.get(ImmutableSet.copyOf(librarySet));
        }
        catch (ExecutionException e) {
            throw Util.throwAsRuntime("populating SqlOperatorTable for library " + librarySet, Util.causeOrSelf(e));
        }
    }
}

