/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.internal.AllocateDirectWritableMap;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AllocateDirectMapMemoryTest {
    private static final String LS = System.getProperty("line.separator");

    @BeforeClass
    public void setReadOnly() {
        UtilTest.setGettysburgAddressFileToReadOnly();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void simpleMap() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((boolean)AllocateDirectWritableMap.isFileReadOnly((File)file));
        try (Memory mem = Memory.map((File)file);){
            mem.close();
        }
    }

    @Test
    public void printGettysbergAddress() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try (Memory mem = Memory.map((File)file);){
            int len1 = (int)mem.getCapacity();
            AllocateDirectMapMemoryTest.println("Mem Cap:       " + len1);
            AllocateDirectMapMemoryTest.println("Total Offset:  " + mem.getRelativeOffset());
            AllocateDirectMapMemoryTest.println("Cum Offset:    " + ((ResourceImpl)mem).getCumulativeOffset(0L));
            AllocateDirectMapMemoryTest.println("Total Offset: " + mem.getRelativeOffset());
            byte[] bArr = new byte[len1];
            mem.getByteArray(0L, bArr, 0, len1);
            String s = new String(bArr, StandardCharsets.UTF_8);
            AllocateDirectMapMemoryTest.println(s);
            AllocateDirectMapMemoryTest.println("");
            Memory mem2 = mem.region(119L, 34L);
            int len2 = (int)mem2.getCapacity();
            AllocateDirectMapMemoryTest.println("Mem Cap:       " + len2);
            AllocateDirectMapMemoryTest.println("Offset:        " + mem.getRelativeOffset());
            AllocateDirectMapMemoryTest.println("Cum Offset:    " + ((ResourceImpl)mem2).getCumulativeOffset(0L));
            AllocateDirectMapMemoryTest.println("Total Offset: " + mem2.getRelativeOffset());
            byte[] bArr2 = new byte[len2];
            mem2.getByteArray(0L, bArr2, 0, len2);
            String s2 = new String(bArr2, StandardCharsets.UTF_8);
            AllocateDirectMapMemoryTest.println(s2);
            Assert.assertEquals((String)s2, (String)"a new nation, conceived in Liberty");
        }
    }

    @Test
    public void testIllegalArguments() throws IOException {
        Throwable throwable;
        Memory mem2;
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try {
            mem2 = Memory.map((File)file, (long)-1L, (long)Integer.MAX_VALUE, (ByteOrder)ByteOrder.nativeOrder());
            throwable = null;
            try {
                Assert.fail((String)"Failed: Position was negative.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mem2 != null) {
                    if (throwable != null) {
                        try {
                            mem2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        mem2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException mem2) {
            // empty catch block
        }
        try {
            mem2 = Memory.map((File)file, (long)0L, (long)-1L, (ByteOrder)ByteOrder.nativeOrder());
            throwable = null;
            try {
                Assert.fail((String)"Failed: Size was negative.");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (mem2 != null) {
                    if (throwable != null) {
                        try {
                            mem2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        mem2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testAccessAfterClose() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            Assert.assertEquals((long)memCapacity, (long)mem.getCapacity());
        }
        mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());
        mem.close();
        mem.getCapacity();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testReadFailAfterClose() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());
        mem.close();
        mem.isLoaded();
    }

    @Test
    public void testLoad() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            mem.load();
            Assert.assertTrue((boolean)mem.isLoaded());
        }
    }

    @Test
    public void printlnTest() {
        AllocateDirectMapMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            AllocateDirectMapMemoryTest.print(LS);
        } else {
            AllocateDirectMapMemoryTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

