/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.converters.AbstractConverter;

public final class ClassConverter<T>
extends AbstractConverter<Class<T>> {
    public ClassConverter() {
    }

    public ClassConverter(Class<T> defaultValue) {
        super(defaultValue);
    }

    @Override
    protected String convertToString(Object value) {
        return value instanceof Class ? ((Class)value).getName() : value.toString();
    }

    @Override
    protected <R> R convertToType(Class<R> type, Object value) throws Throwable {
        if (Class.class.equals(type)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    return type.cast(classLoader.loadClass(value.toString()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            classLoader = ClassConverter.class.getClassLoader();
            return type.cast(classLoader.loadClass(value.toString()));
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected Class<Class<T>> getDefaultType() {
        return Class.class;
    }
}

