/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.cayenne.CayenneRuntimeException;

public class IDUtil {
    private static final int BITMASK_0 = 255;
    private static final int BITMASK_1 = 65280;
    private static final int BITMASK_2 = 0xFF0000;
    private static final int BITMASK_3 = -16777216;
    private static final int BITMASK_4 = 255;
    private static final int BITMASK_5 = 65280;
    private static final int BITMASK_6 = 0xFF0000;
    private static final int BITMASK_7 = -16777216;
    private static volatile int currentId;
    private static MessageDigest md;
    private static byte[] ipAddress;

    public static void appendFormattedByte(Appendable buffer, byte byteValue) {
        String digits = "0123456789ABCDEF";
        try {
            buffer.append("0123456789ABCDEF".charAt(byteValue >>> 4 & 0xF));
            buffer.append("0123456789ABCDEF".charAt(byteValue & 0xF));
        }
        catch (IOException e) {
            throw new CayenneRuntimeException("Error appending data to buffer", (Throwable)e, new Object[0]);
        }
    }

    public static synchronized byte[] pseudoUniqueByteSequence(int length) {
        byte[] nextSequence;
        if (length < 16) {
            throw new IllegalArgumentException("Can't generate unique byte sequence shorter than 16 bytes: " + length);
        }
        if (length == 16) {
            return IDUtil.pseudoUniqueByteSequence16();
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i <= length - 16; i += 16) {
            nextSequence = IDUtil.pseudoUniqueByteSequence16();
            System.arraycopy(nextSequence, 0, bytes, i, 16);
        }
        int leftoverLen = length % 16;
        if (leftoverLen > 0) {
            nextSequence = IDUtil.pseudoUniqueByteSequence16();
            System.arraycopy(nextSequence, 0, bytes, length - leftoverLen, leftoverLen);
        }
        return bytes;
    }

    public static synchronized byte[] pseudoUniqueSecureByteSequence(int length) {
        byte[] nextSequence;
        if (length < 16) {
            throw new IllegalArgumentException("Can't generate unique byte sequence shorter than 16 bytes: " + length);
        }
        if (length == 16) {
            return IDUtil.pseudoUniqueSecureByteSequence16();
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i <= length - 16; i += 16) {
            nextSequence = IDUtil.pseudoUniqueSecureByteSequence16();
            System.arraycopy(nextSequence, 0, bytes, i, 16);
        }
        int leftoverLen = length % 16;
        if (leftoverLen > 0) {
            nextSequence = IDUtil.pseudoUniqueSecureByteSequence16();
            System.arraycopy(nextSequence, 0, bytes, length - leftoverLen, leftoverLen);
        }
        return bytes;
    }

    public static final byte[] pseudoUniqueByteSequence8() {
        byte[] bytes = new byte[8];
        int nextInt = IDUtil.nextInt();
        bytes[0] = (byte)((nextInt & 0xFF0000) >>> 16);
        bytes[1] = (byte)((nextInt & 0xFF00) >>> 8);
        bytes[2] = (byte)(nextInt & 0xFF);
        long t = System.currentTimeMillis();
        bytes[3] = (byte)((t & 0xFF0000L) >>> 16);
        bytes[4] = (byte)((t & 0xFF00L) >>> 8);
        bytes[5] = (byte)(t & 0xFFL);
        System.arraycopy(ipAddress, 2, bytes, 6, 2);
        return bytes;
    }

    public static final byte[] pseudoUniqueByteSequence16() {
        byte[] bytes = new byte[16];
        int nextInt = IDUtil.nextInt();
        bytes[0] = (byte)((nextInt & 0xFF000000) >>> 24);
        bytes[1] = (byte)((nextInt & 0xFF0000) >>> 16);
        bytes[2] = (byte)((nextInt & 0xFF00) >>> 8);
        bytes[3] = (byte)(nextInt & 0xFF);
        long t = System.currentTimeMillis();
        bytes[4] = (byte)((t & 0xFFFFFFFFFF000000L) >>> 56);
        bytes[5] = (byte)((t & 0xFF0000L) >>> 48);
        bytes[6] = (byte)((t & 0xFF00L) >>> 40);
        bytes[7] = (byte)((t & 0xFFL) >>> 32);
        bytes[8] = (byte)((t & 0xFFFFFFFFFF000000L) >>> 24);
        bytes[9] = (byte)((t & 0xFF0000L) >>> 16);
        bytes[10] = (byte)((t & 0xFF00L) >>> 8);
        bytes[11] = (byte)(t & 0xFFL);
        System.arraycopy(ipAddress, 0, bytes, 12, 4);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pseudoUniqueSecureByteSequence16() {
        byte[] bytes = IDUtil.pseudoUniqueByteSequence16();
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            return md.digest(bytes);
        }
    }

    private static final int nextInt() {
        if (currentId == Integer.MAX_VALUE) {
            currentId = 0;
        }
        return currentId++;
    }

    private IDUtil() {
    }

    static {
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CayenneRuntimeException("Can't initialize MessageDigest.", (Throwable)e, new Object[0]);
        }
        try {
            ipAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            ipAddress = new byte[]{127, 0, 0, 1};
        }
    }
}

