/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Arrays;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.modeler.Application;

public class NameGeneratorPreferences {
    private static final String STRATEGIES_PREFERENCE = "name.generators.recent";
    private static final Vector<String> PREDEFINED_STRATEGIES = new Vector();
    static final NameGeneratorPreferences instance;

    public static NameGeneratorPreferences getInstance() {
        return instance;
    }

    Preferences getPreference() {
        return Application.getInstance().getMainPreferenceForProject();
    }

    public Vector<String> getLastUsedStrategies() {
        String prop = null;
        if (this.getPreference() != null) {
            prop = this.getPreference().get(STRATEGIES_PREFERENCE, null);
        }
        if (prop == null) {
            return PREDEFINED_STRATEGIES;
        }
        return new Vector<String>(Arrays.asList(prop.split(",")));
    }

    public void addToLastUsedStrategies(String strategy) {
        Vector<String> strategies = this.getLastUsedStrategies();
        strategies.remove(strategy);
        strategies.add(0, strategy);
        StringBuilder res = new StringBuilder();
        for (String str : strategies) {
            res.append(str).append(",");
        }
        if (!strategies.isEmpty()) {
            res.deleteCharAt(res.length() - 1);
        }
        this.getPreference().put(STRATEGIES_PREFERENCE, res.toString());
    }

    public ObjectNameGenerator createNamingStrategy(Application application) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return application.getClassLoadingService().loadClass(ObjectNameGenerator.class, this.getLastUsedStrategies().get(0)).newInstance();
    }

    public static ObjectNameGenerator defaultNameGenerator() {
        return new DefaultObjectNameGenerator(NoStemStemmer.getInstance());
    }

    static {
        PREDEFINED_STRATEGIES.add(DefaultObjectNameGenerator.class.getCanonicalName());
        instance = new NameGeneratorPreferences();
    }
}

