/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.EmptyConfigurationNodeVisitor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTransferable;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class CopyAction
extends CayenneAction {
    public static String getActionName() {
        return "Copy";
    }

    public CopyAction(Application application) {
        this(CopyAction.getActionName(), application);
    }

    protected CopyAction(String name, Application application) {
        super(name, application);
    }

    @Override
    public String getIconName() {
        return "icon-copy.png";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        Object content = this.copy(mediator);
        if (content != null) {
            Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
            sysClip.setContents(new CayenneTransferable(content), null);
        }
        this.getApplication().getActionManager().getAction(PasteAction.class).updateState();
    }

    public Object copy(ProjectController mediator) {
        return mediator.getCurrentObject();
    }

    protected void print(XMLEncoder encoder, XMLSerializable object) {
        object.encodeAsXML(encoder, new EmptyConfigurationNodeVisitor());
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return object instanceof DataMap || object instanceof QueryDescriptor || object instanceof DbEntity || object instanceof ObjEntity || object instanceof Embeddable || object instanceof EmbeddableAttribute || object instanceof DbAttribute || object instanceof DbRelationship || object instanceof ObjAttribute || object instanceof ObjRelationship || object instanceof ObjCallbackMethod || object instanceof Procedure || object instanceof ProcedureParameter;
    }
}

