/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.reflect.Field;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIUtil;
import org.apache.cayenne.di.spi.DecoratorProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;

class FieldInjectingDecoratorProvider<T>
implements DecoratorProvider<T> {
    private Class<? extends T> implementation;
    private DefaultInjector injector;
    private DecoratorProvider<T> delegate;

    FieldInjectingDecoratorProvider(Class<? extends T> implementation, DecoratorProvider<T> delegate, DefaultInjector injector) {
        this.delegate = delegate;
        this.injector = injector;
        this.implementation = implementation;
    }

    @Override
    public Provider<T> get(final Provider<T> undecorated) throws DIRuntimeException {
        return new FieldInjectingProvider<T>(this.delegate.get(undecorated), this.injector){

            @Override
            protected Object value(Field field, String bindingName) {
                Class<?> fieldType = field.getType();
                if (Provider.class.equals(fieldType)) {
                    Class<?> objectClass = DIUtil.parameterClass(field.getGenericType());
                    if (objectClass == null) {
                        throw new DIRuntimeException("Provider field %s.%s of type %s must be parameterized to be usable for injection", field.getDeclaringClass().getName(), field.getName(), fieldType.getName());
                    }
                    if (objectClass.isAssignableFrom(FieldInjectingDecoratorProvider.this.implementation)) {
                        return undecorated;
                    }
                } else if (fieldType.isAssignableFrom(FieldInjectingDecoratorProvider.this.implementation)) {
                    return undecorated.get();
                }
                return super.value(field, bindingName);
            }
        };
    }
}

