/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.awt.Color;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;

class DbImportNodeHandler {
    private static final Color ACCEPT_COLOR = new Color(60, 179, 113);
    private static final Color EXCLUDE_COLOR = new Color(178, 0, 0);
    static final Color NON_INCLUDE_COLOR = Color.LIGHT_GRAY;
    static final Color LABEL_COLOR = Color.BLACK;
    private static final int EXCLUDE_TABLE_RATE = -10000;
    private boolean existFirstLevelIncludeTable;
    private boolean existCatalogsOrSchemas;
    private boolean hasEntitiesInEmptyContainer;
    private DbImportTreeNode dbSchemaNode;
    private DbImportTree reverseEngineeringTree;

    DbImportNodeHandler() {
    }

    private boolean namesIsEqual(DbImportTreeNode reverseEngineeringNode) {
        if (this.isContainer(reverseEngineeringNode)) {
            return this.dbSchemaNode.getSimpleNodeName().equals(reverseEngineeringNode.getSimpleNodeName());
        }
        return this.dbSchemaNode.getSimpleNodeName().toLowerCase().matches(reverseEngineeringNode.getSimpleNodeName().toLowerCase());
    }

    boolean isContainer(DbImportTreeNode node) {
        return node.getUserObject().getClass() == Schema.class || node.getUserObject().getClass() == Catalog.class;
    }

    private boolean isEmptyContainer(DbImportTreeNode rootNode) {
        return this.getChildIncludeTableCount(rootNode) == 0 && !this.existFirstLevelIncludeTable;
    }

    boolean isParentIncluded() {
        return this.dbSchemaNode.getParent() != null && ((DbImportTreeNode)this.dbSchemaNode.getParent()).isColorized();
    }

    public boolean nodesIsEqual(DbImportTreeNode reverseEngineeringNode) {
        TreePath[] paths = this.reverseEngineeringTree.getSelectionPaths();
        for (TreePath path : paths != null ? paths : new TreePath[]{}) {
            DbImportTreeNode node = (DbImportTreeNode)path.getLastPathComponent();
            if (!this.nodesClassesComparation(node.getUserObject().getClass(), this.dbSchemaNode.getUserObject().getClass()) || !this.namesIsEqual(node) || this.dbSchemaNode.getLevel() < node.getLevel() || !this.dbSchemaNode.parentsIsEqual(node)) continue;
            return true;
        }
        return this.nodesClassesComparation(reverseEngineeringNode.getUserObject().getClass(), this.dbSchemaNode.getUserObject().getClass()) && this.namesIsEqual(reverseEngineeringNode) && this.dbSchemaNode.getLevel() >= reverseEngineeringNode.getLevel() && this.dbSchemaNode.parentsIsEqual(reverseEngineeringNode);
    }

    public boolean checkTreesLevels(DbImportTree dbTree) {
        if (dbTree.getRootNode().getChildCount() == 0) {
            return false;
        }
        DbImportTreeNode dbNode = (DbImportTreeNode)dbTree.getRootNode().getChildAt(0);
        int childCount = this.reverseEngineeringTree.getRootNode().getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (((DbImportTreeNode)this.reverseEngineeringTree.getRootNode().getChildAt(i)).getUserObject().getClass() != Catalog.class) continue;
            return dbNode.getUserObject().getClass() == Catalog.class || dbNode.getUserObject().getClass() == IncludeTable.class;
        }
        return true;
    }

    private boolean compareWithParent(DbImportTreeNode reverseEngineeringNode) {
        if (reverseEngineeringNode == null || this.dbSchemaNode.getParent() == null) {
            return false;
        }
        return ((DbImportTreeNode)this.dbSchemaNode.getParent()).getUserObject().getClass() == reverseEngineeringNode.getUserObject().getClass() && ((DbImportTreeNode)this.dbSchemaNode.getParent()).getSimpleNodeName().equals(reverseEngineeringNode.getSimpleNodeName()) && ((DbImportTreeNode)this.dbSchemaNode.getParent()).getLevel() >= reverseEngineeringNode.getLevel() && ((DbImportTreeNode)this.dbSchemaNode.getParent()).parentsIsEqual(reverseEngineeringNode);
    }

    private int getChildIncludeTableCount(DbImportTreeNode parentNode) {
        if (parentNode.isIncludeTable()) {
            return 1;
        }
        int childCount = parentNode.getChildCount();
        int result = 0;
        for (int i = 0; i < childCount; ++i) {
            DbImportTreeNode tmpNode = (DbImportTreeNode)parentNode.getChildAt(i);
            if (!tmpNode.isIncludeTable()) continue;
            ++result;
        }
        return result;
    }

    private boolean foundExclude(DbImportTreeNode rootNode) {
        int childCount = rootNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DbImportTreeNode tmpNode = (DbImportTreeNode)rootNode.getChildAt(i);
            if (tmpNode.getChildCount() > 0 && (tmpNode.isExcludeTable() || tmpNode.isExcludeProcedure())) {
                return true;
            }
            if (this.dbSchemaNode.getParent() == null || !this.nodesIsEqual(tmpNode) || !tmpNode.isExcludeTable() && !tmpNode.isExcludeProcedure()) continue;
            return true;
        }
        return false;
    }

    int traverseTree(DbImportTreeNode rootNode) {
        DbImportTreeNode tmpNode;
        int i;
        ReverseEngineering reverseEngineering;
        this.hasEntitiesInEmptyContainer = false;
        int traverseResult = 0;
        int childCount = rootNode.getChildCount();
        boolean hasProcedures = false;
        if (childCount == 0 && this.nodesIsEqual(rootNode)) {
            ++traverseResult;
        }
        if (this.nodesIsEqual(rootNode)) {
            ++traverseResult;
        }
        if ((reverseEngineering = this.reverseEngineeringTree.getReverseEngineering()).getCatalogs().isEmpty() && reverseEngineering.getSchemas().isEmpty() && reverseEngineering.getIncludeTables().isEmpty() && !this.dbSchemaNode.isIncludeProcedure()) {
            ++traverseResult;
        }
        if (this.nodesIsEqual(rootNode) && this.isEmptyContainer(rootNode)) {
            this.hasEntitiesInEmptyContainer = true;
            if (this.foundExclude(rootNode)) {
                return -10000;
            }
            return 1;
        }
        if (this.compareWithParent(rootNode) && !rootNode.isReverseEngineering() && this.isEmptyContainer(rootNode) && this.dbSchemaNode.isIncludeTable()) {
            this.hasEntitiesInEmptyContainer = true;
            if (this.foundExclude(rootNode)) {
                return -10000;
            }
            return 1;
        }
        if (this.hasEntitiesInEmptyContainer) {
            for (i = 0; i < childCount; ++i) {
                tmpNode = (DbImportTreeNode)rootNode.getChildAt(i);
                if (!this.dbSchemaNode.isIncludeProcedure() || !this.nodesIsEqual(tmpNode)) continue;
                int tmpNodeChildCount = tmpNode.getChildCount();
                if (tmpNodeChildCount > 0) {
                    traverseResult += this.traverseTree((DbImportTreeNode)rootNode.getChildAt(i));
                }
                ++traverseResult;
                hasProcedures = true;
            }
            if (!(rootNode.isExcludeTable() || this.nodesIsEqual(rootNode) || this.dbSchemaNode.isIncludeProcedure() || this.dbSchemaNode.isIncludeColumn())) {
                ++traverseResult;
            } else if (!hasProcedures && !this.dbSchemaNode.isIncludeProcedure()) {
                traverseResult -= 10000;
            }
        }
        for (i = 0; i < childCount; ++i) {
            tmpNode = (DbImportTreeNode)rootNode.getChildAt(i);
            if (tmpNode.getChildCount() > 0) {
                traverseResult += this.traverseTree(tmpNode);
                if (tmpNode.isExcludeTable() || tmpNode.isExcludeProcedure()) {
                    traverseResult -= 10000;
                }
            } else if (this.compareWithParent(tmpNode) && !this.existFirstLevelIncludeTable && !this.dbSchemaNode.isIncludeProcedure()) {
                ++traverseResult;
            }
            if (this.dbSchemaNode.getParent() == null || !this.nodesIsEqual(tmpNode)) continue;
            if (tmpNode.isExcludeTable() || tmpNode.isExcludeProcedure()) {
                traverseResult -= 10000;
            }
            ++traverseResult;
        }
        return traverseResult;
    }

    Color getColorByNodeType(DbImportTreeNode node) {
        if (this.reverseEngineeringTree.getSelectionPaths() != null && this.reverseEngineeringTree.getSelectionPaths().length > 1) {
            for (TreePath path : this.reverseEngineeringTree.getSelectionPaths()) {
                DbImportTreeNode pathNode = (DbImportTreeNode)path.getLastPathComponent();
                if (!pathNode.getSimpleNodeName().equals(this.dbSchemaNode.getSimpleNodeName())) continue;
                if (pathNode.isExcludeTable() || pathNode.isExcludeProcedure() || node.isExcludeColumn()) {
                    return EXCLUDE_COLOR;
                }
                return ACCEPT_COLOR;
            }
        }
        if (node.isExcludeTable() || node.isExcludeProcedure() || node.isExcludeColumn()) {
            return EXCLUDE_COLOR;
        }
        return ACCEPT_COLOR;
    }

    void findFirstLevelIncludeTable() {
        DbImportTreeNode root = this.reverseEngineeringTree.getRootNode();
        int childCount = root.getChildCount();
        this.existFirstLevelIncludeTable = false;
        this.existCatalogsOrSchemas = false;
        for (int i = 0; i < childCount; ++i) {
            DbImportTreeNode tmpNode = (DbImportTreeNode)root.getChildAt(i);
            if (tmpNode.isIncludeTable()) {
                this.existFirstLevelIncludeTable = true;
            }
            if (!this.isContainer(tmpNode)) continue;
            this.existCatalogsOrSchemas = true;
        }
    }

    boolean isFirstNodeIsPrimitive(DbImportTree tree) {
        boolean firstChildIndex = false;
        DbImportTreeNode root = tree.getRootNode();
        if (root.getChildCount() == 0) {
            return false;
        }
        DbImportTreeNode firstElement = (DbImportTreeNode)root.getChildAt(0);
        return firstElement.isIncludeTable() || firstElement.isIncludeProcedure();
    }

    public boolean nodesClassesComparation(Class firstClass, Class secondClass) {
        if (firstClass.equals(secondClass)) {
            return true;
        }
        if (firstClass.equals(IncludeTable.class) && secondClass.equals(ExcludeTable.class)) {
            return true;
        }
        if (firstClass.equals(ExcludeTable.class) && secondClass.equals(IncludeTable.class)) {
            return true;
        }
        if (firstClass.equals(IncludeProcedure.class) && secondClass.equals(ExcludeProcedure.class)) {
            return true;
        }
        if (firstClass.equals(ExcludeProcedure.class) && secondClass.equals(IncludeProcedure.class)) {
            return true;
        }
        if (firstClass.equals(ExcludeColumn.class) && secondClass.equals(IncludeColumn.class)) {
            return true;
        }
        return firstClass.equals(IncludeColumn.class) && secondClass.equals(ExcludeColumn.class);
    }

    public boolean isExistCatalogsOrSchemas() {
        return this.existCatalogsOrSchemas;
    }

    public boolean getHasEntitiesInEmptyContainer() {
        return this.hasEntitiesInEmptyContainer;
    }

    public void setHasEntitiesInEmptyContainer(boolean newFlag) {
        this.hasEntitiesInEmptyContainer = newFlag;
    }

    public void setDbSchemaNode(DbImportTreeNode dbSchemaNode) {
        this.dbSchemaNode = dbSchemaNode;
    }

    public void setReverseEngineeringTree(DbImportTree reverseEngineeringTree) {
        this.reverseEngineeringTree = reverseEngineeringTree;
    }
}

