---
title: "Apache Parquet I/O connector"
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

[Built-in I/O Transforms](/documentation/io/built-in/)

# Apache Parquet I/O connector

{{< language-switcher java py >}}

The Beam SDKs include built-in transforms that can read data from and write data
to [Apache Parquet](https://parquet.apache.org) files.

## Before you start

<!-- Java specific -->

{{< paragraph class="language-java" >}}
To use ParquetIO, add the Maven artifact dependency to your `pom.xml` file.
{{< /paragraph >}}

{{< highlight java >}}
<dependency>
    <groupId>org.apache.beam</groupId>
    <artifactId>beam-sdks-java-io-parquet</artifactId>
    <version>{{< param release_latest >}}</version>
</dependency>
{{< /highlight >}}

{{< paragraph class="language-java" >}}
Additional resources:
{{< /paragraph >}}

{{< paragraph class="language-java" wrap="span" >}}
* [ParquetIO source code](https://github.com/apache/beam/blob/master/sdks/java/io/parquet/src/main/java/org/apache/beam/sdk/io/parquet/ParquetIO.java)
* [ParquetIO Javadoc](https://beam.apache.org/releases/javadoc/{{< param release_latest >}}/org/apache/beam/sdk/io/parquet/ParquetIO.html)
{{< /paragraph >}}

<!-- Python specific -->

{{< paragraph class="language-py" >}}
ParquetIO comes preinstalled with the Apache Beam python sdk..{{< param release_latest >}}
{{< /paragraph >}}

{{< paragraph class="language-py" >}}
Additional resources:
{{< /paragraph >}}

{{< paragraph class="language-py" wrap="span" >}}
* [ParquetIO source code](https://github.com/apache/beam/blob/master/sdks/python/apache_beam/io/parquetio.py)
* [ParquetIO Pydoc](https://beam.apache.org/releases/pydoc/{{< param release_latest >}}/apache_beam.io.parquetio.html)
{{< /paragraph >}}

{{< paragraph class="language-java" >}}
#### Using ParquetIO with Spark before 2.4
{{< /paragraph >}}

{{< paragraph class="language-java" >}}
`ParquetIO` depends on an API introduced in Apache Parquet 1.10.0.  **Spark 2.4.x is compatible and no additional steps are necessary**.  Older versions of Spark will not work out of the box since a pre-installed version of Parquet libraries will take precedence during execution.  The following workaround should be applied.
{{< /paragraph >}}

{{< paragraph class="language-java" >}}
> **Note**: The following technique allows you to execute your pipeline with `ParquetIO` correctly.
> The Parquet files that are consumed or generated by this Beam connector should remain interoperable with the other tools on your cluster.
{{< /paragraph >}}

{{< paragraph class="language-java" >}}
Include the Parquet artifact normally and ensure that it brings in the correct version of Parquet as a transitive dependency.
{{< /paragraph >}}

{{< highlight java >}}
<dependency>
    <groupId>org.apache.beam</groupId>
    <artifactId>beam-sdks-java-io-parquet</artifactId>
    <version>${beam.version}</version>
</dependency>
{{< /highlight >}}

{{< paragraph class="language-java" >}}
Relocate the following packages:
{{< /paragraph >}}

{{< highlight java >}}
<plugin>
  <groupId>org.apache.maven.plugins</groupId>
  <artifactId>maven-shade-plugin</artifactId>
  <configuration>
    <createDependencyReducedPom>false</createDependencyReducedPom>
    <filters>
      <filter>
        <artifact>*:*</artifact>
        <excludes>
          <exclude>META-INF/*.SF</exclude>
          <exclude>META-INF/*.DSA</exclude>
          <exclude>META-INF/*.RSA</exclude>
        </excludes>
      </filter>
    </filters>
  </configuration>
  <executions>
    <execution>
      <phase>package</phase>
      <goals>
        <goal>shade</goal>
      </goals>
      <configuration>
        <shadedArtifactAttached>true</shadedArtifactAttached>
        <shadedClassifierName>shaded</shadedClassifierName>
        <relocations>
          <relocation>
            <pattern>org.apache.parquet</pattern>
            <shadedPattern>shaded.org.apache.parquet</shadedPattern>
          </relocation>
          <!-- Some packages are shaded already, and on the original spark classpath. Shade them more. -->
          <relocation>
            <pattern>shaded.parquet</pattern>
            <shadedPattern>reshaded.parquet</shadedPattern>
          </relocation>
          <relocation>
            <pattern>org.apache.avro</pattern>
            <shadedPattern>shaded.org.apache.avro</shadedPattern>
          </relocation>
        </relocations>
        <transformers>
          <transformer
            implementation="org.apache.maven.plugins.shade.resource.ServicesResourceTransformer"/>
        </transformers>
      </configuration>
    </execution>
  </executions>
</plugin>
{{< /highlight >}}

{{< paragraph class="language-java" >}}
This technique has been tested to work on Spark 2.2.3, Spark 2.3.3 and Spark 2.4.3 (although it is optional for Spark 2.4+).
{{< /paragraph >}}
