/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class Accept
implements IOMRMElement {
    private AcksTo acksTo;
    private String rmNamespaceValue;

    public Accept(String rmNamespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(rmNamespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownNamespace", rmNamespaceValue));
        }
        this.rmNamespaceValue = rmNamespaceValue;
    }

    public Accept(String rmNamespace, AcksTo acksTo) throws SandeshaException {
        this(rmNamespace);
        this.acksTo = acksTo;
    }

    public String getNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public String getAddressingNamespaceValue() {
        if (this.acksTo != null) {
            return this.acksTo.getAddressingNamespaceValue();
        }
        return null;
    }

    public Object fromOMElement(OMElement element) throws OMException, AxisFault {
        OMElement acceptPart = element.getFirstChildWithName(new QName(this.rmNamespaceValue, "Accept"));
        if (acceptPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noAcceptPartInElement", element.toString()));
        }
        this.acksTo = new AcksTo(this.rmNamespaceValue);
        this.acksTo.fromOMElement(acceptPart);
        return this;
    }

    public OMElement toOMElement(OMElement element) throws OMException, AxisFault {
        OMFactory factory = element.getOMFactory();
        if (this.acksTo == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("acceptNullAcksTo"));
        }
        OMNamespace rmNamespace = factory.createOMNamespace(this.rmNamespaceValue, "wsrm");
        OMElement acceptElement = factory.createOMElement("Accept", rmNamespace);
        this.acksTo.toOMElement(acceptElement);
        element.addChild((OMNode)acceptElement);
        return element;
    }

    public void setAcksTo(AcksTo acksTo) {
        this.acksTo = acksTo;
    }

    public AcksTo getAcksTo() {
        return this.acksTo;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

