/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.SecurityManager;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.TargetRegion;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.util.filesystem.IDirectory;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.SubsystemException;

public class InstallAction
implements PrivilegedAction<BasicSubsystem> {
    private final IDirectory content;
    private final AccessControlContext context;
    private final Coordination coordination;
    private final boolean embedded;
    private final String location;
    private final BasicSubsystem parent;

    public InstallAction(String location, IDirectory content, BasicSubsystem parent, AccessControlContext context) {
        this(location, content, parent, context, null, false);
    }

    public InstallAction(String location, IDirectory content, BasicSubsystem parent, AccessControlContext context, Coordination coordination, boolean embedded) {
        this.location = location;
        this.content = content;
        this.parent = parent;
        this.context = context;
        this.coordination = coordination;
        this.embedded = embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicSubsystem run() {
        Coordination coordination = this.coordination;
        if (coordination == null) {
            coordination = Utils.createCoordination(this.parent);
        }
        BasicSubsystem result = null;
        try {
            TargetRegion region = new TargetRegion(this.parent);
            SubsystemResource ssr = this.createSubsystemResource(this.location, this.content, this.parent);
            result = Activator.getInstance().getSubsystems().getSubsystemByLocation(this.location);
            if (result != null) {
                this.checkLifecyclePermission(result);
                if (!region.contains(result)) {
                    throw new SubsystemException("Location already exists but existing subsystem is not part of target region: " + this.location);
                }
                if (!(result.getSymbolicName().equals(ssr.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName()) && result.getVersion().equals((Object)ssr.getSubsystemManifest().getSubsystemVersionHeader().getVersion()) && result.getType().equals(ssr.getSubsystemManifest().getSubsystemTypeHeader().getType()))) {
                    throw new SubsystemException("Location already exists but symbolic name, version, and type are not the same: " + this.location);
                }
                BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
                return basicSubsystem;
            }
            result = (BasicSubsystem)region.find(ssr.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName(), ssr.getSubsystemManifest().getSubsystemVersionHeader().getVersion());
            if (result != null) {
                this.checkLifecyclePermission(result);
                if (!result.getType().equals(ssr.getSubsystemManifest().getSubsystemTypeHeader().getType())) {
                    throw new SubsystemException("Subsystem already exists in target region but has a different type: " + this.location);
                }
                BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
                return basicSubsystem;
            }
            result = this.createSubsystem(ssr);
            this.checkLifecyclePermission(result);
            BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
            return basicSubsystem;
        }
        catch (Throwable t) {
            coordination.fail(t);
        }
        finally {
            if (!this.embedded) {
                try {
                    coordination.end();
                }
                catch (CoordinationException e) {
                    Throwable t = e.getCause();
                    if (t instanceof SubsystemException) {
                        throw (SubsystemException)t;
                    }
                    if (t instanceof SecurityException) {
                        throw (SecurityException)t;
                    }
                    throw new SubsystemException(t);
                }
            }
        }
        return result;
    }

    private void checkLifecyclePermission(final BasicSubsystem subsystem) {
        if (this.embedded) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityManager.checkLifecyclePermission(subsystem);
                return null;
            }
        }, this.context);
    }

    private BasicSubsystem createSubsystem(SubsystemResource resource) throws URISyntaxException, IOException, BundleException, InvalidSyntaxException {
        BasicSubsystem result = new BasicSubsystem(resource);
        return result;
    }

    private SubsystemResource createSubsystemResource(String location, IDirectory content, BasicSubsystem parent) throws URISyntaxException, IOException, ResolutionException, BundleException, InvalidSyntaxException, ModellerException {
        SubsystemResource result = new SubsystemResource(location, content, parent);
        return result;
    }
}

