/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.jms.JMSException;
import org.apache.activemq.blob.BlobDownloadStrategy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.DefaultStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;

public class DefaultBlobDownloadStrategy
extends DefaultStrategy
implements BlobDownloadStrategy {
    public DefaultBlobDownloadStrategy(BlobTransferPolicy transferPolicy) {
        super(transferPolicy);
    }

    @Override
    public InputStream getInputStream(ActiveMQBlobMessage message) throws IOException, JMSException {
        URL value = message.getURL();
        if (value == null) {
            return null;
        }
        URL uploadURL = new URL(this.transferPolicy.getUploadUrl());
        String protocol = message.getURL().getProtocol();
        if (!protocol.equals(uploadURL.getProtocol())) {
            throw new IOException("The message URL protocol is incorrect");
        }
        String host = message.getURL().getHost();
        if (!host.equals(uploadURL.getHost())) {
            throw new IOException("The message URL host is incorrect");
        }
        int port = message.getURL().getPort();
        if (uploadURL.getPort() != 0 && port != uploadURL.getPort()) {
            throw new IOException("The message URL port is incorrect");
        }
        return value.openStream();
    }

    @Override
    public void deleteFile(ActiveMQBlobMessage message) throws IOException, JMSException {
        URL url = this.createMessageURL(message);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new IOException("DELETE failed on: " + String.valueOf(url), e);
        }
        finally {
            connection.disconnect();
        }
        if (!this.isSuccessfulCode(connection.getResponseCode())) {
            throw new IOException("DELETE was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }
}

