/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<ActiveMQServer, AckManager> managerHashMap = new HashMap<ActiveMQServer, AckManager>();

    public static void reset() {
        managerHashMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ActiveMQServer server) {
        AckManager ackManager = null;
        Map<ActiveMQServer, AckManager> map = managerHashMap;
        synchronized (map) {
            ackManager = managerHashMap.remove(server);
        }
        logger.debug("Removed entry for {}: {}", (Object)server, (Object)ackManager);
        if (ackManager != null) {
            server.removeExternalComponent((ActiveMQComponent)ackManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSize() {
        Map<ActiveMQServer, AckManager> map = managerHashMap;
        synchronized (map) {
            return managerHashMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AckManager getManager(ActiveMQServer server) {
        Objects.requireNonNull(server, "server is null");
        Map<ActiveMQServer, AckManager> map = managerHashMap;
        synchronized (map) {
            AckManager ackManager = managerHashMap.get(server);
            if (ackManager != null) {
                return ackManager;
            }
            ackManager = new AckManager(server);
            managerHashMap.put(server, ackManager);
            try {
                server.addExternalComponent((ActiveMQComponent)ackManager, false);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            return ackManager;
        }
    }
}

