/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSender;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToSenderController;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeToQueueSender
extends AMQPBridgeSender {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AMQPBridgeToQueueSender(AMQPBridgeToPolicyManager policyManager, AMQPBridgeSenderConfiguration configuration, AMQPSessionContext session, AMQPBridgeSenderInfo senderInfo, AMQPBridgeMetrics.SenderMetrics metrics) {
        super(policyManager, configuration, session, senderInfo, metrics);
    }

    @Override
    public AMQPBridgeQueuePolicy getPolicy() {
        return (AMQPBridgeQueuePolicy)this.policy;
    }

    @Override
    protected void doCreateSender() {
        try {
            Sender protonSender = this.session.getSession().sender(this.generateLinkName());
            Target target = new Target();
            Source source = new Source();
            String address = this.senderInfo.getRemoteAddress();
            source.setAddress(this.senderInfo.getLocalFqqn());
            target.setAddress(address);
            target.setDurable(TerminusDurability.NONE);
            target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            target.setCapabilities(this.getRemoteTerminusCapabilities());
            protonSender.setSenderSettleMode(this.configuration.isUsingPresettledSenders() ? SenderSettleMode.SETTLED : SenderSettleMode.UNSETTLED);
            protonSender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (this.configuration.isCoreMessageTunnelingEnabled()) {
                protonSender.setDesiredCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
            }
            protonSender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            protonSender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            protonSender.open();
            AtomicBoolean openTimedOut = new AtomicBoolean(false);
            ScheduledFuture<?> openTimeoutTask = this.configuration.getLinkAttachTimeout() > 0 ? this.bridgeManager.getServer().getScheduledPool().schedule(() -> {
                openTimedOut.set(true);
                this.bridgeManager.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()));
            }, (long)this.configuration.getLinkAttachTimeout(), TimeUnit.SECONDS) : null;
            this.protonSender = protonSender;
            protonSender.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                try {
                    boolean linkOpened;
                    if (openTimeoutTask != null) {
                        openTimeoutTask.cancel(false);
                    }
                    if (openTimedOut.get()) {
                        return;
                    }
                    boolean bl = linkOpened = protonSender.getRemoteTarget() != null;
                    if (linkOpened) {
                        logger.debug("AMQP Bridge {} queue senderContext {} completed open", (Object)this.bridgeManager.getName(), (Object)this.senderInfo);
                    } else {
                        logger.debug("AMQP Bridge {} queue senderContext {} rejected by remote", (Object)this.bridgeManager.getName(), (Object)this.senderInfo);
                    }
                    this.bridgeManager.addLinkClosedInterceptor(this.senderInfo.getId(), this::remoteLinkClosedInterceptor);
                    AMQPBridgeToQueueSenderController senderController = new AMQPBridgeToQueueSenderController(this.senderInfo, this.configuration, this.getPolicyManager(), this.session, this.metrics);
                    this.senderContext = new AMQPBridgeQueueSenderContext(this.connection, protonSender, this.session, this.session.getSessionSPI(), senderController);
                    this.session.addSender(protonSender, this.senderContext);
                    if (linkOpened && this.remoteOpenHandler != null) {
                        this.remoteOpenHandler.accept(this);
                    }
                }
                catch (Exception e) {
                    this.bridgeManager.signalError(e);
                }
            });
        }
        catch (Exception e) {
            this.bridgeManager.signalError(e);
        }
        this.connection.flush();
    }

    private String generateLinkName() {
        return "amqp-bridge-" + this.bridgeManager.getName() + "-policy-" + this.policy.getPolicyName() + "-queue-sender-" + this.senderInfo.getRemoteAddress() + "-" + String.valueOf(this.bridgeManager.getServer().getNodeID()) + "-" + LINK_SEQUENCE_ID.incrementAndGet();
    }

    public static class AMQPBridgeToQueueSenderController
    extends AMQPBridgeToSenderController {
        private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

        public AMQPBridgeToQueueSenderController(AMQPBridgeSenderInfo senderInfo, AMQPBridgeSenderConfiguration configuration, AMQPBridgeToPolicyManager policyManager, AMQPSessionContext session, AMQPBridgeMetrics.SenderMetrics metrics) throws ActiveMQAMQPException {
            super(senderInfo, configuration, policyManager, session, metrics);
        }

        @Override
        public AMQPBridgeToSenderController.SenderRole getRole() {
            return AMQPBridgeToSenderController.SenderRole.QUEUE_SENDER;
        }

        public AMQPBridgeQueuePolicy getPolicy() {
            return (AMQPBridgeQueuePolicy)this.policy;
        }

        @Override
        protected ServerConsumer createServerConsumer(ProtonServerSenderContext senderContext) throws Exception {
            AMQPSessionCallback sessionSPI = this.session.getSessionSPI();
            SimpleString address = SimpleString.of((String)this.senderInfo.getLocalAddress());
            SimpleString queue = SimpleString.of((String)this.senderInfo.getLocalQueue());
            RoutingType expectedRoutingType = this.senderInfo.getRoutingType();
            AMQPBridgeQueuePolicy policy = this.getPolicy();
            try {
                AddressQueryResult addressResult = sessionSPI.addressQuery(address, expectedRoutingType, false);
                if (!addressResult.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(address.toString());
                }
                QueueQueryResult queueResult = sessionSPI.queueQuery(queue, expectedRoutingType, false);
                if (!queueResult.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(queue.toString());
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
            int priority = policy.getPriority() != null ? policy.getPriority() : ActiveMQDefaultConfiguration.getDefaultConsumerPriority() + policy.getPriorityAdjustment();
            return sessionSPI.createSender(senderContext, queue, policy.getFilter(), false, priority);
        }
    }

    private class AMQPBridgeQueueSenderContext
    extends ProtonServerSenderContext {
        AMQPBridgeQueueSenderContext(AMQPConnectionContext connection, Sender sender, AMQPSessionContext protonSession, AMQPSessionCallback server, SenderController senderController) {
            super(connection, sender, protonSession, server, senderController);
        }

        @Override
        public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
            super.close(remoteLinkClose);
            if (remoteLinkClose && AMQPBridgeToQueueSender.this.remoteCloseHandler != null) {
                try {
                    AMQPBridgeToQueueSender.this.remoteCloseHandler.accept(AMQPBridgeToQueueSender.this);
                }
                catch (Exception e) {
                    logger.debug("User remote closed handler threw error: ", (Throwable)e);
                }
                finally {
                    AMQPBridgeToQueueSender.this.remoteCloseHandler = null;
                }
            }
        }
    }
}

