/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.tomcat;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class TomcatLoginContextConfiguration
extends Configuration {
    private final AppConfigurationEntry entry;

    public TomcatLoginContextConfiguration(String digestAlgorithm, String tomcatUserLocation) {
        HashMap<String, String> options = new HashMap<String, String>(1);
        options.put("DIGEST_ALGORITHM", digestAlgorithm);
        options.put("USER_LOCATION", tomcatUserLocation);
        this.entry = new TomcatAppConfigurationEntry(Collections.unmodifiableMap(options));
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return new AppConfigurationEntry[]{this.entry};
    }

    private static final class TomcatAppConfigurationEntry
    extends AppConfigurationEntry {
        public TomcatAppConfigurationEntry(Map<String, Object> options) {
            super("io.hawt.web.tomcat.TomcatUserDatabaseLoginContext", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }
    }
}

