/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.amqp.AmqpInactivityMonitor;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        AmqpTransportFilter amqpTransport = new AmqpTransportFilter(transport, format, this.brokerService);
        Map wireFormatOptions = IntrospectionSupport.extractProperties((Map)options, (String)"wireFormat.");
        IntrospectionSupport.setProperties((Object)amqpTransport, (Map)options);
        IntrospectionSupport.setProperties((Object)amqpTransport.getWireFormat(), (Map)wireFormatOptions);
        return super.compositeConfigure((Transport)amqpTransport, format, options);
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected Transport createInactivityMonitor(Transport transport, WireFormat format) {
        AmqpInactivityMonitor monitor = new AmqpInactivityMonitor(transport, format);
        AmqpTransportFilter filter = (AmqpTransportFilter)transport.narrow(AmqpTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

