/* -*- buffer-read-only: t -*-
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/mk_invlists.pl from mph.pl.
 * Any changes made here will be lost!
 */

#define MPH_VALt I16

/*
rows: 6507
seed: 1348825708
full length of keys: 91401
blob length: 8943
ref length: 52056
data size: 60999 (%66.74)
*/

STATIC const unsigned char mph_blob[] =
    "unifiedcanadianaboriginalsyllabicsextendedcjkcompatibilityideogra"
    "phssupplementarabicmathematicalalphabeticsymbolscombiningdiacriti"
    "calmarksforsymbolscombiningdiacriticalmarkssupplementmiscellaneou"
    "ssymbolsandpictographs_perl_problematic_locale_foldeds_combiningd"
    "iacriticalmarksextendedmiscellaneousmathematicalsymbolsamiscellan"
    "eousmathematicalsymbolsbsupplementalmathematicaloperatorssuppleme"
    "ntalsymbolsandpictographsideographicdescriptioncharactersideograp"
    "hicsymbolsandpunctuationmathematicalalphanumericsymbolscjkunified"
    "ideographsextensionacjkunifiedideographsextensionbcjkunifiedideog"
    "raphsextensionccjkunifiedideographsextensiondcjkunifiedideographs"
    "extensionecjkunifiedideographsextensionfcuneiformnumbersandpunctu"
    "ationenclosedalphanumericsupplementenclosedideographicsupplementm"
    "iscellaneoussymbolsandarrowsphoneticextensionssupplementsupplemen"
    "taryprivateuseareaasupplementaryprivateuseareabvariationselectors"
    "supplementalphabeticpresentationformsancientgreekmusicalnotationc"
    "anonicalcombiningclass=cccenclosedcjklettersandmonthsopticalchara"
    "cterrecognitionconditionaljapanesestarterhalfwidthandfullwidthfor"
    "mskatakanaphoneticextensionsprependedconcatenationmarkchangeswhen"
    "nfkccasefoldeddefaultignorablecodepointsuperscriptsandsubscriptsa"
    "rabicpresentationformsaarabicpresentationformsbcjksymbolsandpunct"
    "uationcombiningmarksforsymbolsconsonantsucceedingrephafullcomposi"
    "tionexclusionhighprivateusesurrogatesindicpositionalcategory=indi"
    "csyllabiccategory=insupsymbolsandpictographsbidipairedbrackettype"
    "=cbyzantinemusicalsymbolsconsonantprecedingrephageometricshapesex"
    "tendedhangulcompatibilityjamolatinextendedadditionalshorthandform"
    "atcontrolssupplementalpunctuationcjkcompatideographssupcommonindi"
    "cnumberformsdiacriticalsforsymbolsearlydynasticcuneiformgraphemec"
    "lusterbreak=smiscellaneoustechnicalspacingmodifierletterstranspor"
    "tandmapsymbolschangeswhencasefoldedchangeswhencasemappedchangeswh"
    "enlowercasedchangeswhentitlecasedchangeswhenuppercasedcjkcompatib"
    "ilityformscjkradicalssupplementcyrillicsupplementaryinscriptional"
    "parthianlogicalorderexceptionmeeteimayekextensionsnoncharactercod"
    "epointpopdirectionalisolatesinhalaarchaicnumbersyijinghexagramsym"
    "bolsanatolianhieroglyphsconnectorpunctuationconsonantplaceholderc"
    "onsonantwithstackergeneralcategory=lineglagoliticsupplementinscri"
    "ptionalpahlavilefttorightembeddingpopdirectionalformatrighttoleft"
    "embeddingtopandbottomandrightverticalorientation=ancientgreeknumb"
    "ersbrahmijoiningnumberburushaskiyehbarreeconsonantheadlettercount"
    "ingrodnumeralsegyptianhieroglyphsenclosedalphanumsupfolds_to_mult"
    "i_charhanguljamoextendedahanguljamoextendedblefttorightoverrideme"
    "roitichieroglyphsmodifiertonelettersmongoliansupplementrighttolef"
    "toverridesundanesesupplementsupplementalarrowsasupplementalarrows"
    "bsupplementalarrowscterminalpunctuationattachedaboverightcherokee"
    "supplementcombininghalfmarksconsonantsubjoinedcopticepactnumbersd"
    "ecompositiontype=devanagariextendedethiopicsupplementeuropeanterm"
    "inatorfirststrongisolategeneralpunctuationgeorgiansupplementidstr"
    "inaryoperatorinitialpunctuationlatinextadditionallefttorightisola"
    "teornamentaldingbatsparagraphseparatorrighttoleftisolateruminumer"
    "alsymbolsscriptextensions=vtaixuanjingsymbolstopandleftandrighttr"
    "ansformedrotatedtransformeduprighttype=notapplicablealchemicalsym"
    "bolsattachedbelowleftcanadiansyllabicscaucasianalbanianconsonantp"
    "refixedcyrillicextendedacyrillicextendedbcyrillicextendedceastasi"
    "anwidth=haethiopicextendedaeuropeanseparatoridsbinaryoperatorlett"
    "erlikesymbolsmanichaeandhamedhmanichaeanhundredmanichaeanthamedhp"
    "atternwhitespaceregionalindicatorsmallformvariantssuttonsignwriti"
    "ngtype=trailingjamoarabicsupplementbopomofoextendedcantillationma"
    "rkcloseparenthesisclosepunctuationcypriotsyllabaryfinalpunctuatio"
    "nhalfandfullformshighpusurrogateslatin1supplementlinearbideograms"
    "linearbsyllabarymanichaeandalethmanichaeanlamedhmanichaeansamekhm"
    "anichaeantwentymiscmathsymbolsamiscmathsymbolsbmyanmarextendedamy"
    "anmarextendedbotherpunctuationsegmentseparatorsentenceterminalsup"
    "mathoperatorssyllablemodifiersyriacsupplementtangutcomponentstype"
    "=leadingjamotype=lvtsyllablevowelindependent_perl_charname_arabic"
    "extendedabamumsupplementboundaryneutralbraillepatternscommonsepar"
    "atorconsonantkillerconsonantmedialcontingentbreakcontrolpicturesc"
    "urrencysymbolsdashpunctuationdiacriticalsextdiacriticalssuphangul"
    "syllablesimperialaramaicjoininggroup=kalowercaselettermanichaeana"
    "lephmanichaeangimelmanichaeansadhemanichaeanzayinmeroiticcursivem"
    "iscpictographsmodifyingletternfcquickcheck=nnfdquickcheck=nnfkcqu"
    "ickcheck=oldnortharabianoldsoutharabianopenpunctuationregistershi"
    "ftersentencebreak=ctitlecaselettertype=lvsyllableuppercaseletterv"
    "edicextensionsvisualorderleftzanabazarsquareancientsymbolscarriag"
    "ereturncjkcompatformscomplexcontextconsonantfinaleuropeannumberge"
    "minationmarkgraphemeextendgreekandcoptichamzaonhehgoalhighsurroga"
    "teskanasupplementkangxiradicalslatinextendedblatinextendedclatine"
    "xtendeddlatinextendedemandatorybreakmanichaeanayinmanichaeanbethm"
    "anichaeanfivemanichaeanhethmanichaeankaphmanichaeanqophmanichaean"
    "reshmanichaeantethmanichaeanyodhmodifiersymbolnfkdquickchecknojoi"
    "ninggroupnonspacingmarkphoneticextsuppostfixnumericpsalterpahlavi"
    "spaceseparatorsuppunctuationtehmarbutagoaltype=voweljamovisiblest"
    "ackervoweldependent1000000000000aegeannumbersasciihexdigitblockel"
    "ementsbottomandleftcaseignorableconsonantdeaddecimalnumberenclosi"
    "ngmarkgreekextendediotasubscriptipaextensionsjoiningtype=dkanaext"
    "endedalineseparatorlowsurrogatesmalayalamlllamalayalamnnnamanicha"
    "eanmemmanichaeannunmanichaeanonemanichaeantawmanichaeantenmanicha"
    "eanwawmisctechnicalnumericvalue=patternsyntaxprefixnumericquotati"
    "onmarkverticalformsalphabeticpfarabicletterarabicnumberbidiclass="
    "bobidimirroredbreaksymbolscyrillicextacyrillicextbcyrillicextceth"
    "iopicextaextendnumletfinalsemkathglueafterzwjgraphemebasehebrewle"
    "tterinfixnumerickhmersymbolsletternumbermahjongtilesmalayalambham"
    "alayalamllamalayalamngamalayalamnnamalayalamnyamalayalamssamalaya"
    "lamttamanichaeanpemasaramgondimathalphanummendekikakuinoncanonica"
    "lnotreorderednumberjoineroldhungarianotherneutralphaistosdiscplay"
    "ingcardsrightjoiningafricannoonbidicontrolbreakbeforecasedletterc"
    "ategory=cadominotilesdoubleabovedoublebelowdoublequotedualjoining"
    "exclamationinseparableinseperablejoincausingjoincontrolkanavoicin"
    "gkatakanaextleftjoininglinebreak=mmalayalamjamalayalamramiscsymbo"
    "lsmyanmarextamyanmarextbnumerictypeotherletterothernumberothersym"
    "bolpahawhhmongrohingyayehsinglequotesorasompengstraightwawsuperan"
    "dsubsylotinagritopandrighttransparentwordbreak=nxidcontinueyehwit"
    "htailyisyllablesafricanfehafricanqafarabicextabasiclatinbelowrigh"
    "tboxdrawingbreakaftercjkstrokescompatjamodalathrishdeprecatedkhar"
    "oshthiknottedhehmiscarrowsnonjoiningnonstarteroldpersianoverstruc"
    "kphoenicianpresentin=purekillerreversedpesaurashtrasmallformssoft"
    "dottedsuparrowsasuparrowsbsuparrowscunassignedwarangcitiwordjoine"
    "ryiradicalsaboveleftambiguousany_foldsarabicpfaarabicpfbbhaiksuki"
    "blk=indicbreakbothemoticonsinheritedkhudawadilatinextblatinextcla"
    "tinextdmidlettermidnumletnabataeannewtailuenonjoinerolditalicoldp"
    "ermicoldturkicpalmyrenepaucinhauquotemetasamaritanscontinuesyriac"
    "waw=decimal=numericarmenianavagrahabalinesebassavahblock=blbugine"
    "seduployanebasegazextenderfarsiyehfractiongujaratigurmukhihiragan"
    "aisolatedisxposixjamoextajamoextbjavanesekanaextalinefeedmahajani"
    "nextlinescript=bspecialsswashkaftagbanwatifinaghtonemarkugariticx"
    "idstartaletteravestanbengalic=maybeccc=ccccjkextacjkextbcjkextccj"
    "kextdcjkextecjkextfdeseretelbasangranthahanunooinsc=inishorizispo"
    "sixisspaceisxperlkannadakayahlilinearamandaicmarchenmultaninobloc"
    "knobreaknondcijolchikioletterosmanyaoverlayphagspasharadashavians"
    "iddhamsoyombosuppuaasuppuabtagalogtaithamtaiviettibetantirhutatyp"
    "e=naucasextunknownvisargazwspace200000216000300000400000432000500"
    "000600000700000800000900000=digit=false_case_carianchakmacircleco"
    "mpexewlinegothicgrbasehatranhyphenisperlisvertkaithikanbunkhojkil"
    "amadhlepchalycianlydiannarrowpatsynrejangsc=khateluguthaanavirama"
    "yudhhe1/16011/12=none=trueadlamalaphatermbatakbeginbindublankbuhi"
    "dc=yescntrlcwkcfgc=segcb=ggrextinpc=inzanisunikhaphlimbunuktanush"
    "uoghamoriyaosagepatwsprintqmarkrunicscx=bstermtailetakritamiluide"
    "ovssupzhain-1/21/101/201/4010.011/213/215/217/23/163/203/805/127/"
    "12adlmage=aghbahexahomalefarmiarmnataratblavstbatkbc=ebhksbpt=buh"
    "dc=nocakmcanscprtcwcfcwcmcyrldsrtdt=efontgonmgrekgujrguruhanihano"
    "hluwhmnginblinshintijg=gjt=lkalikhmrkndakthilanalaoolatnlb=llinal"
    "inblisumeemmercmiaomlymmroomteimymrnarbnbatnewankoonshuogamolckor"
    "khoryaosgephlpphnxplrdprtiqaacqaaiqaphrjngrunrsamrsarbsb=csc=lsee"
    "nsgnwshawshrdsyrctagstalutamltavttfngtglgthaitibtv100vaiiwb=nwide"
    "xpeoxsuxyiiizainzanbzinhzyyyzzzz1.11/31/51/61/71/81/9103107118122"
    "1291301321332.02.12/32/52022142182202222242262282302322332342403."
    "03.13.23/43/54.04.14/55.05.15.25/65/86.06.16.26.37.07/88.09.09/2b"
    "ehcwlcwtcwuea=ebgfsiinvloelrelrilromimnsmnv=ocrpcmpdfrehsmlsqrtah"
    "v11v20v21v30v31v32v40v41v50v51v52v60v61v62v63v70v80v90vo=19353638"
    "39444546474849b2bkh2h3jljvl&vrxxzlzpzs";
/* mph_blob length: 8943 */

struct mph_struct {
    U16 seed2;
    U16 pfx;
    U16 sfx;
    U8  pfx_len;
    U8  sfx_len;
    MPH_VALt value;
};

#define MPH_RSHIFT 8
#define MPH_BUCKETS 6507

STATIC const U32 MPH_SEED1 = 0x5065726c;
STATIC const U32 MPH_FNV_CONST = 0x01000193;


STATIC const struct mph_struct mph_table[MPH_BUCKETS] = {
  {     0,  2108,  7209,   3,   7, PL_INHIRAGANA }   /* inhiragana */,
  {     4,  8376,  6576,   3,  10, PL_LB__BA }   /* lb=breakafter */,
  {     0,  3521,   218,   5,   4, PL_XPOSIXSPACE }   /* spaceperl */,
  {     0,  1417,   468,   9,  11, PL_P }   /* category=punctuation */,
  {     3,  7288,  8111,   7,   5, PL_SC__TAKR }   /* script=takri */,
  {     3,  8096,  8208,   4,   4, PL_AHOM }   /* scx=ahom */,
  {     2,  8508,  7877,   4,   3, PL_LYCI }   /* sc=lyci */,
  {     0,  3129,  8400,  17,   4, PL_MIAO }   /* scriptextensions=miao */,
  {     0,  2221,  4030,   3,  12, PL_GCB__L }   /* hst=leadingjamo */,
  {     0,  6647,  3273,   4,  15, PL_UCAS }   /* iscanadiansyllabics */,
  {     0,  8204,  3223,   4,   3, -PL_POSIXXDIGIT }   /* ahex=no */,
  {     0,  7459,  8536,   3,   4, PL_TALU }   /* sc=talu */,
  {     0,  8572,  4653,   3,   2, PL_WB__SQ }   /* wb=sq */,
  {     4,  6890,  2731,   4,  19, PL_SUPARROWSC }   /* blk=supplementalarrowsc */,
  {     0,  7459,  7900,   3,   6, PL_RJNG }   /* sc=rejang */,
  {     0,  6210,   511,   3,  19, PL_CJK }   /* incjkunifiedideographs */,
  {     1,  4239,  3581,   4,   2, PL_DASH }   /* dash=t */,
  {     1,  8096,  8464,   4,   4, PL_PHNX }   /* scx=phnx */,
  {     2,  1417,  3914,   9,  16, PL_PO }   /* category=otherpunctuation */,
  {     2,  8783,  7997,   3,   4, PL_CWU }   /* cwu=yes */,
  {     0,  7478,  3995,   3,   5, PL_SYRC }   /* issyriac */,
  {     3,  2100,  5871,   3,   3, PL_OGAM }   /* isogam */,
  {     0,  4314,  6516,  13,  10, PL_JG__AFRICANFEH }   /* joininggroup=africanfeh */,
  {     1,  4440,  2251,   4,  11, PL_GLAGOLITICSUP }   /* inglagoliticsup */,
  {     6,  2002,     0,  21,   0, PL_PRTI }   /* inscriptionalparthian */,
  {     0,   184,  7799,   3,   5, PL_COMPEX }   /* iscompex */,
  {     0,  7459,  7520,   3,   4, PL_MARC }   /* sc=marc */,
  {     0,  3129,  2149,  17,  20, PL_HLUW }   /* scriptextensions=anatolianhieroglyphs */,
  {     0,  7459,  7555,   3,   7, PL_OLCK }   /* sc=olchiki */,
  {     0,  6890,  3111,   4,  18, PL_RUMI }   /* blk=ruminumeralsymbols */,
  {     0,  8376,  4524,   3,  15, PL_LB__OP }   /* lb=openpunctuation */,
  {     1,  7136,  1543,   6,  18, PL_GEOMETRICSHAPESEXT }   /* block=geometricshapesext */,
  {     0,  3129,  3994,  17,   6, PL_SYRC }   /* scriptextensions=syriac */,
  {     1,  6263,  7280,  10,   8, PL_LB__NL }   /* linebreak=nextline */,
  {     0,  6890,    78,   4,  10, PL_ARABICMATH }   /* blk=arabicmath */,
  {    22,  7380,  5595,   4,   2, PL_CCC__8 }   /* ccc=kv */,
  {     3,  8096,  8420,   4,   4, PL_NARB }   /* scx=narb */,
  {     0,  5134,  6030,   3,  11, PL_PHAISTOS }   /* isphaistosdisc */,
  {     1,   184,  1681,   3,  21, PL_INDICNUMBERFORMS }   /* iscommonindicnumberforms */,
  {     1,  8121,  7997,   5,   4, PL_UIDEO }   /* uideo=yes */,
  {     1,  2108,  4286,   4,  13, PL_INHANGUL }   /* inhangulsyllables */,
  {     2,  8240,  3093,   3,  18, PL_BC__RLI }   /* bc=righttoleftisolate */,
  {     1,  3129,  8404,  17,   4, PL_MLYM }   /* scriptextensions=mlym */,
  {     1,   184,  8420,   2,   4, PL_NARB }   /* isnarb */,
  {     1,  4402,   780,   3,  28, PL_MISCARROWS }   /* inmiscellaneoussymbolsandarrows */,
  {     1,  6263,   722,  10,   2, PL_LB__CL }   /* linebreak=cl */,
  {     1,  3111,     0,   4,   0, PL_RUMI }   /* rumi */,
  {     1,  6263,  4452,  10,   2, PL_LB__QU }   /* linebreak=qu */,
  {     1,   415,  7951,  11,   5, PL_IDEO }   /* ideographic=true */,
  {     1,  7459,  6406,   3,  11, PL_SORA }   /* sc=sorasompeng */,
  {     2,    21,  2128,   2,   6, PL_YIJING }   /* inyijing */,
  {     1,  7689,  8201,   3,   3, PL_AGHB }   /* isaghb */,
  {     4,  3129,  7144,  17,   8, PL_BUGI }   /* scriptextensions=buginese */,
  {     0,  4239,  7768,   4,   2, -PL_DASH }   /* dash=f */,
  {    18,  7136,  5093,   6,  14, PL_PHONETICEXTSUP }   /* block=phoneticextsup */,
  {     2,  5336,     0,  13,   0, PL_GREEKEXT }   /* greekextended */,
  {     2,  8276,  7997,   4,   4, PL_CWCM }   /* cwcm=yes */,
  {     0,  7136,  2617,   6,  19, PL_MODIFIERTONELETTERS }   /* block=modifiertoneletters */,
  {     1,  6756,  7768,  10,   6, -PL_SD }   /* softdotted=false */,
  {     1,  8798,  7951,   3,   5, PL_LOE }   /* loe=true */,
  {    10,  8092,  1201,   4,   3, PL_ANY }   /* unicode */,
  {     0,  7457,  7328,   5,   8, PL_INSC__TONEMARK }   /* insc=tonemark */,
  {     1,  8096,  2674,   4,   4, PL_SUND }   /* scx=sund */,
  {     0,  4314,    65,  15,   2, PL_JG__KAPH }   /* joininggroup=kaph */,
  {    11,  7569,     0,   7,   0, PL_OSMA }   /* osmanya */,
  {     4,  3509,  7768,  17,   2, -PL_PATWS }   /* patternwhitespace=f */,
  {     0,  8816,  8171,   3,   2, PL_NV__23 }   /* nv=23 */,
  {     1,  5544,  7710,  13,   3, PL_NV__600 }   /* numericvalue=600 */,
  {     0,  7136,  1797,   6,  15, PL_MODIFIERLETTERS }   /* block=modifierletters */,
  {     1,   447,     0,  18,   0, PL_IDEOGRAPHICSYMBOLS }   /* ideographicsymbols */,
  {     0,  8376,  1055,   3,  26, PL_LB__CJ }   /* lb=conditionaljapanesestarter */,
  {     0,  7478,   350,   3,  32, PL_SUPMATHOPERATORS }   /* issupplementalmathematicaloperators */,
  {     0,  3129,  8480,  17,   4, PL_QAAI }   /* scriptextensions=qaai */,
  {     0,  2408,     0,   6,   0, PL_BRAH }   /* brahmi */,
  {     3,  3075,     0,  18,   0, PL_ZP }   /* paragraphseparator */,
  {     0,  4314,  5746,  13,   7, PL_JG__SEMKATH }   /* joininggroup=semkath */,
  {     4,  7459,  7583,   3,   7, PL_SC__PHAG }   /* sc=phagspa */,
  {     2,  2108,  2562,   4,  17, PL_JAMOEXTB }   /* inhanguljamoextendedb */,
  {     0,  5968,   125,   3,   2, PL_OCR }   /* inocr */,
  {     0,  6713,  8888,   3,   3, PL_IN__8 }   /* in=v80 */,
  {     0,  3129,  8492,  17,   4, PL_RUNR }   /* scriptextensions=runr */,
  {     2,  5765,  7951,  12,   5, PL_GRBASE }   /* graphemebase=true */,
  {     0,  3129,  2408,  17,   6, PL_BRAH }   /* scriptextensions=brahmi */,
  {     2,  7136,  1981,   6,  11, PL_CYRILLICSUP }   /* block=cyrillicsup */,
  {     3,  6756,  7997,  10,   4, PL_SD }   /* softdotted=yes */,
  {    33,  2134,  7951,   3,   5, PL_XPOSIXXDIGIT }   /* hex=true */,
  {     1,  5544,  8646,  13,   2, PL_NV__29 }   /* numericvalue=29 */,
  {     0,  2859,  2991,  18,   3, PL_DT__NAR }   /* decompositiontype=nar */,
  {     1,   974,  8675,  24,   3, PL_CCC__BL }   /* canonicalcombiningclass=218 */,
  {     3,  6472,  1621,  10,   6, PL_WB__FO }   /* wordbreak=format */,
  {     9,    18,  3223,   2,   3, -PL_RI }   /* ri=no */,
  {     1,  6890,   660,   4,  30, PL_CJKEXTF }   /* blk=cjkunifiedideographsextensionf */,
  {     0,    96,  7997,   5,   2, PL_XPOSIXALPHA }   /* alpha=y */,
  {     3,   184,  1107,   2,   8, PL_KANA }   /* iskatakana */,
  {     6,  3129,  7312,  17,   8, PL_TAGB }   /* scriptextensions=tagbanwa */,
  {    32,  6890,  3610,   4,   8, PL_INBOPOMOFO }   /* blk=bopomofo */,
  {     1,  5557,  3581,  13,   2, PL_PATSYN }   /* patternsyntax=t */,
  {     0,   184,  3866,   2,  16, PL_MISCMATHSYMBOLSB }   /* ismiscmathsymbolsb */,
  {     1,  7136,  6041,   6,  12, PL_PLAYINGCARDS }   /* block=playingcards */,
  {     1,  7288,  7007,   7,   9, PL_ITAL }   /* script=olditalic */,
  {    12,  7810,     0,   6,   0, PL_GOTH }   /* gothic */,
  {     3,  3129,  7443,  17,   4, PL_GRAN }   /* scriptextensions=gran */,
  {     1,  8016,    36,   4,   1, PL_GCB__T }   /* gcb=t */,
  {     0,  1887,  3223,   5,   2, -PL_XPOSIXLOWER }   /* lower=n */,
  {     1,  8096,   994,   5,   3, PL_BASS }   /* scx=bass */,
  {     2,  7136,  3722,   6,  16, PL_HIGHPUSURROGATES }   /* block=highpusurrogates */,
  {     1,  6706,  8867,  10,   3, PL_IN__5_DOT_1 }   /* presentin=v51 */,
  {     2,  6221,  2467,   4,   9, PL_COUNTINGROD }   /* incountingrod */,
  {     0,  5232,     0,  13,   0, PL_AEGEANNUMBERS }   /* aegeannumbers */,
  {     1,  4314,  7930,  13,   4, PL_JG__YUDH }   /* joininggroup=yudh */,
  {     1,  8816,  8618,   3,   3, PL_NV__1_SLASH_5 }   /* nv=1/5 */,
  {     1,  2100,  1029,   3,  26, PL_OCR }   /* isopticalcharacterrecognition */,
  {     0,  2985,  7768,  18,   6, -PL_IDST }   /* idstrinaryoperator=false */,
  {     4,  1503,  2504,   3,  18, PL_ENCLOSEDALPHANUMSUP }   /* inenclosedalphanumsup */,
  {     1,  8096,  2636,   4,   4, PL_MONG }   /* scx=mong */,
  {     0,  7380,  1483,   4,   2, PL_CCC__DB }   /* ccc=db */,
  {     0,  6890,  7991,   4,   5, PL_INBUHID }   /* blk=buhid */,
  {     2,  1746,    24,  21,   1, PL_GCB__L }   /* graphemeclusterbreak=l */,
  {     1,  8284,     0,   4,   0, PL_DSRT }   /* dsrt */,
  {     1,  7288,  5121,   7,  14, PL_SC__PHLP }   /* script=psalterpahlavi */,
  {     3,  8780,     0,   3,   0, PL_CWT }   /* cwt */,
  {     0,   184,  5323,   2,  13, PL_ME }   /* isenclosingmark */,
  {     1,  1746,  1133,  21,   7, PL_GCB__PP }   /* graphemeclusterbreak=prepend */,
  {     4,  6890,  4883,   4,  14, PL_LATINEXTE }   /* blk=latinextendede */,
  {     0,  1929,     0,   9,   0, PL_XPOSIXUPPER }   /* uppercase */,
  {     1,  1876,  7768,  21,   6, -PL_CWL }   /* changeswhenlowercased=false */,
  {     2,  5544,  7732,  13,   2, PL_NV__50 }   /* numericvalue=50 */,
  {     0,  3610,     0,  16,   0, PL_BOPOMOFOEXT }   /* bopomofoextended */,
  {     5,  6706,  7720,  10,   1, PL_IN__4 }   /* presentin=4 */,
  {     3,  3129,  7104,  17,   8, PL_ARMN }   /* scriptextensions=armenian */,
  {     0,  8332,  7599,   4,   5, PL_SHAW }   /* inshavian */,
  {     0,  7459,  8452,   3,   4, PL_SC__ORYA }   /* sc=orya */,
  {     1,  1746,    70,  21,   2, PL_GCB__PP }   /* graphemeclusterbreak=pp */,
  {     1,  7450,     0,   7,   0, PL_HANO }   /* hanunoo */,
  {     0,  5375,  6208,  12,  11, PL_JT__C }   /* joiningtype=joincausing */,
  {     3,    21,  6926,   2,   9, PL_INKHUDAWADI }   /* inkhudawadi */,
  {     3,  2750,  3223,   4,   3, -PL_TERM }   /* term=no */,
  {     5,   974,  7727,  24,   2, PL_CCC__32 }   /* canonicalcombiningclass=32 */,
  {     3,  8816,  8144,   3,   4, PL_NV__1_SLASH_20 }   /* nv=1/20 */,
  {     1,  6210,  7388,   3,   6, PL_CJKEXTA }   /* incjkexta */,
  {     0,   568,     0,   2,   0, PL_NB }   /* nb */,
  {     1,  2229,  1392,  16,   9, PL_CS }   /* generalcategory=surrogate */,
  {     0,  7408,     0,   7,   0, PL_CJKEXTD }   /* cjkextd */,
  {     1,  6890,   947,   4,  17, PL_ANCIENTGREEKMUSIC }   /* blk=ancientgreekmusic */,
  {     0,  1402,  2349,  24,  20, PL_INPC__TOPANDBOTTOMANDRIGHT }   /* indicpositionalcategory=topandbottomandright */,
  {     0,  1746,  4047,  21,   2, PL_LB__H2 }   /* graphemeclusterbreak=lv */,
  {     0,  8894,     0,   3,   1, PL_VO__U }   /* vo=u */,
  {     0,  4554,  1929,  14,   5, PL_SB__UP }   /* sentencebreak=upper */,
  {     1,   184,  6626,   2,   4, PL_KHAR }   /* iskhar */,
  {     2,  8344,    36,   3,   1, PL_JT__T }   /* jt=t */,
  {     1,  8096,  8192,   4,   4, PL_ADLM }   /* scx=adlm */,
  {     0,  6713,  8879,   3,   3, PL_IN__6_DOT_2 }   /* in=v62 */,
  {     0,  8352,     0,   4,   0, PL_KHMR }   /* khmr */,
  {     1,  3129,  2107,  17,   7, PL_SINH }   /* scriptextensions=sinhala */,
  {     1,  4402,  8401,   3,   3, PL_INMIAO }   /* inmiao */,
  {     1,  1690,     0,   2,   0, PL_CN }   /* cn */,
  {     1,  3129,  2269,  17,  20, PL_PHLI }   /* scriptextensions=inscriptionalpahlavi */,
  {     0,  3129,  7660,  17,   7, PL_TIRH }   /* scriptextensions=tirhuta */,
  {     3,  3129,  8604,  17,   4, PL_ZYYY }   /* scriptextensions=zyyy */,
  {     0,  2229,  8937,  16,   2, PL_ZL }   /* generalcategory=zl */,
  {     1,  2985,  7768,   4,   2, -PL_IDST }   /* idst=f */,
  {     2,   184,  5427,   2,   9, PL_MLYM }   /* ismalayalam */,
  {     1,  8376,  8921,   3,   2, PL_LB__BK }   /* lb=bk */,
  {     0,  6263,  6845,  10,   9, PL_LB__AI }   /* linebreak=ambiguous */,
  {     2,  3129,  7320,  17,   8, PL_TFNG }   /* scriptextensions=tifinagh */,
  {     0,  7136,   113,   6,  35, PL_DIACRITICALSFORSYMBOLS }   /* block=combiningdiacriticalmarksforsymbols */,
  {     1,   864,     0,  28,   0, PL_SUPPUAB }   /* supplementaryprivateuseareab */,
  {     0,  5957,     0,   4,   0, PL_MEND }   /* mend */,
  {     2,  7894,     0,   6,   0, PL_PATSYN }   /* patsyn */,
  {     1,  3129,   494,  17,   3, PL_HAN }   /* scriptextensions=han */,
  {     3,  1963,  7768,   7,   2, -PL_RADICAL }   /* radical=f */,
  {     0,  6890,  7876,   4,   6, PL_INLYCIAN }   /* blk=lycian */,
  {     0,  8572,  6971,   3,   6, PL_WB__MN }   /* wb=midnum */,
  {     0,   974,  1108,  24,   3, PL_CCC__214 }   /* canonicalcombiningclass=ata */,
  {     2,  7459,  2044,   3,  11, PL_MTEI }   /* sc=meeteimayek */,
  {     3,  7288,  2598,   7,   4, PL_MERO }   /* script=mero */,
  {     1,   184,  7534,   2,   7, PL_NB }   /* isnoblock */,
  {     0,  6890,  4659,   4,  14, PL_ANCIENTSYMBOLS }   /* blk=ancientsymbols */,
  {     0,  1887,     0,   9,   0, PL_XPOSIXLOWER }   /* lowercase */,
  {     4,  4554,   496,  14,   7, PL_LB__NU }   /* sentencebreak=numeric */,
  {     1,   122,  7997,   9,   2, PL_DIA }   /* diacritic=y */,
  {     3,  6890,   808,   4,  18, PL_PHONETICEXT }   /* blk=phoneticextensions */,
  {     1,  3850,     0,  16,   0, PL_MISCMATHSYMBOLSA }   /* miscmathsymbolsa */,
  {     2,   184,  8384,   2,   4, PL_LINB }   /* islinb */,
  {     0,   892,  3223,  17,   3, -PL_VS }   /* variationselector=no */,
  {     0,  5134,     6,   3,   1, PL_PD }   /* ispd */,
  {     1,   974,  2777,  24,   5, PL_CCC__A }   /* canonicalcombiningclass=above */,
  {     1,  8011,  1452,   3,   2, PL_PS }   /* gc=ps */,
  {     0,    21,  4841,   2,  14, PL_LATINEXTB }   /* inlatinextendedb */,
  {     2,  3237,     0,  17,   0, PL_ALCHEMICAL }   /* alchemicalsymbols */,
  {     0,  5544,  7732,  13,   6, PL_NV__500000 }   /* numericvalue=500000 */,
  {     4,  2229,  2088,  16,   2, PL_PD }   /* generalcategory=pd */,
  {     0,  4479,  7373,   5,   3, PL_NFCQC__M }   /* nfkcqc=m */,
  {     2,  7136,   959,   6,   5, PL_MUSIC }   /* block=music */,
  {     1,  7136,  3543,   6,  17, PL_SMALLFORMS }   /* block=smallformvariants */,
  {     2,  2985,     0,   4,   0, PL_IDST }   /* idst */,
  {     1,  6881,     0,   9,   0, PL_BHKS }   /* bhaiksuki */,
  {     0,   217,  6484,   6,   6, PL__PERL_IDCONT }   /* _perl_idcont */,
  {     4,    58,     0,   4,   0, PL_IDEO }   /* ideo */,
  {     2,  8340,  3492,   3,  17, PL_JG__MANICHAEANTHAMEDH }   /* jg=manichaeanthamedh */,
  {     7,  8340,  7930,   3,   4, PL_JG__YUDH }   /* jg=yudh */,
  {     7,  8376,  6816,   3,  10, PL_LB__WJ }   /* lb=wordjoiner */,
  {     0,  3129,  4509,  17,  15, PL_SARB }   /* scriptextensions=oldsoutharabian */,
  {     1,  8376,  5753,   3,   4, PL_LB__GL }   /* lb=glue */,
  {     1,   184,  4827,   2,  14, PL_KANGXI }   /* iskangxiradicals */,
  {     1,  1929,  3223,   9,   2, -PL_XPOSIXUPPER }   /* uppercase=n */,
  {     1,  1746,  5762,  21,   3, PL_LB__ZWJ }   /* graphemeclusterbreak=zwj */,
  {     0,  7136,  4883,   6,  14, PL_LATINEXTE }   /* block=latinextendede */,
  {     0,  1963,  3581,   7,   2, PL_RADICAL }   /* radical=t */,
  {     1,  5645,  4149,  10,  15, PL_BC__CS }   /* bidiclass=commonseparator */,
  {     1,  2236,     7,  10,   1, PL_L_AMP_ }   /* category=lc */,
  {     0,  3129,  8364,  17,   4, PL_LANA }   /* scriptextensions=lana */,
  {     0,  6890,  1691,   9,  11, PL_INDICNUMBERFORMS }   /* blk=indicnumberforms */,
  {     2,  6647,   534,   4,   2, PL_CANS }   /* iscans */,
  {     2,  8011,  8941,   3,   2, PL_ZS }   /* gc=zs */,
  {     0,  6263,  6576,  10,  10, PL_LB__BA }   /* linebreak=breakafter */,
  {     0,  4314,  3475,  13,  17, PL_JG__MANICHAEANHUNDRED }   /* joininggroup=manichaeanhundred */,
  {     2,  8096,  8400,   4,   4, PL_MIAO }   /* scx=miao */,
  {     0,  5134,   809,   3,  17, PL_PHONETICEXT }   /* isphoneticextensions */,
  {     6,  8076,  7997,   5,   2, PL_PATWS }   /* patws=y */,
  {     9,  8096,   954,   4,   5, PL_GREK }   /* scx=greek */,
  {     0,   184,  1111,   2,   4, PL_KANA }   /* iskana */,
  {     2,  6263,  5762,  10,   2, PL_LB__ZW }   /* linebreak=zw */,
  {     0,  7136,  2967,   6,  18, PL_GEORGIANSUP }   /* block=georgiansupplement */,
  {     0,  7136,  4644,   6,  15, PL_INZANABAZARSQUARE }   /* block=zanabazarsquare */,
  {     5,  6263,    25,  10,   2, PL_LB__SY }   /* linebreak=sy */,
  {     1,  7136,  7272,   6,   8, PL_INMAHAJANI }   /* block=mahajani */,
  {     3,  6890,    42,   4,  36, PL_CJKCOMPATIDEOGRAPHSSUP }   /* blk=cjkcompatibilityideographssupplement */,
  {     1,  7136,  2249,   6,  20, PL_GLAGOLITICSUP }   /* block=glagoliticsupplement */,
  {     3,  3516,  7768,  10,   6, -PL_XPOSIXSPACE }   /* whitespace=false */,
  {     0,  3521,  7951,   5,   5, PL_XPOSIXSPACE }   /* space=true */,
  {     1,  5310,     0,  13,   0, PL_XPOSIXDIGIT }   /* decimalnumber */,
  {    17,   184,   699,   2,   6, PL_N }   /* isnumber */,
  {     0,  7366,     0,   7,   0, PL_BENG }   /* bengali */,
  {     0,  5544,  8615,  13,   3, PL_NV__1_SLASH_3 }   /* numericvalue=1/3 */,
  {     1,  8011,    47,   4,   1, PL_SM }   /* gc=sm */,
  {     0,  3129,  8444,  17,   4, PL_OLCK }   /* scriptextensions=olck */,
  {     0,  6210,  3340,   3,  16, PL_CYRILLICEXTB }   /* incyrillicextendedb */,
  {     3,  7288,  7506,   7,   7, PL_SC__LINA }   /* script=lineara */,
  {     1,  8096,  7312,   4,   8, PL_TAGB }   /* scx=tagbanwa */,
  {     0,  7288,  7019,   7,   4, PL_SC__PERM }   /* script=perm */,
  {     1,  5544,  7944,  13,   2, PL_NV__12 }   /* numericvalue=12 */,
  {     1,  4284,  7667,  14,   7, PL_HST__NA }   /* hangulsyllabletype=na */,
  {     4,  1929,  3223,   5,   3, -PL_XPOSIXUPPER }   /* upper=no */,
  {     1,  6109,     1,  10,   1, PL_CN }   /* category=cn */,
  {     1,  7380,  8171,   7,   2, PL_CCC__23 }   /* ccc=ccc23 */,
  {     1,  7288,  7272,   7,   8, PL_SC__MAHJ }   /* script=mahajani */,
  {     1,  8006,  3223,   5,   3, -PL_CWKCF }   /* cwkcf=no */,
  {     3,  7136,  8061,   6,   5, PL_INOGHAM }   /* block=ogham */,
  {     7,  7443,     0,   7,   0, PL_GRAN }   /* grantha */,
  {     3,  6890,  7232,   4,   8, PL_JAMOEXTA }   /* blk=jamoexta */,
  {     0,  8096,  8396,   4,   4, PL_MERC }   /* scx=merc */,
  {     0,  8288,  8834,   3,   3, PL_DT__SQR }   /* dt=sqr */,
  {     1,  8340,  6580,   3,   3, PL_JG__KAF }   /* jg=kaf */,
  {     0,  4239,     0,   4,   0, PL_DASH }   /* dash */,
  {     1,  6263,  4561,  10,   2, PL_LB__EB }   /* linebreak=eb */,
  {     2,  7136,  1797,   6,   4, PL_INMODI }   /* block=modi */,
  {     2,  7689,  5246,   3,  12, PL_POSIXXDIGIT }   /* isasciihexdigit */,
  {     1,  6890,  7632,   4,   7, PL_INTAGALOG }   /* blk=tagalog */,
  {     1,  8340,  5163,   3,  14, PL_JG__HAMZAONHEHGOAL }   /* jg=tehmarbutagoal */,
  {     0,  2985,  3581,   4,   2, PL_IDST }   /* idst=t */,
  {     4,  6890,  2805,   4,  18, PL_HALFMARKS }   /* blk=combininghalfmarks */,
  {     3,  6890,  3594,   4,   9, PL_ARABICSUP }   /* blk=arabicsup */,
  {     0,  1897,  3223,  21,   3, -PL_CWT }   /* changeswhentitlecased=no */,
  {     3,  6210,  5694,   3,  11, PL_CYRILLICEXTB }   /* incyrillicextb */,
  {     0,  7459,  7632,   3,   7, PL_SC__TGLG }   /* sc=tagalog */,
  {     0,  4542,  8112,   3,   4, PL_TAKR }   /* istakri */,
  {     1,  5134,  1134,   3,  25, PL_PCM }   /* isprependedconcatenationmark */,
  {     7,  4314,  4344,  13,  15, PL_JG__MANICHAEANALEPH }   /* joininggroup=manichaeanaleph */,
  {     0,  7136,  3882,   6,   7, PL_INMYANMAR }   /* block=myanmar */,
  {     0,   184,  1768,   2,  22, PL_MISCTECHNICAL }   /* ismiscellaneoustechnical */,
  {     6,  7478,  7612,   3,   6, PL_SOYO }   /* issoyombo */,
  {     1,  8786,  1093,   3,   9, PL_EA__F }   /* ea=fullwidth */,
  {     0,  3114,     1,   3,  33, PL_UCAS }   /* inunifiedcanadianaboriginalsyllabics */,
  {     0,    21,  8432,   2,   3, PL_INNKO }   /* innko */,
  {    17,  3129,  8106,  17,   5, PL_TALE }   /* scriptextensions=taile */,
  {     0,   184,  1887,   2,   5, PL_XPOSIXLOWER }   /* islower */,
  {     5,  7136,  1028,   6,  27, PL_OCR }   /* block=opticalcharacterrecognition */,
  {     2,  8572,     0,   4,   1, PL_WB__NU }   /* wb=nu */,
  {     3,  5250,  7997,   8,   4, PL_XPOSIXXDIGIT }   /* hexdigit=yes */,
  {     0,  1834,  7997,  21,   2, PL_CWCF }   /* changeswhencasefolded=y */,
  {     2,  6713,  7720,   3,   1, PL_IN__4 }   /* in=4 */,
  {     1,  8448,     0,   4,   0, PL_ORKH }   /* orkh */,
  {     2,  5544,  7732,  13,   4, PL_NV__5000 }   /* numericvalue=5000 */,
  {     0,   184,  7429,   2,   7, PL_DSRT }   /* isdeseret */,
  {     0,  6890,  7007,   4,   9, PL_INOLDITALIC }   /* blk=olditalic */,
  {     2,  1417,  6362,   9,  11, PL_SO }   /* category=othersymbol */,
  {     0,  6890,     6,   5,   2, PL_INIDC }   /* blk=idc */,
  {     1,  6890,   183,   4,  34, PL_MISCPICTOGRAPHS }   /* blk=miscellaneoussymbolsandpictographs */,
  {     1,   184,  1107,   2,  26, PL_KATAKANAEXT }   /* iskatakanaphoneticextensions */,
  {     1,   184,  8396,   2,   4, PL_MERC }   /* ismerc */,
  {     0,  4554,   723,  15,   4, PL_SB__CL }   /* sentencebreak=close */,
  {     2,   117,   416,   3,  31, PL_INIDC }   /* inideographicdescriptioncharacters */,
  {     8,  5134,  8461,   3,   3, PL_PHLP }   /* isphlp */,
  {     0,  4554,  8101,  14,   5, PL_SB__ST }   /* sentencebreak=sterm */,
  {     0,  8096,  8320,   4,   4, PL_HLUW }   /* scx=hluw */,
  {     6,  7288,  8368,   7,   4, PL_LAO }   /* script=laoo */,
  {     1,   974,  8171,  24,   2, PL_CCC__23 }   /* canonicalcombiningclass=23 */,
  {     1,  4449,  7373,   4,   3, PL_NFCQC__M }   /* nfcqc=m */,
  {     0,  6890,  6863,   4,   9, PL_ARABICPFA }   /* blk=arabicpfa */,
  {     5,  7288,  7604,   7,   7, PL_SIDD }   /* script=siddham */,
  {     1,  6890,  7621,   4,   3, PL_PUA }   /* blk=pua */,
  {     1,  6706,  8768,  10,   3, PL_IN__9 }   /* presentin=9.0 */,
  {     0,  6647,     2,   5,   1, PL_CARI }   /* iscari */,
  {     4,  2859,  3003,  18,   7, PL_DT__INIT }   /* decompositiontype=initial */,
  {     3,  8816,  5219,   3,  13, PL_NV__1000000000000 }   /* nv=1000000000000 */,
  {     2,  8288,  5488,   3,   4, PL_DT__NONE }   /* dt=none */,
  {     0,   974,  7702,  27,   2, PL_CCC__20 }   /* canonicalcombiningclass=ccc20 */,
  {     0,  7906,  5066,   5,   2, PL_SC__KHOJ }   /* sc=khoj */,
  {     0,  2229,  5079,  16,  14, PL_MN }   /* generalcategory=nonspacingmark */,
  {     2,  6554,  1498,   3,  13, PL_BYZANTINEMUSIC }   /* inbyzantinemusic */,
  {     0,  1497,     0,  14,   0, PL_BYZANTINEMUSIC }   /* byzantinemusic */,
  {     5,  8096,  7660,   4,   4, PL_TIRH }   /* scx=tirh */,
  {     4,   184,  8608,   2,   4, PL_ZZZZ }   /* iszzzz */,
  {     0,  3129,  7555,  17,   7, PL_OLCK }   /* scriptextensions=olchiki */,
  {     3,  8096,  8061,   4,   5, PL_OGAM }   /* scx=ogham */,
  {     1,  7459,  7120,   3,   4, PL_BALI }   /* sc=bali */,
  {     4,  8508,  8369,   4,   3, PL_LAO }   /* sc=laoo */,
  {     1,  7288,  7569,   7,   4, PL_OSMA }   /* script=osma */,
  {     2,  8086,  3223,   5,   3, -PL_QMARK }   /* qmark=no */,
  {     1,  7478,  1451,   3,  23, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* issupsymbolsandpictographs */,
  {     0,    76,  7946,   2,   5, PL_NV__NAN }   /* nt=none */,
  {     0,  7459,  4104,   3,   4, PL_BAMU }   /* sc=bamu */,
  {     0,  8011,  8263,   3,   2, PL_MC }   /* gc=mc */,
  {     1,  8016,  8789,   4,   3, PL_WB__EBG }   /* gcb=ebg */,
  {     0,  8026,  5094,   3,  13, PL_PHONETICEXTSUP }   /* inphoneticextsup */,
  {     1,  7459,  7912,   3,   6, PL_SC__TELU }   /* sc=telugu */,
  {     3,  7459,  3458,   3,  10, PL_SC__MANI }   /* sc=manichaean */,
  {     1,  6890,  2249,   4,  13, PL_GLAGOLITICSUP }   /* blk=glagoliticsup */,
  {     3,  4284,  5177,  14,  14, PL_GCB__V }   /* hangulsyllabletype=voweljamo */,
  {     3,  7272,     0,   8,   0, PL_MAHJ }   /* mahajani */,
  {     2,  8240,  3408,   4,  16, PL_BC__ES }   /* bc=europeanseparator */,
  {     6,  7227,  5253,   5,   5, PL_POSIXDIGIT }   /* posixdigit */,
  {     2,  6263,  1204,  10,   2, PL_LB__PO }   /* linebreak=po */,
  {    11,  7478,  2732,   3,  18, PL_SUPARROWSC }   /* issupplementalarrowsc */,
  {     0,   112,     0,   2,   0, PL_SC }   /* sc */,
  {     2,  7288,  7611,   7,   4, PL_SOYO }   /* script=soyo */,
  {     0,  7224,  7986,   8,   5, PL_XPOSIXBLANK }   /* isxposixblank */,
  {     1,  2731,     0,  19,   0, PL_SUPARROWSC }   /* supplementalarrowsc */,
  {     0,  6613,  3723,   3,  15, PL_HIGHPUSURROGATES }   /* ishighpusurrogates */,
  {     4,  8777,  7997,   3,   2, PL_CWL }   /* cwl=y */,
  {     0,  8288,    45,   3,   6, PL_DT__COM }   /* dt=compat */,
  {     0,    34,  7768,   3,   2, -PL_EXT }   /* ext=f */,
  {     0,  3373,  8576,  15,   4, PL_EA__W }   /* eastasianwidth=wide */,
  {     3,  7288,  8472,   7,   4, PL_PRTI }   /* script=prti */,
  {     5,  6890,  3994,   4,  16, PL_SYRIACSUP }   /* blk=syriacsupplement */,
  {     0,    21,  6626,   2,  10, PL_INKHAROSHTHI }   /* inkharoshthi */,
  {     0,  6713,  8660,   3,   3, PL_IN__2_DOT_1 }   /* in=2.1 */,
  {     0,  6890,  2128,   4,   6, PL_YIJING }   /* blk=yijing */,
  {     1,  8798,  7997,   3,   2, PL_LOE }   /* loe=y */,
  {     0,  6484,  7951,  10,   5, PL_IDC }   /* idcontinue=true */,
  {     2,  3129,  8432,  17,   4, PL_NKO }   /* scriptextensions=nkoo */,
  {     0,  2859,  8292,  18,   4, PL_DT__FONT }   /* decompositiontype=font */,
  {     0,  8026,  6450,   5,  11, PL_INPC__TOPANDRIGHT }   /* inpc=topandright */,
  {     0,  7380,  8740,   4,   2, PL_CCC__25 }   /* ccc=25 */,
  {     1,  8240,   806,   3,   2, PL_BC__WS }   /* bc=ws */,
  {     0,  6890,  8056,   4,   5, PL_INNUSHU }   /* blk=nushu */,
  {     1,  6890,  1658,   4,  19, PL_CJKCOMPATIDEOGRAPHS }   /* blk=cjkcompatideographs */,
  {     0,   184,  2531,   2,   4, PL_MULT }   /* ismult */,
  {     0,  8096,  8368,   4,   3, PL_LAO }   /* scx=lao */,
  {     3,  8204,  7997,   4,   4, PL_POSIXXDIGIT }   /* ahex=yes */,
  {     2,  1426,  1330,  22,  24, PL_INSC__CONSONANTSUCCEEDINGREPHA }   /* indicsyllabiccategory=consonantsucceedingrepha */,
  {     0,   221,     0,   2,   0, PL_L_AMP_ }   /* l_ */,
  {     0,  7288,  3674,   7,   7, PL_SC__CPRT }   /* script=cypriot */,
  {     0,  7840,    25,   3,   1, PL_VS }   /* isvs */,
  {     0,   184,    74,   2,   2, PL_ME }   /* isme */,
  {     1,  1417,  3854,   9,  10, PL_SM }   /* category=mathsymbol */,
  {     7,  5544,  8140,  13,   4, PL_NV__1_SLASH_10 }   /* numericvalue=1/10 */,
  {     0,  8011,   133,   3,   4, PL_M }   /* gc=mark */,
  {     0,  2134,  7997,   3,   2, PL_XPOSIXXDIGIT }   /* hex=y */,
  {     0,  7459,  7043,   3,   4, PL_PAUC }   /* sc=pauc */,
  {    16,  8816,  7710,   3,   3, PL_NV__600 }   /* nv=600 */,
  {     5,   949,  7768,   2,   6, -PL_CI }   /* ci=false */,
  {     1,  7288,  8071,   7,   5, PL_OSGE }   /* script=osage */,
  {     3,  8096,  8432,   4,   4, PL_NKO }   /* scx=nkoo */,
  {     1,   113,     0,  25,   0, PL_DIACRITICALS }   /* combiningdiacriticalmarks */,
  {     1,   184,  8296,   2,   4, PL_GONM }   /* isgonm */,
  {     1,  7288,  7590,   7,   7, PL_SC__SHRD }   /* script=sharada */,
  {     0,  2236,     0,  10,   0, PL_L }   /* category=l */,
  {     2,  6890,  3560,   4,  17, PL_SUTTONSIGNWRITING }   /* blk=suttonsignwriting */,
  {     1,  5245,  3223,  13,   3, -PL_POSIXXDIGIT }   /* asciihexdigit=no */,
  {     8,  5645,  2086,  10,  21, PL_BC__PDI }   /* bidiclass=popdirectionalisolate */,
  {     3,  4542,  8549,   3,   3, PL_TFNG }   /* istfng */,
  {     4,  6263,   184,  10,   2, PL_LB__IS }   /* linebreak=is */,
  {     1,  1929,  3223,   5,   2, -PL_XPOSIXUPPER }   /* upper=n */,
  {     1,  7136,  6029,   6,   8, PL_PHAISTOS }   /* block=phaistos */,
  {     2,  3526,  3223,  17,   2, -PL_RI }   /* regionalindicator=n */,
  {     1,  1417,  1886,   9,   2, PL_NL }   /* category=nl */,
  {     3,  8096,  1680,   4,   6, PL_ZYYY }   /* scx=common */,
  {     4,    21,  7534,   2,   7, PL_NB }   /* innoblock */,
  {    11,  6890,  7583,   4,   7, PL_INPHAGSPA }   /* blk=phagspa */,
  {     5,  7288,  7336,   7,   8, PL_UGAR }   /* script=ugaritic */,
  {     1,   184,  8480,   2,   4, PL_QAAI }   /* isqaai */,
  {     0,   184,  3675,   3,   6, PL_CPRT }   /* iscypriot */,
  {     0,  5544,  8180,  13,   3, PL_NV__3_SLASH_8 }   /* numericvalue=3/8 */,
  {     0,  7136,  3898,   6,  16, PL_MYANMAREXTB }   /* block=myanmarextendedb */,
  {    11,   132,     0,   2,   0, PL_LM }   /* lm */,
  {     3,  1448,  2676,   4,   7, PL_INSUNDANESE }   /* insundanese */,
  {     0,  1028,     0,  27,   0, PL_OCR }   /* opticalcharacterrecognition */,
  {     1,  5765,  7768,  12,   2, -PL_GRBASE }   /* graphemebase=f */,
  {     2,  1107,     0,  26,   0, PL_KATAKANAEXT }   /* katakanaphoneticextensions */,
  {     3,    96,     0,   5,   0, PL_XPOSIXALPHA }   /* alpha */,
  {     2,  6890,   183,   4,  20, PL_MISCSYMBOLS }   /* blk=miscellaneoussymbols */,
  {     2,  5645,  4121,  12,  13, PL_BC__BN }   /* bidiclass=boundaryneutral */,
  {     5,  8096,  8216,   4,   4, PL_ARMI }   /* scx=armi */,
  {     0,   974,  8645,  24,   3, PL_CCC__129 }   /* canonicalcombiningclass=129 */,
  {     0,  4923,  5947,   4,  10, PL_MATHALPHANUM }   /* inmathalphanum */,
  {     4,   974,  8687,  24,   3, PL_CCC__R }   /* canonicalcombiningclass=226 */,
  {     0,  7136,  5414,   6,  13, PL_LOWSURROGATES }   /* block=lowsurrogates */,
  {     1,  6472,  7352,  10,   7, PL_WB__LE }   /* wordbreak=aletter */,
  {     5,  7828,  7997,   6,   4, PL_HYPHEN }   /* hyphen=yes */,
  {     0,  3129,  6881,  17,   9, PL_BHKS }   /* scriptextensions=bhaiksuki */,
  {     0,  1702,     0,  12,   0, PL_DIACRITICALS }   /* diacriticals */,
  {     0,  7288,  8420,   7,   4, PL_NARB }   /* script=narb */,
  {     0,  8340,  6494,   3,  11, PL_JG__YEHWITHTAIL }   /* jg=yehwithtail */,
  {     0,   184,  5801,   2,   5, PL_KHMR }   /* iskhmer */,
  {     0,  1450,     0,  24,   0, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* supsymbolsandpictographs */,
  {     0,   295,     0,   2,   0, PL_SM }   /* sm */,
  {     5,  7478,   218,   7,   4, PL_XPOSIXSPACE }   /* isspaceperl */,
  {     1,  4554,    33,  14,   2, PL_SB__SE }   /* sentencebreak=se */,
  {     0,    21,  3770,   2,  16, PL_LINEARBSYLLABARY }   /* inlinearbsyllabary */,
  {     5,  8476,     0,   4,   0, PL_COPT }   /* qaac */,
  {     1,  4314,  7961,  13,   5, PL_JG__ALAPH }   /* joininggroup=alaph */,
  {     1,  8786,  8576,   3,   4, PL_EA__W }   /* ea=wide */,
  {     1,  6210,    43,   3,   2, PL_CJK }   /* incjk */,
  {     0,  8822,     0,   3,   0, PL_PCM }   /* pcm */,
  {     1,  7478,  6787,   3,   9, PL_SUPARROWSC }   /* issuparrowsc */,
  {     1,  5645,    25,  10,   1, PL_BC__S }   /* bidiclass=s */,
  {     3,  2229,  6340,  16,  11, PL_LO }   /* generalcategory=otherletter */,
  {     1,  7288,  2636,   7,   9, PL_SC__MONG }   /* script=mongolian */,
  {     1,  7459,  8268,   3,   4, PL_SC__CPRT }   /* sc=cprt */,
  {     9,   974,  7708,  24,   3, PL_CCC__216 }   /* canonicalcombiningclass=216 */,
  {     0,  8340,  3834,   3,  16, PL_JG__MANICHAEANTWENTY }   /* jg=manichaeantwenty */,
  {     3,  6647,    12,   5,   3, PL_CARI }   /* iscarian */,
  {     0,  8376,  5762,   3,   3, PL_LB__ZWJ }   /* lb=zwj */,
  {     2,  6890,  1028,   4,  27, PL_OCR }   /* blk=opticalcharacterrecognition */,
  {     2,  6890,  1566,   4,   6, PL_INHANGUL }   /* blk=hangul */,
  {     0,  8011,  3003,   3,  18, PL_PI }   /* gc=initialpunctuation */,
  {     2,   184,  2636,   2,  12, PL_MONGOLIANSUP }   /* ismongoliansup */,
  {     1,  8196,  8747,   4,   3, PL_AGE__6 }   /* age=6.0 */,
  {     0,  8196,  8846,   4,   3, PL_AGE__2_DOT_1 }   /* age=v21 */,
  {     0,  7459,  8400,   3,   4, PL_MIAO }   /* sc=miao */,
  {     1,  4209,     0,  15,   0, PL_CONTROLPICTURES }   /* controlpictures */,
  {     0,  8444,     0,   4,   0, PL_OLCK }   /* olck */,
  {     0,  8026,   809,   3,  10, PL_PHONETICEXT }   /* inphoneticext */,
  {     1,  6890,  1797,   4,  15, PL_MODIFIERLETTERS }   /* blk=modifierletters */,
  {     0,  1503,   721,   3,  20, PL_ENCLOSEDALPHANUM }   /* inenclosedalphanumerics */,
  {     4,  7224,  8001,   8,   5, PL_XPOSIXCNTRL }   /* isxposixcntrl */,
  {     1,  7459,  3610,   3,   4, PL_SC__BOPO }   /* sc=bopo */,
  {     2,  6890,  7272,   4,   8, PL_INMAHAJANI }   /* blk=mahajani */,
  {     9,   892,     0,  18,   0, PL_INVS }   /* variationselectors */,
  {     1,  6616,  7997,  10,   2, PL_DEP }   /* deprecated=y */,
  {     3,  6890,  5427,   4,   9, PL_INMALAYALAM }   /* blk=malayalam */,
  {    11,  1417,  8263,   9,   2, PL_MC }   /* category=mc */,
  {     4,  3521,  7997,   5,   4, PL_XPOSIXSPACE }   /* space=yes */,
  {     1,  8096,  3754,   4,   7, PL_LINB }   /* scx=linearb */,
  {     0,   184,  8368,   2,   4, PL_LAO }   /* islaoo */,
  {     0,  4883,     0,  14,   0, PL_LATINEXTE }   /* latinextendede */,
  {     0,  7380,  7727,   4,   2, PL_CCC__32 }   /* ccc=32 */,
  {     0,  1566,     0,  23,   0, PL_COMPATJAMO }   /* hangulcompatibilityjamo */,
  {     0,  7696,  7768,   6,   6, -PL_XPOSIXSPACE }   /* wspace=false */,
  {     0,  8376,  8927,   3,   2, PL_GCB__L }   /* lb=jl */,
  {     1,  1402,  5271,  24,  13, PL_INPC__BOTTOMANDLEFT }   /* indicpositionalcategory=bottomandleft */,
  {     0,  6890,   720,   4,  21, PL_ENCLOSEDALPHANUM }   /* blk=enclosedalphanumerics */,
  {     0,  5375,     0,  13,   0, PL_JT__D }   /* joiningtype=d */,
  {     1,  2389,     0,  19,   0, PL_ANCIENTGREEKNUMBERS }   /* ancientgreeknumbers */,
  {     0,  7136,  4105,   7,  14, PL_BAMUMSUP }   /* block=bamumsupplement */,
  {     0,   184,   541,   3,  29, PL_CJKEXTB }   /* iscjkunifiedideographsextensionb */,
  {     0,  7906,  2098,   4,   3, PL_SC__KALI }   /* sc=kali */,
  {     0,  2229,  3914,  16,   5, PL_C }   /* generalcategory=other */,
  {     3,  2369,  1548,  20,   2, PL_VO__TR }   /* verticalorientation=tr */,
  {     1,  3129,  6989,  17,   9, PL_TALU }   /* scriptextensions=newtailue */,
  {     1,  7227,  6472,   5,   4, PL_POSIXWORD }   /* posixword */,
  {     2,  5645,  3516,  10,  10, PL_BC__WS }   /* bidiclass=whitespace */,
  {     2,  8096,  7192,   4,   8, PL_GUJR }   /* scx=gujarati */,
  {     3,  8795,  4615,   3,   7, PL_VEDICEXT }   /* invedicext */,
  {     0,  6890,  3962,   4,  16, PL_SUPMATHOPERATORS }   /* blk=supmathoperators */,
  {     6,  6980,     0,   9,   0, PL_NBAT }   /* nabataean */,
  {     0,  8096,  8488,   4,   4, PL_RJNG }   /* scx=rjng */,
  {     2,  1448,  3965,   5,  13, PL_SUPMATHOPERATORS }   /* insupmathoperators */,
  {     2,  6890,  5258,   4,  13, PL_BLOCKELEMENTS }   /* blk=blockelements */,
  {     1,  3129,  8596,  17,   4, PL_ZANB }   /* scriptextensions=zanb */,
  {     1,  2750,  7997,   4,   2, PL_TERM }   /* term=y */,
  {     1,  7288,  7912,   7,   6, PL_SC__TELU }   /* script=telugu */,
  {     3,   184,  2877,   2,  10, PL_DEVA }   /* isdevanagari */,
  {     1,  7459,  4010,   3,   6, PL_TANG }   /* sc=tangut */,
  {     4,  8096,  8560,   4,   4, PL_TIBT }   /* scx=tibt */,
  {     1,  7288,  8476,   7,   4, PL_SC__COPT }   /* script=qaac */,
  {     3,  7288,  6676,   7,  10, PL_XPEO }   /* script=oldpersian */,
  {     1,   184,   691,   3,  15, PL_CUNEIFORMNUMBERS }   /* iscuneiformnumbers */,
  {     1,  5544,  7720,  13,   6, PL_NV__400000 }   /* numericvalue=400000 */,
  {     0,   184,  7248,   2,   4, PL_JAVA }   /* isjava */,
  {     0,  8504,  7070,   3,   9, PL_SB__SC }   /* sb=scontinue */,
  {     2,  7345,     0,   7,   0, PL_IDS }   /* idstart */,
  {     0,  7136,  1566,   6,  23, PL_COMPATJAMO }   /* block=hangulcompatibilityjamo */,
  {     8,  8816,  8643,   3,   2, PL_NV__22 }   /* nv=22 */,
  {     1,  7459,  4784,   3,   4, PL_CHAM }   /* sc=cham */,
  {     0,  2985,  7997,   3,   2, PL_IDS }   /* ids=y */,
  {     3,  8196,  8564,   4,   4, PL_AGE__10 }   /* age=v100 */,
  {     0,  4314,  5885,  13,  12, PL_JG__MALAYALAMNYA }   /* joininggroup=malayalamnya */,
  {     6,  3129,  7034,  17,   4, PL_PALM }   /* scriptextensions=palm */,
  {     2,  7380,  6131,   4,  11, PL_CCC__DA }   /* ccc=doubleabove */,
  {     0,  5544,  8691,  13,   2, PL_NV__28 }   /* numericvalue=28 */,
  {     0,  8096,  8408,   4,   4, PL_MRO }   /* scx=mroo */,
  {     2,   217,  6854,   6,   9, PL__PERL_ANY_FOLDS }   /* _perl_any_folds */,
  {     7,  3129,  7429,  17,   7, PL_DSRT }   /* scriptextensions=deseret */,
  {     0,  7478,  3758,   3,   3, PL_SARB }   /* issarb */,
  {    17,  7870,     0,   6,   0, PL_LEPC }   /* lepcha */,
  {     0,  6890,  4869,   4,  14, PL_LATINEXTD }   /* blk=latinextendedd */,
  {     1,  8288,  7888,   3,   6, PL_DT__NAR }   /* dt=narrow */,
  {     3,  3129,  7336,  17,   4, PL_UGAR }   /* scriptextensions=ugar */,
  {     6,  6890,  2598,   4,  19, PL_MERO }   /* blk=meroitichieroglyphs */,
  {     0,  8016,    34,   4,   2, PL_GREXT }   /* gcb=ex */,
  {     2,  8580,     0,   4,   0, PL_XPEO }   /* xpeo */,
  {     0,  7288,  8516,   7,   4, PL_SGNW }   /* script=sgnw */,
  {     1,  8376,  5772,   3,   5, PL_LB__EB }   /* lb=ebase */,
  {     5,   184,  3898,   2,  16, PL_MYANMAREXTB }   /* ismyanmarextendedb */,
  {     1,  8816,  7720,   3,   6, PL_NV__400000 }   /* nv=400000 */,
  {     2,  3129,  8580,  17,   4, PL_XPEO }   /* scriptextensions=xpeo */,
  {     0,   184,  8404,   2,   4, PL_MLYM }   /* ismlym */,
  {     0,   750,     0,  29,   0, PL_ENCLOSEDIDEOGRAPHICSUP }   /* enclosedideographicsupplement */,
  {     0,  1426,  5993,  22,  12, PL_INSC__NUMBERJOINER }   /* indicsyllabiccategory=numberjoiner */,
  {     2,  8816,  7750,   3,   2, PL_NV__80 }   /* nv=80 */,
  {     1,  7840,  8569,   3,   3, PL_VAI }   /* isvaii */,
  {     2,  7136,  7506,   6,   7, PL_INLINEARA }   /* block=lineara */,
  {     2,   186,  3581,   2,   2, PL_CE }   /* ce=t */,
  {     2,   184,  3850,   2,  16, PL_MISCMATHSYMBOLSA }   /* ismiscmathsymbolsa */,
  {     4,  7288,  7208,   7,   4, PL_SC__HIRA }   /* script=hira */,
  {     2,    42,     0,   3,   0, PL_CJK }   /* cjk */,
  {     5,  7288,  2598,   7,  19, PL_MERO }   /* script=meroitichieroglyphs */,
  {     1,  7061,     0,   9,   0, PL_SAMR }   /* samaritan */,
  {     2,  1887,  7997,   5,   2, PL_XPOSIXLOWER }   /* lower=y */,
  {     1,  4923,   363,   4,  19, PL_MATHOPERATORS }   /* inmathematicaloperators */,
  {     3,  1402,  2355,  24,   6, PL_INPC__BOTTOM }   /* indicpositionalcategory=bottom */,
  {     0,  6890,  7436,   4,   7, PL_INELBASAN }   /* blk=elbasan */,
  {     0,  3129,  3754,  17,   7, PL_LINB }   /* scriptextensions=linearb */,
  {     0,  8572,    34,   3,   2, PL_WB__EX }   /* wb=ex */,
  {     0,  8504,  1887,   3,   5, PL_SB__LO }   /* sb=lower */,
  {     1,  5051,  3223,  14,   2, PL_NFKDQC__N }   /* nfkdquickcheck=n */,
  {     0,  6263,    96,  10,  10, PL_LB__AL }   /* linebreak=alphabetic */,
  {     0,  7459,  8428,   3,   4, PL_NEWA }   /* sc=newa */,
  {     0,  7689,    80,   4,   8, PL_ARABICMATH }   /* isarabicmath */,
  {     0,   184,  7120,   2,   8, PL_BALI }   /* isbalinese */,
  {     1,  5134,  7896,   4,   4, PL_PATSYN }   /* ispatsyn */,
  {     0,  5134,   850,   3,  13, PL_PUA }   /* isprivateusearea */,
  {     1,  3129,  8284,  17,   4, PL_DSRT }   /* scriptextensions=dsrt */,
  {     0,  3129,  8091,  17,   5, PL_RUNR }   /* scriptextensions=runic */,
  {    16,  6706,  7756,  10,   1, PL_IN__9 }   /* presentin=9 */,
  {     8,  3129,  7436,  17,   7, PL_ELBA }   /* scriptextensions=elbasan */,
  {     0,  5645,     0,   5,   0, PL_BIDIC }   /* bidic */,
  {     0,  8340,  7864,   3,   6, PL_JG__LAMADH }   /* jg=lamadh */,
  {     0,  4269,     0,  15,   0, PL_DIACRITICALSSUP }   /* diacriticalssup */,
  {     0,  8288,  2991,   3,   3, PL_DT__NAR }   /* dt=nar */,
  {     1,  7288,  3566,   7,  11, PL_SGNW }   /* script=signwriting */,
  {     1,   974,  8648,  24,   3, PL_CCC__130 }   /* canonicalcombiningclass=130 */,
  {     2,  6713,  8882,   3,   3, PL_IN__6_DOT_3 }   /* in=v63 */,
  {     4,  8011,  3086,   5,   7, PL_Z }   /* gc=separator */,
  {     6,  2229,   698,  16,   2, PL_MN }   /* generalcategory=mn */,
  {     2,  6890,  3610,   4,  16, PL_BOPOMOFOEXT }   /* blk=bopomofoextended */,
  {     1,  6890,  7912,   4,   6, PL_INTELUGU }   /* blk=telugu */,
  {     2,  7696,  3223,   6,   3, -PL_XPOSIXSPACE }   /* wspace=no */,
  {     3,  7459,  1540,   3,   4, PL_SC__PHAG }   /* sc=phag */,
  {     2,  6890,   630,   4,  30, PL_CJKEXTE }   /* blk=cjkunifiedideographsextensione */,
  {     6,  7464,  3521,   7,   5, PL_XPOSIXBLANK }   /* ishorizspace */,
  {     0,  7136,  3706,   6,  16, PL_HALFANDFULLFORMS }   /* block=halfandfullforms */,
  {     2,  6208,  7997,   5,   4, PL_JOINC }   /* joinc=yes */,
  {     2,   630,     0,  30,   0, PL_CJKEXTE }   /* cjkunifiedideographsextensione */,
  {     1,  3288,     0,  17,   0, PL_AGHB }   /* caucasianalbanian */,
  {     0,  7136,  3866,   6,  16, PL_MISCMATHSYMBOLSB }   /* block=miscmathsymbolsb */,
  {     1,  8816,  7708,   3,   6, PL_NV__216000 }   /* nv=216000 */,
  {     8,  8200,     0,   4,   0, PL_AGHB }   /* aghb */,
  {     1,  7136,  1450,   6,  24, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* block=supsymbolsandpictographs */,
  {     7,   184,   479,   2,  31, PL_MATHALPHANUM }   /* ismathematicalalphanumericsymbols */,
  {     4,  7459,  1401,   3,   4, PL_SC__SIND }   /* sc=sind */,
  {     4,  7459,  4644,   3,  15, PL_ZANB }   /* sc=zanabazarsquare */,
  {     1,  6890,  1497,   4,  23, PL_BYZANTINEMUSIC }   /* blk=byzantinemusicalsymbols */,
  {     0,  6029,     0,  12,   0, PL_PHAISTOS }   /* phaistosdisc */,
  {     9,  6706,  5219,  10,   2, PL_IN__10 }   /* presentin=10 */,
  {     1,  8816,  8148,   3,   3, PL_NV__1_SLASH_4 }   /* nv=1/4 */,
  {     4,  5645,    32,  10,   2, PL_BC__CS }   /* bidiclass=cs */,
  {     0,  5544,  7732,  13,   5, PL_NV__50000 }   /* numericvalue=50000 */,
  {     3,  7136,   947,   6,  17, PL_ANCIENTGREEKMUSIC }   /* block=ancientgreekmusic */,
  {     1,   513,  7997,  16,   2, PL_UIDEO }   /* unifiedideograph=y */,
  {     2,    62,     0,   5,   0, PL_XPOSIXGRAPH }   /* graph */,
  {     2,  4554,  1887,  14,   5, PL_SB__LO }   /* sentencebreak=lower */,
  {     1,   184,   691,   3,   8, PL_XSUX }   /* iscuneiform */,
  {     2,   184,  1497,   2,  23, PL_BYZANTINEMUSIC }   /* isbyzantinemusicalsymbols */,
  {     0,  5544,  7714,  13,   4, PL_NV__3000 }   /* numericvalue=3000 */,
  {     0,  6263,  5763,  10,   2, PL_LB__WJ }   /* linebreak=wj */,
  {     2,  8783,     0,   3,   0, PL_CWU }   /* cwu */,
  {     1,  5051,  8256,   5,   3, PL_NFKDQC__N }   /* nfkdqc=n */,
  {     1,  8816,  8897,   3,   2, PL_NV__19 }   /* nv=19 */,
  {     0,  8524,     0,   4,   0, PL_SHRD }   /* shrd */,
  {     3,  8096,  2098,   5,   3, PL_BALI }   /* scx=bali */,
  {     1,  6221,  1308,   4,  22, PL_DIACRITICALSFORSYMBOLS }   /* incombiningmarksforsymbols */,
  {     0,  7136,    42,   6,  36, PL_CJKCOMPATIDEOGRAPHSSUP }   /* block=cjkcompatibilityideographssupplement */,
  {     1,  6109,  1628,  10,   6, PL_XPOSIXCNTRL }   /* category=control */,
  {     1,  1417,  4524,   9,  15, PL_PS }   /* category=openpunctuation */,
  {     0,  5968,  7556,   3,   6, PL_OLCK }   /* inolchiki */,
  {     0,  1184,  3581,  25,   2, PL_DI }   /* defaultignorablecodepoint=t */,
  {     4,  7828,  7768,   6,   6, -PL_HYPHEN }   /* hyphen=false */,
  {     0,  6890,  2895,   4,   8, PL_INETHIOPIC }   /* blk=ethiopic */,
  {     1,    58,  7951,   4,   5, PL_IDEO }   /* ideo=true */,
  {     1,  2990,  1236,   4,  22, PL_ARABICPFA }   /* inarabicpresentationformsa */,
  {     0,  3129,  8569,  18,   3, PL_VAI }   /* scriptextensions=vaii */,
  {     1,  6890,  1790,   4,  22, PL_MODIFIERLETTERS }   /* blk=spacingmodifierletters */,
  {     5,   184,  7696,   2,   6, PL_XPOSIXSPACE }   /* iswspace */,
  {     0,  6210,  7423,   3,   6, PL_CJKEXTF }   /* incjkextf */,
  {     2,  7288,  2107,   7,   4, PL_SC__SINH }   /* script=sinh */,
  {     2,  8340,  4981,   3,  14, PL_JG__MANICHAEANQOPH }   /* jg=manichaeanqoph */,
  {     5,  8340,  4935,   3,   4, PL_JG__BETH }   /* jg=beth */,
  {     2,  7457,  3914,   5,   5, PL_INSC__OTHER }   /* insc=other */,
  {     0,  7459,   358,   4,   3, PL_ITAL }   /* sc=ital */,
  {     0,  8816,  7702,   3,   6, PL_NV__200000 }   /* nv=200000 */,
  {     0,  7689,  5316,   3,   4, PL_XPOSIXALNUM }   /* isalnum */,
  {     4,  7288,    78,   7,   4, PL_SC__ARAB }   /* script=arab */,
  {     1,  6890,  7128,   4,   8, PL_INBASSAVAH }   /* blk=bassavah */,
  {     0,  6890,  3706,   4,  16, PL_HALFANDFULLFORMS }   /* blk=halfandfullforms */,
  {     1,  2229,  4224,  16,  14, PL_SC }   /* generalcategory=currencysymbol */,
  {     3,  2229,   206,  16,   2, PL_PI }   /* generalcategory=pi */,
  {     1,  8096,  6882,   5,   8, PL_BHKS }   /* scx=bhaiksuki */,
  {     2,  7380,  2295,   4,   5, PL_CCC__R }   /* ccc=right */,
  {     2,  3129,  8264,  17,   4, PL_CANS }   /* scriptextensions=cans */,
  {     2,   949,     0,   2,   0, PL_CI }   /* ci */,
  {     0,  8096,  2895,   4,   4, PL_ETHI }   /* scx=ethi */,
  {     0,    34,     0,   3,   0, PL_EXT }   /* ext */,
  {     1,  7459,  1160,   3,   4, PL_SC__HANG }   /* sc=hang */,
  {     2,  6890,  4494,   4,  15, PL_NARB }   /* blk=oldnortharabian */,
  {     1,  1206,  8117,   3,   4, PL_INTAMIL }   /* intamil */,
  {     8,  1892,  7951,   5,   5, PL_CASED }   /* cased=true */,
  {     2,  3509,  7997,  17,   2, PL_PATWS }   /* patternwhitespace=y */,
  {     3,  5544,  8729,  13,   3, PL_NV__4_SLASH_5 }   /* numericvalue=4/5 */,
  {     0,  7128,     0,   8,   0, PL_BASS }   /* bassavah */,
  {     0,  5544,  7702,  13,   6, PL_NV__200000 }   /* numericvalue=200000 */,
  {     0,  5557,  3223,  13,   3, -PL_PATSYN }   /* patternsyntax=no */,
  {     1,  1963,  7997,   7,   2, PL_RADICAL }   /* radical=y */,
  {     4,  4074,  7976,  15,   5, PL__PERL_CHARNAME_BEGIN }   /* _perl_charname_begin */,
  {     4,  1448,  2108,   3,   6, PL_INSINHALA }   /* insinhala */,
  {     5,  8816,  7942,   3,   4, PL_NV__1_SLASH_12 }   /* nv=1/12 */,
  {     0,  7136,  6428,   6,  11, PL_SUPERANDSUB }   /* block=superandsub */,
  {     0,  2750,  7997,   4,   4, PL_TERM }   /* term=yes */,
  {     8,   184,    17,   3,   1, PL_CO }   /* isco */,
  {     1,  7288,  8200,   7,   4, PL_AGHB }   /* script=aghb */,
  {     1,   184,  1659,   3,  21, PL_CJKCOMPATIDEOGRAPHSSUP }   /* iscjkcompatideographssup */,
  {     2,  5544,  8666,  13,   3, PL_NV__2_SLASH_5 }   /* numericvalue=2/5 */,
  {     1,  2805,     0,  18,   0, PL_HALFMARKS }   /* combininghalfmarks */,
  {     0,  3021,     0,   9,   0, PL_LATINEXTA }   /* latinexta */,
  {     2,  4314,  5163,  13,  14, PL_JG__HAMZAONHEHGOAL }   /* joininggroup=tehmarbutagoal */,
  {     2,  8096,  6439,   4,  11, PL_SYLO }   /* scx=sylotinagri */,
  {     0,  7136,  6586,   6,  10, PL_CJKSTROKES }   /* block=cjkstrokes */,
  {     1,  7834,     0,   4,   0, PL_PE }   /* ispe */,
  {     2,   184,  3965,   2,  13, PL_MATHOPERATORS }   /* ismathoperators */,
  {     1,  6613,  1567,   3,   5, PL_HANG }   /* ishangul */,
  {     2,   974,  2289,  24,   4, PL_CCC__L }   /* canonicalcombiningclass=left */,
  {     0,   184,  8380,   2,   4, PL_LINA }   /* islina */,
  {     4,  2369,  3194,  20,   7, PL_VO__R }   /* verticalorientation=rotated */,
  {     0,    21,  4855,   2,  14, PL_LATINEXTC }   /* inlatinextendedc */,
  {     2,  6890,  5149,   4,  14, PL_SUPPUNCTUATION }   /* blk=suppunctuation */,
  {     1,  8344,  6461,   3,  11, PL_JT__T }   /* jt=transparent */,
  {     0,  6890,  4089,   4,  15, PL_ARABICEXTA }   /* blk=arabicextendeda */,
  {     4,  6890,   690,   4,  30, PL_CUNEIFORMNUMBERS }   /* blk=cuneiformnumbersandpunctuation */,
  {     0,  5968,  6006,   3,  11, PL_INOLDHUNGARIAN }   /* inoldhungarian */,
  {     0,  7288,  8524,   7,   4, PL_SC__SHRD }   /* script=shrd */,
  {     3,  6917,     0,   9,   0, PL_QAAI }   /* inherited */,
  {     1,  7288,  5801,   7,   5, PL_KHMR }   /* script=khmer */,
  {     0,  4509,     0,  15,   0, PL_SARB }   /* oldsoutharabian */,
  {     4,  8456,     0,   4,   0, PL_OSGE }   /* osge */,
  {     3,  7840,  4616,   4,   6, PL_VEDICEXT }   /* isvedicext */,
  {     3,  7380,  7702,   4,   3, PL_CCC__133 }   /* ccc=200 */,
  {     0,  5544,  7714,  13,   1, PL_NV__3 }   /* numericvalue=3 */,
  {     0,   720,     0,  21,   0, PL_ENCLOSEDALPHANUM }   /* enclosedalphanumerics */,
  {     0,   186,  7768,   2,   6, -PL_CE }   /* ce=false */,
  {     1,  7136,  4869,   6,  14, PL_LATINEXTD }   /* block=latinextendedd */,
  {     3,  7459,  7128,   3,   4, PL_BASS }   /* sc=bass */,
  {     2,  8288,  3543,   3,   5, PL_DT__SML }   /* dt=small */,
  {     2,  7459,  7918,   3,   4, PL_SC__THAA }   /* sc=thaa */,
  {     0,  2229,   966,  16,   2, PL_NO }   /* generalcategory=no */,
  {     6,  8816,  7941,   3,   5, PL_NV__11_SLASH_12 }   /* nv=11/12 */,
  {     5,  8816,  5219,   3,   5, PL_NV__10000 }   /* nv=10000 */,
  {     8,   184,    34,   2,   3, PL_EXT }   /* isext */,
  {     8,  6263,  6816,  10,  10, PL_LB__WJ }   /* linebreak=wordjoiner */,
  {     4,  8376,    25,   3,   2, PL_LB__SY }   /* lb=sy */,
  {     1,  7380,  8933,   4,   2, PL_CCC__9 }   /* ccc=vr */,
  {     2,   184,  3021,   2,  18, PL_LATINEXTADDITIONAL }   /* islatinextadditional */,
  {     0,  2221,  4588,   3,  11, PL_LB__H2 }   /* hst=lvsyllable */,
  {     3,  8011,   599,   3,   2, PL_XPOSIXCNTRL }   /* gc=cc */,
  {     1,   974,  8655,  24,   2, PL_CCC__33 }   /* canonicalcombiningclass=33 */,
  {     1,  6616,  7768,  10,   6, -PL_DEP }   /* deprecated=false */,
  {     0,  1417,  4599,   9,  15, PL_LU }   /* category=uppercaseletter */,
  {     0,  2985,  7951,  18,   5, PL_IDST }   /* idstrinaryoperator=true */,
  {     1,  7459,  1981,   3,   8, PL_SC__CYRL }   /* sc=cyrillic */,
  {     2,  6120,     0,   6,   0, PL_DOMINO }   /* domino */,
  {     1,  1855,  3223,  21,   2, -PL_CWCM }   /* changeswhencasemapped=n */,
  {    12,  6890,  7312,   4,   8, PL_INTAGBANWA }   /* blk=tagbanwa */,
  {     3,  6706,  8756,  10,   3, PL_IN__6_DOT_3 }   /* presentin=6.3 */,
  {     1,  7459,  4104,   3,   5, PL_BAMU }   /* sc=bamum */,
  {     0,  5544,  8160,  13,   2, PL_NV__13 }   /* numericvalue=13 */,
  {     3,  1417,  6351,   9,  11, PL_NO }   /* category=othernumber */,
  {    16,  1426,  3914,  22,   5, PL_INSC__OTHER }   /* indicsyllabiccategory=other */,
  {     1,  5544,  8137,  13,   3, PL_NV__1_SLASH_2 }   /* numericvalue=1/2 */,
  {     2,   184,  5825,   2,   4, PL_MAHJ }   /* ismahj */,
  {     0,  2134,  3223,   3,   3, -PL_XPOSIXXDIGIT }   /* hex=no */,
  {     1,  3129,  8044,  17,   4, PL_PHLI }   /* scriptextensions=phli */,
  {     3,  8288,   436,   4,   2, PL_DT__ENC }   /* dt=enc */,
  {     4,  6472,  5777,  10,  12, PL_LB__HL }   /* wordbreak=hebrewletter */,
  {     1,  6210,  3323,   3,  16, PL_CYRILLICEXTA }   /* incyrillicextendeda */,
  {     0,  6483,  3581,  11,   2, PL_XIDC }   /* xidcontinue=t */,
  {     3,  7380,  8643,   7,   2, PL_CCC__22 }   /* ccc=ccc22 */,
  {     5,  5544,  8164,  13,   4, PL_NV__15_SLASH_2 }   /* numericvalue=15/2 */,
  {     1,  5284,  7951,  13,   5, PL_CI }   /* caseignorable=true */,
  {     0,  7380,  3262,   4,   9, PL_CCC__BL }   /* ccc=belowleft */,
  {     1,  6109,    17,  10,   1, PL_CO }   /* category=co */,
  {     2,  7380,  2769,   4,  13, PL_CCC__214 }   /* ccc=attachedabove */,
  {     0,  1503,  2896,   3,  17, PL_ETHIOPICSUP }   /* inethiopicsupplement */,
  {     0,  7459,    78,   3,   6, PL_SC__ARAB }   /* sc=arabic */,
  {     1,  7583,     0,   7,   0, PL_PHAG }   /* phagspa */,
  {     8,  8783,  3223,   3,   3, -PL_CWU }   /* cwu=no */,
  {     5,  8376,  6666,   3,  10, PL_LB__NS }   /* lb=nonstarter */,
  {     9,  6263,  4673,  10,  14, PL_LB__CR }   /* linebreak=carriagereturn */,
  {    14,   974,  8164,  27,   2, PL_CCC__15 }   /* canonicalcombiningclass=ccc15 */,
  {     0,  7312,     0,   4,   0, PL_TAGB }   /* tagb */,
  {     0,  7520,     0,   7,   0, PL_MARC }   /* marchen */,
  {     4,  6472,  7160,  10,   8, PL_WB__EBG }   /* wordbreak=ebasegaz */,
  {     1,  1402,  4256,   4,  13, PL_DIACRITICALSEXT }   /* indiacriticalsext */,
  {     1,  8101,  3223,   5,   2, -PL_STERM }   /* sterm=n */,
  {     2,  7288,  8440,   7,   4, PL_OGAM }   /* script=ogam */,
  {     0,  5645,  3039,  10,  18, PL_BC__LRI }   /* bidiclass=lefttorightisolate */,
  {     1,  8276,  3223,   4,   2, -PL_CWCM }   /* cwcm=n */,
  {     6,  8016,  5762,   4,   3, PL_LB__ZWJ }   /* gcb=zwj */,
  {     5,  7834,    47,   5,   1, PL_PERM }   /* isperm */,
  {     4,  7459,  5427,   3,   9, PL_SC__MLYM }   /* sc=malayalam */,
  {     0,  3509,  7768,  17,   6, -PL_PATWS }   /* patternwhitespace=false */,
  {    10,  7478,  3995,   3,  15, PL_SYRIACSUP }   /* issyriacsupplement */,
  {     8,  7136,  2044,   6,  14, PL_MEETEIMAYEKEXT }   /* block=meeteimayekext */,
  {     6,  5134,   132,   4,   2, PL_PALM }   /* ispalm */,
  {     0,  3526,  7768,  17,   6, -PL_RI }   /* regionalindicator=false */,
  {     0,  8340,  4359,   3,  15, PL_JG__MANICHAEANGIMEL }   /* jg=manichaeangimel */,
  {    10,  7288,   954,   7,   5, PL_SC__GREK }   /* script=greek */,
  {     7,  8408,     0,   4,   0, PL_MRO }   /* mroo */,
  {     5,  7288,  5777,   7,   6, PL_HEBR }   /* script=hebrew */,
  {     2,  7136,   920,   6,  27, PL_ALPHABETICPF }   /* block=alphabeticpresentationforms */,
  {     5,  7136,  1680,   6,  22, PL_INDICNUMBERFORMS }   /* block=commonindicnumberforms */,
  {     1,  8096,  7492,   4,   7, PL_KNDA }   /* scx=kannada */,
  {     2,  5645,     1,  11,   1, PL_BC__BN }   /* bidiclass=bn */,
  {     3,  6713,  7732,   3,   1, PL_IN__5 }   /* in=5 */,
  {     6,   184,  6626,   2,  10, PL_KHAR }   /* iskharoshthi */,
  {     0,  5375,  6053,  12,  12, PL_JT__R }   /* joiningtype=rightjoining */,
  {     2,   184,  4104,   2,  15, PL_BAMUMSUP }   /* isbamumsupplement */,
  {     0,  6483,  7768,  11,   2, -PL_XIDC }   /* xidcontinue=f */,
  {     0,  7152,     0,   4,   0, PL_DUPL }   /* dupl */,
  {     6,  7136,  8819,   6,   3, PL_OCR }   /* block=ocr */,
  {     0,   184,  7388,   3,   6, PL_CJKEXTA }   /* iscjkexta */,
  {     1,  2023,  7997,  21,   4, PL_LOE }   /* logicalorderexception=yes */,
  {     0,  7288,  6005,   7,  12, PL_HUNG }   /* script=oldhungarian */,
  {     0,  4449,    17,  15,   1, PL_COMPEX }   /* nfcquickcheck=no */,
  {     2,  4314,  6523,  13,   2, PL_JG__FE }   /* joininggroup=fe */,
  {     2,  7459,  8232,   3,   4, PL_AVST }   /* sc=avst */,
  {     0,  6890,  3290,   4,   4, PL_UCAS }   /* blk=ucas */,
  {     2,  6351,     0,  11,   0, PL_NO }   /* othernumber */,
  {     1,  6890,  3458,   4,  10, PL_INMANICHAEAN }   /* blk=manichaean */,
  {     1,  7380,  8901,   7,   2, PL_CCC__36 }   /* ccc=ccc36 */,
  {     8,   184,  4239,   2,   4, PL_DASH }   /* isdash */,
  {     1,   974,  8643,  24,   2, PL_CCC__22 }   /* canonicalcombiningclass=22 */,
  {     6,  2229,  5037,  16,  14, PL_SK }   /* generalcategory=modifiersymbol */,
  {     0,  6616,  7997,  10,   4, PL_DEP }   /* deprecated=yes */,
  {     8,  7136,   570,   6,  30, PL_CJKEXTC }   /* block=cjkunifiedideographsextensionc */,
  {     0,  3458,     0,  10,   0, PL_MANI }   /* manichaean */,
  {     2,  4314,  6384,  13,  11, PL_JG__ROHINGYAYEH }   /* joininggroup=rohingyayeh */,
  {     2,  8798,  7768,   3,   2, -PL_LOE }   /* loe=f */,
  {     1,  4314,  5479,  13,  13, PL_JG__MANICHAEANONE }   /* joininggroup=manichaeanone */,
  {     1,  8816,  8148,   3,   4, PL_NV__1_SLASH_40 }   /* nv=1/40 */,
  {     0,  7136,  5957,   6,  12, PL_INMENDEKIKAKUI }   /* block=mendekikakui */,
  {     0,   184,  8368,   2,   3, PL_LAO }   /* islao */,
  {     0,  8816,  8180,   3,   3, PL_NV__3_SLASH_8 }   /* nv=3/8 */,
  {     0,  5968,  3058,   3,  17, PL_ORNAMENTALDINGBATS }   /* inornamentaldingbats */,
  {     0,   974,  7708,  27,   2, PL_CCC__21 }   /* canonicalcombiningclass=ccc21 */,
  {     3,  7345,  7951,   7,   5, PL_IDS }   /* idstart=true */,
  {     6,   920,     0,  27,   0, PL_ALPHABETICPF }   /* alphabeticpresentationforms */,
  {     0,  6221,   115,   4,  33, PL_DIACRITICALSFORSYMBOLS }   /* incombiningdiacriticalmarksforsymbols */,
  {     0,   186,  7768,   2,   2, -PL_CE }   /* ce=f */,
  {     2,  1448,     0,  26,   0, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* insupsymbolsandpictographs */,
  {     0,  1981,     0,   8,   0, PL_CYRL }   /* cyrillic */,
  {     0,  7689,  5032,   3,   2, PL_ANY }   /* isany */,
  {     0,  6890,  7104,   4,   8, PL_INARMENIAN }   /* blk=armenian */,
  {     3,  7136,  7200,   6,   8, PL_INGURMUKHI }   /* block=gurmukhi */,
  {     0,  4224,     0,  15,   0, PL_CURRENCYSYMBOLS }   /* currencysymbols */,
  {     2,  8340,  5518,   3,  13, PL_JG__MANICHAEANWAW }   /* jg=manichaeanwaw */,
  {     2,  8196,  5219,   4,   2, PL_AGE__10 }   /* age=10 */,
  {     9,  7288,  7858,   7,   4, PL_SC__KHOJ }   /* script=khoj */,
  {     0,  2229,  6796,  16,  10, PL_CN }   /* generalcategory=unassigned */,
  {     0,  6210,   511,   3,  29, PL_CJKEXTA }   /* incjkunifiedideographsextensiona */,
  {    16,  8011,  4329,   3,  15, PL_LL }   /* gc=lowercaseletter */,
  {     3,  8026,  5271,   5,  13, PL_INPC__BOTTOMANDLEFT }   /* inpc=bottomandleft */,
  {     0,  3129,  8520,  17,   4, PL_SHAW }   /* scriptextensions=shaw */,
  {     0,  8376,  8919,   3,   2, PL_LB__B2 }   /* lb=b2 */,
  {     0,   184,  7152,   2,   8, PL_DUPL }   /* isduployan */,
  {     0,  7380,  4976,   4,   2, PL_CCC__7 }   /* ccc=nk */,
  {     1,  6890,     0,   4,  34, PL_UCAS }   /* blk=unifiedcanadianaboriginalsyllabics */,
  {     0,   184,  2408,   2,   6, PL_BRAH }   /* isbrahmi */,
  {     0,  8288,  7541,   3,   7, PL_DT__NB }   /* dt=nobreak */,
  {     2,  6890,  5531,   4,  13, PL_MISCTECHNICAL }   /* blk=misctechnical */,
  {     0,  4554,    72,  14,   2, PL_SB__LE }   /* sentencebreak=le */,
  {    14,  3129,  8548,  17,   4, PL_TFNG }   /* scriptextensions=tfng */,
  {     1,  3129,  7780,  17,   4, PL_CARI }   /* scriptextensions=cari */,
  {     2,  8096,  8268,   4,   4, PL_CPRT }   /* scx=cprt */,
  {     2,  8798,     0,   3,   0, PL_LOE }   /* loe */,
  {    28,  1159,  3223,  25,   2, -PL_CWKCF }   /* changeswhennfkccasefolded=n */,
  {     0,    84,  3581,   4,   2, PL_MATH }   /* math=t */,
  {     1,  7226,  5315,   6,   5, PL_XPOSIXALNUM }   /* xposixalnum */,
  {     2,    58,  3223,   4,   2, -PL_IDEO }   /* ideo=n */,
  {     0,  1417,  1452,   9,   2, PL_PS }   /* category=ps */,
  {     6,  8026,   850,   3,   9, PL_PUA }   /* inprivateuse */,
  {     1,  5544,  8720,  13,   3, PL_NV__3_SLASH_5 }   /* numericvalue=3/5 */,
  {     2,  6706,  8855,  10,   3, PL_IN__3_DOT_2 }   /* presentin=v32 */,
  {     0,  5284,  3223,  13,   3, -PL_CI }   /* caseignorable=no */,
  {     7,  7478,  3568,   3,   3, PL_SGNW }   /* issgnw */,
  {     5,   184,  8436,   2,   4, PL_NSHU }   /* isnshu */,
  {    17,   184,  6980,   2,   9, PL_NBAT }   /* isnabataean */,
  {     0,  8096,  7846,   4,   6, PL_KTHI }   /* scx=kaithi */,
  {     2,  7459,  2636,   3,   9, PL_SC__MONG }   /* sc=mongolian */,
  {     0,  7380,    78,   4,   2, PL_CCC__AR }   /* ccc=ar */,
  {     4,  1426,   699,  22,   6, PL_INSC__NUMBER }   /* indicsyllabiccategory=number */,
  {     0,  8016,  3985,   4,   9, PL_LB__EM }   /* gcb=emodifier */,
  {     3,  7459,  8264,   3,   4, PL_CANS }   /* sc=cans */,
  {     1,  3129,  8424,  17,   4, PL_NBAT }   /* scriptextensions=nbat */,
  {     2,  6890,  5693,   4,  12, PL_CYRILLICEXTB }   /* blk=cyrillicextb */,
  {     1,  5765,  7768,  12,   6, -PL_GRBASE }   /* graphemebase=false */,
  {     2,  7136,  6505,   6,  11, PL_YISYLLABLES }   /* block=yisyllables */,
  {     8,  5544,  8180,  13,   4, PL_NV__3_SLASH_80 }   /* numericvalue=3/80 */,
  {     1,  7380,  8688,   4,   2, PL_CCC__26 }   /* ccc=26 */,
  {     0,  4542,  7585,   3,   3, PL_TAGS }   /* istags */,
  {     0,  8340,  3812,   3,   3, PL_JG__LAM }   /* jg=lam */,
  {     3,  2065,  3581,  21,   2, PL_NCHAR }   /* noncharactercodepoint=t */,
  {     0,  2229,   133,  16,   4, PL_M }   /* generalcategory=mark */,
  {     4,  6890,  1378,   4,  24, PL_HIGHPUSURROGATES }   /* blk=highprivateusesurrogates */,
  {    10,  2750,     0,   4,   0, PL_TERM }   /* term */,
  {     3,  7288,  2877,   7,  10, PL_SC__DEVA }   /* script=devanagari */,
  {     2,  6890,  4509,   4,  15, PL_SARB }   /* blk=oldsoutharabian */,
  {     4,  8204,  7768,   4,   6, -PL_POSIXXDIGIT }   /* ahex=false */,
  {     6,  7288,  8364,   7,   4, PL_LANA }   /* script=lana */,
  {     0,  8096,  7604,   4,   7, PL_SIDD }   /* scx=siddham */,
  {     0,    34,  7997,   3,   2, PL_EXT }   /* ext=y */,
  {     0,  7136,   361,   6,  21, PL_MATHOPERATORS }   /* block=mathematicaloperators */,
  {     9,  7478,  3963,   3,  15, PL_SUPMATHOPERATORS }   /* issupmathoperators */,
  {     0,  1876,  7768,  21,   2, -PL_CWL }   /* changeswhenlowercased=f */,
  {     1,  8816,  8903,   3,   2, PL_NV__38 }   /* nv=38 */,
  {     0,    96,  7951,  10,   5, PL_XPOSIXALPHA }   /* alphabetic=true */,
  {     1,  8777,  7768,   3,   2, -PL_CWL }   /* cwl=f */,
  {     1,   184,  2249,   2,   4, PL_GLAG }   /* isglag */,
  {     9,  7136,  8091,   6,   5, PL_INRUNIC }   /* block=runic */,
  {     0,  7816,  7768,   6,   6, -PL_GRBASE }   /* grbase=false */,
  {     3,  6890,  5388,   4,  13, PL_KANAEXTA }   /* blk=kanaextendeda */,
  {     3,  1876,  3581,  21,   2, PL_CWL }   /* changeswhenlowercased=t */,
  {     2,  1448,   468,   5,  11, PL_SUPPUNCTUATION }   /* insuppunctuation */,
  {     2,   974,  8228,  24,   4, PL_CCC__133 }   /* canonicalcombiningclass=atbl */,
  {     0,  7136,  7786,   6,   6, PL_INCHAKMA }   /* block=chakma */,
  {     2,  5645,    24,  10,   1, PL_BC__L }   /* bidiclass=l */,
  {     2,   184,  6219,   2,  11, PL_JOINC }   /* isjoincontrol */,
  {     0,  7288,  7034,   7,   9, PL_PALM }   /* script=palmyrene */,
  {     0,  8795,    67,   3,   4, PL_VSSUP }   /* invssup */,
  {     0,  8508,  8373,   4,   3, PL_SC__LATN }   /* sc=latn */,
  {     1,  6210,  1659,   3,  18, PL_CJKCOMPATIDEOGRAPHS }   /* incjkcompatideographs */,
  {     0,  1908,     0,   5,   0, PL_LT }   /* title */,
  {     0,  8816,  7744,   3,   3, PL_NV__700 }   /* nv=700 */,
  {     0,  8816,  7732,   3,   4, PL_NV__5000 }   /* nv=5000 */,
  {     1,  6713,  8843,   3,   3, PL_IN__2 }   /* in=v20 */,
  {     2,  4104,     0,  15,   0, PL_BAMUMSUP }   /* bamumsupplement */,
  {     1,  2065,  7768,  21,   2, -PL_NCHAR }   /* noncharactercodepoint=f */,
  {     2,  8096,  8304,   4,   4, PL_GUJR }   /* scx=gujr */,
  {     0,   184,  4419,   2,  15, PL_MISCPICTOGRAPHS }   /* ismiscpictographs */,
  {     3,  6263,    21,  10,   2, PL_LB__IN }   /* linebreak=in */,
  {     1,   184,  7152,   2,   4, PL_DUPL }   /* isdupl */,
  {     1,  8011,  5079,   3,  14, PL_MN }   /* gc=nonspacingmark */,
  {     2,  3516,  7768,  10,   2, -PL_XPOSIXSPACE }   /* whitespace=f */,
  {     1,  7136,  8208,   6,   4, PL_INAHOM }   /* block=ahom */,
  {     0,  1258,     0,  24,   0, PL_ARABICPFB }   /* arabicpresentationformsb */,
  {     9,  7227,  8081,   5,   5, PL_POSIXPRINT }   /* posixprint */,
  {     2,  4402,  3867,   3,  15, PL_MISCMATHSYMBOLSB }   /* inmiscmathsymbolsb */,
  {     1,  6890,  7256,   4,   8, PL_KANAEXTA }   /* blk=kanaexta */,
  {     6,  2023,  7997,  21,   2, PL_LOE }   /* logicalorderexception=y */,
  {     5,  3129,  7646,  17,   7, PL_TAVT }   /* scriptextensions=taiviet */,
  {     0,  8504,    18,   4,   1, PL_LB__CR }   /* sb=cr */,
  {     1,   974,  2769,  24,  18, PL_CCC__216 }   /* canonicalcombiningclass=attachedaboveright */,
  {     0,  7136,  6872,   6,   9, PL_ARABICPFB }   /* block=arabicpfb */,
  {     3,  1448,  6440,   3,  10, PL_INSYLOTINAGRI }   /* insylotinagri */,
  {     0,  7478,  2675,   3,  11, PL_SUNDANESESUP }   /* issundanesesup */,
  {     2,  7136,  4135,   7,  14, PL_BRAI }   /* block=braillepatterns */,
  {     0,  7136,  4614,   6,  15, PL_VEDICEXT }   /* block=vedicextensions */,
  {     0,  8096,  8280,   4,   4, PL_CYRL }   /* scx=cyrl */,
  {    10,  2985,  7997,   3,   4, PL_IDS }   /* ids=yes */,
  {     7,   117,     6,   3,   2, PL_INIDC }   /* inidc */,
  {     2,  8288,  7792,   3,   6, PL_DT__ENC }   /* dt=circle */,
  {     5,  1417,  1204,   9,   2, PL_PO }   /* category=po */,
  {     3,  7136,  7422,   6,   7, PL_CJKEXTF }   /* block=cjkextf */,
  {     4,  8816,  8169,   3,   3, PL_NV__7_SLASH_2 }   /* nv=7/2 */,
  {     3,  5645,    18,  10,   1, PL_BC__R }   /* bidiclass=r */,
  {     4,  7459,  5957,   3,  12, PL_MEND }   /* sc=mendekikakui */,
  {    11,  6890,   361,   4,  21, PL_MATHOPERATORS }   /* blk=mathematicaloperators */,
  {     1,  8096,  7367,   5,   6, PL_BENG }   /* scx=bengali */,
  {     0,   184,   511,   3,  19, PL_CJK }   /* iscjkunifiedideographs */,
  {     0,  3129,  8236,  17,   4, PL_BATK }   /* scriptextensions=batk */,
  {     1,  1834,  7768,  21,   6, -PL_CWCF }   /* changeswhencasefolded=false */,
  {     3,  6484,  7768,  10,   2, -PL_IDC }   /* idcontinue=f */,
  {     0,  7288,  7145,   8,   3, PL_SC__BUGI }   /* script=bugi */,
  {     1,  6263,   125,  10,   2, PL_LB__CR }   /* linebreak=cr */,
  {     0,  6890,  3237,   4,  17, PL_ALCHEMICAL }   /* blk=alchemicalsymbols */,
  {     3,   184,  8488,   2,   4, PL_RJNG }   /* isrjng */,
  {     7,   184,  7436,   2,   4, PL_ELBA }   /* iselba */,
  {     0,    18,  7768,   2,   2, -PL_RI }   /* ri=f */,
  {     1,  3424,  7997,  17,   2, PL_IDSB }   /* idsbinaryoperator=y */,
  {     2,  7459,  8488,   3,   4, PL_RJNG }   /* sc=rjng */,
  {     0,  2065,  7951,  21,   5, PL_NCHAR }   /* noncharactercodepoint=true */,
  {     2,  8376,    42,   3,   2, PL_LB__CJ }   /* lb=cj */,
  {    10,  1358,  7951,  20,   5, PL_CE }   /* compositionexclusion=true */,
  {     6,  7380,  6142,   4,  11, PL_CCC__DB }   /* ccc=doublebelow */,
  {     1,  4869,     0,  14,   0, PL_LATINEXTD }   /* latinextendedd */,
  {     0,   184,   720,   2,  21, PL_ENCLOSEDALPHANUM }   /* isenclosedalphanumerics */,
  {     0,  2484,     0,  19,   0, PL_EGYP }   /* egyptianhieroglyphs */,
  {     2,  8240,  8807,   3,   3, PL_BC__LRO }   /* bc=lro */,
  {     1,  8016,  1133,   4,   7, PL_GCB__PP }   /* gcb=prepend */,
  {     0,  8572,   497,   4,   6, PL_WB__NU }   /* wb=numeric */,
  {    16,  7380,  8678,   4,   3, PL_CCC__B }   /* ccc=220 */,
  {     0,  7478,  7062,   3,   8, PL_SAMR }   /* issamaritan */,
  {     1,  8096,  2841,   4,   4, PL_COPT }   /* scx=copt */,
  {    11,  6863,     0,   9,   0, PL_ARABICPFA }   /* arabicpfa */,
  {     1,  3946,  3223,  16,   3, -PL_STERM }   /* sentenceterminal=no */,
  {     6,  6890,  2271,   6,  18, PL_ININSCRIPTIONALPAHLAVI }   /* blk=inscriptionalpahlavi */,
  {     2,  1918,  3581,  21,   2, PL_CWU }   /* changeswhenuppercased=t */,
  {     1,  3129,    57,  17,   2, PL_YI }   /* scriptextensions=yi */,
  {     2,  7380,  8617,   4,   2, PL_CCC__31 }   /* ccc=31 */,
  {    13,  8816,  8188,   3,   4, PL_NV__7_SLASH_12 }   /* nv=7/12 */,
  {     5,  7994,     0,   7,   0, PL_IDC }   /* idc=yes */,
  {     1,  7136,  8111,   6,   5, PL_INTAKRI }   /* block=takri */,
  {     1,  8096,  7870,   4,   4, PL_LEPC }   /* scx=lepc */,
  {     5,   184,  1028,   3,   5, PL_COPT }   /* iscoptic */,
  {    21,   184,  8400,   2,   4, PL_MIAO }   /* ismiao */,
  {     0,  6890,  6428,   4,  11, PL_SUPERANDSUB }   /* blk=superandsub */,
  {     0,  8011,   468,   3,   5, PL_P }   /* gc=punct */,
  {    19,   184,   631,   3,  29, PL_CJKEXTE }   /* iscjkunifiedideographsextensione */,
  {     0,  7136,  2877,   6,  18, PL_DEVANAGARIEXT }   /* block=devanagariextended */,
  {     0,  7834,  3521,   6,   5, PL_POSIXSPACE }   /* isperlspace */,
  {     1,  8011,    47,   3,   1, PL_M }   /* gc=m */,
  {     0,  1133,  7768,  26,   2, -PL_PCM }   /* prependedconcatenationmark=f */,
  {     2,  5657,     0,  12,   0, PL_BIDIM }   /* bidimirrored */,
  {     2,  2985,  7951,   4,   5, PL_IDST }   /* idst=true */,
  {     0,  8288,  7184,   3,   3, PL_DT__FRA }   /* dt=fra */,
  {     1,   184,  8600,   2,   4, PL_QAAI }   /* iszinh */,
  {     3,  4402,  2618,   3,  18, PL_MODIFIERTONELETTERS }   /* inmodifiertoneletters */,
  {     0,  2369,   472,  20,   2, PL_VO__TU }   /* verticalorientation=tu */,
  {     0,  6890,  2693,   4,  19, PL_SUPARROWSA }   /* blk=supplementalarrowsa */,
  {     4,  7136,  7336,   6,   8, PL_INUGARITIC }   /* block=ugaritic */,
  {     0,  7380,  8702,   4,   3, PL_CCC__DA }   /* ccc=234 */,
  {    10,    11,  7951,   3,   5, PL_DIA }   /* dia=true */,
  {     1,  8816,  7714,   3,   4, PL_NV__3000 }   /* nv=3000 */,
  {     0,  4314,  5921,  13,  12, PL_JG__MANICHAEANPE }   /* joininggroup=manichaeanpe */,
  {     0,  7136,  3754,   6,  16, PL_LINEARBIDEOGRAMS }   /* block=linearbideograms */,
  {     1,  8340,  8512,   3,   4, PL_JG__SEEN }   /* jg=seen */,
  {     6,  4402,  6647,   3,   9, PL_MISCARROWS }   /* inmiscarrows */,
  {     1,  8196,  8750,   4,   3, PL_AGE__6_DOT_1 }   /* age=6.1 */,
  {     1,  7994,    36,   4,   1, PL_IDC }   /* idc=t */,
  {     0,  5149,     0,  14,   0, PL_SUPPUNCTUATION }   /* suppunctuation */,
  {     0,  7288,  3458,   7,   4, PL_SC__MANI }   /* script=mani */,
  {     5,   802,     0,   6,   0, PL_ARROWS }   /* arrows */,
  {     0,  2229,  8009,  16,   2, PL_CF }   /* generalcategory=cf */,
  {     0,  5544,  7702,  13,   3, PL_NV__200 }   /* numericvalue=200 */,
  {     0,  7288,  8396,   7,   4, PL_MERC }   /* script=merc */,
  {     0,    76,  7096,   2,   8, PL_NT__NU }   /* nt=numeric */,
  {     1,    21,  5233,   3,  12, PL_AEGEANNUMBERS }   /* inaegeannumbers */,
  {     0,  6890,  7852,   4,   6, PL_KANBUN }   /* blk=kanbun */,
  {     3,  5544,  7738,  13,   5, PL_NV__60000 }   /* numericvalue=60000 */,
  {     0,  6210,  1982,   3,  10, PL_CYRILLICSUP }   /* incyrillicsup */,
  {     2,  4314,  6072,  13,   4, PL_JG__NOON }   /* joininggroup=noon */,
  {     3,  6890,  7248,   4,   8, PL_INJAVANESE }   /* blk=javanese */,
  {     1,  7288,   690,   7,   9, PL_XSUX }   /* script=cuneiform */,
  {     2,  8121,  7951,   5,   5, PL_UIDEO }   /* uideo=true */,
  {     0,  1887,  7768,   9,   6, -PL_XPOSIXLOWER }   /* lowercase=false */,
  {     0,  7459,  7152,   3,   4, PL_SC__DUPL }   /* sc=dupl */,
  {     0,  6890,  8106,   4,   5, PL_INTAILE }   /* blk=taile */,
  {     2,    21,  7240,   2,   8, PL_JAMOEXTB }   /* injamoextb */,
  {     4,  5717,     0,  12,   0, PL_ETHIOPICEXTA }   /* ethiopicexta */,
  {     0,  8822,  7997,   3,   4, PL_PCM }   /* pcm=yes */,
  {    13,  7459,  8596,   3,   4, PL_ZANB }   /* sc=zanb */,
  {     0,   974,  8672,  24,   3, PL_CCC__214 }   /* canonicalcombiningclass=214 */,
  {     0,  7136,  7499,   6,   7, PL_KALI }   /* block=kayahli */,
  {     2,  8822,  3223,   3,   3, -PL_PCM }   /* pcm=no */,
  {     1,  7459,  7320,   3,   8, PL_TFNG }   /* sc=tifinagh */,
  {     1,  5544,  7720,  13,   3, PL_NV__400 }   /* numericvalue=400 */,
  {     0,  2229,   295,  16,   2, PL_SM }   /* generalcategory=sm */,
  {    19,  5134,  8469,   3,   3, PL_MIAO }   /* isplrd */,
  {     1,  7994,     3,   4,   1, -PL_IDC }   /* idc=f */,
  {     5,   184,  2967,   2,  11, PL_GEORGIANSUP }   /* isgeorgiansup */,
  {     0,  7344,     0,   8,   0, PL_XIDS }   /* xidstart */,
  {     2,  8096,  8552,   4,   4, PL_TGLG }   /* scx=tglg */,
  {     5,  3521,  3581,   5,   2, PL_XPOSIXSPACE }   /* space=t */,
  {     6,  1206,  7913,   3,   5, PL_INTELUGU }   /* intelugu */,
  {     6,  8816,  7708,   3,   2, PL_NV__21 }   /* nv=21 */,
  {     0,  7136,   447,   6,  18, PL_IDEOGRAPHICSYMBOLS }   /* block=ideographicsymbols */,
  {     5,  7478,  7626,   3,   6, PL_SUPPUAB }   /* issuppuab */,
  {     0,  4630,  4600,   3,  14, PL_LU }   /* isuppercaseletter */,
  {     0,  2985,  7768,   3,   2, -PL_IDS }   /* ids=f */,
  {     1,  4464,  7998,  14,   3, PL_NFDQC__Y }   /* nfdquickcheck=yes */,
  {     8,  7288,  3288,   7,  17, PL_AGHB }   /* script=caucasianalbanian */,
  {     3,  8786,    66,   3,   1, PL_EA__H }   /* ea=h */,
  {     0,  4314,  4981,  13,  14, PL_JG__MANICHAEANQOPH }   /* joininggroup=manichaeanqoph */,
  {     9,  8356,     0,   4,   0, PL_KNDA }   /* knda */,
  {     1,  3129,  8312,  17,   4, PL_HAN }   /* scriptextensions=hani */,
  {     2,  5134,  6375,   4,   9, PL_HMNG }   /* ispahawhhmong */,
  {     1,  7288,  5957,   7,  12, PL_MEND }   /* script=mendekikakui */,
  {    19,  7136,  6536,   6,  10, PL_ARABICEXTA }   /* block=arabicexta */,
  {     4,  7136,  1589,   6,  23, PL_LATINEXTADDITIONAL }   /* block=latinextendedadditional */,
  {     4,  6890,  5825,   4,   7, PL_MAHJONG }   /* blk=mahjong */,
  {    16,  1346,   957,   5,   2, PL_INGREEK }   /* ingreek */,
  {     0,   184,  1691,   2,  11, PL_NUMBERFORMS }   /* isnumberforms */,
  {     2,  6483,  7768,  11,   6, -PL_XIDC }   /* xidcontinue=false */,
  {     3,  1929,  7997,   5,   4, PL_XPOSIXUPPER }   /* upper=yes */,
  {     3,  7136,  2674,   6,  12, PL_SUNDANESESUP }   /* block=sundanesesup */,
  {     6,  8096,  6626,   4,  10, PL_KHAR }   /* scx=kharoshthi */,
  {     4,    21,  1691,   2,  11, PL_NUMBERFORMS }   /* innumberforms */,
  {     0,  1417,   112,   9,   2, PL_SC }   /* category=sc */,
  {     5,  1887,  7768,   9,   2, -PL_XPOSIXLOWER }   /* lowercase=f */,
  {     1,  3129,  3610,  17,   8, PL_BOPO }   /* scriptextensions=bopomofo */,
  {    10,  5813,     0,  12,   0, PL_NL }   /* letternumber */,
  {    10,   974,  8897,  27,   2, PL_CCC__19 }   /* canonicalcombiningclass=ccc19 */,
  {     2,  6713,  8873,   3,   3, PL_IN__6 }   /* in=v60 */,
  {     6,  6890,   600,   4,  30, PL_CJKEXTD }   /* blk=cjkunifiedideographsextensiond */,
  {    10,   113,     0,  35,   0, PL_DIACRITICALSFORSYMBOLS }   /* combiningdiacriticalmarksforsymbols */,
  {    12,  8344,  6208,   3,  11, PL_JT__C }   /* jt=joincausing */,
  {     2,  7136,  5801,   6,  12, PL_KHMERSYMBOLS }   /* block=khmersymbols */,
  {     8,  6890,  6120,   4,   6, PL_DOMINO }   /* blk=domino */,
  {    12,  6706,  7750,  10,   1, PL_IN__8 }   /* presentin=8 */,
  {     2,   184,  4225,   3,  14, PL_CURRENCYSYMBOLS }   /* iscurrencysymbols */,
  {     1,  7136,  1812,   6,  15, PL_TRANSPORTANDMAP }   /* block=transportandmap */,
  {     8,  6890,  2249,   4,  20, PL_GLAGOLITICSUP }   /* blk=glagoliticsupplement */,
  {     4,    74,     0,   2,   0, PL_ME }   /* me */,
  {     3,  6263,   373,  10,   2, PL_LB__OP }   /* linebreak=op */,
  {     1,   949,  3223,   2,   3, -PL_CI }   /* ci=no */,
  {     0,  5245,     0,   5,   0, PL_ASCII }   /* ascii */,
  {     0,   600,     0,  30,   0, PL_CJKEXTD }   /* cjkunifiedideographsextensiond */,
  {     0,  4554,    18,  15,   1, PL_LB__CR }   /* sentencebreak=cr */,
  {     0,  8786,     3,   3,   1, PL_EA__F }   /* ea=f */,
  {     2,  7136,   690,   6,   9, PL_INCUNEIFORM }   /* block=cuneiform */,
  {     2,   184,  3526,   2,  17, PL_RI }   /* isregionalindicator */,
  {     1,  7912,     0,   6,   0, PL_TELU }   /* telugu */,
  {     1,  3129,  2841,  17,   6, PL_COPT }   /* scriptextensions=coptic */,
  {     1,  8816,  8615,   3,   3, PL_NV__1_SLASH_3 }   /* nv=1/3 */,
  {     4,  3114,  7337,   3,   7, PL_INUGARITIC }   /* inugaritic */,
  {     0,  6318,     0,  11,   0, PL_MYANMAREXTB }   /* myanmarextb */,
  {     7,   974,  8633,  27,   3, PL_CCC__103 }   /* canonicalcombiningclass=ccc103 */,
  {     9,  7459,  8106,   3,   5, PL_SC__TALE }   /* sc=taile */,
  {     0,  7459,  8496,   3,   4, PL_SAMR }   /* sc=samr */,
  {     4,  6536,     0,  10,   0, PL_ARABICEXTA }   /* arabicexta */,
  {     0,  7136,  1981,   6,  18, PL_CYRILLICSUP }   /* block=cyrillicsupplement */,
  {     3,  2990,  4091,   4,  13, PL_ARABICEXTA }   /* inarabicextendeda */,
  {     0,  8011,  1306,   3,  13, PL_M }   /* gc=combiningmark */,
  {    20,   184,  6991,   3,   2, PL_CWT }   /* iscwt */,
  {     1,  7380,  6230,   4,  11, PL_CCC__8 }   /* ccc=kanavoicing */,
  {     6,  7288,  8568,   7,   3, PL_VAI }   /* script=vai */,
  {     2,  5544,  8160,  13,   4, PL_NV__13_SLASH_2 }   /* numericvalue=13/2 */,
  {     2,  8376,  7828,   3,   6, PL_LB__HY }   /* lb=hyphen */,
  {     3,  8096,  8428,   4,   4, PL_NEWA }   /* scx=newa */,
  {     3,  7459,  2531,   3,   4, PL_SC__MULT }   /* sc=mult */,
  {     2,   974,  5595,  24,   2, PL_CCC__8 }   /* canonicalcombiningclass=kv */,
  {     2,   184,  5531,   2,  13, PL_MISCTECHNICAL }   /* ismisctechnical */,
  {     0,  3509,  3223,  17,   3, -PL_PATWS }   /* patternwhitespace=no */,
  {     9,  8096,  2360,   4,   4, PL_MAND }   /* scx=mand */,
  {     3,  2877,     0,   4,   0, PL_DEVA }   /* deva */,
  {     0,   184,  5957,   2,   4, PL_MEND }   /* ismend */,
  {     6,  8508,    21,   4,   3, PL_SC__LINA }   /* sc=lina */,
  {     0,  5657,  7768,   5,   2, -PL_BIDIM }   /* bidim=f */,
  {     2,   974,  8703,  24,   2, PL_CCC__34 }   /* canonicalcombiningclass=34 */,
  {     1,  7136,   349,   6,  33, PL_SUPMATHOPERATORS }   /* block=supplementalmathematicaloperators */,
  {     0,  8096,  7639,   4,   7, PL_LANA }   /* scx=taitham */,
  {     3,  6890,  5777,   4,   6, PL_INHEBREW }   /* blk=hebrew */,
  {     1,  6890,  3610,   4,  11, PL_BOPOMOFOEXT }   /* blk=bopomofoext */,
  {     1,  7422,     0,   7,   0, PL_CJKEXTF }   /* cjkextf */,
  {     0,  7344,  7768,   8,   6, -PL_XIDS }   /* xidstart=false */,
  {     0,  1206,  3148,   3,  17, PL_TAIXUANJING }   /* intaixuanjingsymbols */,
  {     2,  2221,  3223,   3,  14, PL_HST__NA }   /* hst=notapplicable */,
  {     3,  8011,  5813,   3,  12, PL_NL }   /* gc=letternumber */,
  {     1,  6890,  4134,   4,  15, PL_BRAI }   /* blk=braillepatterns */,
  {     0,  8096,  1160,   4,   4, PL_HANG }   /* scx=hang */,
  {     1,  1746,  3526,  21,  17, PL_RI }   /* graphemeclusterbreak=regionalindicator */,
  {     5,  7288,  7104,   7,   8, PL_SC__ARMN }   /* script=armenian */,
  {     7,  7136,   720,   6,  16, PL_ENCLOSEDALPHANUM }   /* block=enclosedalphanum */,
  {     7,  7380,  3254,   4,  17, PL_CCC__133 }   /* ccc=attachedbelowleft */,
  {     1,  3129,  3674,  17,   7, PL_CPRT }   /* scriptextensions=cypriot */,
  {     0,   184,  4855,   2,  14, PL_LATINEXTC }   /* islatinextendedc */,
  {     0,   217,   436,   6,   5, PL_NCHAR }   /* _perl_nchar */,
  {     1,  4314,  5453,  13,  13, PL_JG__MANICHAEANMEM }   /* joininggroup=manichaeanmem */,
  {     2,  7689,  3238,   3,   9, PL_ALCHEMICAL }   /* isalchemical */,
  {     0,   184,  1835,   3,  20, PL_CWCF }   /* ischangeswhencasefolded */,
  {     0,  7906,  1108,   4,   7, PL_SC__KANA }   /* sc=katakana */,
  {     0,  7136,  5362,   6,  13, PL_IPAEXT }   /* block=ipaextensions */,
  {     0,  6263,  8919,  10,   2, PL_LB__B2 }   /* linebreak=b2 */,
  {     3,  8096,  8237,   5,   3, PL_BATK }   /* scx=batk */,
  {     0,  2065,     0,  21,   0, PL_NCHAR }   /* noncharactercodepoint */,
  {    12,  2100,  7027,   4,   7, PL_ORKH }   /* isoldturkic */,
  {     0,  7689,    15,   4,   2, PL_ARAB }   /* isarab */,
  {     4,  7136,  7632,   6,   7, PL_INTAGALOG }   /* block=tagalog */,
  {     3,  2229,  5323,  16,  13, PL_ME }   /* generalcategory=enclosingmark */,
  {     0,  7478,  6375,   3,   3, PL_SHAW }   /* isshaw */,
  {     1,  4314,  6274,  13,  11, PL_JG__MALAYALAMJA }   /* joininggroup=malayalamja */,
  {     2,  7136,  3850,   6,  16, PL_MISCMATHSYMBOLSA }   /* block=miscmathsymbolsa */,
  {     2,  8783,  3223,   3,   2, -PL_CWU }   /* cwu=n */,
  {     5,   974,  7576,  24,   7, PL_CCC__1 }   /* canonicalcombiningclass=overlay */,
  {     1,   184,     1,   3,   1, PL_CN }   /* iscn */,
  {     0,  7457,  3626,   5,  16, PL_INSC__CANTILLATIONMARK }   /* insc=cantillationmark */,
  {     0,  8096,  7569,   4,   4, PL_OSMA }   /* scx=osma */,
  {     5,  7136,  4827,   6,  14, PL_KANGXI }   /* block=kangxiradicals */,
  {     1,  7288,  6736,   7,   4, PL_SAUR }   /* script=saur */,
  {     2,  7136,   947,   6,  27, PL_ANCIENTGREEKMUSIC }   /* block=ancientgreekmusicalnotation */,
  {     0,  7288,  7810,   7,   4, PL_GOTH }   /* script=goth */,
  {     4,  8096,  2409,   5,   3, PL_BRAH }   /* scx=brah */,
  {     1,  4479,  7996,   5,   3, PL_NFKCQC__Y }   /* nfkcqc=y */,
  {     0,  6890,  3441,   4,  17, PL_LETTERLIKESYMBOLS }   /* blk=letterlikesymbols */,
  {    11,  7136,  1306,   6,  24, PL_DIACRITICALSFORSYMBOLS }   /* block=combiningmarksforsymbols */,
  {     5,   949,  7951,   2,   5, PL_CI }   /* ci=true */,
  {     0,   468,     0,   5,   0, PL_P }   /* punct */,
  {     0,  2229,  2521,  16,   2, PL_PF }   /* generalcategory=pf */,
  {     0,   184,  7520,   2,   4, PL_MARC }   /* ismarc */,
  {     0,  5544,  8169,  13,   3, PL_NV__7_SLASH_2 }   /* numericvalue=7/2 */,
  {     1,  1746,  1083,  21,   2, PL_LB__LF }   /* graphemeclusterbreak=lf */,
  {     1,   184,    43,   3,   8, PL_CJKCOMPAT }   /* iscjkcompat */,
  {     3,  5134,     3,   3,   1, PL_PF }   /* ispf */,
  {     4,  1474,  4524,  22,   4, PL_BPT__O }   /* bidipairedbrackettype=open */,
  {     0,  8026,   473,   3,   2, PL_PUA }   /* inpua */,
  {     3,  5657,  3581,   5,   2, PL_BIDIM }   /* bidim=t */,
  {     1,  4063,  2879,   4,   8, PL_INDEVANAGARI }   /* indevanagari */,
  {     0,  6109,  6100,  11,   9, PL_L_AMP_ }   /* category=casedletter */,
  {     0,  3373,   806,  15,   1, PL_EA__W }   /* eastasianwidth=w */,
  {     5,  8344,     6,   3,   1, PL_JT__D }   /* jt=d */,
  {     3,  1206,  7585,   3,   3, PL_TAGS }   /* intags */,
  {    10,  7136,  4855,   6,  14, PL_LATINEXTC }   /* block=latinextendedc */,
  {    42,  8096,  7336,   4,   4, PL_UGAR }   /* scx=ugar */,
  {     3,  4314,  8212,  13,   4, PL_JG__ALEF }   /* joininggroup=alef */,
  {     0,  5544,  7702,  13,   1, PL_NV__2 }   /* numericvalue=2 */,
  {     0,  7478,  3085,   3,   8, PL_Z }   /* isseparator */,
  {     5,  6890,  4209,   4,  15, PL_CONTROLPICTURES }   /* blk=controlpictures */,
  {    14,  1797,     0,  15,   0, PL_MODIFIERLETTERS }   /* modifierletters */,
  {     0,    21,  6826,   2,  10, PL_YIRADICALS }   /* inyiradicals */,
  {     6,  8096,  7876,   4,   4, PL_LYCI }   /* scx=lyci */,
  {     2,  6890,  7918,   4,   6, PL_INTHAANA }   /* blk=thaana */,
  {    17,  8376,    58,   3,   2, PL_LB__ID }   /* lb=id */,
  {     1,  8096,  8308,   4,   4, PL_GURU }   /* scx=guru */,
  {     0,  7136,  7104,   6,   8, PL_INARMENIAN }   /* block=armenian */,
  {     0,  2859,   974,  18,   9, PL_DT__CAN }   /* decompositiontype=canonical */,
  {     0,  8272,  7768,   4,   6, -PL_CWCF }   /* cwcf=false */,
  {     1,   183,     0,  20,   0, PL_MISCSYMBOLS }   /* miscellaneoussymbols */,
  {     0,  8340,  8041,   3,   5, PL_JG__KHAPH }   /* jg=khaph */,
  {     0,  6706,  8852,  10,   3, PL_IN__3_DOT_1 }   /* presentin=v31 */,
  {     1,  1402,     9,  24,   2, PL_INPC__NA }   /* indicpositionalcategory=na */,
  {     4,  2236,    47,  10,   1, PL_LM }   /* category=lm */,
  {     0,  1417,  1621,   9,   6, PL_CF }   /* category=format */,
  {     2,  1503,  6910,   4,   7, PL_EMOTICONS }   /* inemoticons */,
  {     0,  6076,  7768,  11,   6, -PL_BIDIC }   /* bidicontrol=false */,
  {     0,  8568,     0,   3,   0, PL_VAI }   /* vai */,
  {     0,  7457,  7924,   5,   6, PL_INSC__VIRAMA }   /* insc=virama */,
  {     0,  8504,    49,   3,   2, PL_SB__AT }   /* sb=at */,
  {     0,  8011,  1679,   3,   2, PL_PC }   /* gc=pc */,
  {     2,  7459,  2484,   3,  19, PL_EGYP }   /* sc=egyptianhieroglyphs */,
  {     0,  7288,  3611,   8,   7, PL_SC__BOPO }   /* script=bopomofo */,
  {     1,  7288,    57,   7,   2, PL_SC__YI }   /* script=yi */,
  {    12,  6890,  5609,   4,  12, PL_ALPHABETICPF }   /* blk=alphabeticpf */,
  {     4,  7459,  8600,   3,   4, PL_SC__QAAI }   /* sc=zinh */,
  {     2,  4314,  8592,  13,   4, PL_JG__ZAIN }   /* joininggroup=zain */,
  {     2,  8816,  7702,   3,   3, PL_NV__200 }   /* nv=200 */,
  {     0,  5192,   448,   3,  17, PL_IDEOGRAPHICSYMBOLS }   /* isideographicsymbols */,
  {     3,  8011,    44,   4,   1, PL_SK }   /* gc=sk */,
  {     3,  5544,  5219,  13,   2, PL_NV__10 }   /* numericvalue=10 */,
  {     4,    84,  7951,   4,   5, PL_MATH }   /* math=true */,
  {     2,  6706,  8753,  10,   3, PL_IN__6_DOT_2 }   /* presentin=6.2 */,
  {     0,  5544,  8909,  13,   2, PL_NV__45 }   /* numericvalue=45 */,
  {     1,  8026,  6697,   3,   9, PL_INPHOENICIAN }   /* inphoenician */,
  {     7,  8344,  6253,   4,  10, PL_JT__L }   /* jt=leftjoining */,
  {     3,  3129,  8500,  17,   4, PL_SARB }   /* scriptextensions=sarb */,
  {     2,  6890,  8556,   4,   4, PL_INTHAI }   /* blk=thai */,
  {     4,    21,  4813,   2,   7, PL_KANASUP }   /* inkanasup */,
  {     0,  6713,  7750,   3,   1, PL_IN__8 }   /* in=8 */,
  {    10,  7380,  8740,   7,   2, PL_CCC__25 }   /* ccc=ccc25 */,
  {     1,   184,   720,   2,  16, PL_ENCLOSEDALPHANUM }   /* isenclosedalphanum */,
  {     6,  7288,  8456,   7,   4, PL_OSGE }   /* script=osge */,
  {     0,  7288,  8044,   7,   4, PL_PHLI }   /* script=phli */,
  {     1,  7459,  6980,   3,   9, PL_NBAT }   /* sc=nabataean */,
  {     2,  7380,  7941,   4,   2, PL_CCC__11 }   /* ccc=11 */,
  {     0,  7906,  7493,   4,   6, PL_SC__KNDA }   /* sc=kannada */,
  {     0,  4542,  7313,   3,   7, PL_TAGB }   /* istagbanwa */,
  {     9,  6406,     0,  11,   0, PL_SORA }   /* sorasompeng */,
  {     4,  2229,  4524,  16,  15, PL_PS }   /* generalcategory=openpunctuation */,
  {     1,   974,  8673,  27,   2, PL_CCC__14 }   /* canonicalcombiningclass=ccc14 */,
  {     1,  8016,  1627,   4,   7, PL_GCB__CN }   /* gcb=control */,
  {     6,  4314,  5909,  13,  12, PL_JG__MALAYALAMTTA }   /* joininggroup=malayalamtta */,
  {     8,  6890,  8819,   4,   3, PL_OCR }   /* blk=ocr */,
  {     2,   184,  4644,   2,  15, PL_ZANB }   /* iszanabazarsquare */,
  {     0,  5375,  6252,  12,  11, PL_JT__L }   /* joiningtype=leftjoining */,
  {     0,  8096,  8496,   4,   4, PL_SAMR }   /* scx=samr */,
  {     0,  2249,     0,  10,   0, PL_GLAG }   /* glagolitic */,
  {     2,  7288,  7359,   7,   7, PL_AVST }   /* script=avestan */,
  {     7,  8096,  6989,   4,   9, PL_TALU }   /* scx=newtailue */,
  {     0,  8376,  4701,   3,  14, PL_LB__SA }   /* lb=complexcontext */,
  {    10,  5093,     0,  14,   0, PL_PHONETICEXTSUP }   /* phoneticextsup */,
  {     0,   184,  1307,   3,  12, PL_M }   /* iscombiningmark */,
  {     2,  5192,  1687,   3,  15, PL_INDICNUMBERFORMS }   /* isindicnumberforms */,
  {     0,  6890,  7597,   4,   7, PL_SHAW }   /* blk=shavian */,
  {     4,   184,  7527,   2,   7, PL_MULT }   /* ismultani */,
  {    13,   436,  7997,   5,   2, PL_NCHAR }   /* nchar=y */,
  {     2,  8011,  1627,   3,   7, PL_XPOSIXCNTRL }   /* gc=control */,
  {     2,  3129,  7900,  17,   6, PL_RJNG }   /* scriptextensions=rejang */,
  {     0,  6890,  3543,   4,  17, PL_SMALLFORMS }   /* blk=smallformvariants */,
  {     1,  8340,  6523,   3,   2, PL_JG__FE }   /* jg=fe */,
  {     3,  8240,    36,   4,   1, PL_BC__ET }   /* bc=et */,
  {     0,  8220,     0,   4,   0, PL_ARMN }   /* armn */,
  {     0,  6890,  7208,   4,   8, PL_INHIRAGANA }   /* blk=hiragana */,
  {     1,  7136,  1506,   6,  14, PL_MUSIC }   /* block=musicalsymbols */,
  {     1,  8504,   138,   3,   2, PL_SB__FO }   /* sb=fo */,
  {     0,  7136,  1981,   6,  21, PL_CYRILLICSUP }   /* block=cyrillicsupplementary */,
  {     2,  8500,     0,   4,   0, PL_SARB }   /* sarb */,
  {     0,  8288,  7184,   3,   8, PL_DT__FRA }   /* dt=fraction */,
  {     8,  4449,  7996,   4,   3, PL_NFCQC__Y }   /* nfcqc=y */,
  {     2,  6890,  2149,   4,  20, PL_INANATOLIANHIEROGLYPHS }   /* blk=anatolianhieroglyphs */,
  {     2,  6554,  7368,   4,   5, PL_INBENGALI }   /* inbengali */,
  {     0,  7288,  8308,   7,   4, PL_SC__GURU }   /* script=guru */,
  {     6,  8288,    45,   3,   3, PL_DT__COM }   /* dt=com */,
  {     8,  7288,  2967,   7,   4, PL_SC__GEOR }   /* script=geor */,
  {     0,   974,  7756,  24,   1, PL_CCC__9 }   /* canonicalcombiningclass=9 */,
  {     0,   184,  1702,   2,  22, PL_DIACRITICALSFORSYMBOLS }   /* isdiacriticalsforsymbols */,
  {     9,    21,  4827,   2,  14, PL_KANGXI }   /* inkangxiradicals */,
  {     0,  6890,  7359,   4,   7, PL_INAVESTAN }   /* blk=avestan */,
  {     1,  1417,  5310,   9,  13, PL_XPOSIXDIGIT }   /* category=decimalnumber */,
  {     0,  3129,  8496,  17,   4, PL_SAMR }   /* scriptextensions=samr */,
  {     3,  7798,  7951,   6,   5, PL_COMPEX }   /* compex=true */,
  {     8,   974,  7708,  24,   2, PL_CCC__21 }   /* canonicalcombiningclass=21 */,
  {     0,  7840,  5600,   6,   9, PL_VERTICALFORMS }   /* isverticalforms */,
  {     0,  1027,     0,   2,   0, PL_SO }   /* so */,
  {     1,  7168,  3223,   8,   2, -PL_EXT }   /* extender=n */,
  {     0,  7227,  5315,   5,   5, PL_POSIXALNUM }   /* posixalnum */,
  {     2,  7136,  7450,   6,   7, PL_INHANUNOO }   /* block=hanunoo */,
  {     1,  7136,   540,   6,  30, PL_CJKEXTB }   /* block=cjkunifiedideographsextensionb */,
  {     3,  6506,  6506,   3,  10, PL_YISYLLABLES }   /* isyisyllables */,
  {    11,  8096,  7450,   4,   7, PL_HANO }   /* scx=hanunoo */,
  {     1,  7288,  7597,   7,   7, PL_SHAW }   /* script=shavian */,
  {     6,  7136,  7590,   6,   7, PL_INSHARADA }   /* block=sharada */,
  {     0,   974,  1484,  24,   2, PL_CCC__BR }   /* canonicalcombiningclass=br */,
  {     0,  7459,  8244,   3,   4, PL_BHKS }   /* sc=bhks */,
  {     1,  8504,  3084,   3,   3, PL_SB__SE }   /* sb=sep */,
  {     4,   184,  8021,   2,   5, PL_GREXT }   /* isgrext */,
  {    14,  3526,  3581,  17,   2, PL_RI }   /* regionalindicator=t */,
  {     1,   974,  8643,  27,   2, PL_CCC__22 }   /* canonicalcombiningclass=ccc22 */,
  {     0,  8096,  2841,   4,   6, PL_COPT }   /* scx=coptic */,
  {     0,  6890,  2674,   4,  19, PL_SUNDANESESUP }   /* blk=sundanesesupplement */,
  {     1,  7689,  2150,   3,  19, PL_HLUW }   /* isanatolianhieroglyphs */,
  {     5,  2229,   217,  17,   1, PL_L_AMP_ }   /* generalcategory=l_ */,
  {     0,  5284,  7997,  13,   2, PL_CI }   /* caseignorable=y */,
  {     0,  7288,  7992,   8,   4, PL_SC__BUHD }   /* script=buhid */,
  {     3,  8096,  2484,   4,   4, PL_EGYP }   /* scx=egyp */,
  {    10,  3129,  8372,  17,   4, PL_LATN }   /* scriptextensions=latn */,
  {     9,  7288,  8560,   7,   4, PL_TIBT }   /* script=tibt */,
  {     7,  8096,  4509,   4,  15, PL_SARB }   /* scx=oldsoutharabian */,
  {     0,  8096,  8044,   4,   4, PL_PHLI }   /* scx=phli */,
  {     3,  6210,   541,   3,  29, PL_CJKEXTB }   /* incjkunifiedideographsextensionb */,
  {     0,   184,  7492,   2,   7, PL_KNDA }   /* iskannada */,
  {     0,  1417,    48,   9,   1, PL_P }   /* category=p */,
  {     0,  8240,  2086,   3,  21, PL_BC__PDI }   /* bc=popdirectionalisolate */,
  {     6,  2229,    47,  17,   1, PL_LM }   /* generalcategory=lm */,
  {     9,  7380,  8633,   4,   3, PL_CCC__103 }   /* ccc=103 */,
  {     0,  7380,  8675,   4,   3, PL_CCC__BL }   /* ccc=218 */,
  {     0,  6890,  5705,   4,  12, PL_CYRILLICEXTC }   /* blk=cyrillicextc */,
  {    17,  3129,  7499,  17,   7, PL_KALI }   /* scriptextensions=kayahli */,
  {    11,  6756,  7997,  10,   2, PL_SD }   /* softdotted=y */,
  {     0,  4420,  1077,   4,   2, PL_CPRT }   /* iscprt */,
  {     1,  4542,  5434,   3,   3, PL_TAML }   /* istaml */,
  {     1,  8240,  2088,   3,   3, PL_BC__PDI }   /* bc=pdi */,
  {     0,   184,  1354,   2,  24, PL_COMPEX }   /* isfullcompositionexclusion */,
  {     1,  5645,  2913,  10,  18, PL_BC__ET }   /* bidiclass=europeanterminator */,
  {     0,  8488,     0,   4,   0, PL_RJNG }   /* rjng */,
  {     2,  7689,  5233,   3,  12, PL_AEGEANNUMBERS }   /* isaegeannumbers */,
  {     0,  5657,  7768,   5,   6, -PL_BIDIM }   /* bidim=false */,
  {     0,    21,  1589,   2,  23, PL_LATINEXTADDITIONAL }   /* inlatinextendedadditional */,
  {     2,  3129,  8428,  17,   4, PL_NEWA }   /* scriptextensions=newa */,
  {     1,  1206,  7640,   3,   6, PL_INTAITHAM }   /* intaitham */,
  {     1,  3129,  7208,  17,   8, PL_HIRA }   /* scriptextensions=hiragana */,
  {     0,  7288,  8412,   7,   4, PL_MTEI }   /* script=mtei */,
  {     0,  7136,   568,   6,   2, PL_NB }   /* block=nb */,
  {     3,  7136,  4614,   6,   8, PL_VEDICEXT }   /* block=vedicext */,
  {     0,  1960,     0,  21,   0, PL_CJKRADICALSSUP }   /* cjkradicalssupplement */,
  {     0,  7227,  1887,   5,   5, PL_POSIXLOWER }   /* posixlower */,
  {     2,  7459,  3458,   3,   4, PL_SC__MANI }   /* sc=mani */,
  {     1,  2859,  1209,  18,   5, PL_DT__SUP }   /* decompositiontype=super */,
  {     0,  8086,  7768,   5,   6, -PL_QMARK }   /* qmark=false */,
  {     0,  8472,     0,   4,   0, PL_PRTI }   /* prti */,
  {     8,  5544,  8717,  13,   3, PL_NV__3_SLASH_4 }   /* numericvalue=3/4 */,
  {     0,  5250,     0,   8,   0, PL_XPOSIXXDIGIT }   /* hexdigit */,
  {     4,  6221,  1029,   4,   4, PL_INCOPTIC }   /* incoptic */,
  {     2,  7380,  8187,   4,   2, PL_CCC__27 }   /* ccc=27 */,
  {     0,  8296,     0,   4,   0, PL_GONM }   /* gonm */,
  {     2,  4314,  8133,  13,   3, PL_JG__AIN }   /* joininggroup=ain */,
  {     3,  8572,  4466,   3,   2, PL_WB__DQ }   /* wb=dq */,
  {     0,  3738,     0,   9,   0, PL_LATIN1 }   /* latin1sup */,
  {     1,  1746,  8935,  21,   2, PL_GCB__XX }   /* graphemeclusterbreak=xx */,
  {     5,  7136,  7534,   6,   7, PL_NB }   /* block=noblock */,
  {     1,  8340,  6516,   3,  10, PL_JG__AFRICANFEH }   /* jg=africanfeh */,
  {     0,  6890,   892,   4,  18, PL_INVS }   /* blk=variationselectors */,
  {     9,  4659,     0,  14,   0, PL_ANCIENTSYMBOLS }   /* ancientsymbols */,
  {     9,  8572,    18,   3,   2, PL_RI }   /* wb=ri */,
  {     3,  6890,  2128,   4,  21, PL_YIJING }   /* blk=yijinghexagramsymbols */,
  {     0,  8096,    78,   4,   6, PL_ARAB }   /* scx=arabic */,
  {     3,  2859,  3191,  18,   3, PL_DT__MED }   /* decompositiontype=med */,
  {     0,  5645,  8801,  10,   3, PL_BC__LRE }   /* bidiclass=lre */,
  {     7,  8816,  8905,   3,   2, PL_NV__39 }   /* nv=39 */,
  {     2,  7344,  7951,   4,   5, PL_XIDS }   /* xids=true */,
  {     2,  7136,  3594,   6,  16, PL_ARABICSUP }   /* block=arabicsupplement */,
  {     1,  7288,  8116,   7,   5, PL_SC__TAML }   /* script=tamil */,
  {    18,  7459,  8420,   3,   4, PL_NARB }   /* sc=narb */,
  {    11,  6210,  3469,   3,   3, PL_INCHAM }   /* incham */,
  {     0,  6210,  3675,   3,  15, PL_CYPRIOTSYLLABARY }   /* incypriotsyllabary */,
  {     2,  7459,  7527,   3,   7, PL_SC__MULT }   /* sc=multani */,
  {     0,  6505,     0,  11,   0, PL_YISYLLABLES }   /* yisyllables */,
  {     8,   184,  2617,   2,  19, PL_MODIFIERTONELETTERS }   /* ismodifiertoneletters */,
  {     0,  8011,    38,   3,   2, PL_XPOSIXDIGIT }   /* gc=nd */,
  {     0,  7459,  6005,   3,  12, PL_HUNG }   /* sc=oldhungarian */,
  {     2,  6890,  2895,   4,  18, PL_ETHIOPICSUP }   /* blk=ethiopicsupplement */,
  {     0,  6263,  5107,  10,  14, PL_LB__PO }   /* linebreak=postfixnumeric */,
  {     2,  5645,    37,  10,   2, PL_BC__EN }   /* bidiclass=en */,
  {    10,  8376,   496,   3,   7, PL_LB__NU }   /* lb=numeric */,
  {     0,  6098,     0,  11,   0, PL_L_AMP_ }   /* casedletter */,
  {     0,  8011,    48,   3,   1, PL_P }   /* gc=p */,
  {     3,  8340,  3475,   3,  17, PL_JG__MANICHAEANHUNDRED }   /* jg=manichaeanhundred */,
  {     6,  8011,  2521,   3,   2, PL_PF }   /* gc=pf */,
  {     3,  2236,   217,  10,   1, PL_L_AMP_ }   /* category=l_ */,
  {     0,  3424,  3581,  17,   2, PL_IDSB }   /* idsbinaryoperator=t */,
  {     0,  7459,  8260,   3,   4, PL_SC__CAKM }   /* sc=cakm */,
  {     0,   235,     0,   2,   0, PL_LO }   /* lo */,
  {     6,  6713,  8846,   3,   3, PL_IN__2_DOT_1 }   /* in=v21 */,
  {     1,  7288,  2107,   7,   7, PL_SC__SINH }   /* script=sinhala */,
  {    13,  7816,  3581,   6,   2, PL_GRBASE }   /* grbase=t */,
  {     3,  8096,  7019,   4,   4, PL_PERM }   /* scx=perm */,
  {     0,  8096,  8046,   4,   4, PL_LIMB }   /* scx=limb */,
  {     1,  8096,  8300,   4,   4, PL_GREK }   /* scx=grek */,
  {     8,   184,  1877,   3,  20, PL_CWL }   /* ischangeswhenlowercased */,
  {    31,  6890,  6766,   4,  10, PL_SUPARROWSA }   /* blk=suparrowsa */,
  {     3,  8011,  5136,   4,  13, PL_ZS }   /* gc=spaceseparator */,
  {     9,  6890,  2004,   6,  19, PL_ININSCRIPTIONALPARTHIAN }   /* blk=inscriptionalparthian */,
  {     0,  1234,     0,  24,   0, PL_ARABICPFA }   /* arabicpresentationformsa */,
  {     1,   974,  8684,  24,   3, PL_CCC__L }   /* canonicalcombiningclass=224 */,
  {     5,   184,  8432,   2,   3, PL_NKO }   /* isnko */,
  {     1,  7288,  7145,   8,   7, PL_SC__BUGI }   /* script=buginese */,
  {     0,  8780,  3581,   3,   2, PL_CWT }   /* cwt=t */,
  {     1,  3129,  8308,  17,   4, PL_GURU }   /* scriptextensions=guru */,
  {     3,  6890,  3965,   4,  13, PL_MATHOPERATORS }   /* blk=mathoperators */,
  {     2,   690,     0,  30,   0, PL_CUNEIFORMNUMBERS }   /* cuneiformnumbersandpunctuation */,
  {     0,    18,  7768,   2,   6, -PL_RI }   /* ri=false */,
  {    12,  7478,  6767,   3,   9, PL_SUPARROWSA }   /* issuparrowsa */,
  {     1,   974,  1483,  24,   2, PL_CCC__DB }   /* canonicalcombiningclass=db */,
  {     4,  7457,  7112,   5,   8, PL_INSC__AVAGRAHA }   /* insc=avagraha */,
  {     0,  7798,  3223,   6,   2, -PL_COMPEX }   /* compex=n */,
  {     4,  8376,   534,   3,   2, PL_LB__NS }   /* lb=ns */,
  {    13,  7436,     0,   7,   0, PL_ELBA }   /* elbasan */,
  {     4,  3129,  8600,  17,   4, PL_QAAI }   /* scriptextensions=zinh */,
  {     3,  6890,  7192,   4,   8, PL_INGUJARATI }   /* blk=gujarati */,
  {     8,  6706,  8882,  10,   3, PL_IN__6_DOT_3 }   /* presentin=v63 */,
  {     0,  7136,  7387,   6,   7, PL_CJKEXTA }   /* block=cjkexta */,
  {    13,  8096,  7569,   4,   7, PL_OSMA }   /* scx=osmanya */,
  {     2,  2636,     0,   9,   0, PL_MONG }   /* mongolian */,
  {     0,  6890,  4827,   4,  14, PL_KANGXI }   /* blk=kangxiradicals */,
  {     0,  7136,   802,   6,   6, PL_ARROWS }   /* block=arrows */,
  {     2,  4542,  7647,   3,   6, PL_TAVT }   /* istaiviet */,
  {    13,  8795,    25,   3,   1, PL_INVS }   /* invs */,
  {     0,  7459,  7359,   3,   7, PL_AVST }   /* sc=avestan */,
  {     1,  3424,  7768,  17,   2, -PL_IDSB }   /* idsbinaryoperator=f */,
  {     2,  6890,  8428,   4,   4, PL_INNEWA }   /* blk=newa */,
  {     0,  3129,  2636,  17,   4, PL_MONG }   /* scriptextensions=mong */,
  {     2,  7689,  7957,   3,   4, PL_ADLM }   /* isadlam */,
  {     0,   184,  5079,   2,  14, PL_MN }   /* isnonspacingmark */,
  {     0,  7136,  6567,   7,   9, PL_BOXDRAWING }   /* block=boxdrawing */,
  {     8,  7459,  8540,   3,   4, PL_SC__TAML }   /* sc=taml */,
  {     4,  6483,  3223,   4,   3, -PL_XIDC }   /* xidc=no */,
  {     1,  7227,    96,   5,   5, PL_POSIXALPHA }   /* posixalpha */,
  {     0,  7816,  7768,   6,   2, -PL_GRBASE }   /* grbase=f */,
  {     0,  7288,  8061,   7,   5, PL_OGAM }   /* script=ogham */,
  {     2,  2841,     0,  18,   0, PL_COPTICEPACTNUMBERS }   /* copticepactnumbers */,
  {     8,  3129,  7604,  17,   4, PL_SIDD }   /* scriptextensions=sidd */,
  {     0,  8096,  8111,   4,   5, PL_TAKR }   /* scx=takri */,
  {     3,   974,  8051,  24,   5, PL_CCC__7 }   /* canonicalcombiningclass=nukta */,
  {     4,  7478,  1210,   3,  24, PL_SUPERANDSUB }   /* issuperscriptsandsubscripts */,
  {     2,  6472,  8789,  10,   3, PL_WB__EBG }   /* wordbreak=ebg */,
  {     2,  5544,  8168,  13,   4, PL_NV__17_SLASH_2 }   /* numericvalue=17/2 */,
  {     3,  5544,  8617,  13,   2, PL_NV__31 }   /* numericvalue=31 */,
  {     0,  7359,     0,   7,   0, PL_AVST }   /* avestan */,
  {     0,  4402,   224,   3,   2, PL_INMRO }   /* inmro */,
  {     0,  2990,  6538,   4,   8, PL_ARABICEXTA }   /* inarabicexta */,
  {     0,  7288,  8600,   7,   4, PL_SC__QAAI }   /* script=zinh */,
  {     0,  6890,  7120,   4,   8, PL_INBALINESE }   /* blk=balinese */,
  {     1,  8086,  3581,   5,   2, PL_QMARK }   /* qmark=t */,
  {     9,  7380,  7714,   4,   2, PL_CCC__30 }   /* ccc=30 */,
  {     1,  8416,     0,   4,   0, PL_MYMR }   /* mymr */,
  {     4,  8026,  3165,   5,  18, PL_INPC__TOPANDLEFTANDRIGHT }   /* inpc=topandleftandright */,
  {     0,   184,  4104,   2,   8, PL_BAMUMSUP }   /* isbamumsup */,
  {     0,  4284,  4042,  14,  16, PL_LB__H3 }   /* hangulsyllabletype=lvtsyllable */,
  {     0,   184,   183,   2,  20, PL_MISCSYMBOLS }   /* ismiscellaneoussymbols */,
  {     0,  2895,     0,   8,   0, PL_ETHI }   /* ethiopic */,
  {     0,   808,     0,  28,   0, PL_PHONETICEXTSUP }   /* phoneticextensionssupplement */,
  {     6,   184,   601,   3,  29, PL_CJKEXTD }   /* iscjkunifiedideographsextensiond */,
  {     0,  8340,  4785,   3,  14, PL_JG__HAMZAONHEHGOAL }   /* jg=hamzaonhehgoal */,
  {     0,  5968,  7017,   3,   8, PL_INOLDPERMIC }   /* inoldpermic */,
  {     8,  5583,  3223,  13,   3, -PL_QMARK }   /* quotationmark=no */,
  {     0,  3129,  6008,  17,   4, PL_HUNG }   /* scriptextensions=hung */,
  {     0,  6263,  8921,  10,   2, PL_LB__BK }   /* linebreak=bk */,
  {     0,  3129,  7436,  17,   4, PL_ELBA }   /* scriptextensions=elba */,
  {     1,   184,  2788,   3,  10, PL_CHEROKEESUP }   /* ischerokeesup */,
  {     1,  4284,  3219,  14,  18, PL_HST__NA }   /* hangulsyllabletype=notapplicable */,
  {     0,  8011,    24,   3,   1, PL_L }   /* gc=l */,
  {     4,    11,  3223,   3,   2, -PL_DIA }   /* dia=n */,
  {     1,  1426,  1520,  22,  23, PL_INSC__CONSONANTPRECEDINGREPHA }   /* indicsyllabiccategory=consonantprecedingrepha */,
  {     0,  4314,  5023,  13,  14, PL_JG__MANICHAEANYODH }   /* joininggroup=manichaeanyodh */,
  {     1,  4314,  6523,  13,   3, PL_JG__FEH }   /* joininggroup=feh */,
  {     3,  8016,  3914,   4,   5, PL_GCB__XX }   /* gcb=other */,
  {     0,  3129,  8116,  17,   5, PL_TAML }   /* scriptextensions=tamil */,
  {     1,  7136,   892,   6,  28, PL_VSSUP }   /* block=variationselectorssupplement */,
  {     3,  8096,  8584,   4,   4, PL_XSUX }   /* scx=xsux */,
  {     0,  7459,  7590,   3,   7, PL_SC__SHRD }   /* sc=sharada */,
  {     6,  7136,  6406,   6,  11, PL_INSORASOMPENG }   /* block=sorasompeng */,
  {     2,   690,     0,   9,   0, PL_XSUX }   /* cuneiform */,
  {     0,  7689,    27,   3,   2, PL_ALL }   /* isall */,
  {     0,   186,  7997,   2,   4, PL_CE }   /* ce=yes */,
  {     0,  7136,  2877,   6,  13, PL_DEVANAGARIEXT }   /* block=devanagariext */,
  {     0,  8822,  3581,   3,   2, PL_PCM }   /* pcm=t */,
  {     2,  8572,    34,   3,   6, PL_WB__EXTEND }   /* wb=extend */,
  {     3,  6076,  7951,  11,   5, PL_BIDIC }   /* bidicontrol=true */,
  {     2,  5134,  3511,   4,  15, PL_PATWS }   /* ispatternwhitespace */,
  {     0,  1426,  6998,  22,   9, PL_INSC__NONJOINER }   /* indicsyllabiccategory=nonjoiner */,
  {     5,  2236,  5814,  10,  11, PL_NL }   /* category=letternumber */,
  {     4,  6613,  1379,   3,  23, PL_HIGHPUSURROGATES }   /* ishighprivateusesurrogates */,
  {     0,  8288,  5969,   3,  12, PL_DT__NONCANON }   /* dt=noncanonical */,
  {     0,  8816,  7738,   3,   6, PL_NV__600000 }   /* nv=600000 */,
  {     0,  7200,     0,   8,   0, PL_GURU }   /* gurmukhi */,
  {     0,  5544,  7714,  13,   6, PL_NV__300000 }   /* numericvalue=300000 */,
  {     0,   184,  3738,   2,   6, PL_LATIN1 }   /* islatin1 */,
  {     2,  8096,  8600,   4,   4, PL_QAAI }   /* scx=zinh */,
  {     4,  8340,  5849,   3,  12, PL_JG__MALAYALAMLLA }   /* jg=malayalamlla */,
  {     2,   184,  7128,   2,   4, PL_BASS }   /* isbass */,
  {     0,  7459,  8091,   3,   5, PL_RUNR }   /* sc=runic */,
  {     1,  3129,  8420,  17,   4, PL_NARB }   /* scriptextensions=narb */,
  {    24,  4284,  3577,  14,  17, PL_GCB__T }   /* hangulsyllabletype=trailingjamo */,
  {     0,  2100,   125,   3,   2, PL_OCR }   /* isocr */,
  {     0,  6706,  8888,  10,   3, PL_IN__8 }   /* presentin=v80 */,
  {     1,  8272,  7768,   4,   2, -PL_CWCF }   /* cwcf=f */,
  {     8,  8248,  5488,   4,   4, PL_BPT__N }   /* bpt=none */,
  {     2,  6210,  1940,   3,  20, PL_CJKCOMPATFORMS }   /* incjkcompatibilityforms */,
  {     1,  5192,    59,   3,   3, PL_IDEO }   /* isideo */,
  {     0,   974,  3262,  24,   9, PL_CCC__BL }   /* canonicalcombiningclass=belowleft */,
  {     0,  7288,  7918,   7,   4, PL_SC__THAA }   /* script=thaa */,
  {     0,  7136,  6806,   6,  10, PL_INWARANGCITI }   /* block=warangciti */,
  {     0,  7288,  7882,   7,   6, PL_LYDI }   /* script=lydian */,
  {     2,  1159,  7768,  25,   6, -PL_CWKCF }   /* changeswhennfkccasefolded=false */,
  {     0,  7136,  7256,   6,   8, PL_KANAEXTA }   /* block=kanaexta */,
  {     1,  4402,   317,   3,  32, PL_MISCMATHSYMBOLSB }   /* inmiscellaneousmathematicalsymbolsb */,
  {     0,  4464,     0,  15,   0, PL_DT__CAN }   /* nfdquickcheck=n */,
  {     3,    96,  3581,   5,   2, PL_XPOSIXALPHA }   /* alpha=t */,
  {     0,  8816,  7702,   3,   2, PL_NV__20 }   /* nv=20 */,
  {     2,  2229,  3084,  16,   9, PL_Z }   /* generalcategory=separator */,
  {     0,  5544,  5219,  13,   4, PL_NV__1000 }   /* numericvalue=1000 */,
  {     1,  6554,  4105,   3,   7, PL_BAMUMSUP }   /* inbamumsup */,
  {     8,  8096,  7822,   4,   4, PL_HATR }   /* scx=hatr */,
  {     6,  8001,     0,   5,   0, PL_XPOSIXCNTRL }   /* cntrl */,
  {     0,  3594,     0,   9,   0, PL_ARABICSUP }   /* arabicsup */,
  {     0,  6484,  7997,  10,   2, PL_IDC }   /* idcontinue=y */,
  {    11,  1204,     0,   2,   0, PL_PO }   /* po */,
  {     2,  7136,  7152,   6,   8, PL_INDUPLOYAN }   /* block=duployan */,
  {     3,  8340,  7930,   3,   6, PL_JG__YUDHHE }   /* jg=yudhhe */,
  {    17,  7459,  2787,   3,   4, PL_CHER }   /* sc=cher */,
  {     1,  2985,  7997,  18,   2, PL_IDST }   /* idstrinaryoperator=y */,
  {     4,  6713,  8876,   3,   3, PL_IN__6_DOT_1 }   /* in=v61 */,
  {     9,  7136,  7527,   6,   7, PL_INMULTANI }   /* block=multani */,
  {     7,  1426,  7688,  22,   7, PL_INSC__VISARGA }   /* indicsyllabiccategory=visarga */,
  {    22,   184,  1919,   3,  20, PL_CWU }   /* ischangeswhenuppercased */,
  {     1,  6554,  3611,   3,  10, PL_BOPOMOFOEXT }   /* inbopomofoext */,
  {     3,  1701,  3581,   2,   2, PL_SD }   /* sd=t */,
  {     6,  7457,  4058,   5,   5, PL_INSC__VOWEL }   /* insc=vowel */,
  {    19,  2229,  3914,  16,  16, PL_PO }   /* generalcategory=otherpunctuation */,
  {     0,    21,  7882,   2,   6, PL_INLYDIAN }   /* inlydian */,
  {     4,  2985,  3223,   3,   3, -PL_IDS }   /* ids=no */,
  {     4,  1887,  7997,   9,   2, PL_XPOSIXLOWER }   /* lowercase=y */,
  {     2,  2108,  2543,   4,  17, PL_JAMOEXTA }   /* inhanguljamoextendeda */,
  {     3,  7459,  8520,   3,   4, PL_SHAW }   /* sc=shaw */,
  {    14,  8096,  1401,   4,   4, PL_SIND }   /* scx=sind */,
  {     0,  7459,  8111,   3,   5, PL_SC__TAKR }   /* sc=takri */,
  {     3,  7019,     0,   4,   0, PL_PERM }   /* perm */,
  {     0,  3129,  6806,  17,   4, PL_WARA }   /* scriptextensions=wara */,
  {     9,  4630,  1174,   3,   3, PL_UCAS }   /* isucas */,
  {     0,  1346,  2053,   5,   5, PL_GREEKEXT }   /* ingreekext */,
  {     1,  2990,  7106,   4,   6, PL_INARMENIAN }   /* inarmenian */,
  {     0,   974,  5349,  24,  13, PL_CCC__IS }   /* canonicalcombiningclass=iotasubscript */,
  {     9,  6890,   720,   4,  16, PL_ENCLOSEDALPHANUM }   /* blk=enclosedalphanum */,
  {     0,    96,  7768,   5,   2, -PL_XPOSIXALPHA }   /* alpha=f */,
  {     0,  8096,  2531,   4,   4, PL_MULT }   /* scx=mult */,
  {     0,  6890,   570,   4,  30, PL_CJKEXTC }   /* blk=cjkunifiedideographsextensionc */,
  {     0,  1426,  4434,  22,  15, PL_INSC__MODIFYINGLETTER }   /* indicsyllabiccategory=modifyingletter */,
  {     0,  4479,  7996,   5,   5, PL_NFKCQC__Y }   /* nfkcqc=yes */,
  {     1,  5544,  8136,  13,   4, PL_NV___MINUS_1_SLASH_2 }   /* numericvalue=-1/2 */,
  {     1,   974,  8640,  27,   2, PL_CCC__18 }   /* canonicalcombiningclass=ccc18 */,
  {     5,  5583,  7997,  13,   2, PL_QMARK }   /* quotationmark=y */,
  {    33,  5544,  8188,  13,   4, PL_NV__7_SLASH_12 }   /* numericvalue=7/12 */,
  {     4,  7136,  5400,   7,   7, PL_INBALINESE }   /* block=balinese */,
  {     5,  5583,     0,  13,   0, PL_QMARK }   /* quotationmark */,
  {    14,    11,  3581,   2,   2, PL_DI }   /* di=t */,
  {     0,  7136,  7129,   7,   7, PL_INBASSAVAH }   /* block=bassavah */,
  {     0,  7380,   727,   4,   2, PL_CCC__DA }   /* ccc=da */,
  {     0,  2484,     0,   4,   0, PL_EGYP }   /* egyp */,
  {     0,  3129,  4644,  17,  15, PL_ZANB }   /* scriptextensions=zanabazarsquare */,
  {     1,  6554,  3611,   3,   7, PL_INBOPOMOFO }   /* inbopomofo */,
  {     0,  1448,  3995,   3,  15, PL_SYRIACSUP }   /* insyriacsupplement */,
  {     0,  7136,  5777,   6,   6, PL_INHEBREW }   /* block=hebrew */,
  {     6,  7459,  8208,   3,   4, PL_AHOM }   /* sc=ahom */,
  {     0,  5544,  8165,  13,   3, PL_NV__5_SLASH_2 }   /* numericvalue=5/2 */,
  {    10,  5657,  3223,   5,   3, -PL_BIDIM }   /* bidim=no */,
  {     0,  8096,  8404,   4,   4, PL_MLYM }   /* scx=mlym */,
  {     1,  2100,  4525,   3,  14, PL_PS }   /* isopenpunctuation */,
  {     1,  7136,   849,   6,  14, PL_PUA }   /* block=privateusearea */,
  {     9,  7380,  8648,   7,   3, PL_CCC__130 }   /* ccc=ccc130 */,
  {     3,   184,  8784,   3,   2, PL_CWU }   /* iscwu */,
  {     4,  1918,  7951,  21,   5, PL_CWU }   /* changeswhenuppercased=true */,
  {     1,  2990,  3596,   4,  14, PL_ARABICSUP }   /* inarabicsupplement */,
  {     0,  8006,  7768,   5,   2, -PL_CWKCF }   /* cwkcf=f */,
  {     0,  7136,  8046,   6,   5, PL_INLIMBU }   /* block=limbu */,
  {     4,  2100,  3915,   3,   4, PL_C }   /* isother */,
  {     0,  6890,  3882,   4,  16, PL_MYANMAREXTA }   /* blk=myanmarextendeda */,
  {     1,  8508,  6554,   4,   3, PL_SC__LINB }   /* sc=linb */,
  {     1,  3373,  1083,  17,   7, PL_EA__H }   /* eastasianwidth=halfwidth */,
  {    10,  8816,  8137,   3,   3, PL_NV__1_SLASH_2 }   /* nv=1/2 */,
  {     1,  3129,  4010,  17,   4, PL_TANG }   /* scriptextensions=tang */,
  {     0,   184,  6318,   2,  11, PL_MYANMAREXTB }   /* ismyanmarextb */,
  {     1,  7810,     0,   4,   0, PL_GOTH }   /* goth */,
  {     8,  8011,   982,   3,   2, PL_L_AMP_ }   /* gc=lc */,
  {     0,  4239,  7997,   4,   4, PL_DASH }   /* dash=yes */,
  {     0,  7144,     0,   8,   0, PL_BUGI }   /* buginese */,
  {     0,    21,  7499,   2,   7, PL_KALI }   /* inkayahli */,
  {     6,  7136,  3147,   6,  11, PL_TAIXUANJING }   /* block=taixuanjing */,
  {     2,  6210,  7409,   3,   6, PL_CJKEXTD }   /* incjkextd */,
  {     8,  7478,  6429,   3,  10, PL_SUPERANDSUB }   /* issuperandsub */,
  {     1,  6890,   349,   4,  33, PL_SUPMATHOPERATORS }   /* blk=supplementalmathematicaloperators */,
  {     1,   974,  8899,  24,   2, PL_CCC__35 }   /* canonicalcombiningclass=35 */,
  {     0,  7882,     0,   4,   0, PL_LYDI }   /* lydi */,
  {     0,  3129,  8396,  17,   4, PL_MERC }   /* scriptextensions=merc */,
  {     0,    11,  7768,   2,   2, -PL_DI }   /* di=f */,
  {    10,  7459,  7639,   3,   7, PL_LANA }   /* sc=taitham */,
  {     2,  8096,  3611,   5,   7, PL_BOPO }   /* scx=bopomofo */,
  {     4,  1543,     0,  23,   0, PL_GEOMETRICSHAPESEXT }   /* geometricshapesextended */,
  {     0,  6890,  3994,   4,   6, PL_INSYRIAC }   /* blk=syriac */,
  {     0,  7457,  3978,   5,  16, PL_INSC__SYLLABLEMODIFIER }   /* insc=syllablemodifier */,
  {     0,  1202,  3223,   3,   3, -PL_DEP }   /* dep=no */,
  {     0,  6890,  7956,   4,   5, PL_INADLAM }   /* blk=adlam */,
  {     0,   184,  4841,   2,  14, PL_LATINEXTB }   /* islatinextendedb */,
  {     0,  8360,     0,   4,   0, PL_KTHI }   /* kthi */,
  {     0,  1133,  7997,  26,   4, PL_PCM }   /* prependedconcatenationmark=yes */,
  {     0,  6890,  1543,   4,  15, PL_GEOMETRICSHAPES }   /* blk=geometricshapes */,
  {     1,   184,  3469,   3,   3, PL_CHAM }   /* ischam */,
  {     2,  4542,  7919,   3,   3, PL_THAA }   /* isthaa */,
  {     0,  7459,  2674,   3,   9, PL_SUND }   /* sc=sundanese */,
  {     0,   184,  5258,   2,  13, PL_BLOCKELEMENTS }   /* isblockelements */,
  {     0,  8006,  3581,   5,   2, PL_CWKCF }   /* cwkcf=t */,
  {     0,  7288,  8056,   7,   5, PL_NSHU }   /* script=nushu */,
  {     0,  8196,  8714,   4,   3, PL_AGE__3_DOT_2 }   /* age=3.2 */,
  {    11,  1206,  8112,   3,   4, PL_INTAKRI }   /* intakri */,
  {     0,  7288,  2895,   7,   4, PL_ETHI }   /* script=ethi */,
  {     2,   184,  1184,   2,  25, PL_DI }   /* isdefaultignorablecodepoint */,
  {     0,  6890,  3390,   4,  11, PL_ETHIOPICEXT }   /* blk=ethiopicext */,
  {     0,  7136,  3111,   6,  18, PL_RUMI }   /* block=ruminumeralsymbols */,
  {     1,  6890,   864,   4,  28, PL_SUPPUAB }   /* blk=supplementaryprivateuseareab */,
  {     4,  8016,  4561,   4,   2, PL_WB__EB }   /* gcb=eb */,
  {    10,  8816,  8140,   3,   4, PL_NV__1_SLASH_10 }   /* nv=1/10 */,
  {     1,  2221,  5181,   3,  10, PL_GCB__V }   /* hst=voweljamo */,
  {     1,  8096,  3583,   5,   3, PL_BRAI }   /* scx=brai */,
  {     2,  8288,  8576,   3,   4, PL_EA__F }   /* dt=wide */,
  {    42,  7288,  1160,   7,   4, PL_SC__HANG }   /* script=hang */,
  {     8,   184,     2,   3,   1, PL_CI }   /* isci */,
  {    49,  8011,  1372,   3,   2, PL_LU }   /* gc=lu */,
  {     0,  8340,  8133,   3,   3, PL_JG__AIN }   /* jg=ain */,
  {     0,  3129,  5427,  17,   9, PL_MLYM }   /* scriptextensions=malayalam */,
  {     2,  6944,     0,   9,   0, PL_LATINEXTC }   /* latinextc */,
  {     0,  6210,    43,   3,  35, PL_CJKCOMPATIDEOGRAPHSSUP }   /* incjkcompatibilityideographssupplement */,
  {     0,  4542,  8561,   3,   3, PL_TIBT }   /* istibt */,
  {     0,   184,  1681,   3,   5, PL_ZYYY }   /* iscommon */,
  {     1,  6890,  6120,   4,  11, PL_DOMINO }   /* blk=dominotiles */,
  {     1,  7597,     0,   7,   0, PL_SHAW }   /* shavian */,
  {     3,    21,  1589,   2,  14, PL_LATINEXTA }   /* inlatinextendeda */,
  {     0,  6210,   691,   3,   8, PL_INCUNEIFORM }   /* incuneiform */,
  {     5,  1812,     0,  22,   0, PL_TRANSPORTANDMAP }   /* transportandmapsymbols */,
  {     0,    21,  3738,   2,   6, PL_LATIN1 }   /* inlatin1 */,
  {     0,  6613,  1082,   3,  25, PL_HALFANDFULLFORMS }   /* ishalfwidthandfullwidthforms */,
  {     0,  7912,     0,   4,   0, PL_TELU }   /* telu */,
  {     2,  3129,  8056,  17,   5, PL_NSHU }   /* scriptextensions=nushu */,
  {     0,  7288,  7912,   7,   4, PL_SC__TELU }   /* script=telu */,
  {     0,  7288,  7956,   7,   5, PL_SC__ADLM }   /* script=adlam */,
  {    17,  8783,  7951,   3,   5, PL_CWU }   /* cwu=true */,
  {     5,  2108,  2543,   4,   8, PL_JAMO }   /* inhanguljamo */,
  {     0,  7288,  6989,   7,   9, PL_TALU }   /* script=newtailue */,
  {     0,   117,  2271,   4,  18, PL_ININSCRIPTIONALPAHLAVI }   /* ininscriptionalpahlavi */,
  {     0,   184,  8352,   2,   4, PL_KHMR }   /* iskhmr */,
  {     3,  6890,  8208,   4,   4, PL_INAHOM }   /* blk=ahom */,
  {     2,  8096,  3566,   4,  11, PL_SGNW }   /* scx=signwriting */,
  {     2,   122,     0,   9,   0, PL_DIA }   /* diacritic */,
  {     2,  8288,  4653,   3,   6, PL_DT__SQR }   /* dt=square */,
  {    13,  4402,  1769,   3,  21, PL_MISCTECHNICAL }   /* inmiscellaneoustechnical */,
  {     1,  4479,  8256,   5,   3, PL_NFKCQC__N }   /* nfkcqc=n */,
  {     0,  3129,  2674,  17,   4, PL_SUND }   /* scriptextensions=sund */,
  {     0,  5968,  7570,   3,   6, PL_INOSMANYA }   /* inosmanya */,
  {     5,  7351,     0,   4,   0, PL_TALE }   /* tale */,
  {     1,  6647,     9,   4,  16, PL_CANS }   /* iscanadianaboriginal */,
  {     0,  7136,  2841,   6,   6, PL_INCOPTIC }   /* block=coptic */,
  {     0,  5544,  8176,  13,   4, PL_NV__3_SLASH_20 }   /* numericvalue=3/20 */,
  {     1,  5544,  3743,  13,   1, PL_NV__1 }   /* numericvalue=1 */,
  {     2,  7380,  8669,   4,   3, PL_CCC__202 }   /* ccc=202 */,
  {     2,  7136,  4841,   6,  14, PL_LATINEXTB }   /* block=latinextendedb */,
  {     0,  7478,  7612,   3,   3, PL_SOYO }   /* issoyo */,
  {     1,  7136,  2503,   6,  19, PL_ENCLOSEDALPHANUMSUP }   /* block=enclosedalphanumsup */,
  {     0,   184,  5037,   2,  14, PL_SK }   /* ismodifiersymbol */,
  {     1,  5544,  7750,  13,   3, PL_NV__800 }   /* numericvalue=800 */,
  {     1,  2236,    24,  10,   1, PL_LL }   /* category=ll */,
  {     0,  8376,  8457,   3,   2, PL_LB__SG }   /* lb=sg */,
  {     1,  8795,  1479,   3,   2, PL_INVAI }   /* invai */,
  {     2,  7016,     0,   9,   0, PL_PERM }   /* oldpermic */,
  {     0,  1426,  4743,  22,  14, PL_INSC__GEMINATIONMARK }   /* indicsyllabiccategory=geminationmark */,
  {     0,  8540,     0,   4,   0, PL_TAML }   /* taml */,
  {     2,  5645,  3930,  10,  16, PL_BC__S }   /* bidiclass=segmentseparator */,
  {     1,  6890,  7900,   4,   6, PL_INREJANG }   /* blk=rejang */,
  {     1,  8816,  8862,   3,   2, PL_NV__41 }   /* nv=41 */,
  {     0,  1202,  3581,   3,   2, PL_DEP }   /* dep=t */,
  {     1,  7344,  3581,   8,   2, PL_XIDS }   /* xidstart=t */,
  {     0,   184,  8046,   2,   4, PL_LIMB }   /* islimb */,
  {     1,  8006,  7768,   5,   6, -PL_CWKCF }   /* cwkcf=false */,
  {     0,  1358,  3223,  20,   3, -PL_CE }   /* compositionexclusion=no */,
  {     1,   184,  6989,   2,   9, PL_TALU }   /* isnewtailue */,
  {     0,  6890,  1812,   4,  22, PL_TRANSPORTANDMAP }   /* blk=transportandmapsymbols */,
  {     0,  6706,  8750,  10,   3, PL_IN__6_DOT_1 }   /* presentin=6.1 */,
  {     1,  3129,  8408,  17,   4, PL_MRO }   /* scriptextensions=mroo */,
  {     2,  5544,  8907,  13,   2, PL_NV__44 }   /* numericvalue=44 */,
  {    16,  7104,     0,   8,   0, PL_ARMN }   /* armenian */,
  {     2,  3373,     3,  15,   1, PL_EA__F }   /* eastasianwidth=f */,
  {     0,  6221,   150,   4,  33, PL_DIACRITICALSSUP }   /* incombiningdiacriticalmarkssupplement */,
  {     0,  5544,  7941,  13,   2, PL_NV__11 }   /* numericvalue=11 */,
  {     8,   184,   436,   2,   5, PL_NCHAR }   /* isnchar */,
  {     2,   892,  3581,  17,   2, PL_VS }   /* variationselector=t */,
  {     3,  1918,  7997,  21,   4, PL_CWU }   /* changeswhenuppercased=yes */,
  {     4,  7380,  8685,   7,   2, PL_CCC__24 }   /* ccc=ccc24 */,
  {     2,  6713,  7756,   3,   1, PL_IN__9 }   /* in=9 */,
  {     2,  5192,  2986,   3,  17, PL_IDST }   /* isidstrinaryoperator */,
  {     1,   974,  8168,  27,   2, PL_CCC__17 }   /* canonicalcombiningclass=ccc17 */,
  {     0,  8096,  8245,   5,   3, PL_BHKS }   /* scx=bhks */,
  {     0,  8340,  6285,   3,  11, PL_JG__MALAYALAMRA }   /* jg=malayalamra */,
  {     9,  7136,  3560,   6,  17, PL_SUTTONSIGNWRITING }   /* block=suttonsignwriting */,
  {     0,  7380,  5219,   4,   2, PL_CCC__10 }   /* ccc=10 */,
  {     2,  3129,  8320,  17,   4, PL_HLUW }   /* scriptextensions=hluw */,
  {     3,  7344,  7768,   8,   2, -PL_XIDS }   /* xidstart=f */,
  {     0,  8096,  1108,   5,   4, PL_BATK }   /* scx=batak */,
  {     2,   949,  7997,   2,   4, PL_CI }   /* ci=yes */,
  {     0,   415,  3223,  11,   3, -PL_IDEO }   /* ideographic=no */,
  {     0,  6713,  8858,   3,   3, PL_IN__4 }   /* in=v40 */,
  {     0,  7136,  1282,   6,  24, PL_CJKSYMBOLS }   /* block=cjksymbolsandpunctuation */,
  {     2,  7956,     0,   5,   0, PL_ADLM }   /* adlam */,
  {     0,  8076,  3223,   5,   2, -PL_PATWS }   /* patws=n */,
  {     1,   184,  8300,   2,   4, PL_GREK }   /* isgrek */,
  {     6,  8026,  2289,   5,   4, PL_INPC__LEFT }   /* inpc=left */,
  {     7,  2229,  8941,  16,   2, PL_ZS }   /* generalcategory=zs */,
  {     1,  7288,  8432,   7,   3, PL_NKO }   /* script=nko */,
  {     1,   184,  2023,   2,  21, PL_LOE }   /* islogicalorderexception */,
  {     1,  2985,  7997,   4,   2, PL_IDST }   /* idst=y */,
  {     0,  6472,    34,  10,   2, PL_WB__EX }   /* wordbreak=ex */,
  {     3,  2044,     0,  21,   0, PL_MEETEIMAYEKEXT }   /* meeteimayekextensions */,
  {     3,  7136,  1702,   6,  12, PL_DIACRITICALS }   /* block=diacriticals */,
  {     0,  7380,  8703,   7,   2, PL_CCC__34 }   /* ccc=ccc34 */,
  {     2,   184,    43,   3,  25, PL_CJKCOMPATIDEOGRAPHS }   /* iscjkcompatibilityideographs */,
  {     0,  7982,  7154,   4,   6, PL_INDUPLOYAN }   /* induployan */,
  {     4,  6890,  3288,   4,  17, PL_INCAUCASIANALBANIAN }   /* blk=caucasianalbanian */,
  {     2,  5192,     6,   3,   2, PL_IDC }   /* isidc */,
  {     1,  8096,  7061,   4,   9, PL_SAMR }   /* scx=samaritan */,
  {     0,    76,  7762,   2,   6, PL_NT__DI }   /* nt=digit */,
  {     0,  3129,  8232,  17,   4, PL_AVST }   /* scriptextensions=avst */,
  {     1,  7288,  2674,   7,   9, PL_SUND }   /* script=sundanese */,
  {     1,   436,  3223,   5,   2, -PL_NCHAR }   /* nchar=n */,
  {     3,  8572,  8935,   3,   2, PL_WB__XX }   /* wb=xx */,
  {     2,   949,  3223,   2,   2, -PL_CI }   /* ci=n */,
  {     3,  7288,  8220,   7,   4, PL_SC__ARMN }   /* script=armn */,
  {     1,  7834,  6472,   6,   4, PL_POSIXWORD }   /* isperlword */,
  {     0,   892,  7768,  17,   2, -PL_VS }   /* variationselector=f */,
  {     7,  1746,    18,  21,   2, PL_RI }   /* graphemeclusterbreak=ri */,
  {     3,   184,  7402,   3,   6, PL_CJKEXTC }   /* iscjkextc */,
  {     1,  3390,     0,  17,   0, PL_ETHIOPICEXTA }   /* ethiopicextendeda */,
  {     4,  2859,  5969,  18,  12, PL_DT__NONCANON }   /* decompositiontype=noncanonical */,
  {    12,  5657,  3581,  12,   2, PL_BIDIM }   /* bidimirrored=t */,
  {     0,  4923,     0,  12,   0, PL_INMANICHAEAN }   /* inmanichaean */,
  {     6,  8096,  2787,   4,   8, PL_CHER }   /* scx=cherokee */,
  {     1,   184,  4239,   2,  15, PL_PD }   /* isdashpunctuation */,
  {     5,   974,  7750,  24,   1, PL_CCC__8 }   /* canonicalcombiningclass=8 */,
  {     1,   184,  6908,   2,   9, PL_EMOTICONS }   /* isemoticons */,
  {     1,  8016,    18,   4,   2, PL_RI }   /* gcb=ri */,
  {     0,  3129,  3882,  17,   7, PL_MYMR }   /* scriptextensions=myanmar */,
  {    10,  6890,  2877,   4,  13, PL_DEVANAGARIEXT }   /* blk=devanagariext */,
  {     0,  1159,  7951,  25,   5, PL_CWKCF }   /* changeswhennfkccasefolded=true */,
  {     1,  5544,  7756,  13,   2, PL_NV__90 }   /* numericvalue=90 */,
  {     1,    84,  7997,   4,   4, PL_MATH }   /* math=yes */,
  {     0,    24,     0,   1,   0, PL_L }   /* l */,
  {     2,  4449,  7375,  14,   5, PL_NFCQC__M }   /* nfcquickcheck=maybe */,
  {     1,   974,  7702,  24,   2, PL_CCC__20 }   /* canonicalcombiningclass=20 */,
  {     0,  1834,  7951,  21,   5, PL_CWCF }   /* changeswhencasefolded=true */,
  {     0,  3129,  7810,  17,   4, PL_GOTH }   /* scriptextensions=goth */,
  {     1,  8777,  7997,   3,   4, PL_CWL }   /* cwl=yes */,
  {     0,  6696,     0,  10,   0, PL_PHNX }   /* phoenician */,
  {     1,  2598,     0,  19,   0, PL_MERO }   /* meroitichieroglyphs */,
  {    16,    21,  7506,   2,   7, PL_INLINEARA }   /* inlineara */,
  {     6,  7288,  7786,   7,   6, PL_SC__CAKM }   /* script=chakma */,
  {     0,  2369,  3183,  20,  18, PL_VO__TR }   /* verticalorientation=transformedrotated */,
  {     1,  6613,  2327,   3,   3, PL_HATR }   /* ishatr */,
  {     0,  8240,  5413,   3,   3, PL_BC__RLO }   /* bc=rlo */,
  {     1,   974,  8171,  27,   2, PL_CCC__23 }   /* canonicalcombiningclass=ccc23 */,
  {    11,  7136,  7882,   6,   6, PL_INLYDIAN }   /* block=lydian */,
  {     0,  7136,  2541,   6,  19, PL_JAMOEXTA }   /* block=hanguljamoextendeda */,
  {     0,  4314,  8837,  13,   3, PL_JG__TAH }   /* joininggroup=tah */,
  {     0,  8096,  1111,   4,   4, PL_KANA }   /* scx=kana */,
  {     1,  4314,  3834,  13,  16, PL_JG__MANICHAEANTWENTY }   /* joininggroup=manichaeantwenty */,
  {     1,   184,  2967,   2,   8, PL_GEOR }   /* isgeorgian */,
  {     1,  8268,     0,   4,   0, PL_CPRT }   /* cprt */,
  {     2,  4284,  4042,  14,   8, PL_LB__H3 }   /* hangulsyllabletype=lvt */,
  {     0,  8096,  8056,   4,   5, PL_NSHU }   /* scx=nushu */,
  {     1,  5657,  3223,  12,   3, -PL_BIDIM }   /* bidimirrored=no */,
  {     0,  7816,  7951,   6,   5, PL_GRBASE }   /* grbase=true */,
  {     1,  6210,  1283,   3,   9, PL_CJKSYMBOLS }   /* incjksymbols */,
  {     0,  7345,  7768,   7,   2, -PL_IDS }   /* idstart=f */,
  {     4,  2134,  7768,   3,   6, -PL_XPOSIXXDIGIT }   /* hex=false */,
  {     2,  7288,  8106,   7,   5, PL_SC__TALE }   /* script=taile */,
  {     8,  2229,    24,  17,   1, PL_LL }   /* generalcategory=ll */,
  {     0,  7224,  1887,   8,   5, PL_XPOSIXLOWER }   /* isxposixlower */,
  {     5,  4449,     0,  15,   0, PL_COMPEX }   /* nfcquickcheck=n */,
  {     2,  7459,  7248,   3,   4, PL_SC__JAVA }   /* sc=java */,
  {     0,  7226,  6472,   6,   4, PL_XPOSIXWORD }   /* xposixword */,
  {     2,  6210,   571,   3,  29, PL_CJKEXTC }   /* incjkunifiedideographsextensionc */,
  {    12,  1358,  3223,  20,   2, -PL_CE }   /* compositionexclusion=n */,
  {     3,  6472,  7804,  11,   6, PL_WB__NL }   /* wordbreak=newline */,
  {    19,  7459,  7144,   3,   8, PL_SC__BUGI }   /* sc=buginese */,
  {     1,  7478,     0,   7,   0, PL_XPOSIXSPACE }   /* isspace */,
  {     1,  8816,  7750,   3,   4, PL_NV__8000 }   /* nv=8000 */,
  {    27,  7288,  6917,   7,   9, PL_SC__QAAI }   /* script=inherited */,
  {     7,  7380,  8640,   7,   2, PL_CCC__18 }   /* ccc=ccc18 */,
  {     1,  8096,  7660,   4,   7, PL_TIRH }   /* scx=tirhuta */,
  {     0,  8011,   698,   3,   2, PL_MN }   /* gc=mn */,
  {     0,    11,  7997,   2,   4, PL_DI }   /* di=yes */,
  {     4,  7478,  1613,   3,  22, PL_SHORTHANDFORMATCONTROLS }   /* isshorthandformatcontrols */,
  {     8,  7471,  8081,   7,   5, PL_POSIXPRINT }   /* isposixprint */,
  {     0,  5284,  3581,  13,   2, PL_CI }   /* caseignorable=t */,
  {     0,  7136,  4799,   6,  14, PL_HIGHSURROGATES }   /* block=highsurrogates */,
  {     0,  1929,  7997,   5,   2, PL_XPOSIXUPPER }   /* upper=y */,
  {     0,  5645,  2931,  10,  18, PL_BC__FSI }   /* bidiclass=firststrongisolate */,
  {     0,  1981,     0,  21,   0, PL_CYRILLICSUP }   /* cyrillicsupplementary */,
  {     5,  6890,  7336,   4,   8, PL_INUGARITIC }   /* blk=ugaritic */,
  {     6,  5250,  7768,   8,   6, -PL_XPOSIXXDIGIT }   /* hexdigit=false */,
  {     0,  3129,  7128,  17,   8, PL_BASS }   /* scriptextensions=bassavah */,
  {     1,  7380,  8691,   4,   2, PL_CCC__28 }   /* ccc=28 */,
  {     0,   184,  7876,   2,   6, PL_LYCI }   /* islycian */,
  {     4,  2750,     0,  19,   0, PL_TERM }   /* terminalpunctuation */,
  {     0,  2108,  2817,   5,   6, PL_HALFMARKS }   /* inhalfmarks */,
  {     0,  3147,     0,  11,   0, PL_TAIXUANJING }   /* taixuanjing */,
  {     0,  7288,  2002,   7,  21, PL_PRTI }   /* script=inscriptionalparthian */,
  {     7,   184,  4269,   2,  15, PL_DIACRITICALSSUP }   /* isdiacriticalssup */,
  {     1,  7816,  7997,   6,   2, PL_GRBASE }   /* grbase=y */,
  {     0,  4757,     0,  14,   0, PL_GREXT }   /* graphemeextend */,
  {     6,  2134,  3581,   3,   2, PL_XPOSIXXDIGIT }   /* hex=t */,
  {     2,  5031,     0,   3,   0, PL_ANY }   /* any */,
  {     1,  7136,  3738,   6,  16, PL_LATIN1 }   /* block=latin1supplement */,
  {     1,  7380,  2590,   4,   2, PL_CCC__1 }   /* ccc=ov */,
  {     7,   184,    27,   2,   2, PL_LL }   /* isll */,
  {     0,  3566,     0,  11,   0, PL_SGNW }   /* signwriting */,
  {     1,  7288,  7822,   7,   6, PL_HATR }   /* script=hatran */,
  {     6,  1202,  7997,   3,   4, PL_DEP }   /* dep=yes */,
  {     1,  3129,  7876,  17,   4, PL_LYCI }   /* scriptextensions=lyci */,
  {    10,  6890,  6505,   4,  11, PL_YISYLLABLES }   /* blk=yisyllables */,
  {     0,  8096,  2269,   4,  20, PL_PHLI }   /* scx=inscriptionalpahlavi */,
  {     3,  4314,  5741,  13,  12, PL_JG__FINALSEMKATH }   /* joininggroup=finalsemkath */,
  {    53,  7288,  8540,   7,   4, PL_SC__TAML }   /* script=taml */,
  {     1,  6890,  2787,   4,  11, PL_CHEROKEESUP }   /* blk=cherokeesup */,
  {     8,  8780,  7997,   3,   2, PL_CWT }   /* cwt=y */,
  {     1,  7288,  8580,   7,   4, PL_XPEO }   /* script=xpeo */,
  {     5,  7288,  4105,   8,   4, PL_BAMU }   /* script=bamum */,
  {     0,  3754,     0,  16,   0, PL_LINEARBIDEOGRAMS }   /* linearbideograms */,
  {     2,    48,     0,   1,   0, PL_P }   /* p */,
  {     6,  1417,  1679,   9,   2, PL_PC }   /* category=pc */,
  {     0,  6890,  7401,   4,   7, PL_CJKEXTC }   /* blk=cjkextc */,
  {     4,  3390,     0,  11,   0, PL_ETHIOPICEXT }   /* ethiopicext */,
  {     1,  7136,  6696,   6,  10, PL_INPHOENICIAN }   /* block=phoenician */,
  {     0,  8196,  8870,   4,   3, PL_AGE__5_DOT_2 }   /* age=v52 */,
  {     0,  7459,  8580,   3,   4, PL_XPEO }   /* sc=xpeo */,
  {     0,  8504,  8101,   3,   5, PL_SB__ST }   /* sb=sterm */,
  {     3,  5544,  7726,  13,   6, PL_NV__432000 }   /* numericvalue=432000 */,
  {     0,    21,  7858,   2,   6, PL_INKHOJKI }   /* inkhojki */,
  {     0,  1282,     0,  24,   0, PL_CJKSYMBOLS }   /* cjksymbolsandpunctuation */,
  {     0,  3129,  5777,  17,   6, PL_HEBR }   /* scriptextensions=hebrew */,
  {     4,  8795,   893,   3,  27, PL_VSSUP }   /* invariationselectorssupplement */,
  {     0,  7459,  2149,   3,  20, PL_HLUW }   /* sc=anatolianhieroglyphs */,
  {     0,  5544,  1335,  13,   3, PL_NV__NAN }   /* numericvalue=nan */,
  {     1,  8011,   218,   3,   2, PL_PE }   /* gc=pe */,
  {     1,  8096,  8200,   4,   4, PL_AGHB }   /* scx=aghb */,
  {     3,   106,     0,   6,   0, PL_S }   /* symbol */,
  {     0,  8096,  3882,   4,   7, PL_MYMR }   /* scx=myanmar */,
  {     2,   184,  1887,   2,   9, PL_XPOSIXLOWER }   /* islowercase */,
  {    24,  8816,  7732,   3,   6, PL_NV__500000 }   /* nv=500000 */,
  {     2,  3129,  6406,  17,  11, PL_SORA }   /* scriptextensions=sorasompeng */,
  {    13,  8588,     0,   4,   0, PL_YI }   /* yiii */,
  {     5,  8011,     0,   4,   0, PL_S }   /* gc=s */,
  {     0,  2221,  4046,   3,  12, PL_LB__H3 }   /* hst=lvtsyllable */,
  {     9,  7136,  2895,   6,  11, PL_ETHIOPICSUP }   /* block=ethiopicsup */,
  {     3,  7459,  2107,   3,   7, PL_SC__SINH }   /* sc=sinhala */,
  {     1,  8894,   472,   3,   2, PL_VO__TU }   /* vo=tu */,
  {    49,    21,  8209,   3,   3, PL_INAHOM }   /* inahom */,
  {     1,  7136,  1585,   6,   4, PL_JAMO }   /* block=jamo */,
  {     1,  3129,  8536,  17,   4, PL_TALU }   /* scriptextensions=talu */,
  {     8,  3129,   690,  17,   9, PL_XSUX }   /* scriptextensions=cuneiform */,
  {     0,  7380,  8636,   7,   3, PL_CCC__107 }   /* ccc=ccc107 */,
  {     9,  8096,  7152,   4,   8, PL_DUPL }   /* scx=duployan */,
  {     3,  4314,  5861,  13,  12, PL_JG__MALAYALAMNGA }   /* joininggroup=malayalamnga */,
  {     0,  7136,  3611,   7,  10, PL_BOPOMOFOEXT }   /* block=bopomofoext */,
  {     5,  7459,  7653,   3,   7, PL_TIBT }   /* sc=tibetan */,
  {     0,  6616,  3223,  10,   2, -PL_DEP }   /* deprecated=n */,
  {     5,  4104,     0,   8,   0, PL_BAMUMSUP }   /* bamumsup */,
  {     4,  7459,  2787,   3,   8, PL_CHER }   /* sc=cherokee */,
  {     0,  8795,  4615,   3,  14, PL_VEDICEXT }   /* invedicextensions */,
  {     0,  4479,  7375,  15,   5, PL_NFCQC__M }   /* nfkcquickcheck=maybe */,
  {     1,  7136,  3882,   6,  16, PL_MYANMAREXTA }   /* block=myanmarextendeda */,
  {     0,  7136,   148,   6,  35, PL_DIACRITICALSSUP }   /* block=combiningdiacriticalmarkssupplement */,
  {     0,  3129,  7312,  17,   4, PL_TAGB }   /* scriptextensions=tagb */,
  {     0,  8026,   469,   3,  10, PL_INPUNCTUATION }   /* inpunctuation */,
  {     0,  6210,  4225,   3,  14, PL_CURRENCYSYMBOLS }   /* incurrencysymbols */,
  {     1,  1426,  2446,  22,  19, PL_INSC__CONSONANTHEADLETTER }   /* indicsyllabiccategory=consonantheadletter */,
  {     0,   479,     0,  31,   0, PL_MATHALPHANUM }   /* mathematicalalphanumericsymbols */,
  {     0,    21,  6935,   2,   9, PL_LATINEXTB }   /* inlatinextb */,
  {     2,  6472,  4653,  10,   2, PL_WB__SQ }   /* wordbreak=sq */,
  {     2,  6890,   779,   4,  29, PL_MISCARROWS }   /* blk=miscellaneoussymbolsandarrows */,
  {     1,  1417,  3690,   9,  16, PL_PF }   /* category=finalpunctuation */,
  {     5,  7288,  8380,   7,   4, PL_SC__LINA }   /* script=lina */,
  {     0,  6890,  8408,   4,   3, PL_INMRO }   /* blk=mro */,
  {     0,  7288,  2787,   7,   4, PL_CHER }   /* script=cher */,
  {     5,  8816,  8165,   3,   3, PL_NV__5_SLASH_2 }   /* nv=5/2 */,
  {     8,  7136,  8556,   6,   4, PL_INTHAI }   /* block=thai */,
  {     8,  8816,  7710,   3,   2, PL_NV__60 }   /* nv=60 */,
  {     0,   217,    25,  29,   1, PL__PERL_PROBLEMATIC_LOCALE_FOLDS }   /* _perl_problematic_locale_folds */,
  {    14,   184,  1202,   2,   3, PL_DEP }   /* isdep */,
  {     2,  8096,  1566,   4,   6, PL_HANG }   /* scx=hangul */,
  {     0,    96,  3223,  10,   2, -PL_XPOSIXALPHA }   /* alphabetic=n */,
  {     0,  7478,    44,   3,   1, PL_SK }   /* issk */,
  {     0,  3129,  7604,  17,   7, PL_SIDD }   /* scriptextensions=siddham */,
  {     0,  5544,  7727,  13,   2, PL_NV__32 }   /* numericvalue=32 */,
  {     4,  8288,  3690,   3,   5, PL_DT__FIN }   /* dt=final */,
  {     0,  7459,  8524,   3,   4, PL_SC__SHRD }   /* sc=shrd */,
  {     0,    18,     0,   2,   0, PL_RI }   /* ri */,
  {     4,  2369,  3201,  20,  18, PL_VO__TU }   /* verticalorientation=transformedupright */,
  {     0,  7459,  2249,   3,  10, PL_SC__GLAG }   /* sc=glagolitic */,
  {     2,  6890,  7506,   4,   7, PL_INLINEARA }   /* blk=lineara */,
  {     1,  5777,     0,   6,   0, PL_HEBR }   /* hebrew */,
  {     0,  6806,     0,  10,   0, PL_WARA }   /* warangciti */,
  {     0,  7136,  7007,   6,   9, PL_INOLDITALIC }   /* block=olditalic */,
  {     2,  4314,  5505,  13,  13, PL_JG__MANICHAEANTEN }   /* joininggroup=manichaeanten */,
  {    10,  4923,   481,   4,  29, PL_MATHALPHANUM }   /* inmathematicalalphanumericsymbols */,
  {     0,  3021,     0,  18,   0, PL_LATINEXTADDITIONAL }   /* latinextadditional */,
  {     0,  6890,  5121,   4,  14, PL_INPSALTERPAHLAVI }   /* blk=psalterpahlavi */,
  {     4,  2229,    25,  16,   1, PL_S }   /* generalcategory=s */,
  {     0,  2859,  3690,  18,   5, PL_DT__FIN }   /* decompositiontype=final */,
  {     6,   184,  8304,   2,   4, PL_GUJR }   /* isgujr */,
  {     3,  7288,  8608,   7,   4, PL_ZZZZ }   /* script=zzzz */,
  {     9,  8786,     9,   3,   2, PL_EA__NA }   /* ea=na */,
  {     1,  8572,  5777,   3,  12, PL_LB__HL }   /* wb=hebrewletter */,
  {     0,  6076,  3223,  11,   2, -PL_BIDIC }   /* bidicontrol=n */,
  {     2,  6472,  5435,  10,   2, PL_WB__ML }   /* wordbreak=ml */,
  {     2,  6890,  1306,   4,  24, PL_DIACRITICALSFORSYMBOLS }   /* blk=combiningmarksforsymbols */,
  {     0,  2636,     0,  19,   0, PL_MONGOLIANSUP }   /* mongoliansupplement */,
  {     8,  7136,  5121,   6,  14, PL_INPSALTERPAHLAVI }   /* block=psalterpahlavi */,
  {    16,  5645,  7768,   5,   2, -PL_BIDIC }   /* bidic=f */,
  {     0,   122,  7951,   9,   5, PL_DIA }   /* diacritic=true */,
  {     9,  7227,  1929,   5,   5, PL_POSIXUPPER }   /* posixupper */,
  {     0,  8016,    73,   4,   2, PL_LB__EM }   /* gcb=em */,
  {     5,   184,  5801,   2,  12, PL_KHMERSYMBOLS }   /* iskhmersymbols */,
  {     0,  7459,  8071,   3,   5, PL_OSGE }   /* sc=osage */,
  {     6,  7380,  6556,   4,  10, PL_CCC__BR }   /* ccc=belowright */,
  {     0,  7380,  7924,   4,   6, PL_CCC__9 }   /* ccc=virama */,
  {     5,  6263,  1496,  10,   2, PL_LB__CB }   /* linebreak=cb */,
  {     1,   184,  1001,   2,  11, PL_ENCLOSEDCJK }   /* isenclosedcjk */,
  {     4,  2229,  1627,  16,   7, PL_XPOSIXCNTRL }   /* generalcategory=control */,
  {     1,  4198,  2969,   4,   6, PL_INGEORGIAN }   /* ingeorgian */,
  {     2,  7136,  2598,   6,  19, PL_MERO }   /* block=meroitichieroglyphs */,
  {     6,  3129,  4494,  17,  15, PL_NARB }   /* scriptextensions=oldnortharabian */,
  {     0,     0,     0,  42,   0, PL_UCASEXT }   /* unifiedcanadianaboriginalsyllabicsextended */,
  {    10,  2229,  6351,  16,  11, PL_NO }   /* generalcategory=othernumber */,
  {     5,  8011,    32,   3,   2, PL_CS }   /* gc=cs */,
  {     7,  7288,  8111,   7,   4, PL_SC__TAKR }   /* script=takr */,
  {     1,  6706,  8879,  10,   3, PL_IN__6_DOT_2 }   /* presentin=v62 */,
  {     4,  8272,     0,   4,   0, PL_CWCF }   /* cwcf */,
  {     1,  8408,     0,   3,   0, PL_MRO }   /* mro */,
  {     1,  7288,  8536,   7,   4, PL_TALU }   /* script=talu */,
  {     0,  8026,  7044,   3,   8, PL_INPAUCINHAU }   /* inpaucinhau */,
  {     2,   184,  2598,   2,  19, PL_MERO }   /* ismeroitichieroglyphs */,
  {     0,  7288,  6806,   7,  10, PL_WARA }   /* script=warangciti */,
  {     0,  1887,  3223,   9,   3, -PL_XPOSIXLOWER }   /* lowercase=no */,
  {     0,  8196,     9,   4,   2, PL_AGE__NA }   /* age=na */,
  {     2,  6890,  8091,   4,   5, PL_INRUNIC }   /* blk=runic */,
  {     8,  2985,  3581,  18,   2, PL_IDST }   /* idstrinaryoperator=t */,
  {     3,  6890,  7443,   4,   7, PL_INGRANTHA }   /* blk=grantha */,
  {     1,  7136,  7674,   6,   7, PL_UCASEXT }   /* block=ucasext */,
  {    22,  2229,  5814,  17,  11, PL_NL }   /* generalcategory=letternumber */,
  {     4,  1897,     0,  21,   0, PL_CWT }   /* changeswhentitlecased */,
  {     1,  1206,  4011,   3,   5, PL_INTANGUT }   /* intangut */,
  {     3,  6890,  6776,   4,  10, PL_SUPARROWSB }   /* blk=suparrowsb */,
  {     0,  7136,  2674,   6,  19, PL_SUNDANESESUP }   /* block=sundanesesupplement */,
  {     2,  8016,  5772,   4,   5, PL_WB__EB }   /* gcb=ebase */,
  {     8,  6890,  2674,   4,  12, PL_SUNDANESESUP }   /* blk=sundanesesup */,
  {     4,  8780,  7951,   3,   5, PL_CWT }   /* cwt=true */,
  {     0,  6890,  1589,   4,  14, PL_LATINEXTA }   /* blk=latinextendeda */,
  {     4,  8026,   809,   3,  17, PL_PHONETICEXT }   /* inphoneticextensions */,
  {     1,  1589,     0,  23,   0, PL_LATINEXTADDITIONAL }   /* latinextendedadditional */,
  {     1,  6706,  8846,  10,   3, PL_IN__2_DOT_1 }   /* presentin=v21 */,
  {     2,  7653,     0,   7,   0, PL_TIBT }   /* tibetan */,
  {     7,  7288,  6008,   7,   4, PL_HUNG }   /* script=hung */,
  {     4,  4284,  4026,  14,   6, PL_GCB__L }   /* hangulsyllabletype=l */,
  {     0,  8096,  5121,   4,  14, PL_PHLP }   /* scx=psalterpahlavi */,
  {     5,  6613,  7829,   3,   5, PL_HYPHEN }   /* ishyphen */,
  {     8,  6613,  4832,   3,   3, PL_HIRA }   /* ishira */,
  {     0,  6798,     0,   8,   0, PL_ASSIGNED }   /* assigned */,
  {     4,  2229,  1027,  16,   2, PL_SO }   /* generalcategory=so */,
  {     2,  3129,  3610,  17,   4, PL_BOPO }   /* scriptextensions=bopo */,
  {     1,   184,  3882,   2,  16, PL_MYANMAREXTA }   /* ismyanmarextendeda */,
  {     0,  7798,  7997,   6,   4, PL_COMPEX }   /* compex=yes */,
  {     5,  7288,  7639,   7,   7, PL_LANA }   /* script=taitham */,
  {     8,  7136,  2044,   6,  11, PL_INMEETEIMAYEK }   /* block=meeteimayek */,
  {     0,  3129,  8316,  17,   4, PL_HANO }   /* scriptextensions=hano */,
  {     0,  6263,  6666,  10,  10, PL_LB__NS }   /* linebreak=nonstarter */,
  {     0,  8400,     0,   4,   0, PL_MIAO }   /* miao */,
  {     0,  4314,  5009,  13,  14, PL_JG__MANICHAEANTETH }   /* joininggroup=manichaeanteth */,
  {     1,  1897,  3223,  21,   2, -PL_CWT }   /* changeswhentitlecased=n */,
  {    17,  5544,  5219,  13,  13, PL_NV__1000000000000 }   /* numericvalue=1000000000000 */,
  {    41,  4314,  6726,  13,  10, PL_JG__REVERSEDPE }   /* joininggroup=reversedpe */,
  {     4,  4314,  6064,  13,   3, PL_JG__GAF }   /* joininggroup=gaf */,
  {     0,  1887,  3581,   5,   2, PL_XPOSIXLOWER }   /* lower=t */,
  {     1,  2895,     0,   4,   0, PL_ETHI }   /* ethi */,
  {     0,  3129,  2360,  17,   4, PL_MAND }   /* scriptextensions=mand */,
  {    23,  2990,   804,   4,   4, PL_ARROWS }   /* inarrows */,
  {     1,  6041,     0,  12,   0, PL_PLAYINGCARDS }   /* playingcards */,
  {     0,  7136,  1686,   6,  16, PL_INDICNUMBERFORMS }   /* block=indicnumberforms */,
  {     1,  3129,     7,  17,  18, PL_CANS }   /* scriptextensions=canadianaboriginal */,
  {     0,  7136,  2465,   6,  11, PL_COUNTINGROD }   /* block=countingrod */,
  {     1,  6616,  3223,  10,   3, -PL_DEP }   /* deprecated=no */,
  {     0,  2985,  7768,  18,   2, -PL_IDST }   /* idstrinaryoperator=f */,
  {     0,   184,  3675,   3,  15, PL_CYPRIOTSYLLABARY }   /* iscypriotsyllabary */,
  {     1,  7689,  5610,   3,  11, PL_ALPHABETICPF }   /* isalphabeticpf */,
  {     3,  4771,     0,  14,   0, PL_INGREEK }   /* greekandcoptic */,
  {     8,   513,  3223,  16,   2, -PL_UIDEO }   /* unifiedideograph=n */,
  {     4,    21,  7492,   2,   7, PL_INKANNADA }   /* inkannada */,
  {     8,   184,  2949,   2,  18, PL_INPUNCTUATION }   /* isgeneralpunctuation */,
  {     0,  3770,     0,  16,   0, PL_LINEARBSYLLABARY }   /* linearbsyllabary */,
  {     5,  2369,  3521,   4,   5, PL_VERTSPACE }   /* vertspace */,
  {     1,   184,  3323,   3,  16, PL_CYRILLICEXTA }   /* iscyrillicextendeda */,
  {     1,  1354,  7951,  24,   5, PL_COMPEX }   /* fullcompositionexclusion=true */,
  {     0,  1543,     0,  18,   0, PL_GEOMETRICSHAPESEXT }   /* geometricshapesext */,
  {     0,  8096,  7882,   4,   6, PL_LYDI }   /* scx=lydian */,
  {    23,  6890,   540,   4,  30, PL_CJKEXTB }   /* blk=cjkunifiedideographsextensionb */,
  {     1,  8816,  7944,   3,   2, PL_NV__12 }   /* nv=12 */,
  {     0,  7136,  2636,   6,  12, PL_MONGOLIANSUP }   /* block=mongoliansup */,
  {     2,  2229,   106,  16,   6, PL_S }   /* generalcategory=symbol */,
  {     5,  8011,  1621,   3,   6, PL_CF }   /* gc=format */,
  {     4,  7136,  2249,   6,  10, PL_INGLAGOLITIC }   /* block=glagolitic */,
  {     1,  1417,   849,   9,  10, PL_CO }   /* category=privateuse */,
  {     1,  6890,  3339,   4,  17, PL_CYRILLICEXTB }   /* blk=cyrillicextendedb */,
  {     1,  7459,  7128,   3,   8, PL_BASS }   /* sc=bassavah */,
  {     3,  7288,  7043,   7,   9, PL_PAUC }   /* script=paucinhau */,
  {     6,   184,  5717,   2,  12, PL_ETHIOPICEXTA }   /* isethiopicexta */,
  {     0,   660,     0,  30,   0, PL_CJKEXTF }   /* cjkunifiedideographsextensionf */,
  {    13,  5544,  7710,  13,   2, PL_NV__60 }   /* numericvalue=60 */,
  {     3,  8240,  2289,   3,  11, PL_BC__L }   /* bc=lefttoright */,
  {     2,  1746,    34,  21,   2, PL_GREXT }   /* graphemeclusterbreak=ex */,
  {     0,  3509,  3581,  17,   2, PL_PATWS }   /* patternwhitespace=t */,
  {     2,  3946,  7768,  16,   6, -PL_STERM }   /* sentenceterminal=false */,
  {     0,  3129,  5933,  17,  12, PL_GONM }   /* scriptextensions=masaramgondi */,
  {    40,  7288,  4105,   8,   3, PL_BAMU }   /* script=bamu */,
  {     0,  8026,  2295,   5,   5, PL_INPC__RIGHT }   /* inpc=right */,
  {     0,  7478,   107,   3,   5, PL_S }   /* issymbol */,
  {     1,  7136,  6318,   6,  11, PL_MYANMAREXTB }   /* block=myanmarextb */,
  {     1,  4402,  5959,   4,  10, PL_INMENDEKIKAKUI }   /* inmendekikakui */,
  {     1,  7136,  8432,   6,   3, PL_INNKO }   /* block=nko */,
  {     0,  8096,  8540,   4,   4, PL_TAML }   /* scx=taml */,
  {     8,  3946,  7768,  16,   2, -PL_STERM }   /* sentenceterminal=f */,
  {     0,  6210,  3273,   4,  15, PL_UCAS }   /* incanadiansyllabics */,
  {     0,  3129,  6806,  17,  10, PL_WARA }   /* scriptextensions=warangciti */,
  {     1,  7288,  1797,   7,   4, PL_SC__MODI }   /* script=modi */,
  {     2,   184,  3390,   2,  11, PL_ETHIOPICEXT }   /* isethiopicext */,
  {     1,  1417,  5082,   9,  11, PL_MC }   /* category=spacingmark */,
  {     3,  7459,  8460,   3,   4, PL_SC__PHLP }   /* sc=phlp */,
  {     6,  5134,  5094,   3,  13, PL_PHONETICEXTSUP }   /* isphoneticextsup */,
  {     0,  7380,  8654,   7,   3, PL_CCC__133 }   /* ccc=ccc133 */,
  {     1,   184,  7513,   2,   7, PL_MAND }   /* ismandaic */,
  {     0,  7457,  8051,   5,   5, PL_INSC__NUKTA }   /* insc=nukta */,
  {     3,  3129,  3458,  17,  10, PL_MANI }   /* scriptextensions=manichaean */,
  {     0,  7485,    17,   5,   1, PL_XPEO }   /* isxpeo */,
  {     1,  6890,  3898,   4,  16, PL_MYANMAREXTB }   /* blk=myanmarextendedb */,
  {     0,  6890,  3111,   4,   4, PL_RUMI }   /* blk=rumi */,
  {     2,  6890,  7513,   4,   7, PL_INMANDAIC }   /* blk=mandaic */,
  {     2,  4314,  5466,  13,  13, PL_JG__MANICHAEANNUN }   /* joininggroup=manichaeannun */,
  {     1,  4542,  7914,   4,   4, PL_TELU }   /* istelugu */,
  {     5,  8340,  5746,   3,   7, PL_JG__SEMKATH }   /* jg=semkath */,
  {     0,  3526,  3223,  17,   3, -PL_RI }   /* regionalindicator=no */,
  {     0,  8508,  7507,   4,   6, PL_SC__LINA }   /* sc=lineara */,
  {     0,  2100,   295,   3,   3, PL_OSMA }   /* isosma */,
  {     0,  6890,  3271,   4,  17, PL_UCAS }   /* blk=canadiansyllabics */,
  {     0,  6210,  7416,   3,   6, PL_CJKEXTE }   /* incjkexte */,
  {     2,  6890,   113,   4,  35, PL_DIACRITICALSFORSYMBOLS }   /* blk=combiningdiacriticalmarksforsymbols */,
  {     2,   974,  8901,  24,   2, PL_CCC__36 }   /* canonicalcombiningclass=36 */,
  {     0,  1929,  7768,   5,   6, -PL_XPOSIXUPPER }   /* upper=false */,
  {     1,  6890,  4614,   4,  15, PL_VEDICEXT }   /* blk=vedicextensions */,
  {     0,   974,  8224,  24,   4, PL_CCC__216 }   /* canonicalcombiningclass=atar */,
  {     0,  4314,  4792,  13,   3, PL_JG__HEH }   /* joininggroup=heh */,
  {     2,  7288,  8360,   7,   4, PL_SC__KTHI }   /* script=kthi */,
  {     1,  7136,  6005,   6,  12, PL_INOLDHUNGARIAN }   /* block=oldhungarian */,
  {     0,  8096,  8312,   4,   4, PL_HAN }   /* scx=hani */,
  {     3,  5557,  7768,  13,   2, -PL_PATSYN }   /* patternsyntax=f */,
  {     5,  7459,  8472,   3,   4, PL_PRTI }   /* sc=prti */,
  {     1,  8096,  7918,   4,   4, PL_THAA }   /* scx=thaa */,
  {     8,  4554,  7562,  14,   7, PL_SB__LE }   /* sentencebreak=oletter */,
  {     4,  8006,  7997,   5,   4, PL_CWKCF }   /* cwkcf=yes */,
  {    10,  6263,   202,  10,   2, PL_LB__SA }   /* linebreak=sa */,
  {     0,   184,  1589,   2,  14, PL_LATINEXTA }   /* islatinextendeda */,
  {     0,   184,  8086,   2,   5, PL_QMARK }   /* isqmark */,
  {     3,  1887,  7997,   9,   4, PL_XPOSIXLOWER }   /* lowercase=yes */,
  {    11,  8340,  5427,   3,  13, PL_JG__MALAYALAMLLLA }   /* jg=malayalamllla */,
  {     2,  3946,  3581,  16,   2, PL_STERM }   /* sentenceterminal=t */,
  {     1,  7876,     0,   6,   0, PL_LYCI }   /* lycian */,
  {     4,  8196,  8852,   4,   3, PL_AGE__3_DOT_1 }   /* age=v31 */,
  {     0,   184,  1160,   3,  24, PL_CWKCF }   /* ischangeswhennfkccasefolded */,
  {    10,  4644,     0,  15,   0, PL_ZANB }   /* zanabazarsquare */,
  {     4,  2100,  8449,   3,   3, PL_ORKH }   /* isorkh */,
  {     6,  8368,     0,   4,   0, PL_LAO }   /* laoo */,
  {    10,    21,  2128,   2,  21, PL_YIJING }   /* inyijinghexagramsymbols */,
  {     3,  1963,     0,   7,   0, PL_RADICAL }   /* radical */,
  {     4,  6613,  4800,   3,  13, PL_HIGHSURROGATES }   /* ishighsurrogates */,
  {     0,  7288,  7367,   8,   6, PL_SC__BENG }   /* script=bengali */,
  {    11,  8340,  2427,   3,  19, PL_JG__BURUSHASKIYEHBARREE }   /* jg=burushaskiyehbarree */,
  {     0,  5645,  3075,  10,  18, PL_BC__B }   /* bidiclass=paragraphseparator */,
  {     2,  8504,  8935,   3,   2, PL_SB__XX }   /* sb=xx */,
  {     1,  8376,  3642,   3,  16, PL_LB__CP }   /* lb=closeparenthesis */,
  {     1,  7459,  8476,   3,   4, PL_SC__COPT }   /* sc=qaac */,
  {     7,  5645,  2329,  10,  11, PL_BC__R }   /* bidiclass=righttoleft */,
  {     8,  8011,  1189,   3,   2, PL_LT }   /* gc=lt */,
  {     3,  7136,  1107,   6,  26, PL_KATAKANAEXT }   /* block=katakanaphoneticextensions */,
  {     5,  1701,  7951,   2,   5, PL_SD }   /* sd=true */,
  {     6,  1474,     1,  22,   1, PL_BPT__N }   /* bidipairedbrackettype=n */,
  {     4,  6935,     0,   9,   0, PL_LATINEXTB }   /* latinextb */,
  {     1,  6890,  1450,   4,  24, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* blk=supsymbolsandpictographs */,
  {     0,  8006,     0,   5,   0, PL_CWKCF }   /* cwkcf */,
  {     1,  4542,  2753,   5,  16, PL_TERM }   /* isterminalpunctuation */,
  {     8,  7136,  5336,   6,  13, PL_GREEKEXT }   /* block=greekextended */,
  {     2,  6890,   316,   4,  33, PL_MISCMATHSYMBOLSB }   /* blk=miscellaneousmathematicalsymbolsb */,
  {     0,  7380,  8639,   4,   3, PL_CCC__118 }   /* ccc=118 */,
  {     0,  7520,     0,   4,   0, PL_MARC }   /* marc */,
  {     0,  4104,     0,   5,   0, PL_BAMU }   /* bamum */,
  {     8,  8572,  5762,   3,   3, PL_LB__ZWJ }   /* wb=zwj */,
  {     0,   415,  3223,  11,   2, -PL_IDEO }   /* ideographic=n */,
  {     2,  4449,  7996,   4,   5, PL_NFCQC__Y }   /* nfcqc=yes */,
  {     2,   436,  7951,   5,   5, PL_NCHAR }   /* nchar=true */,
  {     0,  4402,   960,   3,   4, PL_MUSIC }   /* inmusic */,
  {     1,  8196,  8711,   4,   3, PL_AGE__3_DOT_1 }   /* age=3.1 */,
  {     2,  7288,  8280,   7,   4, PL_SC__CYRL }   /* script=cyrl */,
  {     0,  6890,  4614,   4,   8, PL_VEDICEXT }   /* blk=vedicext */,
  {     0,  2750,  3581,  19,   2, PL_TERM }   /* terminalpunctuation=t */,
  {     0,  3129,  7912,  17,   4, PL_TELU }   /* scriptextensions=telu */,
  {     8,  5544,  7714,  13,   2, PL_NV__30 }   /* numericvalue=30 */,
  {     0,  7136,  1635,   6,  23, PL_SUPPUNCTUATION }   /* block=supplementalpunctuation */,
  {     1,  5657,  7951,   5,   5, PL_BIDIM }   /* bidim=true */,
  {     2,  7639,     0,   7,   0, PL_LANA }   /* taitham */,
  {     1,  3516,  3581,  10,   2, PL_XPOSIXSPACE }   /* whitespace=t */,
  {     0,  7459,  8552,   3,   4, PL_SC__TGLG }   /* sc=tglg */,
  {     3,  8340,  5023,   3,  14, PL_JG__MANICHAEANYODH }   /* jg=manichaeanyodh */,
  {     2,  3129,  7918,  17,   6, PL_THAA }   /* scriptextensions=thaana */,
  {     1,   974,  3262,  24,   5, PL_CCC__B }   /* canonicalcombiningclass=below */,
  {     0,  1417,  6796,   9,  10, PL_CN }   /* category=unassigned */,
  {     2,  7136,  1589,   6,  14, PL_LATINEXTA }   /* block=latinextendeda */,
  {     0,  2023,  7768,  21,   6, -PL_LOE }   /* logicalorderexception=false */,
  {     0,  4402,  1798,   3,   3, PL_INMODI }   /* inmodi */,
  {     1,  5544,  5220,  13,   1, PL_NV__0 }   /* numericvalue=0 */,
  {     0,  7380,  2777,   4,   5, PL_CCC__A }   /* ccc=above */,
  {     0,  2236,    17,  10,   1, PL_LO }   /* category=lo */,
  {     0,  8816,  7750,   3,   6, PL_NV__800000 }   /* nv=800000 */,
  {     2,  5252,     0,   6,   0, PL_XPOSIXXDIGIT }   /* xdigit */,
  {     0,  7828,  3223,   6,   2, -PL_HYPHEN }   /* hyphen=n */,
  {     1,  8508,  8047,   4,   4, PL_SC__LIMB }   /* sc=limbu */,
  {     0,  8096,  8364,   4,   4, PL_LANA }   /* scx=lana */,
  {     0,  7136,  2674,   6,   9, PL_INSUNDANESE }   /* block=sundanese */,
  {     8,  6506,  8589,   3,   3, PL_YI }   /* isyiii */,
  {     0,  4314,  7448,  13,   3, PL_JG__HAH }   /* joininggroup=hah */,
  {    11,  6706,  8732,  10,   3, PL_IN__5 }   /* presentin=5.0 */,
  {     1,  6472,  4466,  10,   2, PL_WB__DQ }   /* wordbreak=dq */,
  {     1,  7136,  3994,   6,   6, PL_INSYRIAC }   /* block=syriac */,
  {     4,  8816,  7720,   3,   2, PL_NV__40 }   /* nv=40 */,
  {     1,  3129,  8304,  17,   4, PL_GUJR }   /* scriptextensions=gujr */,
  {     4,  4314,   727,  13,   3, PL_JG__DAL }   /* joininggroup=dal */,
  {     1,    34,  7768,   3,   6, -PL_EXT }   /* ext=false */,
  {     4,  6890,  4813,   4,   7, PL_KANASUP }   /* blk=kanasup */,
  {     1,  8011,  1690,   3,   2, PL_CN }   /* gc=cn */,
  {     6,  7459,  7681,   3,   7, PL_ZZZZ }   /* sc=unknown */,
  {     0,  1417,   106,   9,   6, PL_S }   /* category=symbol */,
  {     1,  6613,  7451,   3,   6, PL_HANO }   /* ishanunoo */,
  {    10,  1354,  7768,  24,   2, -PL_COMPEX }   /* fullcompositionexclusion=f */,
  {     0,  6890,  7646,   4,   7, PL_INTAIVIET }   /* blk=taiviet */,
  {     1,  8011,  8001,   3,   5, PL_XPOSIXCNTRL }   /* gc=cntrl */,
  {    10,  4923,  5827,   4,   5, PL_MAHJONG }   /* inmahjong */,
  {     0,  5544,  8624,  13,   3, PL_NV__1_SLASH_7 }   /* numericvalue=1/7 */,
  {     2,  5544,  8913,  13,   2, PL_NV__47 }   /* numericvalue=47 */,
  {     4,   184,  4404,   2,  15, PL_MERC }   /* ismeroiticcursive */,
  {     3,  7906,  2018,   4,   3, PL_SC__KTHI }   /* sc=kthi */,
  {    11,  3057,     0,  18,   0, PL_ORNAMENTALDINGBATS }   /* ornamentaldingbats */,
  {     0,  7288,  8436,   7,   4, PL_NSHU }   /* script=nshu */,
  {    18,  3129,  6980,  17,   9, PL_NBAT }   /* scriptextensions=nabataean */,
  {     0,  7380,  8187,   7,   2, PL_CCC__27 }   /* ccc=ccc27 */,
  {    11,  6706,  8747,  10,   3, PL_IN__6 }   /* presentin=6.0 */,
  {     0,  8240,  3039,   3,  18, PL_BC__LRI }   /* bc=lefttorightisolate */,
  {     0,  7380,  8160,   4,   2, PL_CCC__13 }   /* ccc=13 */,
  {     1,  4314,  8042,  14,   4, PL_JG__KHAPH }   /* joininggroup=khaph */,
  {     9,  4923,  7516,   5,   4, PL_INMANDAIC }   /* inmandaic */,
  {     3,  6713,  8861,   3,   3, PL_IN__4_DOT_1 }   /* in=v41 */,
  {     0,  5657,  7997,  12,   2, PL_BIDIM }   /* bidimirrored=y */,
  {     0,  6472,  1083,  10,   2, PL_LB__LF }   /* wordbreak=lf */,
  {    17,  3129,  2674,  17,   9, PL_SUND }   /* scriptextensions=sundanese */,
  {     0,   974,  7709,  27,   2, PL_CCC__16 }   /* canonicalcombiningclass=ccc16 */,
  {     0,  7380,  4538,   4,   2, PL_CCC__0 }   /* ccc=nr */,
  {     1,  3722,     0,  16,   0, PL_HIGHPUSURROGATES }   /* highpusurrogates */,
  {     0,  8096,  7597,   4,   7, PL_SHAW }   /* scx=shavian */,
  {     1,  8240,  2329,   3,  11, PL_BC__R }   /* bc=righttoleft */,
  {     1,   184,  2466,   3,  10, PL_COUNTINGROD }   /* iscountingrod */,
  {     4,   184,  5825,   2,  12, PL_MAHJONG }   /* ismahjongtiles */,
  {     2,  4314,  5502,  13,   3, PL_JG__TAW }   /* joininggroup=taw */,
  {     0,  8320,     0,   4,   0, PL_HLUW }   /* hluw */,
  {     0,  7136,  8428,   6,   4, PL_INNEWA }   /* block=newa */,
  {     1,  1855,  7997,  21,   2, PL_CWCM }   /* changeswhencasemapped=y */,
  {     0,  3129,  7359,  17,   7, PL_AVST }   /* scriptextensions=avestan */,
  {     0,  8096,  5777,   4,   4, PL_HEBR }   /* scx=hebr */,
  {     1,  4314,  5528,  13,   3, PL_JG__WAW }   /* joininggroup=waw */,
  {     0,  8340,  6533,   3,   3, PL_JG__QAF }   /* jg=qaf */,
  {     0,  7459,  8468,   3,   4, PL_MIAO }   /* sc=plrd */,
  {     3,  7646,     0,   7,   0, PL_TAVT }   /* taiviet */,
  {     4,  7457,  5297,   5,  13, PL_INSC__CONSONANTDEAD }   /* insc=consonantdead */,
  {     0,  8340,  4995,   3,  14, PL_JG__MANICHAEANRESH }   /* jg=manichaeanresh */,
  {     0,  6208,  7768,   5,   6, -PL_JOINC }   /* joinc=false */,
  {     0,  6472,   497,  11,   6, PL_WB__NU }   /* wordbreak=numeric */,
  {    25,  8011,  4569,   3,  15, PL_LT }   /* gc=titlecaseletter */,
  {     2,  8404,     0,   4,   0, PL_MLYM }   /* mlym */,
  {     1,  8376,   722,   3,   2, PL_LB__CL }   /* lb=cl */,
  {     0,  6554,  6882,   3,   8, PL_INBHAIKSUKI }   /* inbhaiksuki */,
  {     0,  1621,     0,   6,   0, PL_CF }   /* format */,
  {     1,  6890,  1702,   4,  22, PL_DIACRITICALSFORSYMBOLS }   /* blk=diacriticalsforsymbols */,
  {     0,   184,  7395,   3,   6, PL_CJKEXTB }   /* iscjkextb */,
  {     0,  8504,  3914,   3,   5, PL_SB__XX }   /* sb=other */,
  {     1,  3129,  5957,  17,  12, PL_MEND }   /* scriptextensions=mendekikakui */,
  {     5,  3424,     0,   4,   0, PL_IDSB }   /* idsb */,
  {     1,  7459,  8061,   3,   5, PL_OGAM }   /* sc=ogham */,
  {     8,  8011,  4239,   3,  15, PL_PD }   /* gc=dashpunctuation */,
  {     8,  7459,  6406,   3,   4, PL_SORA }   /* sc=sora */,
  {    11,  8532,     0,   4,   0, PL_TAGS }   /* tags */,
  {     0,   184,  2636,   2,   9, PL_MONG }   /* ismongolian */,
  {     1,  3129,  8192,  17,   4, PL_ADLM }   /* scriptextensions=adlm */,
  {     0,  7696,  3223,   6,   2, -PL_XPOSIXSPACE }   /* wspace=n */,
  {     3,  8376,  7265,   4,   7, PL_LB__LF }   /* lb=linefeed */,
  {     2,  8248,    17,   4,   1, PL_BPT__O }   /* bpt=o */,
  {    10,  7459,  7569,   3,   4, PL_OSMA }   /* sc=osma */,
  {    32,  6890,  6566,   4,  10, PL_BOXDRAWING }   /* blk=boxdrawing */,
  {     0,  8572,  7165,   3,   3, PL_WB__GAZ }   /* wb=gaz */,
  {     6,  8368,     0,   3,   0, PL_LAO }   /* lao */,
  {     1,   974,  8187,  24,   2, PL_CCC__27 }   /* canonicalcombiningclass=27 */,
  {     1,    47,     0,   1,   0, PL_M }   /* m */,
  {     0,   974,  8901,  27,   2, PL_CCC__36 }   /* canonicalcombiningclass=ccc36 */,
  {     5,  7478,  1312,   6,   7, PL_MC }   /* isspacingmark */,
  {     0,  7288,  7192,   7,   8, PL_SC__GUJR }   /* script=gujarati */,
  {     0,  7471,  3521,   7,   5, PL_POSIXSPACE }   /* isposixspace */,
  {     6,  8376,  7681,   3,   7, PL_LB__XX }   /* lb=unknown */,
  {     4,  7288,  8046,   7,   5, PL_SC__LIMB }   /* script=limbu */,
  {     0,  1426,  4539,  22,  15, PL_INSC__REGISTERSHIFTER }   /* indicsyllabiccategory=registershifter */,
  {     1,  2814,     0,   9,   0, PL_HALFMARKS }   /* halfmarks */,
  {     1,  7227,  7986,   5,   5, PL_POSIXBLANK }   /* posixblank */,
  {     0,  7288,  8388,   7,   4, PL_LISU }   /* script=lisu */,
  {     0,  4590,  7768,   2,   6, -PL_VS }   /* vs=false */,
  {     0,  7380,  8228,   4,   3, PL_CCC__202 }   /* ccc=atb */,
  {     0,  2229,    17,  17,   1, PL_LO }   /* generalcategory=lo */,
  {     1,  5968,  8067,   3,   4, PL_INORIYA }   /* inoriya */,
  {     0,  8240,  4730,   4,  13, PL_BC__EN }   /* bc=europeannumber */,
  {     2,  6484,     0,  10,   0, PL_IDC }   /* idcontinue */,
  {     1,  7136,  1790,   6,  22, PL_MODIFIERLETTERS }   /* block=spacingmodifierletters */,
  {     6,  7168,  7951,   8,   5, PL_EXT }   /* extender=true */,
  {     0,  6076,  7997,  11,   4, PL_BIDIC }   /* bidicontrol=yes */,
  {     0,  1306,     0,  24,   0, PL_DIACRITICALSFORSYMBOLS }   /* combiningmarksforsymbols */,
  {     1,  8376,  6087,   3,  11, PL_LB__BB }   /* lb=breakbefore */,
  {     8,  8340,  6726,   3,  10, PL_JG__REVERSEDPE }   /* jg=reversedpe */,
  {     6,  7288,  7336,   7,   4, PL_UGAR }   /* script=ugar */,
  {     1,  2229,   468,  16,   5, PL_P }   /* generalcategory=punct */,
  {     0,  4449,    47,  14,   1, PL_NFCQC__M }   /* nfcquickcheck=m */,
  {    10,  2149,     0,  20,   0, PL_HLUW }   /* anatolianhieroglyphs */,
  {     0,  8096,  6414,   5,   3, PL_BENG }   /* scx=beng */,
  {     0,  8412,     0,   4,   0, PL_MTEI }   /* mtei */,
  {     1,  2065,  7997,  21,   2, PL_NCHAR }   /* noncharactercodepoint=y */,
  {    16,  5051,  7997,  14,   2, PL_DT__NONE }   /* nfkdquickcheck=y */,
  {     0,  7816,  7997,   6,   4, PL_GRBASE }   /* grbase=yes */,
  {     0,   184,  2170,   3,  19, PL_PC }   /* isconnectorpunctuation */,
  {     4,  7226,  8081,   6,   5, PL_XPOSIXPRINT }   /* xposixprint */,
  {    19,  5645,  8804,  10,   3, PL_BC__LRI }   /* bidiclass=lri */,
  {     1,  7208,     0,   8,   0, PL_HIRA }   /* hiragana */,
  {     2,  7168,  7997,   8,   4, PL_EXT }   /* extender=yes */,
  {     1,     7,     0,   1,   0, PL_C }   /* c */,
  {     2,  4314,  5837,  13,  12, PL_JG__MALAYALAMBHA }   /* joininggroup=malayalambha */,
  {     0,   184,  8416,   2,   4, PL_MYMR }   /* ismymr */,
  {     7,  7380,  8897,   7,   2, PL_CCC__19 }   /* ccc=ccc19 */,
  {     1,  3129,  7025,  17,   9, PL_ORKH }   /* scriptextensions=oldturkic */,
  {     5,  8011,  4224,   3,  14, PL_SC }   /* gc=currencysymbol */,
  {     3,  4314,     3,  15,   1, PL_JG__KAF }   /* joininggroup=kaf */,
  {    20,  4554,  1083,  14,   2, PL_LB__LF }   /* sentencebreak=lf */,
  {     3,  6208,  3223,   5,   3, -PL_JOINC }   /* joinc=no */,
  {     2,  7136,  5531,   6,  13, PL_MISCTECHNICAL }   /* block=misctechnical */,
  {     2,  8121,  7997,   5,   2, PL_UIDEO }   /* uideo=y */,
  {     7,  7457,  2209,   5,  20, PL_INSC__CONSONANTWITHSTACKER }   /* insc=consonantwithstacker */,
  {     0,   184,  6587,   3,   9, PL_CJKSTROKES }   /* iscjkstrokes */,
  {     2,   184,  3754,   2,  16, PL_LINEARBIDEOGRAMS }   /* islinearbideograms */,
  {     0,  7136,  4105,   7,   4, PL_INBAMUM }   /* block=bamum */,
  {     0,   184,  5414,   2,  13, PL_LOWSURROGATES }   /* islowsurrogates */,
  {     2,  7689,  4091,   4,  13, PL_ARABICEXTA }   /* isarabicextendeda */,
  {     6,  7459,  5933,   3,  12, PL_GONM }   /* sc=masaramgondi */,
  {     0,   184,   283,   2,  33, PL_MISCMATHSYMBOLSA }   /* ismiscellaneousmathematicalsymbolsa */,
  {     0,  3129,  7653,  17,   7, PL_TIBT }   /* scriptextensions=tibetan */,
  {     2,  7380,  8646,   4,   2, PL_CCC__29 }   /* ccc=29 */,
  {     2,  6890,  5681,   4,  12, PL_CYRILLICEXTA }   /* blk=cyrillicexta */,
  {     0,  7840,  3521,   6,   5, PL_VERTSPACE }   /* isvertspace */,
  {     0,  8798,  3223,   3,   3, -PL_LOE }   /* loe=no */,
  {     0,  8204,  7768,   4,   2, -PL_POSIXXDIGIT }   /* ahex=f */,
  {    32,  7288,  8400,   7,   4, PL_MIAO }   /* script=miao */,
  {     5,  2985,  7768,   3,   6, -PL_IDS }   /* ids=false */,
  {     6,  7457,  5191,   7,  14, PL_INSC__INVISIBLESTACKER }   /* insc=invisiblestacker */,
  {    18,  6706,  8612,  10,   3, PL_IN__1_DOT_1 }   /* presentin=1.1 */,
  {     4,   184,   132,   2,   2, PL_LM }   /* islm */,
  {     2,  7288,  5427,   7,   9, PL_SC__MLYM }   /* script=malayalam */,
  {    26,  3129,  1589,  17,   5, PL_LATN }   /* scriptextensions=latin */,
  {     0,  7689,  2134,   3,   3, PL_POSIXXDIGIT }   /* isahex */,
  {     0,  8780,  7997,   3,   4, PL_CWT }   /* cwt=yes */,
  {     3,  6263,  7681,  10,   7, PL_LB__XX }   /* linebreak=unknown */,
  {     1,  5037,     0,  14,   0, PL_SK }   /* modifiersymbol */,
  {     0,  6890,  6980,   4,   9, PL_INNABATAEAN }   /* blk=nabataean */,
  {     4,  5245,  7768,  13,   2, -PL_POSIXXDIGIT }   /* asciihexdigit=f */,
  {     0,    34,  3581,   3,   2, PL_EXT }   /* ext=t */,
  {     1,   184,   691,   3,  29, PL_CUNEIFORMNUMBERS }   /* iscuneiformnumbersandpunctuation */,
  {     0,   184,  1499,   2,   1, PL_Z }   /* isz */,
  {     0,  6890,  7555,   4,   7, PL_OLCK }   /* blk=olchiki */,
  {     0,  7136,  6676,   6,  10, PL_INOLDPERSIAN }   /* block=oldpersian */,
  {     3,  6484,  7768,  10,   6, -PL_IDC }   /* idcontinue=false */,
  {     4,  3129,  2249,  17,   4, PL_GLAG }   /* scriptextensions=glag */,
  {     1,  6890,  7394,   4,   7, PL_CJKEXTB }   /* blk=cjkextb */,
  {     0,  7478,  7605,   3,   6, PL_SIDD }   /* issiddham */,
  {     0,  7136,  7604,   6,   7, PL_INSIDDHAM }   /* block=siddham */,
  {     5,    96,  7997,  10,   2, PL_XPOSIXALPHA }   /* alphabetic=y */,
  {    12,  8376,  8344,   3,   2, PL_GCB__T }   /* lb=jt */,
  {     8,  8480,     0,   4,   0, PL_QAAI }   /* qaai */,
  {    11,   982,     0,   2,   0, PL_L_AMP_ }   /* lc */,
  {     8,  7136,  4784,   6,   4, PL_INCHAM }   /* block=cham */,
  {     3,  4542,  3148,   3,  17, PL_TAIXUANJING }   /* istaixuanjingsymbols */,
  {     1,  7380,  7750,   4,   1, PL_CCC__8 }   /* ccc=8 */,
  {     1,  8196,  8867,   4,   3, PL_AGE__5_DOT_1 }   /* age=v51 */,
  {     0,    21,  3239,   4,   8, PL_ALCHEMICAL }   /* inalchemical */,
  {     2,  1448,  7062,   3,   8, PL_INSAMARITAN }   /* insamaritan */,
  {     1,  4224,     0,  14,   0, PL_SC }   /* currencysymbol */,
  {     1,  6210,    43,   3,  25, PL_CJKCOMPATIDEOGRAPHS }   /* incjkcompatibilityideographs */,
  {     1,  8011,  2088,   3,   2, PL_PD }   /* gc=pd */,
  {     1,  7288,  8596,   7,   4, PL_ZANB }   /* script=zanb */,
  {     0,   184,  2065,   2,  21, PL_NCHAR }   /* isnoncharactercodepoint */,
  {     1,  1426,  7981,  22,   5, PL_INSC__BINDU }   /* indicsyllabiccategory=bindu */,
  {    12,  7288,  4494,   7,  15, PL_NARB }   /* script=oldnortharabian */,
  {     1,  5657,  7997,  12,   4, PL_BIDIM }   /* bidimirrored=yes */,
  {     0,  7478,     6,   3,   1, PL_SD }   /* issd */,
  {     5,  7604,     0,   4,   0, PL_SIDD }   /* sidd */,
  {     3,  1202,  7951,   3,   5, PL_DEP }   /* dep=true */,
  {     0,   974,   226,  24,   2, PL_CCC__BL }   /* canonicalcombiningclass=bl */,
  {     4,  8096,  2877,   4,  10, PL_DEVA }   /* scx=devanagari */,
  {     0,   974,  7709,  24,   2, PL_CCC__16 }   /* canonicalcombiningclass=16 */,
  {     0,  8816,  7750,   3,   5, PL_NV__80000 }   /* nv=80000 */,
  {     8,  6890,  6786,   4,  10, PL_SUPARROWSC }   /* blk=suparrowsc */,
  {     2,  4402,  3851,   3,  15, PL_MISCMATHSYMBOLSA }   /* inmiscmathsymbolsa */,
  {     0,  5051,  7997,  14,   4, PL_DT__NONE }   /* nfkdquickcheck=yes */,
  {     0,  8376,    73,   3,   2, PL_LB__EM }   /* lb=em */,
  {     0,  8452,     0,   4,   0, PL_ORYA }   /* orya */,
  {     5,  5544,  7702,  13,   4, PL_NV__2000 }   /* numericvalue=2000 */,
  {    26,  5245,  3581,  13,   2, PL_POSIXXDIGIT }   /* asciihexdigit=t */,
  {     8,  8783,  7768,   3,   6, -PL_CWU }   /* cwu=false */,
  {     2,  4923,  5935,   4,  10, PL_INMASARAMGONDI }   /* inmasaramgondi */,
  {     0,  7136,  6863,   6,   9, PL_ARABICPFA }   /* block=arabicpfa */,
  {    42,  3129,  8516,  17,   4, PL_SGNW }   /* scriptextensions=sgnw */,
  {     0,  8332,  1614,   4,  21, PL_SHORTHANDFORMATCONTROLS }   /* inshorthandformatcontrols */,
  {     0,  7487,  3521,   5,   5, PL_XPOSIXSPACE }   /* xperlspace */,
  {     5,  6613,  3300,   3,   3, PL_HAN }   /* ishani */,
  {     4,  7136,  1282,   6,  10, PL_CJKSYMBOLS }   /* block=cjksymbols */,
  {     2,  2859,  4188,  18,   6, PL_DT__MED }   /* decompositiontype=medial */,
  {     2,  7136,  3994,   6,   9, PL_SYRIACSUP }   /* block=syriacsup */,
  {     1,  6706,  8876,  10,   3, PL_IN__6_DOT_1 }   /* presentin=v61 */,
  {     0,    21,  6944,   2,   9, PL_LATINEXTC }   /* inlatinextc */,
  {     1,  7288,     7,   7,  18, PL_CANS }   /* script=canadianaboriginal */,
  {     3,  6613,     8,   3,   2, PL_HAN }   /* ishan */,
  {     1,  8096,  4010,   4,   4, PL_TANG }   /* scx=tang */,
  {     0,   184,  1589,   2,   9, PL_LATINEXTE }   /* islatinexte */,
  {     1,  7136,  7401,   6,   7, PL_CJKEXTC }   /* block=cjkextc */,
  {     8,  2985,  7951,   3,   5, PL_IDS }   /* ids=true */,
  {     1,  8096,  2787,   4,   4, PL_CHER }   /* scx=cher */,
  {     0,   122,  7997,   9,   4, PL_DIA }   /* diacritic=yes */,
  {     0,  6890,  6626,   4,  10, PL_INKHAROSHTHI }   /* blk=kharoshthi */,
  {     0,  6890,  7822,   4,   6, PL_INHATRAN }   /* blk=hatran */,
  {     2,  7459,  7208,   3,   8, PL_SC__HIRA }   /* sc=hiragana */,
  {     0,  7136,  7639,   6,   7, PL_INTAITHAM }   /* block=taitham */,
  {     1,    84,  7768,   4,   2, -PL_MATH }   /* math=f */,
  {    24,   849,     0,  14,   0, PL_PUA }   /* privateusearea */,
  {     5,  7224,  6484,   3,  10, PL_XIDC }   /* isxidcontinue */,
  {     4,  5765,  3581,  12,   2, PL_GRBASE }   /* graphemebase=t */,
  {     0,  6890,  7450,   4,   7, PL_INHANUNOO }   /* blk=hanunoo */,
  {     4,  7136,  1543,   6,  23, PL_GEOMETRICSHAPESEXT }   /* block=geometricshapesextended */,
  {     0,   974,  8640,  24,   2, PL_CCC__18 }   /* canonicalcombiningclass=18 */,
  {     0,  5544,  8655,  13,   2, PL_NV__33 }   /* numericvalue=33 */,
  {     1,  6566,     0,  10,   0, PL_BOXDRAWING }   /* boxdrawing */,
  {     0,  8196,  8885,   4,   3, PL_AGE__7 }   /* age=v70 */,
  {     0,  6613,  2815,   3,   8, PL_HALFMARKS }   /* ishalfmarks */,
  {     6,  7288,  7152,   7,   4, PL_SC__DUPL }   /* script=dupl */,
  {     3,  1887,  3223,   5,   3, -PL_XPOSIXLOWER }   /* lower=no */,
  {     0,  8096,  7034,   4,   4, PL_PALM }   /* scx=palm */,
  {     2,  2108,  1379,   3,  23, PL_HIGHPUSURROGATES }   /* inhighprivateusesurrogates */,
  {     0,  8096,  2967,   4,   8, PL_GEOR }   /* scx=georgian */,
  {    69,  7506,     0,   7,   0, PL_LINA }   /* lineara */,
  {     0,  7689,  3596,   4,  14, PL_ARABICSUP }   /* isarabicsupplement */,
  {     0,  8816,  8172,   3,   4, PL_NV__3_SLASH_16 }   /* nv=3/16 */,
  {     1,  8096,  7208,   4,   8, PL_HIRA }   /* scx=hiragana */,
  {     0,  8376,  6175,   3,  11, PL_LB__EX }   /* lb=exclamation */,
  {     1,  8096,  2249,   4,  10, PL_GLAG }   /* scx=glagolitic */,
  {     1,  8780,  3223,   3,   3, -PL_CWT }   /* cwt=no */,
  {     2,  7380,  8901,   4,   2, PL_CCC__36 }   /* ccc=36 */,
  {     1,  6219,  7951,  11,   5, PL_JOINC }   /* joincontrol=true */,
  {     1,  8496,     0,   4,   0, PL_SAMR }   /* samr */,
  {     0,  6210,   691,   3,  15, PL_CUNEIFORMNUMBERS }   /* incuneiformnumbers */,
  {     2,   184,   661,   3,  29, PL_CJKEXTF }   /* iscjkunifiedideographsextensionf */,
  {     0,  1417,  5037,   9,  14, PL_SK }   /* category=modifiersymbol */,
  {     8,  2108,  1084,   5,  23, PL_HALFANDFULLFORMS }   /* inhalfwidthandfullwidthforms */,
  {     2,   184,  8348,   2,   4, PL_KALI }   /* iskali */,
  {     0,    21,  7900,   2,   6, PL_INREJANG }   /* inrejang */,
  {     2,  6890,  5336,   4,   8, PL_GREEKEXT }   /* blk=greekext */,
  {     3,   184,  2484,   2,  19, PL_EGYP }   /* isegyptianhieroglyphs */,
  {     3,  8026,  6686,   5,  10, PL_INPC__OVERSTRUCK }   /* inpc=overstruck */,
  {    11,  8276,  7951,   4,   5, PL_CWCM }   /* cwcm=true */,
  {    16,  6263,  2163,  10,   2, PL_LB__GL }   /* linebreak=gl */,
  {     0,  1448,   385,   5,  30, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* insupplementalsymbolsandpictographs */,
  {     6,  8096,  7555,   4,   7, PL_OLCK }   /* scx=olchiki */,
  {     2,  6890,   808,   4,  28, PL_PHONETICEXTSUP }   /* blk=phoneticextensionssupplement */,
  {     4,  7459,  7429,   3,   7, PL_DSRT }   /* sc=deseret */,
  {     0,    21,  5388,   2,  13, PL_KANAEXTA }   /* inkanaextendeda */,
  {     1,  3129,  7660,  17,   4, PL_TIRH }   /* scriptextensions=tirh */,
  {     0,  8011,     1,   3,   1, PL_N }   /* gc=n */,
  {     1,  7136,  8116,   6,   5, PL_INTAMIL }   /* block=tamil */,
  {     4,  7918,     0,   4,   0, PL_THAA }   /* thaa */,
  {     5,  8061,     0,   5,   0, PL_OGAM }   /* ogham */,
  {     1,  3674,     0,   7,   0, PL_CPRT }   /* cypriot */,
  {     1,  7288,  8452,   7,   4, PL_SC__ORYA }   /* script=orya */,
  {     0,  7621,     0,   3,   0, PL_PUA }   /* pua */,
  {     5,  3129,  4299,  17,  15, PL_ARMI }   /* scriptextensions=imperialaramaic */,
  {     0,  4449,  7998,  14,   3, PL_NFCQC__Y }   /* nfcquickcheck=yes */,
  {     6,  8822,  3223,   3,   2, -PL_PCM }   /* pcm=n */,
  {     4,  7136,  3994,   6,  16, PL_SYRIACSUP }   /* block=syriacsupplement */,
  {     0,  3373,  6845,  15,   9, PL_EA__A }   /* eastasianwidth=ambiguous */,
  {     2,   184,  2877,   2,  13, PL_DEVANAGARIEXT }   /* isdevanagariext */,
  {     0,  7380,    18,   4,   1, PL_CCC__R }   /* ccc=r */,
  {     0,  6219,  7997,  11,   2, PL_JOINC }   /* joincontrol=y */,
  {     8,  6263,  8929,  10,   2, PL_GCB__V }   /* linebreak=jv */,
  {     1,  1691,     0,  11,   0, PL_NUMBERFORMS }   /* numberforms */,
  {     1,  8572,  4561,   3,   2, PL_WB__EB }   /* wb=eb */,
  {     2,  4314,  7930,  13,   6, PL_JG__YUDHHE }   /* joininggroup=yudhhe */,
  {     0,  8096,  5957,   4,  12, PL_MEND }   /* scx=mendekikakui */,
  {     0,  4554,  8935,  14,   2, PL_SB__XX }   /* sentencebreak=xx */,
  {     0,  3129,  4784,  17,   4, PL_CHAM }   /* scriptextensions=cham */,
  {     2,  3129,  8408,  17,   3, PL_MRO }   /* scriptextensions=mro */,
  {     0,  1746,  3985,  21,   9, PL_LB__EM }   /* graphemeclusterbreak=emodifier */,
  {    12,  1474,    17,  22,   1, PL_BPT__O }   /* bidipairedbrackettype=o */,
  {     5,  4923,  5429,   4,   7, PL_INMALAYALAM }   /* inmalayalam */,
  {     3,  1543,     0,  15,   0, PL_GEOMETRICSHAPES }   /* geometricshapes */,
  {     2,  3994,     0,   9,   0, PL_SYRIACSUP }   /* syriacsup */,
  {     1,  7380,  8916,   4,   2, PL_CCC__84 }   /* ccc=84 */,
  {     0,  1184,  7768,  25,   2, -PL_DI }   /* defaultignorablecodepoint=f */,
  {     0,  2985,  7997,   4,   4, PL_IDST }   /* idst=yes */,
  {     0,  7136,  2409,   7,   5, PL_INBRAHMI }   /* block=brahmi */,
  {     2,  8096,  2107,   4,   4, PL_SINH }   /* scx=sinh */,
  {    13,  6706,  8843,  10,   3, PL_IN__2 }   /* presentin=v20 */,
  {     1,   436,     0,   5,   0, PL_NCHAR }   /* nchar */,
  {     4,  2229,  8932,  17,   1, PL_L_AMP_ }   /* generalcategory=l& */,
  {     0,  8011,  5401,   3,  13, PL_ZL }   /* gc=lineseparator */,
  {     1,  4314,  3812,  13,   3, PL_JG__LAM }   /* joininggroup=lam */,
  {     1,  7459,  8444,   3,   4, PL_OLCK }   /* sc=olck */,
  {     0,  8096,  5427,   4,   9, PL_MLYM }   /* scx=malayalam */,
  {     6,   206,     0,   2,   0, PL_PI }   /* pi */,
  {     6,  7288,  2249,   7,  10, PL_SC__GLAG }   /* script=glagolitic */,
  {     5,  7136,  4284,   6,  15, PL_INHANGUL }   /* block=hangulsyllables */,
  {     4,  3129,  7780,  17,   6, PL_CARI }   /* scriptextensions=carian */,
  {     5,  2985,  7768,   4,   6, -PL_IDST }   /* idst=false */,
  {    28,   184,  8244,   2,   4, PL_BHKS }   /* isbhks */,
  {    14,  8816,  8771,   3,   3, PL_NV__9_SLASH_2 }   /* nv=9/2 */,
  {     0,  7459,  7604,   3,   4, PL_SIDD }   /* sc=sidd */,
  {     6,  1448,  3995,   3,   8, PL_SYRIACSUP }   /* insyriacsup */,
  {    10,  7906,  7847,   4,   5, PL_SC__KTHI }   /* sc=kaithi */,
  {     2,  4542,  7919,   3,   5, PL_THAA }   /* isthaana */,
  {     8,  7478,  7591,   3,   6, PL_SHRD }   /* issharada */,
  {     0,  7478,  7619,   3,   6, PL_SUPPUAA }   /* issuppuaa */,
  {     0,  8096,  4299,   4,  15, PL_ARMI }   /* scx=imperialaramaic */,
  {     1,  7288,  7660,   7,   4, PL_SC__TIRH }   /* script=tirh */,
  {     0,  7136,     0,   6,  34, PL_UCAS }   /* block=unifiedcanadianaboriginalsyllabics */,
  {     0,  2229,     1,  16,   1, PL_N }   /* generalcategory=n */,
  {     2,  7459,  7248,   3,   8, PL_SC__JAVA }   /* sc=javanese */,
  {     0,  6890,  6696,   4,  10, PL_INPHOENICIAN }   /* blk=phoenician */,
  {     0,  2229,  4569,  16,  15, PL_LT }   /* generalcategory=titlecaseletter */,
  {     5,  5544,  5219,  13,  11, PL_NV__10000000000 }   /* numericvalue=10000000000 */,
  {     7,  5284,  7768,  13,   6, -PL_CI }   /* caseignorable=false */,
  {     0,   184,    38,   2,   2, PL_XPOSIXDIGIT }   /* isnd */,
  {     0,  7459,  2484,   3,   4, PL_EGYP }   /* sc=egyp */,
  {     2,  2100,  8072,   3,   4, PL_OSGE }   /* isosage */,
  {     8,   184,  3340,   3,  16, PL_CYRILLICEXTB }   /* iscyrillicextendedb */,
  {     7,  1354,  7997,  24,   4, PL_COMPEX }   /* fullcompositionexclusion=yes */,
  {     0,  7136,    42,   6,  26, PL_CJKCOMPATIDEOGRAPHS }   /* block=cjkcompatibilityideographs */,
  {     0,  6890,  1497,   4,  14, PL_BYZANTINEMUSIC }   /* blk=byzantinemusic */,
  {     0,  8101,  7997,   5,   4, PL_STERM }   /* sterm=yes */,
  {     0,  3129,  8111,  17,   4, PL_TAKR }   /* scriptextensions=takr */,
  {     0,  7288,  8520,   7,   4, PL_SHAW }   /* script=shaw */,
  {     0,  8816,  8160,   3,   2, PL_NV__13 }   /* nv=13 */,
  {     0,  6890,   510,   4,  30, PL_CJKEXTA }   /* blk=cjkunifiedideographsextensiona */,
  {     7,  8288,  1209,   3,   5, PL_DT__SUP }   /* dt=super */,
  {     6,  7459,  5825,   3,   4, PL_SC__MAHJ }   /* sc=mahj */,
  {     0,  7136,  4105,   7,   7, PL_BAMUMSUP }   /* block=bamumsup */,
  {     1,  6890,  7846,   4,   6, PL_INKAITHI }   /* blk=kaithi */,
  {     2,  8011,   221,   3,   2, PL_L_AMP_ }   /* gc=l_ */,
  {     2,  6210,  1982,   3,   7, PL_INCYRILLIC }   /* incyrillic */,
  {     1,  5192,  3425,   3,   3, PL_IDSB }   /* isidsb */,
  {     0,  7994,     0,   5,   0, PL_IDC }   /* idc=y */,
  {    11,  6890,  3356,   4,  17, PL_CYRILLICEXTC }   /* blk=cyrillicextendedc */,
  {     2,  7136,  4404,   6,  15, PL_INMEROITICCURSIVE }   /* block=meroiticcursive */,
  {     7,  8196,  7710,   4,   1, PL_AGE__6 }   /* age=6 */,
  {     1,  6890,  3850,   4,  16, PL_MISCMATHSYMBOLSA }   /* blk=miscmathsymbolsa */,
  {    10,  4923,  7274,   4,   6, PL_INMAHAJANI }   /* inmahajani */,
  {     9,   184,  2967,   2,   4, PL_GEOR }   /* isgeor */,
  {     0,  8011,  3914,   3,  16, PL_PO }   /* gc=otherpunctuation */,
  {     7,  8340,  8484,   3,   4, PL_JG__QAPH }   /* jg=qaph */,
  {     9,  7459,  2636,   3,   4, PL_SC__MONG }   /* sc=mong */,
  {     2,  4314,  3802,  13,  16, PL_JG__MANICHAEANLAMEDH }   /* joininggroup=manichaeanlamedh */,
  {     5,    21,  7870,   2,   6, PL_INLEPCHA }   /* inlepcha */,
  {     1,  2100,  7570,   3,   6, PL_OSMA }   /* isosmanya */,
  {     2,  7136,  3021,   6,  18, PL_LATINEXTADDITIONAL }   /* block=latinextadditional */,
  {     1,  7380,  8705,   4,   3, PL_CCC__IS }   /* ccc=240 */,
  {    10,  5645,  2655,  10,  19, PL_BC__RLO }   /* bidiclass=righttoleftoverride */,
  {     1,  6307,     0,  11,   0, PL_MYANMAREXTA }   /* myanmarexta */,
  {     1,  7459,  6736,   3,   4, PL_SAUR }   /* sc=saur */,
  {     1,  8011,  5037,   3,  14, PL_SK }   /* gc=modifiersymbol */,
  {     1,  8096,  3458,   4,   4, PL_MANI }   /* scx=mani */,
  {     1,  3656,     0,  18,   0, PL_PE }   /* isclosepunctuation */,
  {     2,  6472,     0,  11,   1, PL_WB__NU }   /* wordbreak=nu */,
  {     4,  7459,    78,   3,   4, PL_SC__ARAB }   /* sc=arab */,
  {     0,   184,  1307,   3,  23, PL_DIACRITICALSFORSYMBOLS }   /* iscombiningmarksforsymbols */,
  {     0,  7380,  8651,   7,   3, PL_CCC__132 }   /* ccc=ccc132 */,
  {     0,  8894,  3212,   3,   7, PL_VO__U }   /* vo=upright */,
  {     7,  8121,     0,   5,   0, PL_UIDEO }   /* uideo */,
  {     0,   184,  5957,   2,  12, PL_MEND }   /* ismendekikakui */,
  {     6,  7798,     0,   6,   0, PL_COMPEX }   /* compex */,
  {     0,  8240,    32,   3,   2, PL_BC__CS }   /* bc=cs */,
  {     0,  7226,    96,   6,   5, PL_XPOSIXALPHA }   /* xposixalpha */,
  {     2,  7459,  7660,   3,   4, PL_SC__TIRH }   /* sc=tirh */,
  {     1,  7288,  1401,   7,   4, PL_SC__SIND }   /* script=sind */,
  {     2,   184,  1543,   2,  18, PL_GEOMETRICSHAPESEXT }   /* isgeometricshapesext */,
  {     1,  6613,  3707,   3,  15, PL_HALFANDFULLFORMS }   /* ishalfandfullforms */,
  {     2,  6210,  4688,   3,  13, PL_CJKCOMPATFORMS }   /* incjkcompatforms */,
  {     4,  7136,  1812,   6,  22, PL_TRANSPORTANDMAP }   /* block=transportandmapsymbols */,
  {     2,  4134,     0,  15,   0, PL_BRAI }   /* braillepatterns */,
  {     0,  8196,  7750,   4,   1, PL_AGE__8 }   /* age=8 */,
  {     0,   184,     0,   4,   0, PL_CE }   /* isce */,
  {     4,  5192,  2986,   3,   3, PL_IDST }   /* isidst */,
  {     0,  7136,   808,   6,  28, PL_PHONETICEXTSUP }   /* block=phoneticextensionssupplement */,
  {     0,  8508,  3755,   4,   6, PL_SC__LINB }   /* sc=linearb */,
  {    17,    21,  1107,   2,   8, PL_INKATAKANA }   /* inkatakana */,
  {     1,  2236,  4330,  10,  14, PL_LL }   /* category=lowercaseletter */,
  {     1,  8196,  8849,   4,   3, PL_AGE__3 }   /* age=v30 */,
  {     2,  8096,  6005,   4,  12, PL_HUNG }   /* scx=oldhungarian */,
  {     3,  1160,     0,   4,   0, PL_HANG }   /* hang */,
  {    10,  8340,  5440,   3,  13, PL_JG__MALAYALAMNNNA }   /* jg=malayalamnnna */,
  {     5,  1918,     0,  21,   0, PL_CWU }   /* changeswhenuppercased */,
  {     4,  6296,     0,  11,   0, PL_MISCSYMBOLS }   /* miscsymbols */,
  {     3,  5134,    25,   3,   1, PL_PS }   /* isps */,
  {     0,  5079,     0,  14,   0, PL_MN }   /* nonspacingmark */,
  {     1,   122,  3223,   9,   2, -PL_DIA }   /* diacritic=n */,
  {     9,  5657,  7997,   5,   2, PL_BIDIM }   /* bidim=y */,
  {     0,  6890,  1506,   4,  14, PL_MUSIC }   /* blk=musicalsymbols */,
  {     0,    96,  3223,  10,   3, -PL_XPOSIXALPHA }   /* alphabetic=no */,
  {     2,   184,  2360,   2,   4, PL_MAND }   /* ismand */,
  {    27,   966,     0,   2,   0, PL_NO }   /* no */,
  {     0,  7136,  1107,   6,   8, PL_INKATAKANA }   /* block=katakana */,
  {     0,  6890,  1981,   4,  21, PL_CYRILLICSUP }   /* blk=cyrillicsupplementary */,
  {    10,   186,     0,   2,   0, PL_CE }   /* ce */,
  {     0,  7457,  5205,   5,  14, PL_INSC__VOWELDEPENDENT }   /* insc=voweldependent */,
  {     1,  1503,   721,   3,  29, PL_ENCLOSEDALPHANUMSUP }   /* inenclosedalphanumericsupplement */,
  {     0,  7459,  2877,   3,  10, PL_SC__DEVA }   /* sc=devanagari */,
  {    16,  8340,  3786,   3,  16, PL_JG__MANICHAEANDALETH }   /* jg=manichaeandaleth */,
  {     2,  5134,   469,   3,   4, PL_P }   /* ispunct */,
  {     6,  6890,    78,   4,   6, PL_INARABIC }   /* blk=arabic */,
  {     0,  7459,  6806,   3,  10, PL_WARA }   /* sc=warangciti */,
  {    24,   184,  7986,   2,   5, PL_XPOSIXBLANK }   /* isblank */,
  {     0,  6890,   448,   5,  17, PL_IDEOGRAPHICSYMBOLS }   /* blk=ideographicsymbols */,
  {     0,  8816,  7720,   3,   3, PL_NV__400 }   /* nv=400 */,
  {     1,  6890,  7366,   4,   7, PL_INBENGALI }   /* blk=bengali */,
  {     0,  8340,  5921,   3,  12, PL_JG__MANICHAEANPE }   /* jg=manichaeanpe */,
  {    26,  8376,    34,   3,   2, PL_LB__EX }   /* lb=ex */,
  {     4,    21,  8388,   2,   4, PL_LISU }   /* inlisu */,
  {     1,  7894,  3223,   6,   2, -PL_PATSYN }   /* patsyn=n */,
  {     4,  6890,  8432,   4,   3, PL_INNKO }   /* blk=nko */,
  {     0,  2754,   923,   5,  24, PL_ALPHABETICPF }   /* inalphabeticpresentationforms */,
  {     0,  8816,  7936,   3,   4, PL_NV__1_SLASH_16 }   /* nv=1/16 */,
  {     1,  4314,  3458,  13,  17, PL_JG__MANICHAEANDHAMEDH }   /* joininggroup=manichaeandhamedh */,
  {     0,  8816,  7744,   3,   1, PL_NV__7 }   /* nv=7 */,
  {     2,  7288,  7436,   7,   4, PL_ELBA }   /* script=elba */,
  {     0,  4314,  8512,  13,   4, PL_JG__SEEN }   /* joininggroup=seen */,
  {     1,  2750,  7768,   4,   6, -PL_TERM }   /* term=false */,
  {     0,  8288,  3690,   3,   3, PL_DT__FIN }   /* dt=fin */,
  {     1,  7696,  7997,   6,   2, PL_XPOSIXSPACE }   /* wspace=y */,
  {    20,  3516,  3223,  10,   3, -PL_XPOSIXSPACE }   /* whitespace=no */,
  {     5,  1746,  3914,  21,   5, PL_GCB__XX }   /* graphemeclusterbreak=other */,
  {     2,  1417,  3914,   9,   5, PL_C }   /* category=other */,
  {     4,  7136,   720,   6,  21, PL_ENCLOSEDALPHANUM }   /* block=enclosedalphanumerics */,
  {     3,   122,  7768,   9,   6, -PL_DIA }   /* diacritic=false */,
  {     1,  7689,  2390,   3,  18, PL_ANCIENTGREEKNUMBERS }   /* isancientgreeknumbers */,
  {     0,  7136,  7992,   7,   4, PL_INBUHID }   /* block=buhid */,
  {     2,  5645,  7768,   5,   6, -PL_BIDIC }   /* bidic=false */,
  {     1,  6890,  7061,   4,   9, PL_INSAMARITAN }   /* blk=samaritan */,
  {     9,  6263,  5669,  10,  12, PL_LB__SY }   /* linebreak=breaksymbols */,
  {     0,  2859,  5969,  18,   8, PL_DT__NONCANON }   /* decompositiontype=noncanon */,
  {     1,  8196,  8708,   4,   3, PL_AGE__3 }   /* age=3.0 */,
  {     4,  8192,     0,   4,   0, PL_ADLM }   /* adlm */,
  {     0,  6613,  7209,   3,   7, PL_HIRA }   /* ishiragana */,
  {     0,  7986,     0,   5,   0, PL_XPOSIXBLANK }   /* blank */,
  {    16,  1897,  7997,  21,   4, PL_CWT }   /* changeswhentitlecased=yes */,
  {     1,  1402,  2355,  24,  14, PL_INPC__BOTTOMANDRIGHT }   /* indicpositionalcategory=bottomandright */,
  {     2,  6109,     7,  10,   1, PL_XPOSIXCNTRL }   /* category=cc */,
  {     2,  7136,  2787,   6,   8, PL_INCHEROKEE }   /* block=cherokee */,
  {     2,  8528,     0,   4,   0, PL_SYRC }   /* syrc */,
  {     5,  5657,  3223,  12,   2, -PL_BIDIM }   /* bidimirrored=n */,
  {    13,  3129,  8384,  17,   4, PL_LINB }   /* scriptextensions=linb */,
  {     1,  6706,  8861,  10,   3, PL_IN__4_DOT_1 }   /* presentin=v41 */,
  {     4,  5544,  7744,  13,   1, PL_NV__7 }   /* numericvalue=7 */,
  {     4,  8816,  7756,   3,   1, PL_NV__9 }   /* nv=9 */,
  {     3,  1448,  3544,   3,  16, PL_SMALLFORMS }   /* insmallformvariants */,
  {     0,  1908,     0,   9,   0, PL_LT }   /* titlecase */,
  {     6,  7459,  8111,   3,   4, PL_SC__TAKR }   /* sc=takr */,
  {     1,  8240,  3075,   3,  18, PL_BC__B }   /* bc=paragraphseparator */,
  {     0,   184,  7876,   2,   4, PL_LYCI }   /* islyci */,
  {     5,  6890,  2967,   4,   8, PL_INGEORGIAN }   /* blk=georgian */,
  {     5,   184,  5657,   2,  12, PL_BIDIM }   /* isbidimirrored */,
  {     0,  6208,  7768,   5,   2, -PL_JOINC }   /* joinc=f */,
  {     1,  7288,  7152,   7,   8, PL_SC__DUPL }   /* script=duployan */,
  {     0,  4198,  1545,   4,  16, PL_GEOMETRICSHAPESEXT }   /* ingeometricshapesext */,
  {     0,  8276,  3581,   4,   2, PL_CWCM }   /* cwcm=t */,
  {     2,  5645,  5633,  10,  12, PL_BC__AN }   /* bidiclass=arabicnumber */,
  {    15,  1206,  7919,   3,   5, PL_INTHAANA }   /* inthaana */,
  {     5,  6890,  2841,   4,  18, PL_COPTICEPACTNUMBERS }   /* blk=copticepactnumbers */,
  {    19,  6241,     0,  11,   0, PL_KATAKANAEXT }   /* katakanaext */,
  {     0,  7288,  4135,   8,   6, PL_BRAI }   /* script=braille */,
  {    36,  8340,  5837,   3,  12, PL_JG__MALAYALAMBHA }   /* jg=malayalambha */,
  {     0,  1209,     0,  25,   0, PL_SUPERANDSUB }   /* superscriptsandsubscripts */,
  {     4,  6890,  4269,   4,  15, PL_DIACRITICALSSUP }   /* blk=diacriticalssup */,
  {     1,  8011,    45,   3,   2, PL_CO }   /* gc=co */,
  {     1,   436,  3581,   5,   2, PL_NCHAR }   /* nchar=t */,
  {     2,  3129,  2841,  17,   4, PL_COPT }   /* scriptextensions=copt */,
  {     0,  1417,  8939,   9,   2, PL_ZP }   /* category=zp */,
  {     0,  8196,  8891,   4,   3, PL_AGE__9 }   /* age=v90 */,
  {     7,  7136,  6746,   6,  10, PL_SMALLFORMS }   /* block=smallforms */,
  {    17,  8816,  7726,   3,   2, PL_NV__43 }   /* nv=43 */,
  {     5,  4784,     0,   4,   0, PL_CHAM }   /* cham */,
  {     1,  7136,  2787,   6,  18, PL_CHEROKEESUP }   /* block=cherokeesupplement */,
  {     2,  8894,  3194,   3,   7, PL_VO__R }   /* vo=rotated */,
  {     0,  6483,  7951,  11,   5, PL_XIDC }   /* xidcontinue=true */,
  {     0,  7459,  2598,   3,  19, PL_MERO }   /* sc=meroitichieroglyphs */,
  {    11,  5544,  8911,  13,   2, PL_NV__46 }   /* numericvalue=46 */,
  {     1,  5544,  8621,  13,   3, PL_NV__1_SLASH_6 }   /* numericvalue=1/6 */,
  {     0,  3373,  4127,  15,   7, PL_EA__N }   /* eastasianwidth=neutral */,
  {     0,   184,  6076,   2,  11, PL_BIDIC }   /* isbidicontrol */,
  {     1,  8516,     0,   4,   0, PL_SGNW }   /* sgnw */,
  {     0,  7380,  8688,   7,   2, PL_CCC__26 }   /* ccc=ccc26 */,
  {     4,  2990,    80,   4,   8, PL_ARABICMATH }   /* inarabicmath */,
  {     7,  8340,  8334,   3,   4, PL_JG__SHIN }   /* jg=shin */,
  {    35,  6263,  1479,  10,   2, PL_LB__AI }   /* linebreak=ai */,
  {     0,  6890,  6029,   4,  12, PL_PHAISTOS }   /* blk=phaistosdisc */,
  {    20,  7380,  7944,   4,   2, PL_CCC__12 }   /* ccc=12 */,
  {     0,  1892,  7768,   5,   2, -PL_CASED }   /* cased=f */,
  {     2,  1589,     0,   5,   0, PL_LATN }   /* latin */,
  {     1,  7828,  3223,   6,   3, -PL_HYPHEN }   /* hyphen=no */,
  {     0,  6329,  7088,  11,   8, PL_XPOSIXDIGIT }   /* numerictype=decimal */,
  {     1,  4464,  7996,   4,   5, PL_NFDQC__Y }   /* nfdqc=yes */,
  {     0,  1282,     0,  10,   0, PL_CJKSYMBOLS }   /* cjksymbols */,
  {     1,  6208,  3581,   5,   2, PL_JOINC }   /* joinc=t */,
  {     3,  6263,    73,  10,   2, PL_LB__EM }   /* linebreak=em */,
  {     7,  8096,  8352,   4,   4, PL_KHMR }   /* scx=khmr */,
  {     1,  8026,  5122,   3,  13, PL_INPSALTERPAHLAVI }   /* inpsalterpahlavi */,
  {     1,   974,  8693,  24,   3, PL_CCC__A }   /* canonicalcombiningclass=230 */,
  {     3,  7224,  1929,   8,   5, PL_XPOSIXUPPER }   /* isxposixupper */,
  {     0,  1448,  6747,   3,   9, PL_SMALLFORMS }   /* insmallforms */,
  {    35,  5968,  7008,   3,   8, PL_INOLDITALIC }   /* inolditalic */,
  {     0,  4314,  8484,  13,   4, PL_JG__QAPH }   /* joininggroup=qaph */,
  {     0,   184,  8412,   2,   4, PL_MTEI }   /* ismtei */,
  {     2,  7459,  7104,   3,   8, PL_SC__ARMN }   /* sc=armenian */,
  {     8,  8096,  4010,   4,   6, PL_TANG }   /* scx=tangut */,
  {     5,  8572,   138,   3,   2, PL_WB__FO }   /* wb=fo */,
  {     2,  5968,  6677,   3,   9, PL_INOLDPERSIAN }   /* inoldpersian */,
  {    18,  8196,  6796,   4,  10, PL_AGE__NA }   /* age=unassigned */,
  {     0,  8026,  7584,   3,   6, PL_INPHAGSPA }   /* inphagspa */,
  {     0,  8196,  8840,   4,   3, PL_IN__1_DOT_1 }   /* age=v11 */,
  {     5,   184,   698,   2,   2, PL_MN }   /* ismn */,
  {     0,  7555,     0,   7,   0, PL_OLCK }   /* olchiki */,
  {     6,  7459,     7,   3,  18, PL_CANS }   /* sc=canadianaboriginal */,
  {    10,  6890,  7639,   4,   7, PL_INTAITHAM }   /* blk=taitham */,
  {     0,  8376,    83,   3,   2, PL_LB__CM }   /* lb=cm */,
  {     3,  1426,  4164,  22,  15, PL_INSC__CONSONANTKILLER }   /* indicsyllabiccategory=consonantkiller */,
  {    52,  8816,  7732,   3,   3, PL_NV__500 }   /* nv=500 */,
  {     3,  8340,  5065,   3,  14, PL_JG__NOJOININGGROUP }   /* jg=nojoininggroup */,
  {     0,   184,  7416,   3,   6, PL_CJKEXTE }   /* iscjkexte */,
  {     0,  8240,  4119,   3,  15, PL_BC__BN }   /* bc=boundaryneutral */,
  {    12,  2859,   568,  18,   2, PL_DT__NB }   /* decompositiontype=nb */,
  {     7,  6263,  7828,  10,   2, PL_LB__HY }   /* linebreak=hy */,
  {     3,  6890,    42,   4,  16, PL_CJKCOMPAT }   /* blk=cjkcompatibility */,
  {     0,    21,  4660,   3,  13, PL_ANCIENTSYMBOLS }   /* inancientsymbols */,
  {     3,  8777,  3223,   3,   3, -PL_CWL }   /* cwl=no */,
  {     0,  8096,  8544,   4,   4, PL_TAVT }   /* scx=tavt */,
  {     1,  8276,  7768,   4,   6, -PL_CWCM }   /* cwcm=false */,
  {     0,   974,  8916,  24,   2, PL_CCC__84 }   /* canonicalcombiningclass=84 */,
  {     0,  7136,  7145,   7,   7, PL_INBUGINESE }   /* block=buginese */,
  {     3,  7136,  7583,   6,   7, PL_INPHAGSPA }   /* block=phagspa */,
  {     3,  7380,  7727,   7,   2, PL_CCC__32 }   /* ccc=ccc32 */,
  {     0,  7380,  1108,   4,   3, PL_CCC__214 }   /* ccc=ata */,
  {     4,  8248,     1,   4,   1, PL_BPT__N }   /* bpt=n */,
  {     4,  1474,   723,  23,   4, PL_BPT__C }   /* bidipairedbrackettype=close */,
  {     4,  8196,  8735,   4,   3, PL_AGE__5_DOT_1 }   /* age=5.1 */,
  {    18,  1887,  3223,   9,   2, -PL_XPOSIXLOWER }   /* lowercase=n */,
  {     7,  5192,   247,   3,   2, PL_IDS }   /* isids */,
  {     8,  3129,  2044,  17,  11, PL_MTEI }   /* scriptextensions=meeteimayek */,
  {     0,  6362,     0,  11,   0, PL_SO }   /* othersymbol */,
  {     3,   974,  8899,  27,   2, PL_CCC__35 }   /* canonicalcombiningclass=ccc35 */,
  {     2,     1,     0,   1,   0, PL_N }   /* n */,
  {     0,  6263,  5777,  10,  12, PL_LB__HL }   /* linebreak=hebrewletter */,
  {     1,  8096,  7604,   4,   4, PL_SIDD }   /* scx=sidd */,
  {     0,  6890,  7780,   4,   6, PL_INCARIAN }   /* blk=carian */,
  {     0,  7336,     0,   8,   0, PL_UGAR }   /* ugaritic */,
  {     9,    76,  7762,   2,   3, PL_NT__DI }   /* nt=di */,
  {     0,  8240,  3446,   3,   3, PL_BC__RLI }   /* bc=rli */,
  {     1,  8026,   850,   3,  13, PL_PUA }   /* inprivateusearea */,
  {     0,  3526,  7997,  17,   2, PL_RI }   /* regionalindicator=y */,
  {     0,  2859,    45,  18,   6, PL_DT__COM }   /* decompositiontype=compat */,
  {    14,  8816,  7744,   3,   4, PL_NV__7000 }   /* nv=7000 */,
  {     0,  1963,  3223,   7,   3, -PL_RADICAL }   /* radical=no */,
  {     1,   184,  8308,   2,   4, PL_GURU }   /* isguru */,
  {     1,  8011,   107,   4,   5, PL_S }   /* gc=symbol */,
  {     6,  2859,  3690,  18,   3, PL_DT__FIN }   /* decompositiontype=fin */,
  {     2,  6613,  5778,   3,   5, PL_HEBR }   /* ishebrew */,
  {     0,  8076,     0,   5,   0, PL_PATWS }   /* patws */,
  {     4,   184,  1982,   3,   7, PL_CYRL }   /* iscyrillic */,
  {     2,  1417,  8937,   9,   2, PL_ZL }   /* category=zl */,
  {     0,  2877,     0,  13,   0, PL_DEVANAGARIEXT }   /* devanagariext */,
  {     5,  2044,     0,  11,   0, PL_MTEI }   /* meeteimayek */,
  {     0,  7674,     0,   7,   0, PL_UCASEXT }   /* ucasext */,
  {     9,   184,  7144,   2,   4, PL_BUGI }   /* isbugi */,
  {    10,  5051,  8256,   5,   4, PL_NFKDQC__N }   /* nfkdqc=no */,
  {     0,  8096,  7436,   4,   7, PL_ELBA }   /* scx=elbasan */,
  {     0,  7288,  8444,   7,   4, PL_OLCK }   /* script=olck */,
  {     3,  6890,   148,   4,  35, PL_DIACRITICALSSUP }   /* blk=combiningdiacriticalmarkssupplement */,
  {     2,  6890,  8046,   4,   5, PL_INLIMBU }   /* blk=limbu */,
  {     1,  1417,  6340,   9,  11, PL_LO }   /* category=otherletter */,
  {     1,  7459,  6989,   3,   9, PL_TALU }   /* sc=newtailue */,
  {     4,  7288,  4509,   7,  15, PL_SARB }   /* script=oldsoutharabian */,
  {     1,  8288,  7216,   3,   8, PL_DT__ISO }   /* dt=isolated */,
  {     1,   184,  7816,   2,   6, PL_GRBASE }   /* isgrbase */,
  {     0,  7457,  6716,   5,  10, PL_INSC__PUREKILLER }   /* insc=purekiller */,
  {     2,  1346,  5339,   5,  10, PL_GREEKEXT }   /* ingreekextended */,
  {     0,  3129,  6439,  17,  11, PL_SYLO }   /* scriptextensions=sylotinagri */,
  {     3,  7457,  2446,   5,  19, PL_INSC__CONSONANTHEADLETTER }   /* insc=consonantheadletter */,
  {     2,  4314,  5440,  13,  13, PL_JG__MALAYALAMNNNA }   /* joininggroup=malayalamnnna */,
  {     0,  4590,  3223,   2,   3, -PL_VS }   /* vs=no */,
  {     0,  7136,   808,   6,  18, PL_PHONETICEXT }   /* block=phoneticextensions */,
  {    10,  8096,  8500,   4,   4, PL_SARB }   /* scx=sarb */,
  {    37,  4599,     0,  15,   0, PL_LU }   /* uppercaseletter */,
  {     1,  6472,    34,  10,   6, PL_WB__EXTEND }   /* wordbreak=extend */,
  {     0,  7136,  4509,   6,  15, PL_SARB }   /* block=oldsoutharabian */,
  {     4,  2967,     0,   8,   0, PL_GEOR }   /* georgian */,
  {     1,  7136,  2128,   6,   6, PL_YIJING }   /* block=yijing */,
  {     0,  3129,  7870,  17,   4, PL_LEPC }   /* scriptextensions=lepc */,
  {     0,  5645,    23,  10,   2, PL_BC__AL }   /* bidiclass=al */,
  {     0,  1159,  3581,  25,   2, PL_CWKCF }   /* changeswhennfkccasefolded=t */,
  {     0,  3129,  7870,  17,   6, PL_LEPC }   /* scriptextensions=lepcha */,
  {     9,  8536,     0,   4,   0, PL_TALU }   /* talu */,
  {     5,  2369,     0,  20,   1, PL_VO__U }   /* verticalorientation=u */,
  {     4,   974,  8688,  24,   2, PL_CCC__26 }   /* canonicalcombiningclass=26 */,
  {     0,  5765,  7997,  12,   2, PL_GRBASE }   /* graphemebase=y */,
  {     4,  8798,  3581,   3,   2, PL_LOE }   /* loe=t */,
  {     1,  6890,  6005,   4,  12, PL_INOLDHUNGARIAN }   /* blk=oldhungarian */,
  {     5,  6890,  4104,   4,   8, PL_BAMUMSUP }   /* blk=bamumsup */,
  {     1,  2108,  7452,   4,   5, PL_INHANUNOO }   /* inhanunoo */,
  {     0,  8937,     0,   2,   0, PL_ZL }   /* zl */,
  {     1,  7136,  6029,   6,  12, PL_PHAISTOS }   /* block=phaistosdisc */,
  {     3,  7288,  5933,   7,  12, PL_GONM }   /* script=masaramgondi */,
  {     1,  8340,  8392,   3,   4, PL_JG__MEEM }   /* jg=meem */,
  {     0,  4314,  8131,  13,   5, PL_JG__ZHAIN }   /* joininggroup=zhain */,
  {     2,  2236,  8932,  10,   1, PL_L_AMP_ }   /* category=l& */,
  {     2,  7590,     0,   7,   0, PL_SHRD }   /* sharada */,
  {     2,  7136,  6882,   7,   8, PL_INBHAIKSUKI }   /* block=bhaiksuki */,
  {     2,  2100,  6363,   3,  10, PL_SO }   /* isothersymbol */,
  {     1,  7478,  2108,   3,   3, PL_SINH }   /* issinh */,
  {     0,  5544,  8148,  13,   4, PL_NV__1_SLASH_40 }   /* numericvalue=1/40 */,
  {     0,  7288,  7061,   7,   9, PL_SAMR }   /* script=samaritan */,
  {     0,  8096,  8528,   4,   4, PL_SYRC }   /* scx=syrc */,
  {     1,  6263,   223,  10,   2, PL_LB__PR }   /* linebreak=pr */,
  {     0,  8572,  3914,   3,   5, PL_WB__XX }   /* wb=other */,
  {     3,  1797,     0,  14,   0, PL_LM }   /* modifierletter */,
  {     5,  7457,  7981,   5,   5, PL_INSC__BINDU }   /* insc=bindu */,
  {     0,  8101,  7768,   5,   6, -PL_STERM }   /* sterm=false */,
  {    12,  7478,  6757,   3,   9, PL_SD }   /* issoftdotted */,
  {     0,  3129,  7351,  17,   4, PL_TALE }   /* scriptextensions=tale */,
  {     3,    42,     0,  36,   0, PL_CJKCOMPATIDEOGRAPHSSUP }   /* cjkcompatibilityideographssupplement */,
  {     5,  8816,  8703,   3,   2, PL_NV__34 }   /* nv=34 */,
  {     0,  3526,     0,  17,   0, PL_RI }   /* regionalindicator */,
  {     1,  7380,  7756,   4,   1, PL_CCC__9 }   /* ccc=9 */,
  {     0,  1417,   218,   9,   2, PL_PE }   /* category=pe */,
  {     0,  8121,  3223,   5,   2, -PL_UIDEO }   /* uideo=n */,
  {     8,   415,  7997,  11,   4, PL_IDEO }   /* ideographic=yes */,
  {     1,  6890,  1001,   4,  27, PL_ENCLOSEDCJK }   /* blk=enclosedcjklettersandmonths */,
  {     8,  3129,  8488,  17,   4, PL_RJNG }   /* scriptextensions=rjng */,
  {     0,  6329,  7096,  11,   3, PL_NT__NU }   /* numerictype=nu */,
  {     0,  4542,  8117,   3,   4, PL_TAML }   /* istamil */,
  {     2,   184,  1961,   3,  13, PL_CJKRADICALSSUP }   /* iscjkradicalssup */,
  {     1,  8196,  8864,   4,   3, PL_AGE__5 }   /* age=v50 */,
  {    64,    96,  7997,   5,   4, PL_XPOSIXALPHA }   /* alpha=yes */,
  {    11,  8340,  2437,   3,   3, PL_JG__YEH }   /* jg=yeh */,
  {     0,  7136,  7858,   6,   6, PL_INKHOJKI }   /* block=khojki */,
  {     0,  8340,  1353,   4,   2, PL_JG__GAF }   /* jg=gaf */,
  {     0,  8816,  8762,   3,   3, PL_NV__7_SLASH_8 }   /* nv=7/8 */,
  {     0,  7288,  7429,   7,   7, PL_DSRT }   /* script=deseret */,
  {     0,  8816,  8184,   3,   4, PL_NV__5_SLASH_12 }   /* nv=5/12 */,
  {     0,  6210,  1961,   3,  20, PL_CJKRADICALSSUP }   /* incjkradicalssupplement */,
  {    15,  1701,  3223,   2,   3, -PL_SD }   /* sd=no */,
  {     4,  8272,  7997,   4,   4, PL_CWCF }   /* cwcf=yes */,
  {     0,   974,  8168,  24,   2, PL_CCC__17 }   /* canonicalcombiningclass=17 */,
  {     0,  7288,  2149,   7,  20, PL_HLUW }   /* script=anatolianhieroglyphs */,
  {    26,  7288,  8192,   7,   4, PL_SC__ADLM }   /* script=adlm */,
  {    10,  8376,  3521,   3,   5, PL_LB__SP }   /* lb=space */,
  {     0,   184,  7200,   2,   8, PL_GURU }   /* isgurmukhi */,
  {     4,  8011,  8931,   3,   2, PL_L_AMP_ }   /* gc=l& */,
  {     9,  8096,  5400,   5,   7, PL_BALI }   /* scx=balinese */,
  {     3,  7459,  5957,   3,   4, PL_MEND }   /* sc=mend */,
  {     1,  3129,  8220,  17,   4, PL_ARMN }   /* scriptextensions=armn */,
  {     0,  6890,  5596,   4,  13, PL_VERTICALFORMS }   /* blk=verticalforms */,
  {     8,  6219,  7768,  11,   2, -PL_JOINC }   /* joincontrol=f */,
  {     2,  6890,   382,   4,  33, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* blk=supplementalsymbolsandpictographs */,
  {     1,   974,  7941,  27,   2, PL_CCC__11 }   /* canonicalcombiningclass=ccc11 */,
  {     0,  7227,    62,   5,   5, PL_POSIXGRAPH }   /* posixgraph */,
  {     0,  5245,  7768,  13,   6, -PL_POSIXXDIGIT }   /* asciihexdigit=false */,
  {     0,   184,  6953,   2,   9, PL_LATINEXTD }   /* islatinextd */,
  {    26,  6329,  7762,  11,   3, PL_NT__DI }   /* numerictype=di */,
  {     1,  6706,  8873,  10,   3, PL_IN__6 }   /* presentin=v60 */,
  {     1,  1206,  1813,   3,  14, PL_TRANSPORTANDMAP }   /* intransportandmap */,
  {    14,  7459,  8236,   3,   4, PL_BATK }   /* sc=batk */,
  {     0,  5544,  5219,  13,   6, PL_NV__100000 }   /* numericvalue=100000 */,
  {    10,  2229,  3003,  16,  18, PL_PI }   /* generalcategory=initialpunctuation */,
  {     7,  7288,  3458,   7,  10, PL_SC__MANI }   /* script=manichaean */,
  {     0,  8376,  1886,   3,   2, PL_LB__NL }   /* lb=nl */,
  {     0,  8340,  4911,   3,  14, PL_JG__MANICHAEANAYIN }   /* jg=manichaeanayin */,
  {     0,  7136,  7394,   6,   7, PL_CJKEXTB }   /* block=cjkextb */,
  {     0,  8204,  7997,   4,   2, PL_POSIXXDIGIT }   /* ahex=y */,
  {     0,  7288,  6626,   7,  10, PL_KHAR }   /* script=kharoshthi */,
  {     0,  3129,  4104,  17,   4, PL_BAMU }   /* scriptextensions=bamu */,
  {     5,  7478,  6440,   3,   3, PL_SYLO }   /* issylo */,
  {     0,  7288,  7034,   7,   4, PL_PALM }   /* script=palm */,
  {     3,  8011,     7,   3,   1, PL_C }   /* gc=c */,
  {     0,  7459,  8416,   3,   4, PL_SC__MYMR }   /* sc=mymr */,
  {    17,  6890,  1234,   4,  24, PL_ARABICPFA }   /* blk=arabicpresentationformsa */,
  {     1,  8021,  3223,   5,   3, -PL_GREXT }   /* grext=no */,
  {     1,  7457,  4058,   5,  16, PL_INSC__VOWELINDEPENDENT }   /* insc=vowelindependent */,
  {     8,  7459,  7810,   3,   4, PL_GOTH }   /* sc=goth */,
  {     0,  7459,  7312,   3,   8, PL_SC__TAGB }   /* sc=tagbanwa */,
  {     0,  8196,  8768,   4,   3, PL_AGE__9 }   /* age=9.0 */,
  {    65,  2065,  7997,  21,   4, PL_NCHAR }   /* noncharactercodepoint=yes */,
  {     0,  6219,  3581,  11,   2, PL_JOINC }   /* joincontrol=t */,
  {     7,  2023,     0,  21,   0, PL_LOE }   /* logicalorderexception */,
  {     2,  5544,  8703,  13,   2, PL_NV__34 }   /* numericvalue=34 */,
  {     0,  8196,  8612,   4,   3, PL_IN__1_DOT_1 }   /* age=1.1 */,
  {     0,   117,   448,   3,  17, PL_IDEOGRAPHICSYMBOLS }   /* inideographicsymbols */,
  {     5,  8096,  5957,   4,   4, PL_MEND }   /* scx=mend */,
  {     2,  6706,  8735,  10,   3, PL_IN__5_DOT_1 }   /* presentin=5.1 */,
  {     1,  7459,  7152,   3,   8, PL_SC__DUPL }   /* sc=duployan */,
  {     0,  3129,  7010,  17,   4, PL_ITAL }   /* scriptextensions=ital */,
  {     2,  1426,  5205,  22,  14, PL_INSC__VOWELDEPENDENT }   /* indicsyllabiccategory=voweldependent */,
  {     7,  5544,  7744,  13,   6, PL_NV__700000 }   /* numericvalue=700000 */,
  {     7,   974,  2590,  24,   2, PL_CCC__1 }   /* canonicalcombiningclass=ov */,
  {    13,  7224,  2985,   3,   3, PL_XIDS }   /* isxids */,
  {     0,  3129,  7208,  17,   4, PL_HIRA }   /* scriptextensions=hira */,
  {     0,   974,  8897,  24,   2, PL_CCC__19 }   /* canonicalcombiningclass=19 */,
  {     6,  7459,  7336,   3,   8, PL_UGAR }   /* sc=ugaritic */,
  {     7,  4479,  7373,   5,   7, PL_NFCQC__M }   /* nfkcqc=maybe */,
  {     0,  1929,  3223,   9,   3, -PL_XPOSIXUPPER }   /* uppercase=no */,
  {     3,  3129,  7366,  17,   7, PL_BENG }   /* scriptextensions=bengali */,
  {     0,  7380,  8899,   4,   2, PL_CCC__35 }   /* ccc=35 */,
  {     0,  4524,     0,  15,   0, PL_PS }   /* openpunctuation */,
  {     0,  5957,     0,  12,   0, PL_MEND }   /* mendekikakui */,
  {     0,  8340,  7961,   3,   5, PL_JG__ALAPH }   /* jg=alaph */,
  {     0,  3037,     0,   3,   0, PL_ALL }   /* all */,
  {     0,   974,  8633,  24,   3, PL_CCC__103 }   /* canonicalcombiningclass=103 */,
  {     0,  1566,     0,   6,   0, PL_HANG }   /* hangul */,
  {     2,  6472,   698,  10,   2, PL_WB__MN }   /* wordbreak=mn */,
  {     2,  3129,  6696,  17,  10, PL_PHNX }   /* scriptextensions=phoenician */,
  {     7,   974,  8639,  27,   3, PL_CCC__118 }   /* canonicalcombiningclass=ccc118 */,
  {     0,  6484,  3581,  10,   2, PL_IDC }   /* idcontinue=t */,
  {    39,  4010,     0,  16,   0, PL_TANGUTCOMPONENTS }   /* tangutcomponents */,
  {     2,  8376,  4897,   3,  14, PL_LB__BK }   /* lb=mandatorybreak */,
  {     2,  7136,  7312,   6,   8, PL_INTAGBANWA }   /* block=tagbanwa */,
  {     0,  5245,     0,  13,   0, PL_POSIXXDIGIT }   /* asciihexdigit */,
  {     4,  4554,    69,  14,   2, PL_SB__UP }   /* sentencebreak=up */,
  {     0,  2229,   112,  16,   2, PL_SC }   /* generalcategory=sc */,
  {     0,  3129,  6439,  17,   4, PL_SYLO }   /* scriptextensions=sylo */,
  {     2,   184,  6806,   2,   4, PL_WARA }   /* iswara */,
  {     0,  5375,  6165,  13,  10, PL_JT__D }   /* joiningtype=dualjoining */,
  {     3,   250,     0,  33,   0, PL_DIACRITICALSEXT }   /* combiningdiacriticalmarksextended */,
  {     4,   184,  5645,   2,   5, PL_BIDIC }   /* isbidic */,
  {     4,  8340,  6526,   3,  10, PL_JG__AFRICANQAF }   /* jg=africanqaf */,
  {     3,  2088,     0,   2,   0, PL_PD }   /* pd */,
  {     1,  8336,  7662,   4,   5, PL_INTIRHUTA }   /* intirhuta */,
  {     0,  6890,  3147,   4,  18, PL_TAIXUANJING }   /* blk=taixuanjingsymbols */,
  {     3,  7894,  7951,   6,   5, PL_PATSYN }   /* patsyn=true */,
  {    41,  1448,  3562,   4,  15, PL_SUTTONSIGNWRITING }   /* insuttonsignwriting */,
  {     6,  6890,   808,   4,  11, PL_PHONETICEXT }   /* blk=phoneticext */,
  {     2,   184,  2044,   2,  21, PL_MEETEIMAYEKEXT }   /* ismeeteimayekextensions */,
  {     0,  7660,     0,   7,   0, PL_TIRH }   /* tirhuta */,
  {    13,  6647,  3290,   4,  15, PL_AGHB }   /* iscaucasianalbanian */,
  {     1,  6890,  1691,   4,  11, PL_NUMBERFORMS }   /* blk=numberforms */,
  {     0,  2229,  5135,  16,  14, PL_ZS }   /* generalcategory=spaceseparator */,
  {     2,   184,  2484,   2,   4, PL_EGYP }   /* isegyp */,
  {     1,  4314,  5492,  13,  13, PL_JG__MANICHAEANTAW }   /* joininggroup=manichaeantaw */,
  {     0,  7136,  4419,   6,  15, PL_MISCPICTOGRAPHS }   /* block=miscpictographs */,
  {     1,  1918,  7768,  21,   2, -PL_CWU }   /* changeswhenuppercased=f */,
  {     0,  3129,  6736,  17,  10, PL_SAUR }   /* scriptextensions=saurashtra */,
  {     4,  7380,   226,   4,   2, PL_CCC__BL }   /* ccc=bl */,
  {     2,  2229,     7,  16,   1, PL_C }   /* generalcategory=c */,
  {     1,  7288,  7882,   7,   4, PL_LYDI }   /* script=lydi */,
  {     0,  8508,  7883,   4,   3, PL_LYDI }   /* sc=lydi */,
  {    54,  8096,  8260,   4,   4, PL_CAKM }   /* scx=cakm */,
  {     1,  7457,  1520,   5,  23, PL_INSC__CONSONANTPRECEDINGREPHA }   /* insc=consonantprecedingrepha */,
  {    18,  6373,     0,  11,   0, PL_HMNG }   /* pahawhhmong */,
  {     0,  8340,  3802,   3,  16, PL_JG__MANICHAEANLAMEDH }   /* jg=manichaeanlamedh */,
  {    24,  8240,    16,   3,   1, PL_BC__B }   /* bc=b */,
  {     0,  7288,  7918,   7,   6, PL_SC__THAA }   /* script=thaana */,
  {     5,  6890,  4855,   4,  14, PL_LATINEXTC }   /* blk=latinextendedc */,
  {     0,  2108,  4800,   3,  13, PL_HIGHSURROGATES }   /* inhighsurrogates */,
  {     5,   513,  7768,  16,   6, -PL_UIDEO }   /* unifiedideograph=false */,
  {     7,   361,     0,  21,   0, PL_MATHOPERATORS }   /* mathematicaloperators */,
  {     1,  8096,  8066,   4,   5, PL_ORYA }   /* scx=oriya */,
  {     2,   974,  6131,  24,  11, PL_CCC__DA }   /* canonicalcombiningclass=doubleabove */,
  {     1,  7288,  8448,   7,   4, PL_ORKH }   /* script=orkh */,
  {     6,  7288,  7351,   7,   4, PL_SC__TALE }   /* script=tale */,
  {     8,  3509,  7997,  17,   4, PL_PATWS }   /* patternwhitespace=yes */,
  {     1,  7459,  2004,   5,  19, PL_PRTI }   /* sc=inscriptionalparthian */,
  {     0,  4402,   284,   3,  32, PL_MISCMATHSYMBOLSA }   /* inmiscellaneousmathematicalsymbolsa */,
  {    64,  7120,     0,   8,   0, PL_BALI }   /* balinese */,
  {     1,  3129,  8440,  17,   4, PL_OGAM }   /* scriptextensions=ogam */,
  {    12,  7288,  8408,   7,   4, PL_MRO }   /* script=mroo */,
  {     0,  7858,     0,   6,   0, PL_KHOJ }   /* khojki */,
  {     2,  1701,  7768,   2,   6, -PL_SD }   /* sd=false */,
  {     4,  3129,  7061,  17,   9, PL_SAMR }   /* scriptextensions=samaritan */,
  {     1,  4402,  2637,   3,   8, PL_INMONGOLIAN }   /* inmongolian */,
  {     1,  7288,  8604,   7,   4, PL_SC__ZYYY }   /* script=zyyy */,
  {     4,  4923,  5827,   4,  10, PL_MAHJONG }   /* inmahjongtiles */,
  {     1,   184,  5657,   2,   5, PL_BIDIM }   /* isbidim */,
  {     0,    11,  7997,   2,   2, PL_DI }   /* di=y */,
  {     1,  1417,  3084,   9,   9, PL_Z }   /* category=separator */,
  {    10,  2229,  1621,  16,   6, PL_CF }   /* generalcategory=format */,
  {     4,  2465,     0,  11,   0, PL_COUNTINGROD }   /* countingrod */,
  {     0,  7136,  4813,   6,  14, PL_KANASUP }   /* block=kanasupplement */,
  {     6,  2249,     0,  20,   0, PL_GLAGOLITICSUP }   /* glagoliticsupplement */,
  {     3,  2229,    47,  16,   1, PL_M }   /* generalcategory=m */,
  {     0,  8096,  8580,   4,   4, PL_XPEO }   /* scx=xpeo */,
  {     4,  8376,  4673,   3,  14, PL_LB__CR }   /* lb=carriagereturn */,
  {     0,  8340,  8131,   3,   5, PL_JG__ZHAIN }   /* jg=zhain */,
  {    21,  8572,  3526,   3,  17, PL_RI }   /* wb=regionalindicator */,
  {     0,  5192,   358,   3,   3, PL_ITAL }   /* isital */,
  {     6,  8096,  8296,   4,   4, PL_GONM }   /* scx=gonm */,
  {     0,  8240,    24,   3,   1, PL_BC__L }   /* bc=l */,
  {     0,  5645,  5621,  10,  12, PL_BC__AL }   /* bidiclass=arabicletter */,
  {     0,  7232,     0,   8,   0, PL_JAMOEXTA }   /* jamoexta */,
  {     0,  6406,     0,   4,   0, PL_SORA }   /* sora */,
  {    10,   184,  2503,   2,  19, PL_ENCLOSEDALPHANUMSUP }   /* isenclosedalphanumsup */,
  {     0,  7136,  1108,   7,   4, PL_INBATAK }   /* block=batak */,
  {     0,  3129,  4134,  17,   4, PL_BRAI }   /* scriptextensions=brai */,
  {    15,  6890,  7152,   4,   8, PL_INDUPLOYAN }   /* blk=duployan */,
  {     0,   184,  3357,   3,  16, PL_CYRILLICEXTC }   /* iscyrillicextendedc */,
  {     0,  8096,  7016,   4,   9, PL_PERM }   /* scx=oldpermic */,
  {     0,  5544,  8171,  13,   2, PL_NV__23 }   /* numericvalue=23 */,
  {     1,  4542,  1909,   3,   4, PL_LT }   /* istitle */,
  {     4,  8816,  5219,   3,   2, PL_NV__10 }   /* nv=10 */,
  {     2,  2229,  8263,  16,   2, PL_MC }   /* generalcategory=mc */,
  {     8,   184,  7192,   2,   8, PL_GUJR }   /* isgujarati */,
  {    11,  5375,  6656,  12,  10, PL_JT__U }   /* joiningtype=nonjoining */,
  {     1,  7689,   698,   4,   2, PL_ARMN }   /* isarmn */,
  {     1,  8096,    57,   4,   2, PL_YI }   /* scx=yi */,
  {     0,  6890,  2503,   4,  19, PL_ENCLOSEDALPHANUMSUP }   /* blk=enclosedalphanumsup */,
  {     5,  5583,  3581,  13,   2, PL_QMARK }   /* quotationmark=t */,
  {     1,  8196,  7744,   4,   1, PL_AGE__7 }   /* age=7 */,
  {     3,  7994,  7769,   4,   5, -PL_IDC }   /* idc=false */,
  {     4,  3521,  7768,   5,   2, -PL_XPOSIXSPACE }   /* space=f */,
  {    14,  8288,  3003,   3,   7, PL_DT__INIT }   /* dt=initial */,
  {     2,  7288,  6414,   8,   3, PL_SC__BENG }   /* script=beng */,
  {     0,  6646,     0,  10,   0, PL_MISCARROWS }   /* miscarrows */,
  {     0,  8572,  6153,   3,  11, PL_WB__DQ }   /* wb=doublequote */,
  {     0,  8376,  7280,   3,   8, PL_LB__NL }   /* lb=nextline */,
  {     7,  6890,  4010,   4,  16, PL_TANGUTCOMPONENTS }   /* blk=tangutcomponents */,
  {     1,  8096,  7780,   4,   6, PL_CARI }   /* scx=carian */,
  {     0,  8096,  7320,   4,   8, PL_TFNG }   /* scx=tifinagh */,
  {     5,  2100,  4496,   4,  13, PL_NARB }   /* isoldnortharabian */,
  {    16,  5645,   435,  10,   2, PL_BC__ON }   /* bidiclass=on */,
  {     0,   186,  3223,   2,   3, -PL_CE }   /* ce=no */,
  {     1,  3129,  7128,  17,   4, PL_BASS }   /* scriptextensions=bass */,
  {     0,   184,  1497,   2,  14, PL_BYZANTINEMUSIC }   /* isbyzantinemusic */,
  {     4,  6890,   836,   4,  28, PL_SUPPUAA }   /* blk=supplementaryprivateuseareaa */,
  {     0,  8240,  3930,   3,  16, PL_BC__S }   /* bc=segmentseparator */,
  {     0,  1746,   852,  21,   1, PL_GCB__V }   /* graphemeclusterbreak=v */,
  {     0,  2636,     0,   4,   0, PL_MONG }   /* mong */,
  {    13,  2236,     0,  10,   1, PL_LU }   /* category=lu */,
  {     1,  8340,  4344,   3,  15, PL_JG__MANICHAEANALEPH }   /* jg=manichaeanaleph */,
  {     3,    84,     0,   4,   0, PL_MATH }   /* math */,
  {     6,  1963,  3223,   7,   2, -PL_RADICAL }   /* radical=n */,
  {     9,   184,  1797,   2,  14, PL_LM }   /* ismodifierletter */,
  {     0,  1540,     0,   4,   0, PL_PHAG }   /* phag */,
  {     1,  8504,   112,   3,   2, PL_SB__SC }   /* sb=sc */,
  {     4,  8096,  1107,   4,   8, PL_KANA }   /* scx=katakana */,
  {     0,  7894,  7997,   6,   2, PL_PATSYN }   /* patsyn=y */,
  {     1,  3129,  8452,  17,   4, PL_ORYA }   /* scriptextensions=orya */,
  {    15,  7136,  4827,   6,   6, PL_KANGXI }   /* block=kangxi */,
  {     0,  6890,  1589,   4,   9, PL_LATINEXTE }   /* blk=latinexte */,
  {     1,  7136,   113,   6,  25, PL_DIACRITICALS }   /* block=combiningdiacriticalmarks */,
  {     4,  6210,    43,   3,  15, PL_CJKCOMPAT }   /* incjkcompatibility */,
  {     0,   184,  6307,   2,  11, PL_MYANMAREXTA }   /* ismyanmarexta */,
  {     2,  1929,  3581,   9,   2, PL_XPOSIXUPPER }   /* uppercase=t */,
  {     3,  8816,  5219,   3,   4, PL_NV__1000 }   /* nv=1000 */,
  {     3,  8240,  8825,   3,   3, PL_BC__PDF }   /* bc=pdf */,
  {     0,  5583,  7768,  13,   2, -PL_QMARK }   /* quotationmark=f */,
  {     4,  2541,     0,  19,   0, PL_JAMOEXTA }   /* hanguljamoextendeda */,
  {     0,  4074,  6486,  15,   8, PL__PERL_CHARNAME_CONTINUE }   /* _perl_charname_continue */,
  {    33,  7798,  7768,   6,   6, -PL_COMPEX }   /* compex=false */,
  {     0,  1886,     0,   2,   0, PL_NL }   /* nl */,
  {     2,  2859,  8831,  18,   3, PL_DT__SML }   /* decompositiontype=sml */,
  {     9,   249,  2777,   5,   5, PL_CCC__A }   /* _combabove */,
  {     6,  8196,  7756,   4,   1, PL_AGE__9 }   /* age=9 */,
  {     5,  4590,  7768,   2,   2, -PL_VS }   /* vs=f */,
  {     0,  8096,  7312,   4,   4, PL_TAGB }   /* scx=tagb */,
  {     0,  7288,  8492,   7,   4, PL_RUNR }   /* script=runr */,
  {     6,  7136,  8106,   6,   5, PL_INTAILE }   /* block=taile */,
  {    10,  7136,   750,   6,  29, PL_ENCLOSEDIDEOGRAPHICSUP }   /* block=enclosedideographicsupplement */,
  {     1,  6890,   283,   4,  33, PL_MISCMATHSYMBOLSA }   /* blk=miscellaneousmathematicalsymbolsa */,
  {     0,  6263,  5753,  10,   4, PL_LB__GL }   /* linebreak=glue */,
  {     1,  8096,  8324,   4,   4, PL_HMNG }   /* scx=hmng */,
  {     1,  7288,  8304,   7,   4, PL_SC__GUJR }   /* script=gujr */,
  {     0,  2465,     0,  19,   0, PL_COUNTINGROD }   /* countingrodnumerals */,
  {     1,  8006,  7997,   5,   2, PL_CWKCF }   /* cwkcf=y */,
  {     2,  1929,  7768,   9,   2, -PL_XPOSIXUPPER }   /* uppercase=f */,
  {     0,  6586,     0,  10,   0, PL_CJKSTROKES }   /* cjkstrokes */,
  {     0,  8096,  2409,   5,   5, PL_BRAH }   /* scx=brahmi */,
  {     2,  8504,    34,   3,   2, PL_SB__EX }   /* sb=ex */,
  {     3,  1981,     0,  11,   0, PL_CYRILLICSUP }   /* cyrillicsup */,
  {     0,  8344,    18,   3,   1, PL_JT__R }   /* jt=r */,
  {     0,  4542,  8107,   3,   4, PL_TALE }   /* istaile */,
  {    20,  8344,  6656,   3,  10, PL_JT__U }   /* jt=nonjoining */,
  {     2,  3526,  7951,  17,   5, PL_RI }   /* regionalindicator=true */,
  {     3,  5657,  7997,   5,   4, PL_BIDIM }   /* bidim=yes */,
  {     2,  8376,  2440,   3,   2, PL_LB__BA }   /* lb=ba */,
  {     0,  3129,  8348,  17,   4, PL_KALI }   /* scriptextensions=kali */,
  {     0,  8016,  4047,   4,   3, PL_LB__H3 }   /* gcb=lvt */,
  {     0,  1887,  7951,   9,   5, PL_XPOSIXLOWER }   /* lowercase=true */,
  {     3,  2107,     0,   4,   0, PL_SINH }   /* sinh */,
  {     9,    21,  1107,   2,  26, PL_KATAKANAEXT }   /* inkatakanaphoneticextensions */,
  {     2,   184,   114,   3,  24, PL_DIACRITICALS }   /* iscombiningdiacriticalmarks */,
  {     0,  3237,     0,  10,   0, PL_ALCHEMICAL }   /* alchemical */,
  {     7,  7459,  6008,   3,   4, PL_HUNG }   /* sc=hung */,
  {     1,  8376,   807,   3,   2, PL_LB__SP }   /* lb=sp */,
  {     0,  8276,  7997,   4,   2, PL_CWCM }   /* cwcm=y */,
  {     0,  8096,  7646,   4,   7, PL_TAVT }   /* scx=taiviet */,
  {     5,  8086,     0,   5,   0, PL_QMARK }   /* qmark */,
  {    16,   184,  1001,   2,  27, PL_ENCLOSEDCJK }   /* isenclosedcjklettersandmonths */,
  {     1,  7611,     0,   4,   0, PL_SOYO }   /* soyo */,
  {     1,  3424,  7997,  17,   4, PL_IDSB }   /* idsbinaryoperator=yes */,
  {     0,  2100,  7009,   4,   7, PL_ITAL }   /* isolditalic */,
  {     2,  8096,  5777,   4,   6, PL_HEBR }   /* scx=hebrew */,
  {     1,  1658,     0,  19,   0, PL_CJKCOMPATIDEOGRAPHS }   /* cjkcompatideographs */,
  {     0,  7459,  7822,   3,   4, PL_HATR }   /* sc=hatr */,
  {     1,  6890,  7043,   4,   9, PL_INPAUCINHAU }   /* blk=paucinhau */,
  {     1,  2750,  7997,  19,   4, PL_TERM }   /* terminalpunctuation=yes */,
  {     4,  8096,  8456,   4,   4, PL_OSGE }   /* scx=osge */,
  {     6,  1206,  2117,   3,   3, PL_INTHAI }   /* inthai */,
  {     0,  1448,  7621,   5,   4, PL_SUPPUAA }   /* insuppuaa */,
  {     0,  6706,  8858,  10,   3, PL_IN__4 }   /* presentin=v40 */,
  {     7,  6890,  5414,   4,  13, PL_LOWSURROGATES }   /* blk=lowsurrogates */,
  {     0,  6713,  6796,   3,  10, PL_AGE__NA }   /* in=unassigned */,
  {     2,  7136,  2814,   6,   9, PL_HALFMARKS }   /* block=halfmarks */,
  {     0,  7344,  7997,   8,   2, PL_XIDS }   /* xidstart=y */,
  {     1,  8816,  7750,   3,   1, PL_NV__8 }   /* nv=8 */,
  {     2,   184,  8002,   3,   4, PL_XPOSIXCNTRL }   /* iscntrl */,
  {     1,  1448,  3995,   3,   5, PL_INSYRIAC }   /* insyriac */,
  {     1,  7136,  1209,   6,  25, PL_SUPERANDSUB }   /* block=superscriptsandsubscripts */,
  {     0,  6890,  2560,   4,  19, PL_JAMOEXTB }   /* blk=hanguljamoextendedb */,
  {     8,  7429,     0,   7,   0, PL_DSRT }   /* deseret */,
  {     1,  7288,  8232,   7,   4, PL_AVST }   /* script=avst */,
  {     0,  5544,  7710,  13,   1, PL_NV__6 }   /* numericvalue=6 */,
  {     2,   184,  3770,   2,  16, PL_LINEARBSYLLABARY }   /* islinearbsyllabary */,
  {     0,  3129,  8380,  17,   4, PL_LINA }   /* scriptextensions=lina */,
  {     5,  7288,  7513,   7,   7, PL_SC__MAND }   /* script=mandaic */,
  {    16,  1448,  2108,   3,  20, PL_SINHALAARCHAICNUMBERS }   /* insinhalaarchaicnumbers */,
  {    12,  7459,  6676,   3,  10, PL_XPEO }   /* sc=oldpersian */,
  {     8,  4464,  8256,   4,   4, PL_DT__CAN }   /* nfdqc=no */,
  {     4,   468,     0,  11,   0, PL_P }   /* punctuation */,
  {     1,    21,  3441,   2,  17, PL_LETTERLIKESYMBOLS }   /* inletterlikesymbols */,
  {     0,  7696,  3581,   6,   2, PL_XPOSIXSPACE }   /* wspace=t */,
  {     1,  7136,    78,   6,   6, PL_INARABIC }   /* block=arabic */,
  {    12,  8101,  7997,   5,   2, PL_STERM }   /* sterm=y */,
  {     1,  5544,  8618,  13,   3, PL_NV__1_SLASH_5 }   /* numericvalue=1/5 */,
  {     2,  6890,  8126,   4,   5, PL_VSSUP }   /* blk=vssup */,
  {     0,  1202,  7997,   3,   2, PL_DEP }   /* dep=y */,
  {     9,  8816,  8674,   3,   2, PL_NV__42 }   /* nv=42 */,
  {     2,  3994,     0,   6,   0, PL_SYRC }   /* syriac */,
  {     0,  5544,  7744,  13,   3, PL_NV__700 }   /* numericvalue=700 */,
  {     1,  6890,  8071,   4,   5, PL_INOSAGE }   /* blk=osage */,
  {     7,  7478,  3995,   3,   8, PL_SYRIACSUP }   /* issyriacsup */,
  {     1,   184,  2788,   3,   3, PL_CHER }   /* ischer */,
  {     3,  6706,  8738,  10,   3, PL_IN__5_DOT_2 }   /* presentin=5.2 */,
  {     0,   184,    18,   2,   2, PL_RI }   /* isri */,
  {     0,  8096,  3611,   5,   3, PL_BOPO }   /* scx=bopo */,
  {     0,  8026,  3165,   5,  10, PL_INPC__TOPANDLEFT }   /* inpc=topandleft */,
  {     0,  3111,     0,  18,   0, PL_RUMI }   /* ruminumeralsymbols */,
  {     0,  8248,  4524,   4,   4, PL_BPT__O }   /* bpt=open */,
  {     0,  3129,  8556,  17,   4, PL_THAI }   /* scriptextensions=thai */,
  {    67,  4063,  7431,   4,   5, PL_DSRT }   /* indeseret */,
  {     0,  1417,   699,   9,   6, PL_N }   /* category=number */,
  {     0,  3373,     8,  15,   1, PL_EA__A }   /* eastasianwidth=a */,
  {     0,  6546,     0,  10,   0, PL_ASCII }   /* basiclatin */,
  {    15,  6263,  2284,  10,   2, PL_LB__HL }   /* linebreak=hl */,
  {     1,  6890,  4104,   4,   5, PL_INBAMUM }   /* blk=bamum */,
  {     0,  6713,  8759,   3,   3, PL_IN__7 }   /* in=7.0 */,
  {     3,  7288,  7653,   7,   7, PL_TIBT }   /* script=tibetan */,
  {    33,  7288,  2484,   7,   4, PL_EGYP }   /* script=egyp */,
  {    24,  7380,  8646,   7,   2, PL_CCC__29 }   /* ccc=ccc29 */,
  {    23,  1503,  3391,   3,  10, PL_ETHIOPICEXT }   /* inethiopicext */,
  {     5,  6647,   958,   4,   2, PL_CAKM }   /* iscakm */,
  {     1,  6890,  4813,   4,  14, PL_KANASUP }   /* blk=kanasupplement */,
  {     0,  7136,  5245,   6,   5, PL_ASCII }   /* block=ascii */,
  {     2,  1918,  7768,  21,   6, -PL_CWU }   /* changeswhenuppercased=false */,
  {     0,  7459,  8320,   3,   4, PL_HLUW }   /* sc=hluw */,
  {     3,  8816,  8168,   3,   4, PL_NV__17_SLASH_2 }   /* nv=17/2 */,
  {     1,   415,     0,  11,   0, PL_IDEO }   /* ideographic */,
  {     0,  7380,  8164,   4,   2, PL_CCC__15 }   /* ccc=15 */,
  {     1,  3129,  2249,  17,  10, PL_GLAG }   /* scriptextensions=glagolitic */,
  {     1,  5544,  7732,  13,   3, PL_NV__500 }   /* numericvalue=500 */,
  {     1,  2229,  8939,  16,   2, PL_ZP }   /* generalcategory=zp */,
  {     3,  1746,     0,  23,   0, PL_GCB__SM }   /* graphemeclusterbreak=sm */,
  {     1,   974,  5219,  27,   2, PL_CCC__10 }   /* canonicalcombiningclass=ccc10 */,
  {     1,  5192,  3004,   3,  17, PL_PI }   /* isinitialpunctuation */,
  {     0,  4554,    34,  14,   2, PL_SB__EX }   /* sentencebreak=ex */,
  {     2,  8572,  5753,   3,  12, PL_WB__GAZ }   /* wb=glueafterzwj */,
  {     0,  7478,  2750,   3,   4, PL_STERM }   /* issterm */,
  {     0,  6890,  5717,   4,  12, PL_ETHIOPICEXTA }   /* blk=ethiopicexta */,
  {     1,  7288,  2044,   7,  11, PL_MTEI }   /* script=meeteimayek */,
  {    40,  1402,  1704,   4,  10, PL_DIACRITICALS }   /* indiacriticals */,
  {     1,   218,  6472,   4,   4, PL_POSIXWORD }   /* perlword */,
  {     8,  6890,  7870,   4,   6, PL_INLEPCHA }   /* blk=lepcha */,
  {     0,  8584,     0,   4,   0, PL_XSUX }   /* xsux */,
  {     2,  7459,  8300,   3,   4, PL_SC__GREK }   /* sc=grek */,
  {     1,  8096,  8436,   4,   4, PL_NSHU }   /* scx=nshu */,
  {     0,  3129,  8360,  17,   4, PL_KTHI }   /* scriptextensions=kthi */,
  {    12,  3129,  3566,  17,  11, PL_SGNW }   /* scriptextensions=signwriting */,
  {     0,  5544,  8862,  13,   2, PL_NV__41 }   /* numericvalue=41 */,
  {     0,  7459,  7120,   3,   8, PL_BALI }   /* sc=balinese */,
  {    27,  7689,  3596,   4,   7, PL_ARABICSUP }   /* isarabicsup */,
  {     0,  7288,  6980,   7,   9, PL_NBAT }   /* script=nabataean */,
  {     3,  5583,  7997,  13,   4, PL_QMARK }   /* quotationmark=yes */,
  {    10,    21,   948,   3,  26, PL_ANCIENTGREEKMUSIC }   /* inancientgreekmusicalnotation */,
  {     3,   184,  3690,   2,  16, PL_PF }   /* isfinalpunctuation */,
  {     0,  5544,  5219,  13,   5, PL_NV__10000 }   /* numericvalue=10000 */,
  {     0,  1503,  2896,   3,  10, PL_ETHIOPICSUP }   /* inethiopicsup */,
  {     0,  7136,  5388,   6,  13, PL_KANAEXTA }   /* block=kanaextendeda */,
  {     0,    96,     0,  10,   0, PL_XPOSIXALPHA }   /* alphabetic */,
  {     1,     7,     0,  18,   0, PL_CANS }   /* canadianaboriginal */,
  {     5,  6890,  3147,   4,  11, PL_TAIXUANJING }   /* blk=taixuanjing */,
  {     4,  3882,     0,   7,   0, PL_MYMR }   /* myanmar */,
  {     0,   184,  7409,   3,   6, PL_CJKEXTD }   /* iscjkextd */,
  {     5,  8101,  3223,   5,   3, -PL_STERM }   /* sterm=no */,
  {     1,  1417,  3005,  11,  16, PL_PI }   /* category=initialpunctuation */,
  {     0,  8376,  4194,   3,  15, PL_LB__CB }   /* lb=contingentbreak */,
  {     1,  1417,  5079,   9,  14, PL_MN }   /* category=nonspacingmark */,
  {     0,  7136,  2560,   6,  19, PL_JAMOEXTB }   /* block=hanguljamoextendedb */,
  {    28,  7380,  8655,   7,   2, PL_CCC__33 }   /* ccc=ccc33 */,
  {     0,  6329,  7096,  11,   8, PL_NT__NU }   /* numerictype=numeric */,
  {     5,   117,  1688,   4,  14, PL_INDICNUMBERFORMS }   /* inindicnumberforms */,
  {     2,   947,     0,  17,   0, PL_ANCIENTGREEKMUSIC }   /* ancientgreekmusic */,
  {     1,  7136,   836,   6,  28, PL_SUPPUAA }   /* block=supplementaryprivateuseareaa */,
  {     3,  1426,  5999,  22,   6, PL_LB__ZWJ }   /* indicsyllabiccategory=joiner */,
  {    25,  6890,  7144,   4,   8, PL_INBUGINESE }   /* blk=buginese */,
  {     4,  6676,     0,  10,   0, PL_XPEO }   /* oldpersian */,
  {     8,  3129,  4404,  17,  15, PL_MERC }   /* scriptextensions=meroiticcursive */,
  {     0,    34,  3223,   3,   2, -PL_EXT }   /* ext=n */,
  {     2,  1106,     0,   2,   0, PL_SK }   /* sk */,
  {     5,   974,  8740,  24,   2, PL_CCC__25 }   /* canonicalcombiningclass=25 */,
  {     0,  4404,     0,  15,   0, PL_MERC }   /* meroiticcursive */,
  {     1,  2229,  1306,  16,  13, PL_M }   /* generalcategory=combiningmark */,
  {     8,   974,  8703,  27,   2, PL_CCC__34 }   /* canonicalcombiningclass=ccc34 */,
  {     0,   184,  7272,   2,   8, PL_MAHJ }   /* ismahajani */,
  {     0,  7288,  4784,   7,   4, PL_CHAM }   /* script=cham */,
  {     1,  6890,  8368,   4,   3, PL_INLAO }   /* blk=lao */,
  {     5,  1929,  3581,   5,   2, PL_XPOSIXUPPER }   /* upper=t */,
  {     4,  1417,  1499,   9,   1, PL_Z }   /* category=z */,
  {     0,  8096,  7272,   4,   8, PL_MAHJ }   /* scx=mahajani */,
  {     4,  8011,  3075,   3,  18, PL_ZP }   /* gc=paragraphseparator */,
  {     4,  3965,     0,  13,   0, PL_MATHOPERATORS }   /* mathoperators */,
  {     0,    21,  3111,   2,  18, PL_RUMI }   /* inruminumeralsymbols */,
  {     1,  1929,  7768,   5,   2, -PL_XPOSIXUPPER }   /* upper=f */,
  {     0,  1417,  5323,   9,  13, PL_ME }   /* category=enclosingmark */,
  {     0,  8600,     0,   4,   0, PL_QAAI }   /* zinh */,
  {     0,  5544,  8771,  13,   3, PL_NV__9_SLASH_2 }   /* numericvalue=9/2 */,
  {     3,  8795,   893,   3,  17, PL_INVS }   /* invariationselectors */,
  {     0,  5544,  7744,  13,   4, PL_NV__7000 }   /* numericvalue=7000 */,
  {    24,   513,     0,  16,   0, PL_UIDEO }   /* unifiedideograph */,
  {     0,  7457,  4715,   5,  14, PL_INSC__CONSONANTFINAL }   /* insc=consonantfinal */,
  {    10,  1585,     0,   4,   0, PL_JAMO }   /* jamo */,
  {    25,  7513,     0,   7,   0, PL_MAND }   /* mandaic */,
  {     0,  2949,     0,  18,   0, PL_INPUNCTUATION }   /* generalpunctuation */,
  {     0,  7459,  7450,   3,   7, PL_SC__HANO }   /* sc=hanunoo */,
  {     1,    76,  7088,   2,   8, PL_XPOSIXDIGIT }   /* nt=decimal */,
  {     0,  2859,  8834,  18,   3, PL_DT__SQR }   /* decompositiontype=sqr */,
  {     2,  6472,    18,  10,   2, PL_RI }   /* wordbreak=ri */,
  {     6,  1426,  2189,  22,  20, PL_INSC__CONSONANTPLACEHOLDER }   /* indicsyllabiccategory=consonantplaceholder */,
  {     0,   494,     0,   3,   0, PL_HAN }   /* han */,
  {     0,  7459,  7611,   3,   4, PL_SOYO }   /* sc=soyo */,
  {     2,  7136,   183,   6,  34, PL_MISCPICTOGRAPHS }   /* block=miscellaneoussymbolsandpictographs */,
  {     0,  1133,  7768,  26,   6, -PL_PCM }   /* prependedconcatenationmark=false */,
  {     4,  5645,  8807,  10,   3, PL_BC__LRO }   /* bidiclass=lro */,
  {     5,  8572,    73,   3,   2, PL_LB__EM }   /* wb=em */,
  {     3,  7380,  8636,   4,   3, PL_CCC__107 }   /* ccc=107 */,
  {    10,  3994,     0,  16,   0, PL_SYRIACSUP }   /* syriacsupplement */,
  {     2,  6706,  8765,  10,   3, PL_IN__8 }   /* presentin=8.0 */,
  {     5,  6713,  8753,   3,   3, PL_IN__6_DOT_2 }   /* in=6.2 */,
  {     0,  6746,     0,  10,   0, PL_SMALLFORMS }   /* smallforms */,
  {     2,  5250,  3223,   8,   2, -PL_XPOSIXXDIGIT }   /* hexdigit=n */,
  {     1,  8508,  7871,   4,   5, PL_LEPC }   /* sc=lepcha */,
  {     5,  8504,   235,   3,   2, PL_SB__LO }   /* sb=lo */,
  {     5,  5645,  8825,  10,   3, PL_BC__PDF }   /* bidiclass=pdf */,
  {     4,  7288,  6806,   7,   4, PL_WARA }   /* script=wara */,
  {     6,  7478,  2108,   3,  20, PL_SINHALAARCHAICNUMBERS }   /* issinhalaarchaicnumbers */,
  {     0,  5765,  3223,  12,   3, -PL_GRBASE }   /* graphemebase=no */,
  {    25,   513,  3223,  16,   3, -PL_UIDEO }   /* unifiedideograph=no */,
  {     0,  3129,  7991,  17,   5, PL_BUHD }   /* scriptextensions=buhid */,
  {     1,  2674,     0,  19,   0, PL_SUNDANESESUP }   /* sundanesesupplement */,
  {     0,  7136,  3021,   6,   9, PL_LATINEXTA }   /* block=latinexta */,
  {     4,  3526,  7768,  17,   2, -PL_RI }   /* regionalindicator=f */,
  {     0,  7136,  4209,   6,  15, PL_CONTROLPICTURES }   /* block=controlpictures */,
  {    21,  7471,  1929,   7,   5, PL_POSIXUPPER }   /* isposixupper */,
  {     0,  5765,  3223,  12,   2, -PL_GRBASE }   /* graphemebase=n */,
  {     0,  7136,  6547,   7,   9, PL_ASCII }   /* block=basiclatin */,
  {     0,  7288,  8408,   7,   3, PL_MRO }   /* script=mro */,
  {     1,  3129,  8524,  17,   4, PL_SHRD }   /* scriptextensions=shrd */,
  {     2,  7478,  3567,   3,  10, PL_SGNW }   /* issignwriting */,
  {     0,  7459,  7312,   3,   4, PL_SC__TAGB }   /* sc=tagb */,
  {     0,  4314,     5,  13,   1, PL_JG__E }   /* joininggroup=e */,
  {    19,   184,   235,   2,   2, PL_LO }   /* islo */,
  {     0,   217,  1392,   6,   9, PL_CS }   /* _perl_surrogate */,
  {    27,  4314,  7304,  13,   8, PL_JG__SWASHKAF }   /* joininggroup=swashkaf */,
  {     0,  1358,     0,  20,   0, PL_CE }   /* compositionexclusion */,
  {     0,  2229,  4599,  16,  15, PL_LU }   /* generalcategory=uppercaseletter */,
  {     3,  4799,     0,  14,   0, PL_HIGHSURROGATES }   /* highsurrogates */,
  {    15,    21,  6806,   2,  10, PL_INWARANGCITI }   /* inwarangciti */,
  {     0,  7478,  6292,   3,   3, PL_SAMR }   /* issamr */,
  {     2,   184,  6241,   2,  11, PL_KATAKANAEXT }   /* iskatakanaext */,
  {     3,  8240,  2579,   3,  19, PL_BC__LRO }   /* bc=lefttorightoverride */,
  {     0,  7288,  7248,   7,   4, PL_SC__JAVA }   /* script=java */,
  {     2,  4198,  1545,   4,  21, PL_GEOMETRICSHAPESEXT }   /* ingeometricshapesextended */,
  {     0,  7288,   494,   7,   3, PL_SC__HAN }   /* script=han */,
  {     0,  2985,     0,  18,   0, PL_IDST }   /* idstrinaryoperator */,
  {     0,  2023,  7768,  21,   2, -PL_LOE }   /* logicalorderexception=f */,
  {     1,    25,     0,   1,   0, PL_S }   /* s */,
  {     2,  7798,  3581,   6,   2, PL_COMPEX }   /* compex=t */,
  {     0,  2023,  7951,  21,   5, PL_LOE }   /* logicalorderexception=true */,
  {    11,  8816,  7756,   3,   4, PL_NV__9000 }   /* nv=9000 */,
  {     1,  6890,  7025,   4,   9, PL_INOLDTURKIC }   /* blk=oldturkic */,
  {     1,  8348,     0,   4,   0, PL_KALI }   /* kali */,
  {     4,  8816,  8899,   3,   2, PL_NV__35 }   /* nv=35 */,
  {     1,  8376,  5777,   3,  12, PL_LB__HL }   /* lb=hebrewletter */,
  {     2,  1474,  5488,  22,   4, PL_BPT__N }   /* bidipairedbrackettype=none */,
  {     1,    58,  7997,   4,   2, PL_IDEO }   /* ideo=y */,
  {     4,  6554,  4105,   3,   4, PL_INBAMUM }   /* inbamum */,
  {     1,  5375,    18,  12,   1, PL_JT__R }   /* joiningtype=r */,
  {     0,  6890,   250,   4,  33, PL_DIACRITICALSEXT }   /* blk=combiningdiacriticalmarksextended */,
  {     1,  7136,  7320,   6,   8, PL_INTIFINAGH }   /* block=tifinagh */,
  {     0,    84,  3223,   4,   3, -PL_MATH }   /* math=no */,
  {     4,  7380,  8642,   4,   3, PL_CCC__122 }   /* ccc=122 */,
  {     3,  6472,  6962,  10,   9, PL_WB__ML }   /* wordbreak=midletter */,
  {    10,   974,  6836,  24,   9, PL_CCC__AL }   /* canonicalcombiningclass=aboveleft */,
  {     2,  8376,  8929,   3,   2, PL_GCB__V }   /* lb=jv */,
  {     1,  6890,    42,   4,   3, PL_CJK }   /* blk=cjk */,
  {    18,  1417,  2088,   9,   2, PL_PD }   /* category=pd */,
  {     0,  7471,  5253,   7,   5, PL_POSIXDIGIT }   /* isposixdigit */,
  {     0,  1354,     0,  24,   0, PL_COMPEX }   /* fullcompositionexclusion */,
  {     1,  3129,  8300,  17,   4, PL_GREK }   /* scriptextensions=grek */,
  {    12,  2750,  7997,  19,   2, PL_TERM }   /* terminalpunctuation=y */,
  {     1,  8508,  8047,   4,   3, PL_SC__LIMB }   /* sc=limb */,
  {     0,    21,  8368,   2,   3, PL_INLAO }   /* inlao */,
  {     6,  7459,  2877,   3,   4, PL_SC__DEVA }   /* sc=deva */,
  {     0,  3129,  2877,  17,  10, PL_DEVA }   /* scriptextensions=devanagari */,
  {     2,   974,  8673,  24,   2, PL_CCC__14 }   /* canonicalcombiningclass=14 */,
  {     0,   184,   251,   3,  32, PL_DIACRITICALSEXT }   /* iscombiningdiacriticalmarksextended */,
  {     1,  8795,  5597,   3,  12, PL_VERTICALFORMS }   /* inverticalforms */,
  {     0,  6890,  1960,   4,  21, PL_CJKRADICALSSUP }   /* blk=cjkradicalssupplement */,
  {     5,   184,  1982,   3,  17, PL_CYRILLICSUP }   /* iscyrillicsupplement */,
  {     0,  6713,  8870,   3,   3, PL_IN__5_DOT_2 }   /* in=v52 */,
  {     0,  6613,   975,   3,   3, PL_HANO }   /* ishano */,
  {     0,  7136,   510,   6,  20, PL_CJK }   /* block=cjkunifiedideographs */,
  {    16,   974,  8690,  24,   3, PL_CCC__AL }   /* canonicalcombiningclass=228 */,
  {     0,  8508,  7883,   4,   5, PL_LYDI }   /* sc=lydian */,
  {     3,  2023,  3581,  21,   2, PL_LOE }   /* logicalorderexception=t */,
  {     0,  6890,  2465,   4,  19, PL_COUNTINGROD }   /* blk=countingrodnumerals */,
  {     0,  6483,  3223,  11,   3, -PL_XIDC }   /* xidcontinue=no */,
  {    17,  1206,  7633,   3,   6, PL_INTAGALOG }   /* intagalog */,
  {     0,  3594,     0,  16,   0, PL_ARABICSUP }   /* arabicsupplement */,
  {    28,  2100,  6678,   4,   8, PL_XPEO }   /* isoldpersian */,
  {     3,  8816,  8640,   3,   2, PL_NV__18 }   /* nv=18 */,
  {     0,  7459,  8280,   3,   4, PL_SC__CYRL }   /* sc=cyrl */,
  {     4,   974,  6142,  24,  11, PL_CCC__DB }   /* canonicalcombiningclass=doublebelow */,
  {     0,    21,  3021,   2,   9, PL_LATINEXTA }   /* inlatinexta */,
  {     0,  2221,  7671,   3,   3, PL_HST__NA }   /* hst=na */,
  {     1,  5375,    24,  12,   1, PL_JT__L }   /* joiningtype=l */,
  {     7,  6706,  8726,  10,   3, PL_IN__4_DOT_1 }   /* presentin=4.1 */,
  {     0,  4757,  7997,  14,   4, PL_GREXT }   /* graphemeextend=yes */,
  {     1,  6221,  4216,   9,   8, PL_CONTROLPICTURES }   /* incontrolpictures */,
  {     0,  7136,  7625,   6,   7, PL_SUPPUAB }   /* block=suppuab */,
  {     0,  4314,  6637,  14,   9, PL_JG__KNOTTEDHEH }   /* joininggroup=knottedheh */,
  {     0,  8196,  8732,   4,   3, PL_AGE__5 }   /* age=5.0 */,
  {     0,  7288,  8384,   7,   4, PL_SC__LINB }   /* script=linb */,
  {    12,  5657,  7951,  12,   5, PL_BIDIM }   /* bidimirrored=true */,
  {     0,  1887,     0,   5,   0, PL_XPOSIXLOWER }   /* lower */,
  {     0,   184,  7870,   2,   6, PL_LEPC }   /* islepcha */,
  {     0,  7288,  7208,   7,   8, PL_SC__HIRA }   /* script=hiragana */,
  {     0,  6263,  8923,  10,   2, PL_LB__H2 }   /* linebreak=h2 */,
  {     1,    21,  6980,   2,   9, PL_INNABATAEAN }   /* innabataean */,
  {     0,  8376,  8935,   3,   2, PL_LB__XX }   /* lb=xx */,
  {     2,   184,  4827,   2,   6, PL_KANGXI }   /* iskangxi */,
  {     3,  5544,  7702,  13,   5, PL_NV__20000 }   /* numericvalue=20000 */,
  {     3,  8340,  2437,   3,   9, PL_JG__YEHBARREE }   /* jg=yehbarree */,
  {     2,  7380,  8899,   7,   2, PL_CCC__35 }   /* ccc=ccc35 */,
  {     4,  7459,  7019,   3,   4, PL_SC__PERM }   /* sc=perm */,
  {     0,  6329,  7762,  11,   6, PL_NT__DI }   /* numerictype=digit */,
  {     1,  5933,     0,  12,   0, PL_GONM }   /* masaramgondi */,
  {     0,  8816,  8136,   3,   4, PL_NV___MINUS_1_SLASH_2 }   /* nv=-1/2 */,
  {     2,  1876,  7951,  21,   5, PL_CWL }   /* changeswhenlowercased=true */,
  {     1,  7136,  7846,   6,   6, PL_INKAITHI }   /* block=kaithi */,
  {     0,  7380,  8703,   4,   2, PL_CCC__34 }   /* ccc=34 */,
  {     0,  5544,  8899,  13,   2, PL_NV__35 }   /* numericvalue=35 */,
  {     0,  7136,  3322,   6,  17, PL_CYRILLICEXTA }   /* block=cyrillicextendeda */,
  {     8,  8196,  8723,   4,   3, PL_AGE__4 }   /* age=4.0 */,
  {     6,  8780,  7768,   3,   2, -PL_CWT }   /* cwt=f */,
  {     1,  1417,    74,   9,   2, PL_ME }   /* category=me */,
  {    15,  8520,     0,   4,   0, PL_SHAW }   /* shaw */,
  {     1,  8340,  4374,   3,  15, PL_JG__MANICHAEANSADHE }   /* jg=manichaeansadhe */,
  {     0,  2229,    48,  16,   1, PL_P }   /* generalcategory=p */,
  {     0,  8111,     0,   4,   0, PL_TAKR }   /* takr */,
  {     0,  6263,  4701,  10,  14, PL_LB__SA }   /* linebreak=complexcontext */,
  {     1,  8504,   496,   3,   7, PL_LB__NU }   /* sb=numeric */,
  {     3,  7457,  5993,   5,  12, PL_INSC__NUMBERJOINER }   /* insc=numberjoiner */,
  {    46,  8096,  8432,   4,   3, PL_NKO }   /* scx=nko */,
  {     3,   184,  7248,   2,   8, PL_JAVA }   /* isjavanese */,
  {     0,  7459,  3288,   3,  17, PL_AGHB }   /* sc=caucasianalbanian */,
  {     0,  8816,  5219,   3,   6, PL_NV__100000 }   /* nv=100000 */,
  {     4,  6713,  8152,   3,   4, PL_IN__10 }   /* in=10.0 */,
  {     8,  7828,  3581,   6,   2, PL_HYPHEN }   /* hyphen=t */,
  {     3,  7840,  1479,   3,   2, PL_VAI }   /* isvai */,
  {   133,  7288,  7646,   7,   7, PL_TAVT }   /* script=taiviet */,
  {    13,  8096,  7870,   4,   6, PL_LEPC }   /* scx=lepcha */,
  {     0,    21,  7360,   3,   6, PL_INAVESTAN }   /* inavestan */,
  {     1,  8096,  7876,   4,   6, PL_LYCI }   /* scx=lycian */,
  {     0,  7632,     0,   7,   0, PL_TGLG }   /* tagalog */,
  {     1,  1448,  2676,   4,  10, PL_SUNDANESESUP }   /* insundanesesup */,
  {     2,  6706,  8891,  10,   3, PL_IN__9 }   /* presentin=v90 */,
  {    16,   184,  8360,   2,   4, PL_KTHI }   /* iskthi */,
  {    35,  6890,  6736,   4,  10, PL_INSAURASHTRA }   /* blk=saurashtra */,
  {     1,  7136,  5801,   6,   5, PL_INKHMER }   /* block=khmer */,
  {     2,  1402,  3165,  24,  18, PL_INPC__TOPANDLEFTANDRIGHT }   /* indicpositionalcategory=topandleftandright */,
  {     0,  8096,  5825,   4,   4, PL_MAHJ }   /* scx=mahj */,
  {     0,   415,  7768,  11,   6, -PL_IDEO }   /* ideographic=false */,
  {     0,   218,     0,   2,   0, PL_PE }   /* pe */,
  {     0,  5645,  3093,  10,  18, PL_BC__RLI }   /* bidiclass=righttoleftisolate */,
  {    17,  7226,  5252,   6,   6, PL_XPOSIXXDIGIT }   /* xposixxdigit */,
  {     0,  6890,  6872,   4,   9, PL_ARABICPFB }   /* blk=arabicpfb */,
  {     0,  8096,  1589,   4,   5, PL_LATN }   /* scx=latin */,
  {    34,  1402,  4629,  24,  15, PL_LOE }   /* indicpositionalcategory=visualorderleft */,
  {    10,  6263,  8344,  10,   2, PL_GCB__T }   /* linebreak=jt */,
  {     2,  6890,  4284,   4,  15, PL_INHANGUL }   /* blk=hangulsyllables */,
  {     3,    96,  3223,   5,   3, -PL_XPOSIXALPHA }   /* alpha=no */,
  {     2,  7136,  3611,   7,  15, PL_BOPOMOFOEXT }   /* block=bopomofoextended */,
  {     1,  8096,  7810,   4,   6, PL_GOTH }   /* scx=gothic */,
  {     5,  7288,  7822,   7,   4, PL_HATR }   /* script=hatr */,
  {     0,  3129,  8432,  17,   3, PL_NKO }   /* scriptextensions=nko */,
  {     2,  7136,  4135,   7,   6, PL_BRAI }   /* block=braille */,
  {     1,  3129,  3458,  17,   4, PL_MANI }   /* scriptextensions=mani */,
  {     2,  4284,  4042,  14,   7, PL_LB__H2 }   /* hangulsyllabletype=lv */,
  {     9,  7136,  3339,   6,  17, PL_CYRILLICEXTB }   /* block=cyrillicextendedb */,
  {     1,  7136,   690,   6,  16, PL_CUNEIFORMNUMBERS }   /* block=cuneiformnumbers */,
  {     1,  1701,  3223,   2,   2, -PL_SD }   /* sd=n */,
  {     8,  8086,  7997,   5,   4, PL_QMARK }   /* qmark=yes */,
  {     0,  8086,  7768,   5,   2, -PL_QMARK }   /* qmark=f */,
  {     2,  8240,  3516,   3,  10, PL_BC__WS }   /* bc=whitespace */,
  {     5,  3424,     0,  17,   0, PL_IDSB }   /* idsbinaryoperator */,
  {     3,  3129,  2787,  17,   4, PL_CHER }   /* scriptextensions=cher */,
  {    12,  7380,  5219,   7,   2, PL_CCC__10 }   /* ccc=ccc10 */,
  {     6,  6890,  8568,   4,   3, PL_INVAI }   /* blk=vai */,
  {     0,  7459,  8404,   3,   4, PL_SC__MLYM }   /* sc=mlym */,
  {     0,  6890,  4841,   4,  14, PL_LATINEXTB }   /* blk=latinextendedb */,
  {     1,  7459,  8492,   3,   4, PL_RUNR }   /* sc=runr */,
  {     0,  6890,   416,   5,  31, PL_INIDC }   /* blk=ideographicdescriptioncharacters */,
  {     0,  7136,  7025,   6,   9, PL_INOLDTURKIC }   /* block=oldturkic */,
  {     1,  3129,  7882,  17,   6, PL_LYDI }   /* scriptextensions=lydian */,
  {     0,  6472,  1107,  10,   8, PL_WB__KA }   /* wordbreak=katakana */,
  {     0,  6472,  3985,  10,   9, PL_LB__EM }   /* wordbreak=emodifier */,
  {     1,  1448,  7605,   3,   6, PL_INSIDDHAM }   /* insiddham */,
  {     3,  7288,  2674,   7,   4, PL_SUND }   /* script=sund */,
  {     3,  7380,  8645,   7,   3, PL_CCC__129 }   /* ccc=ccc129 */,
  {     1,  7136,   468,   6,  11, PL_INPUNCTUATION }   /* block=punctuation */,
  {     0,  3129,  8324,  17,   4, PL_HMNG }   /* scriptextensions=hmng */,
  {     1,  8236,     0,   4,   0, PL_BATK }   /* batk */,
  {     3,  5544,  7750,  13,   6, PL_NV__800000 }   /* numericvalue=800000 */,
  {     0,   184,  7232,   2,   8, PL_JAMOEXTA }   /* isjamoexta */,
  {    15,   184,   568,   2,   2, PL_NB }   /* isnb */,
  {     2,   184,  4771,   2,  14, PL_INGREEK }   /* isgreekandcoptic */,
  {    24,   184,  2044,   2,  14, PL_MEETEIMAYEKEXT }   /* ismeeteimayekext */,
  {     1,  7136,  1081,   6,  26, PL_HALFANDFULLFORMS }   /* block=halfwidthandfullwidthforms */,
  {     9,   184,  1585,   2,   4, PL_JAMO }   /* isjamo */,
  {     0,  7380,    16,   4,   1, PL_CCC__B }   /* ccc=b */,
  {     0,  6890,  7786,   4,   6, PL_INCHAKMA }   /* blk=chakma */,
  {     3,  2229,     0,  17,   0, PL_L }   /* generalcategory=l */,
  {     4,  8508,  1590,   4,   4, PL_SC__LATN }   /* sc=latin */,
  {     4,  7344,  3223,   4,   2, -PL_XIDS }   /* xids=n */,
  {     0,   119,  7201,   3,   7, PL_INGURMUKHI }   /* ingurmukhi */,
  {     1,    21,   568,   2,   2, PL_NB }   /* innb */,
  {     0,  8508,  4789,   4,   2, PL_LAO }   /* sc=lao */,
  {     4,    21,  3239,   4,  15, PL_ALCHEMICAL }   /* inalchemicalsymbols */,
  {     1,  1402,  6121,   3,   5, PL_DOMINO }   /* indomino */,
  {     2,  8376,    18,   3,   2, PL_RI }   /* lb=ri */,
  {     0,  5250,  3223,   8,   3, -PL_XPOSIXXDIGIT }   /* hexdigit=no */,
  {     3,  4630,  1930,   3,   4, PL_XPOSIXUPPER }   /* isupper */,
  {    34,  5583,  7951,  13,   5, PL_QMARK }   /* quotationmark=true */,
  {     2,  8096,  7010,   4,   4, PL_ITAL }   /* scx=ital */,
  {     0,  4479,   966,  15,   2, PL_NFKCQC__N }   /* nfkcquickcheck=no */,
  {    10,  6890,  3322,   4,  17, PL_CYRILLICEXTA }   /* blk=cyrillicextendeda */,
  {     2,  4494,     0,  15,   0, PL_NARB }   /* oldnortharabian */,
  {     1,  3129,  2408,  17,   4, PL_BRAH }   /* scriptextensions=brah */,
  {     0,  6483,  3223,   4,   2, -PL_XIDC }   /* xidc=n */,
  {     0,  3129,  7200,  17,   8, PL_GURU }   /* scriptextensions=gurmukhi */,
  {     0,  4314,  2437,  13,   3, PL_JG__YEH }   /* joininggroup=yeh */,
  {     0,  5544,  8643,  13,   2, PL_NV__22 }   /* numericvalue=22 */,
  {     0,  3129,  7513,  17,   7, PL_MAND }   /* scriptextensions=mandaic */,
  {    68,  8816,  7941,   3,   2, PL_NV__11 }   /* nv=11 */,
  {     0,  7459,  8584,   3,   4, PL_XSUX }   /* sc=xsux */,
  {     0,  7288,  8356,   7,   4, PL_SC__KNDA }   /* script=knda */,
  {     0,  7192,     0,   8,   0, PL_GUJR }   /* gujarati */,
  {     0,  8272,  3581,   4,   2, PL_CWCF }   /* cwcf=t */,
  {     0,  4402,  6297,   3,  10, PL_MISCSYMBOLS }   /* inmiscsymbols */,
  {    27,  8096,  8284,   4,   4, PL_DSRT }   /* scx=dsrt */,
  {     1,  6890,   468,   4,  11, PL_INPUNCTUATION }   /* blk=punctuation */,
  {     2,  6706,  7714,  10,   1, PL_IN__3 }   /* presentin=3 */,
  {     1,  8196,  7720,   4,   1, PL_AGE__4 }   /* age=4 */,
  {     0,   892,  7768,  17,   6, -PL_VS }   /* variationselector=false */,
  {     2,  4402,  3883,   3,  15, PL_MYANMAREXTA }   /* inmyanmarextendeda */,
  {    10,  3509,  7951,  17,   5, PL_PATWS }   /* patternwhitespace=true */,
  {     0,  1378,     0,  24,   0, PL_HIGHPUSURROGATES }   /* highprivateusesurrogates */,
  {     0,  1402,  2349,  24,  12, PL_INPC__TOPANDBOTTOM }   /* indicpositionalcategory=topandbottom */,
  {     0,  7136,  8568,   6,   3, PL_INVAI }   /* block=vai */,
  {     1,  6890,   750,   4,  22, PL_ENCLOSEDIDEOGRAPHICSUP }   /* blk=enclosedideographicsup */,
  {     9,  6219,  7768,  11,   6, -PL_JOINC }   /* joincontrol=false */,
  {     2,  3129,  7527,  17,   7, PL_MULT }   /* scriptextensions=multani */,
  {     0,  8894,    18,   3,   1, PL_VO__R }   /* vo=r */,
  {     0,  7240,     0,   8,   0, PL_JAMOEXTB }   /* jamoextb */,
  {    18,  4402,   184,   3,  19, PL_MISCSYMBOLS }   /* inmiscellaneoussymbols */,
  {     0,  2221,  4046,   3,   3, PL_LB__H2 }   /* hst=lv */,
  {     0,  7380,    24,   4,   1, PL_CCC__L }   /* ccc=l */,
  {     0,    34,  7951,   3,   5, PL_EXT }   /* ext=true */,
  {     0,  1159,  7997,  25,   2, PL_CWKCF }   /* changeswhennfkccasefolded=y */,
  {     1,  6890,  2674,   4,   9, PL_INSUNDANESE }   /* blk=sundanese */,
  {    26,  8026,  6030,   3,   7, PL_PHAISTOS }   /* inphaistos */,
  {     1,  7459,  7780,   3,   6, PL_CARI }   /* sc=carian */,
  {     2,  5134,  7045,   4,   7, PL_PAUC }   /* ispaucinhau */,
  {     7,  7459,  4010,   3,   4, PL_TANG }   /* sc=tang */,
  {     1,  3854,     0,  10,   0, PL_SM }   /* mathsymbol */,
  {    16,  5777,     0,   4,   0, PL_HEBR }   /* hebr */,
  {     4,  5245,  7997,  13,   4, PL_POSIXXDIGIT }   /* asciihexdigit=yes */,
  {    34,  3129,  4134,  17,   7, PL_BRAI }   /* scriptextensions=braille */,
  {     0,  7128,     0,   4,   0, PL_BASS }   /* bass */,
  {     0,  8026,  6374,   3,  10, PL_INPAHAWHHMONG }   /* inpahawhhmong */,
  {     1,  7478,  2675,   3,   8, PL_SUND }   /* issundanese */,
  {    16,  8096,  7034,   4,   9, PL_PALM }   /* scx=palmyrene */,
  {     4,  7136,  1566,   6,   6, PL_INHANGUL }   /* block=hangul */,
  {     8,   436,  7768,   5,   6, -PL_NCHAR }   /* nchar=false */,
  {     0,  8011,   468,   3,  11, PL_P }   /* gc=punctuation */,
  {     1,  1627,     0,   7,   0, PL_XPOSIXCNTRL }   /* control */,
  {     2,  6890,  6953,   4,   9, PL_LATINEXTD }   /* blk=latinextd */,
  {     4,  2236,    36,  10,   1, PL_LT }   /* category=lt */,
  {     4,  8011,   235,   3,   2, PL_LO }   /* gc=lo */,
  {     0,  6890,  3021,   4,  18, PL_LATINEXTADDITIONAL }   /* blk=latinextadditional */,
  {     1,  8196,  8855,   4,   3, PL_AGE__3_DOT_2 }   /* age=v32 */,
  {     2,   184,  4813,   2,   7, PL_KANASUP }   /* iskanasup */,
  {     2,  7136,  6307,   6,  11, PL_MYANMAREXTA }   /* block=myanmarexta */,
  {     7,  1474,     0,  23,   0, PL_BPT__C }   /* bidipairedbrackettype=c */,
  {    15,  8011,  2169,   3,  20, PL_PC }   /* gc=connectorpunctuation */,
  {     2,  4314,  5065,  13,  14, PL_JG__NOJOININGGROUP }   /* joininggroup=nojoininggroup */,
  {     7,  7136,  7192,   6,   8, PL_INGUJARATI }   /* block=gujarati */,
  {     0,   184,  1621,   2,   6, PL_CF }   /* isformat */,
  {     2,  8816,  7710,   3,   1, PL_NV__6 }   /* nv=6 */,
  {     0,    21,  2390,   3,  18, PL_ANCIENTGREEKNUMBERS }   /* inancientgreeknumbers */,
  {     1,  7136,  5825,   6,   7, PL_MAHJONG }   /* block=mahjong */,
  {     0,  7136,  1981,   6,   8, PL_INCYRILLIC }   /* block=cyrillic */,
  {     0,  8572,  1621,   3,   6, PL_WB__FO }   /* wb=format */,
  {     0,  2229,  1204,  16,   2, PL_PO }   /* generalcategory=po */,
  {    20,  6109,  1307,  10,  12, PL_M }   /* category=combiningmark */,
  {     0,  3129,  7043,  17,   4, PL_PAUC }   /* scriptextensions=pauc */,
  {     0,  4239,  7951,   4,   5, PL_DASH }   /* dash=true */,
  {     3,  8096,  8220,   4,   4, PL_ARMN }   /* scx=armn */,
  {     0,    34,  3223,   3,   3, -PL_EXT }   /* ext=no */,
  {    20,  7459,  2841,   3,   6, PL_SC__COPT }   /* sc=coptic */,
  {     0,  4590,  7997,   2,   2, PL_VS }   /* vs=y */,
  {     1,  7136,  2949,   6,  18, PL_INPUNCTUATION }   /* block=generalpunctuation */,
  {     8,  8011,  4599,   3,  15, PL_LU }   /* gc=uppercaseletter */,
  {     5,  8504,   807,   3,   2, PL_SB__SP }   /* sb=sp */,
  {     0,  5134,    83,   3,   2, PL_PCM }   /* ispcm */,
  {    22,  2134,  7997,   3,   4, PL_XPOSIXXDIGIT }   /* hex=yes */,
  {     0,  8288,  4188,   3,   6, PL_DT__MED }   /* dt=medial */,
  {    20,  3129,  7882,  17,   4, PL_LYDI }   /* scriptextensions=lydi */,
  {     0,  8783,  7997,   3,   2, PL_CWU }   /* cwu=y */,
  {    51,  8096,  8253,   5,   3, PL_BUHD }   /* scx=buhd */,
  {     2,  8504,   496,   3,   2, PL_LB__NU }   /* sb=nu */,
  {     0,  8340,   218,   3,   2, PL_JG__PE }   /* jg=pe */,
  {     0,  7478,  6407,   3,  10, PL_SORA }   /* issorasompeng */,
  {     0,  6890,  8111,   4,   5, PL_INTAKRI }   /* blk=takri */,
  {     0,  7224,  5253,   3,   5, PL_XPOSIXXDIGIT }   /* isxdigit */,
  {     6,   184,  6208,   2,   5, PL_JOINC }   /* isjoinc */,
  {     0,  5544,  7750,  13,   4, PL_NV__8000 }   /* numericvalue=8000 */,
  {     0,  7224,  8585,   3,   3, PL_XSUX }   /* isxsux */,
  {     0,  6472,  8935,  10,   2, PL_WB__XX }   /* wordbreak=xx */,
  {     0,  8816,  7732,   3,   1, PL_NV__5 }   /* nv=5 */,
  {     2,   117,  4300,   3,  14, PL_INIMPERIALARAMAIC }   /* inimperialaramaic */,
  {     0,  7846,     0,   6,   0, PL_KTHI }   /* kaithi */,
  {    14,  6506,  4832,   3,   9, PL_YIRADICALS }   /* isyiradicals */,
  {    16,  7906,   800,   4,   3, PL_SC__KNDA }   /* sc=knda */,
  {     0,  2598,     0,   4,   0, PL_MERO }   /* mero */,
  {     0,  3424,  7951,  17,   5, PL_IDSB }   /* idsbinaryoperator=true */,
  {     3,  6890,  5801,   4,   5, PL_INKHMER }   /* blk=khmer */,
  {     6,  5544,  8663,  13,   3, PL_NV__2_SLASH_3 }   /* numericvalue=2/3 */,
  {     0,  8340,  6065,   3,  11, PL_JG__AFRICANNOON }   /* jg=africannoon */,
  {     2,  8340,  5528,   3,   3, PL_JG__WAW }   /* jg=waw */,
  {     5,   184,  1940,   3,  20, PL_CJKCOMPATFORMS }   /* iscjkcompatibilityforms */,
  {     0,  6890,  7034,   4,   9, PL_PALM }   /* blk=palmyrene */,
  {     5,  4630,  7675,   3,   6, PL_UCASEXT }   /* isucasext */,
  {     3,  7136,  2895,   6,   8, PL_INETHIOPIC }   /* block=ethiopic */,
  {     9,  6890,  1107,   4,   8, PL_INKATAKANA }   /* blk=katakana */,
  {     0,  6263,   807,  10,   2, PL_LB__SP }   /* linebreak=sp */,
  {     0,  6713,  8891,   3,   3, PL_IN__9 }   /* in=v90 */,
  {     0,  5134,     7,   3,   1, PL_PC }   /* ispc */,
  {     2,  1746,    34,  21,   6, PL_GREXT }   /* graphemeclusterbreak=extend */,
  {     2,   184,  1012,   2,   6, PL_L }   /* isletter */,
  {     0,    21,  3021,   2,  18, PL_LATINEXTADDITIONAL }   /* inlatinextadditional */,
  {     4,  8344,     7,   3,   1, PL_JT__C }   /* jt=c */,
  {     4,  7288,  8348,   7,   4, PL_SC__KALI }   /* script=kali */,
  {     4,  6890,  2541,   4,  19, PL_JAMOEXTA }   /* blk=hanguljamoextendeda */,
  {     0,  7136,  2841,   6,  18, PL_COPTICEPACTNUMBERS }   /* block=copticepactnumbers */,
  {     4,  3129,  7152,  17,   8, PL_DUPL }   /* scriptextensions=duployan */,
  {     0,  8336,  7655,   4,   5, PL_INTIBETAN }   /* intibetan */,
  {     1,  7459,  7272,   3,   8, PL_SC__MAHJ }   /* sc=mahajani */,
  {     2,  7226,    62,   6,   5, PL_XPOSIXGRAPH }   /* xposixgraph */,
  {     0,  7136,  3111,   6,   4, PL_RUMI }   /* block=rumi */,
  {     8,  7288,  8460,   7,   4, PL_SC__PHLP }   /* script=phlp */,
  {     3,  7443,     0,   4,   0, PL_GRAN }   /* gran */,
  {     1,  7478,  2675,   3,  18, PL_SUNDANESESUP }   /* issundanesesupplement */,
  {     1,  7288,  6439,   7,  11, PL_SC__SYLO }   /* script=sylotinagri */,
  {     0,  5765,     0,  12,   0, PL_GRBASE }   /* graphemebase */,
  {     1,  5544,  7732,  13,   1, PL_NV__5 }   /* numericvalue=5 */,
  {    40,  8101,  3581,   5,   2, PL_STERM }   /* sterm=t */,
  {     1,    78,     0,   6,   0, PL_ARAB }   /* arabic */,
  {     1,  5544,  8148,  13,   3, PL_NV__1_SLASH_4 }   /* numericvalue=1/4 */,
  {     1,  6472,  5772,  10,   5, PL_WB__EB }   /* wordbreak=ebase */,
  {     5,  7906,     8,   4,   3, PL_SC__KANA }   /* sc=kana */,
  {     1,  6890,  2617,   4,  19, PL_MODIFIERTONELETTERS }   /* blk=modifiertoneletters */,
  {     0,  8101,  7768,   5,   2, -PL_STERM }   /* sterm=f */,
  {     1,  8816,  8909,   3,   2, PL_NV__45 }   /* nv=45 */,
  {     7,  6210,   691,   3,  29, PL_CUNEIFORMNUMBERS }   /* incuneiformnumbersandpunctuation */,
  {    38,  6890,  1658,   4,  22, PL_CJKCOMPATIDEOGRAPHSSUP }   /* blk=cjkcompatideographssup */,
  {     0,  7136,   864,   6,  28, PL_SUPPUAB }   /* block=supplementaryprivateuseareab */,
  {     4,  7459,  7336,   3,   4, PL_UGAR }   /* sc=ugar */,
  {     6,  5544,  8144,  13,   4, PL_NV__1_SLASH_20 }   /* numericvalue=1/20 */,
  {     0,  3129,  7822,  17,   6, PL_HATR }   /* scriptextensions=hatran */,
  {     4,  3129,  8416,  17,   4, PL_MYMR }   /* scriptextensions=mymr */,
  {    36,  8096,  7590,   4,   7, PL_SHRD }   /* scx=sharada */,
  {     3,  6890,   690,   4,  16, PL_CUNEIFORMNUMBERS }   /* blk=cuneiformnumbers */,
  {     0,  3129,  8460,  17,   4, PL_PHLP }   /* scriptextensions=phlp */,
  {     0,  1426,  7328,  22,   8, PL_INSC__TONEMARK }   /* indicsyllabiccategory=tonemark */,
  {     0,  7136,  7248,   6,   8, PL_INJAVANESE }   /* block=javanese */,
  {    15,   184,  1506,   2,  14, PL_MUSIC }   /* ismusicalsymbols */,
  {     3,  5544,  7720,  13,   2, PL_NV__40 }   /* numericvalue=40 */,
  {     2,  5681,     0,  12,   0, PL_CYRILLICEXTA }   /* cyrillicexta */,
  {    10,  1680,     0,   6,   0, PL_ZYYY }   /* common */,
  {     4,  8096,  8480,   4,   4, PL_QAAI }   /* scx=qaai */,
  {     4,  7136,  2693,   6,  19, PL_SUPARROWSA }   /* block=supplementalarrowsa */,
  {     0,  8036,  7683,   4,   5, PL_ZZZZ }   /* isunknown */,
  {     0,   184,  6597,   3,   9, PL_COMPATJAMO }   /* iscompatjamo */,
  {     2,  5645,  7997,   5,   4, PL_BIDIC }   /* bidic=yes */,
  {     0,  7288,  2098,   8,   3, PL_BALI }   /* script=bali */,
  {     6,  7224,  6472,   8,   4, PL_XPOSIXWORD }   /* isxposixword */,
  {     2,  8096,  8460,   4,   4, PL_PHLP }   /* scx=phlp */,
  {     0,  7380,  8691,   7,   2, PL_CCC__28 }   /* ccc=ccc28 */,
  {     2,  3129,  8468,  17,   4, PL_MIAO }   /* scriptextensions=plrd */,
  {     4,  1702,     0,  22,   0, PL_DIACRITICALSFORSYMBOLS }   /* diacriticalsforsymbols */,
  {     3,  2100,  8067,   3,   4, PL_ORYA }   /* isoriya */,
  {    32,  8096,  7429,   4,   7, PL_DSRT }   /* scx=deseret */,
  {     0,  7136,  3237,   6,  10, PL_ALCHEMICAL }   /* block=alchemical */,
  {     1,  4314,  4384,  13,   3, PL_JG__SAD }   /* joininggroup=sad */,
  {     4,  7380,  8673,   4,   2, PL_CCC__14 }   /* ccc=14 */,
  {     0,  8096,  8368,   4,   4, PL_LAO }   /* scx=laoo */,
  {     3,  6472,    72,  10,   2, PL_WB__LE }   /* wordbreak=le */,
  {     1,  8026,  6030,   3,  11, PL_PHAISTOS }   /* inphaistosdisc */,
  {    17,  7136,  6373,   6,  11, PL_INPAHAWHHMONG }   /* block=pahawhhmong */,
  {    20,  3129,  8368,  17,   3, PL_LAO }   /* scriptextensions=lao */,
  {     0,   974,  8160,  27,   2, PL_CCC__13 }   /* canonicalcombiningclass=ccc13 */,
  {     0,   184,  8428,   2,   4, PL_NEWA }   /* isnewa */,
  {     0,  1426,  2625,  22,  10, PL_INSC__TONELETTER }   /* indicsyllabiccategory=toneletter */,
  {     0,  1963,  7768,   7,   6, -PL_RADICAL }   /* radical=false */,
  {     1,  1680,     0,  22,   0, PL_INDICNUMBERFORMS }   /* commonindicnumberforms */,
  {     0,  7136,   954,   6,   5, PL_INGREEK }   /* block=greek */,
  {     1,   974,  8696,  24,   3, PL_CCC__AR }   /* canonicalcombiningclass=232 */,
  {     8,  1202,  7768,   3,   2, -PL_DEP }   /* dep=f */,
  {     1,  7288,  8368,   7,   3, PL_LAO }   /* script=lao */,
  {     0,   184,  4104,   2,   5, PL_BAMU }   /* isbamum */,
  {    39,  3610,     0,   8,   0, PL_BOPO }   /* bopomofo */,
  {     4,   184,  7443,   2,   4, PL_GRAN }   /* isgran */,
  {     0,  1503,  2896,   3,   7, PL_INETHIOPIC }   /* inethiopic */,
  {     0,   954,     0,   5,   0, PL_GREK }   /* greek */,
  {     0,  7136,  2149,   6,  20, PL_INANATOLIANHIEROGLYPHS }   /* block=anatolianhieroglyphs */,
  {     0,  6109,    25,  10,   1, PL_CS }   /* category=cs */,
  {     2,  8240,  1804,   3,   3, PL_BC__RLE }   /* bc=rle */,
  {     4,  8504,  7562,   3,   7, PL_SB__LE }   /* sb=oletter */,
  {     1,  8240,  2309,   3,  20, PL_BC__PDF }   /* bc=popdirectionalformat */,
  {     0,  8798,  3223,   3,   2, -PL_LOE }   /* loe=n */,
  {     0,   186,  3223,   2,   2, -PL_CE }   /* ce=n */,
  {     2,  8816,  7714,   3,   3, PL_NV__300 }   /* nv=300 */,
  {     1,  7136,  8408,   6,   3, PL_INMRO }   /* block=mro */,
  {     1,  7380,    23,   4,   2, PL_CCC__AL }   /* ccc=al */,
  {     2,  8240,    25,   4,   1, PL_BC__ES }   /* bc=es */,
  {     2,  2750,  7951,  19,   5, PL_TERM }   /* terminalpunctuation=true */,
  {     2,  3658,     0,  16,   0, PL_PE }   /* closepunctuation */,
  {     8,  7288,  3882,   7,   7, PL_SC__MYMR }   /* script=myanmar */,
  {     3,  4329,     0,  15,   0, PL_LL }   /* lowercaseletter */,
  {    15,  7136,  2107,   6,   7, PL_INSINHALA }   /* block=sinhala */,
  {     6,  1929,  7997,   9,   4, PL_XPOSIXUPPER }   /* uppercase=yes */,
  {     2,   184,   779,   2,  29, PL_MISCARROWS }   /* ismiscellaneoussymbolsandarrows */,
  {     1,   974,  8685,  24,   2, PL_CCC__24 }   /* canonicalcombiningclass=24 */,
  {     0,  7136,  7810,   6,   6, PL_INGOTHIC }   /* block=gothic */,
  {     0,  7786,     0,   6,   0, PL_CAKM }   /* chakma */,
  {     0,  1892,  3223,   5,   3, -PL_CASED }   /* cased=no */,
  {     3,  8006,  7951,   5,   5, PL_CWKCF }   /* cwkcf=true */,
  {     0,  7224,  8081,   8,   5, PL_XPOSIXPRINT }   /* isxposixprint */,
  {     0,  7380,  7714,   7,   2, PL_CCC__30 }   /* ccc=ccc30 */,
  {     8,  7459,  8432,   3,   3, PL_NKO }   /* sc=nko */,
  {     1,  6890,  7882,   4,   6, PL_INLYDIAN }   /* blk=lydian */,
  {     0,  7136,    42,   6,   3, PL_CJK }   /* block=cjk */,
  {     2,  7136,  5232,   6,  13, PL_AEGEANNUMBERS }   /* block=aegeannumbers */,
  {     0,  8096,  6736,   4,  10, PL_SAUR }   /* scx=saurashtra */,
  {     4,  8021,  7768,   5,   6, -PL_GREXT }   /* grext=false */,
  {     0,  5323,     0,  13,   0, PL_ME }   /* enclosingmark */,
  {     2,  5284,  3223,  13,   2, -PL_CI }   /* caseignorable=n */,
  {     3,   974,  8655,  27,   2, PL_CCC__33 }   /* canonicalcombiningclass=ccc33 */,
  {     0,  2859,     7,  18,   3, PL_DT__CAN }   /* decompositiontype=can */,
  {     7,  7459,  7443,   3,   4, PL_SC__GRAN }   /* sc=gran */,
  {     0,  7224,  7345,   3,   7, PL_XIDS }   /* isxidstart */,
  {     0,  7010,     0,   4,   0, PL_ITAL }   /* ital */,
  {     0,  1876,  3223,  21,   2, -PL_CWL }   /* changeswhenlowercased=n */,
  {    19,  3129,  7912,  17,   6, PL_TELU }   /* scriptextensions=telugu */,
  {     1,  6210,  3554,   4,   4, PL_INCARIAN }   /* incarian */,
  {    14,  2100,  6341,   3,  10, PL_LO }   /* isotherletter */,
  {     0,    96,  7768,  10,   6, -PL_XPOSIXALPHA }   /* alphabetic=false */,
  {     3,  3129,  5801,  17,   5, PL_KHMR }   /* scriptextensions=khmer */,
  {    16,  5609,     0,  12,   0, PL_ALPHABETICPF }   /* alphabeticpf */,
  {    52,   892,  7951,  17,   5, PL_VS }   /* variationselector=true */,
  {     0,   184,   959,   2,   5, PL_MUSIC }   /* ismusic */,
  {     0,  5544,  5219,  13,   7, PL_NV__1000000 }   /* numericvalue=1000000 */,
  {     0,  4198,  2969,   4,   9, PL_GEORGIANSUP }   /* ingeorgiansup */,
  {     1,  4314,  3786,  13,  16, PL_JG__MANICHAEANDALETH }   /* joininggroup=manichaeandaleth */,
  {    68,  6890,  4254,   4,  15, PL_DIACRITICALSEXT }   /* blk=diacriticalsext */,
  {     4,  8096,  8372,   4,   4, PL_LATN }   /* scx=latn */,
  {     2,  4757,  7768,  14,   2, -PL_GREXT }   /* graphemeextend=f */,
  {     3,  7288,  8496,   7,   4, PL_SAMR }   /* script=samr */,
  {     9,  4554,   807,  14,   2, PL_SB__SP }   /* sentencebreak=sp */,
  {    12,  2967,     0,  18,   0, PL_GEORGIANSUP }   /* georgiansupplement */,
  {     9,  8036,  1200,   5,   4, PL_ANY }   /* isunicode */,
  {     0,   133,     0,   4,   0, PL_M }   /* mark */,
  {    34,  8816,  7744,   3,   6, PL_NV__700000 }   /* nv=700000 */,
  {    48,  3129,  2484,  17,  19, PL_EGYP }   /* scriptextensions=egyptianhieroglyphs */,
  {     0,  7136,  2269,   6,  20, PL_ININSCRIPTIONALPAHLAVI }   /* block=inscriptionalpahlavi */,
  {     2,   122,  3223,   9,   3, -PL_DIA }   /* diacritic=no */,
  {     1,  7471,    96,   7,   5, PL_POSIXALPHA }   /* isposixalpha */,
  {     4,  6713,  8756,   3,   3, PL_IN__6_DOT_3 }   /* in=6.3 */,
  {     1,  6613,  7823,   3,   5, PL_HATR }   /* ishatran */,
  {     2,  6917,  5779,   4,   4, PL_INHEBREW }   /* inhebrew */,
  {     3,  7459,  2360,   3,   4, PL_SC__MAND }   /* sc=mand */,
  {    34,  8464,     0,   4,   0, PL_PHNX }   /* phnx */,
  {     6,   184,   316,   2,  33, PL_MISCMATHSYMBOLSB }   /* ismiscellaneousmathematicalsymbolsb */,
  {     0,  5645,  2088,  10,   3, PL_BC__PDI }   /* bidiclass=pdi */,
  {     0,  6890,  8388,   4,   4, PL_LISU }   /* blk=lisu */,
  {     0,  8308,     0,   4,   0, PL_GURU }   /* guru */,
  {     3,  5544,  7720,  13,   5, PL_NV__40000 }   /* numericvalue=40000 */,
  {     1,  8288,  2369,   3,   4, PL_DT__VERT }   /* dt=vert */,
  {     6,  3129,  7611,  17,   4, PL_SOYO }   /* scriptextensions=soyo */,
  {     1,  7798,  7997,   6,   2, PL_COMPEX }   /* compex=y */,
  {    29,  3424,  7768,   4,   6, -PL_IDSB }   /* idsb=false */,
  {     3,  8280,     0,   4,   0, PL_CYRL }   /* cyrl */,
  {     1,  7336,     0,   4,   0, PL_UGAR }   /* ugar */,
  {     6,  5645,     8,  10,   2, PL_BC__AN }   /* bidiclass=an */,
  {    65,  6890,  3738,   4,   9, PL_LATIN1 }   /* blk=latin1sup */,
  {     2,   808,     0,  18,   0, PL_PHONETICEXT }   /* phoneticextensions */,
  {    64,  8096,  7200,   4,   8, PL_GURU }   /* scx=gurmukhi */,
  {     2,  8240,    23,   3,   2, PL_BC__AL }   /* bc=al */,
  {     2,   184,  5336,   2,  13, PL_GREEKEXT }   /* isgreekextended */,
  {     3,  8340,  5479,   3,  13, PL_JG__MANICHAEANONE }   /* jg=manichaeanone */,
  {     1,  5645,  8813,  10,   3, PL_BC__NSM }   /* bidiclass=nsm */,
  {     2,  2859,   720,  18,   3, PL_DT__ENC }   /* decompositiontype=enc */,
  {     5,  4757,  3581,  14,   2, PL_GREXT }   /* graphemeextend=t */,
  {    10,  5192,  3425,   3,  16, PL_IDSB }   /* isidsbinaryoperator */,
  {     0,   184,  8798,   2,   3, PL_LOE }   /* isloe */,
  {     0,  2750,  3223,  19,   2, -PL_TERM }   /* terminalpunctuation=n */,
  {     0,  7478,  7605,   3,   3, PL_SIDD }   /* issidd */,
  {     0,   779,     0,  29,   0, PL_MISCARROWS }   /* miscellaneoussymbolsandarrows */,
  {     0,  7345,  3581,   7,   2, PL_IDS }   /* idstart=t */,
  {    15,  2065,  3223,  21,   2, -PL_NCHAR }   /* noncharactercodepoint=n */,
  {     0,  4402,  5532,   3,  12, PL_MISCTECHNICAL }   /* inmisctechnical */,
  {     0,  7459,  7366,   3,   4, PL_SC__BENG }   /* sc=beng */,
  {     1,  7136,  7034,   6,   9, PL_PALM }   /* block=palmyrene */,
  {     9,  1426,  3626,  22,  16, PL_INSC__CANTILLATIONMARK }   /* indicsyllabiccategory=cantillationmark */,
  {    40,  3516,  3223,  10,   2, -PL_XPOSIXSPACE }   /* whitespace=n */,
  {     0,  8026,  7035,   3,   8, PL_PALM }   /* inpalmyrene */,
  {     1,  8816,  7756,   3,   2, PL_NV__90 }   /* nv=90 */,
  {     0,   184,  3610,   2,  11, PL_BOPOMOFOEXT }   /* isbopomofoext */,
  {     8,  1834,  7768,  21,   2, -PL_CWCF }   /* changeswhencasefolded=f */,
  {     4,   184,  5765,   2,  12, PL_GRBASE }   /* isgraphemebase */,
  {     5,  6756,  3223,  10,   2, -PL_SD }   /* softdotted=n */,
  {     0,  8816,  8176,   3,   4, PL_NV__3_SLASH_20 }   /* nv=3/20 */,
  {     6,  3755,  1727,   5,  19, PL_EARLYDYNASTICCUNEIFORM }   /* inearlydynasticcuneiform */,
  {     0,  6554,  4135,   3,  14, PL_BRAI }   /* inbraillepatterns */,
  {     0,  6263,  1055,  10,  26, PL_LB__CJ }   /* linebreak=conditionaljapanesestarter */,
  {     0,   184,    43,   3,  35, PL_CJKCOMPATIDEOGRAPHSSUP }   /* iscjkcompatibilityideographssupplement */,
  {     0,  8780,  7768,   3,   6, -PL_CWT }   /* cwt=false */,
  {     9,  7906,  6293,   5,   2, PL_KHMR }   /* sc=khmr */,
  {     0,  8816,  8901,   3,   2, PL_NV__36 }   /* nv=36 */,
  {     2,  2229,  5082,  16,  11, PL_MC }   /* generalcategory=spacingmark */,
  {     6,  6890,  8400,   4,   4, PL_INMIAO }   /* blk=miao */,
  {    19,  5134,  8082,   3,   4, PL_XPOSIXPRINT }   /* isprint */,
  {     4,  7840,   893,   3,  17, PL_INVS }   /* isvariationselectors */,
  {    20,  5645,   427,  10,   2, PL_BC__ES }   /* bidiclass=es */,
  {     0,  5134,   850,   3,   9, PL_CO }   /* isprivateuse */,
  {     0,  6263,   534,  10,   2, PL_LB__NS }   /* linebreak=ns */,
  {     5,  4402,  3899,   3,  15, PL_MYANMAREXTB }   /* inmyanmarextendedb */,
  {     0,  8460,     0,   4,   0, PL_PHLP }   /* phlp */,
  {     0,  6890,  7810,   4,   6, PL_INGOTHIC }   /* blk=gothic */,
  {     0,    76,  7096,   2,   3, PL_NT__NU }   /* nt=nu */,
  {     2,  6263,  5772,  10,   5, PL_LB__EB }   /* linebreak=ebase */,
  {     1,  6890,  4300,   5,  14, PL_INIMPERIALARAMAIC }   /* blk=imperialaramaic */,
  {    24,    18,  3223,   2,   2, -PL_RI }   /* ri=n */,
  {     1,  8011,   206,   3,   2, PL_PI }   /* gc=pi */,
  {     6,  1189,     0,   2,   0, PL_LT }   /* lt */,
  {     0,  3946,     0,  16,   0, PL_STERM }   /* sentenceterminal */,
  {     1,  3543,     0,  17,   0, PL_SMALLFORMS }   /* smallformvariants */,
  {     2,  5825,     0,   7,   0, PL_MAHJONG }   /* mahjong */,
  {     1,   184,  3738,   2,   9, PL_LATIN1 }   /* islatin1sup */,
  {     0,  2134,  7768,   3,   2, -PL_XPOSIXXDIGIT }   /* hex=f */,
  {     7,  8096,  7351,   4,   4, PL_TALE }   /* scx=tale */,
  {     0,   974,  8164,  24,   2, PL_CCC__15 }   /* canonicalcombiningclass=15 */,
  {     2,   184,  6120,   2,  11, PL_DOMINO }   /* isdominotiles */,
  {    40,  8096,  8408,   4,   3, PL_MRO }   /* scx=mro */,
  {     0,  7459,  8192,   3,   4, PL_SC__ADLM }   /* sc=adlm */,
  {     0,  7478,  6747,   3,   9, PL_SMALLFORMS }   /* issmallforms */,
  {    32,  5544,  8903,  13,   2, PL_NV__38 }   /* numericvalue=38 */,
  {     0,  6713,  8867,   3,   3, PL_IN__5_DOT_1 }   /* in=v51 */,
  {     2,  7136,  3965,   6,  13, PL_MATHOPERATORS }   /* block=mathoperators */,
  {     0,  1133,  3223,  26,   2, -PL_PCM }   /* prependedconcatenationmark=n */,
  {    38,  2100,  7557,   4,   5, PL_OLCK }   /* isolchiki */,
  {     2,   184,  8432,   2,   4, PL_NKO }   /* isnkoo */,
  {     0,  8504,    69,   3,   2, PL_SB__UP }   /* sb=up */,
  {     1,  8096,  7912,   4,   4, PL_TELU }   /* scx=telu */,
  {     0,  4554,  1621,  14,   6, PL_SB__FO }   /* sentencebreak=format */,
  {     7,  2108,  1568,   4,   4, PL_INHANGUL }   /* inhangul */,
  {     0,  5375,     7,  12,   1, PL_JT__C }   /* joiningtype=c */,
  {     6,  7457,  6998,   5,   9, PL_INSC__NONJOINER }   /* insc=nonjoiner */,
  {     0,  3424,  7768,  17,   6, -PL_IDSB }   /* idsbinaryoperator=false */,
  {     0,  7380,  1484,   4,   2, PL_CCC__BR }   /* ccc=br */,
  {     7,  3129,  8046,  17,   5, PL_LIMB }   /* scriptextensions=limbu */,
  {     0,  7459,  7513,   3,   7, PL_SC__MAND }   /* sc=mandaic */,
  {     5,  6484,     0,   3,   0, PL_IDC }   /* idc */,
  {    29,  6736,     0,  10,   0, PL_SAUR }   /* saurashtra */,
  {     4,  6706,  8723,  10,   3, PL_IN__4 }   /* presentin=4.0 */,
  {     5,  7288,  6406,   7,  11, PL_SORA }   /* script=sorasompeng */,
  {     3,  8021,  3223,   5,   2, -PL_GREXT }   /* grext=n */,
  {     4,  4284,  3577,  14,   6, PL_GCB__T }   /* hangulsyllabletype=t */,
  {     6,  8340,  4953,   3,  14, PL_JG__MANICHAEANHETH }   /* jg=manichaeanheth */,
  {     1,  8096,  6917,   4,   9, PL_QAAI }   /* scx=inherited */,
  {     4,  6263,  8925,  10,   2, PL_LB__H3 }   /* linebreak=h3 */,
  {     4,  7459,  2408,   3,   6, PL_BRAH }   /* sc=brahmi */,
  {    38,  3424,  7997,   4,   4, PL_IDSB }   /* idsb=yes */,
  {     5,  7459,  2271,   5,  18, PL_PHLI }   /* sc=inscriptionalpahlavi */,
  {     1,  3322,     0,  17,   0, PL_CYRILLICEXTA }   /* cyrillicextendeda */,
  {     8,  7459,   494,   3,   3, PL_SC__HAN }   /* sc=han */,
  {     3,  8071,     0,   5,   0, PL_OSGE }   /* osage */,
  {     6,  8011,   699,   3,   6, PL_N }   /* gc=number */,
  {     0,  7136,  3147,   6,  18, PL_TAIXUANJING }   /* block=taixuanjingsymbols */,
  {    40,  7840,   893,   3,  16, PL_VS }   /* isvariationselector */,
  {     3,  4314,  5873,  13,  12, PL_JG__MALAYALAMNNA }   /* joininggroup=malayalamnna */,
  {     1,  4314,  8810,  13,   3, PL_JG__MIM }   /* joininggroup=mim */,
  {     0,  3129,  7590,  17,   7, PL_SHRD }   /* scriptextensions=sharada */,
  {     2,  7136,  7016,   6,   9, PL_INOLDPERMIC }   /* block=oldpermic */,
  {     0,  5544,  8901,  13,   2, PL_NV__36 }   /* numericvalue=36 */,
  {     0,  3754,     0,   7,   0, PL_LINB }   /* linearb */,
  {     8,  4402,  3883,   3,   6, PL_INMYANMAR }   /* inmyanmar */,
  {     0,  7457,  2189,   5,  20, PL_INSC__CONSONANTPLACEHOLDER }   /* insc=consonantplaceholder */,
  {     0,   184,    43,   3,  15, PL_CJKCOMPAT }   /* iscjkcompatibility */,
  {     0,  8196,  8726,   4,   3, PL_AGE__4_DOT_1 }   /* age=4.1 */,
  {     1,  8096,  7611,   4,   4, PL_SOYO }   /* scx=soyo */,
  {     1,  8096,  8444,   4,   4, PL_OLCK }   /* scx=olck */,
  {     0,  8240,  8801,   3,   3, PL_BC__LRE }   /* bc=lre */,
  {     4,  4314,  4359,  13,  15, PL_JG__MANICHAEANGIMEL }   /* joininggroup=manichaeangimel */,
  {     0,  7288,  7846,   7,   6, PL_SC__KTHI }   /* script=kaithi */,
  {     0,  8424,     0,   4,   0, PL_NBAT }   /* nbat */,
  {     8,  6890,  4771,   4,  14, PL_INGREEK }   /* blk=greekandcoptic */,
  {     0,  8816,  8741,   3,   3, PL_NV__5_SLASH_6 }   /* nv=5/6 */,
  {    15,  7858,     0,   4,   0, PL_KHOJ }   /* khoj */,
  {    68,  6890,  7387,   4,   7, PL_CJKEXTA }   /* blk=cjkexta */,
  {     1,  8096,  7443,   4,   4, PL_GRAN }   /* scx=gran */,
  {     0,  8096,  6806,   4,   4, PL_WARA }   /* scx=wara */,
  {     1,  7994,  7952,   4,   4, PL_IDC }   /* idc=true */,
  {     8,  5645,  1804,  10,   3, PL_BC__RLE }   /* bidiclass=rle */,
  {     7,  6890,  6908,   4,   9, PL_EMOTICONS }   /* blk=emoticons */,
  {     0,  7288,  8300,   7,   4, PL_SC__GREK }   /* script=grek */,
  {     1,   690,     0,  16,   0, PL_CUNEIFORMNUMBERS }   /* cuneiformnumbers */,
  {     0,   184,  1543,   2,  15, PL_GEOMETRICSHAPES }   /* isgeometricshapes */,
  {     1,  1448,  6431,   5,   8, PL_SUPERANDSUB }   /* insuperandsub */,
  {     1,  6890,  7604,   4,   7, PL_INSIDDHAM }   /* blk=siddham */,
  {     8,  7136,  3290,   6,   4, PL_UCAS }   /* block=ucas */,
  {    16,  8504,  7966,   3,   5, PL_SB__AT }   /* sb=aterm */,
  {     1,  8816,  7744,   3,   5, PL_NV__70000 }   /* nv=70000 */,
  {     0,  7288,  7780,   7,   4, PL_CARI }   /* script=cari */,
  {    67,  2360,     0,   4,   0, PL_MAND }   /* mand */,
  {     0,  4449,  8256,   4,   3, PL_COMPEX }   /* nfcqc=n */,
  {    24,   184,  2636,   2,   4, PL_MONG }   /* ismong */,
  {     6,  4314,  5019,  13,   4, PL_JG__TETH }   /* joininggroup=teth */,
  {    81,  8816,  7714,   3,   6, PL_NV__300000 }   /* nv=300000 */,
  {     0,  2521,     0,   2,   0, PL_PF }   /* pf */,
  {    32,  7136,  2805,   6,  18, PL_HALFMARKS }   /* block=combininghalfmarks */,
  {     0,  7136,  6826,   6,  10, PL_YIRADICALS }   /* block=yiradicals */,
  {     0,  1184,     0,  25,   0, PL_DI }   /* defaultignorablecodepoint */,
  {    48,  5557,     0,  13,   0, PL_PATSYN }   /* patternsyntax */,
  {     0,  8376,   415,   3,  11, PL_LB__ID }   /* lb=ideographic */,
  {     1,  8816,  8646,   3,   2, PL_NV__29 }   /* nv=29 */,
  {    22,  5968,  1029,   3,  26, PL_OCR }   /* inopticalcharacterrecognition */,
  {    17,  7136,  8126,   6,   5, PL_VSSUP }   /* block=vssup */,
  {     0,  7136,  7611,   6,   7, PL_INSOYOMBO }   /* block=soyombo */,
  {     0,  7136,  7912,   6,   6, PL_INTELUGU }   /* block=telugu */,
  {     0,  7459,  2408,   3,   4, PL_BRAH }   /* sc=brah */,
  {     0,  6890,  1724,   4,  22, PL_EARLYDYNASTICCUNEIFORM }   /* blk=earlydynasticcuneiform */,
  {     1,  1346,  3500,   4,   5, PL_INGRANTHA }   /* ingrantha */,
  {     1,  7459,  7192,   3,   8, PL_SC__GUJR }   /* sc=gujarati */,
  {     0,  2859,  2369,  18,   4, PL_DT__VERT }   /* decompositiontype=vert */,
  {     3,  7288,  7320,   7,   8, PL_TFNG }   /* script=tifinagh */,
  {     1,  7288,  2484,   7,  19, PL_EGYP }   /* script=egyptianhieroglyphs */,
  {     0,  7288,  7312,   7,   4, PL_SC__TAGB }   /* script=tagb */,
  {     0,  7380,  7941,   7,   2, PL_CCC__11 }   /* ccc=ccc11 */,
  {     1,  7288,  2531,   7,   4, PL_SC__MULT }   /* script=mult */,
  {     0,  8288,     7,   3,   3, PL_DT__CAN }   /* dt=can */,
  {     0,  3129,   954,  17,   5, PL_GREK }   /* scriptextensions=greek */,
  {    12,  5544,  8184,  13,   4, PL_NV__5_SLASH_12 }   /* numericvalue=5/12 */,
  {    16,  4314,  3818,  13,  16, PL_JG__MANICHAEANSAMEKH }   /* joininggroup=manichaeansamekh */,
  {     0,  5645,  3581,   5,   2, PL_BIDIC }   /* bidic=t */,
  {     7,  6713,  8852,   3,   3, PL_IN__3_DOT_1 }   /* in=v31 */,
  {     2,  8096,    78,   4,   4, PL_ARAB }   /* scx=arab */,
  {     4,  7136,  3356,   6,  17, PL_CYRILLICEXTC }   /* block=cyrillicextendedc */,
  {     4,  8096,  7025,   4,   9, PL_ORKH }   /* scx=oldturkic */,
  {     1,  7224,  6484,   3,   3, PL_XIDC }   /* isxidc */,
  {     2,  7136,  7443,   6,   7, PL_INGRANTHA }   /* block=grantha */,
  {     0,   184,  1283,   3,   9, PL_CJKSYMBOLS }   /* iscjksymbols */,
  {     0,  4239,  3223,   4,   2, -PL_DASH }   /* dash=n */,
  {    12,  7288,  8416,   7,   4, PL_SC__MYMR }   /* script=mymr */,
  {     0,  7288,  7632,   7,   7, PL_SC__TGLG }   /* script=tagalog */,
  {     3,  6890,  1680,   4,  22, PL_INDICNUMBERFORMS }   /* blk=commonindicnumberforms */,
  {     0,  6890,  1001,   4,  11, PL_ENCLOSEDCJK }   /* blk=enclosedcjk */,
  {     0,  7136,  7900,   6,   6, PL_INREJANG }   /* block=rejang */,
  {     2,  8096,  7043,   4,   4, PL_PAUC }   /* scx=pauc */,
  {    18,   974,  6556,  24,  10, PL_CCC__BR }   /* canonicalcombiningclass=belowright */,
  {     0,   184,  6881,   2,   9, PL_BHKS }   /* isbhaiksuki */,
  {     0,  6890,  1960,   4,  14, PL_CJKRADICALSSUP }   /* blk=cjkradicalssup */,
  {     0,  6890,  6596,   4,  10, PL_COMPATJAMO }   /* blk=compatjamo */,
  {     2,  7288,  7780,   7,   6, PL_CARI }   /* script=carian */,
  {     0,  6890,  2967,   4,  18, PL_GEORGIANSUP }   /* blk=georgiansupplement */,
  {     0,  1417,  1106,   9,   2, PL_SK }   /* category=sk */,
  {     1,  8786,     1,   3,   1, PL_EA__N }   /* ea=n */,
  {   123,  7459,  8220,   3,   4, PL_SC__ARMN }   /* sc=armn */,
  {     0,  4449,  8256,   4,   4, PL_COMPEX }   /* nfcqc=no */,
  {     0,  7459,  8396,   3,   4, PL_MERC }   /* sc=merc */,
  {     2,  7478,  3084,   7,   9, PL_ZS }   /* isspaceseparator */,
  {     0,  1358,  7997,  20,   4, PL_CE }   /* compositionexclusion=yes */,
  {     0,  4542,  7640,   3,   6, PL_LANA }   /* istaitham */,
  {     1,  8783,  7768,   3,   2, -PL_CWU }   /* cwu=f */,
  {     2,  7459,  2674,   3,   4, PL_SUND }   /* sc=sund */,
  {     0,  6483,  7997,   4,   4, PL_XIDC }   /* xidc=yes */,
  {     1,  3129,  2107,  17,   4, PL_SINH }   /* scriptextensions=sinh */,
  {     0,  7459,  7569,   3,   7, PL_OSMA }   /* sc=osmanya */,
  {     8,  3129,  7192,  17,   8, PL_GUJR }   /* scriptextensions=gujarati */,
  {     5,  1701,  7997,   2,   2, PL_SD }   /* sd=y */,
  {     7,  7288,  7660,   7,   7, PL_SC__TIRH }   /* script=tirhuta */,
  {     0,  8196,  8765,   4,   3, PL_AGE__8 }   /* age=8.0 */,
  {    48,  7288,  7870,   7,   4, PL_LEPC }   /* script=lepc */,
  {     1,  8096,  6696,   4,  10, PL_PHNX }   /* scx=phoenician */,
  {    10,  5544,  7708,  13,   2, PL_NV__21 }   /* numericvalue=21 */,
  {    28,   184,  7240,   2,   8, PL_JAMOEXTB }   /* isjamoextb */,
  {     0,  7136,  8368,   6,   3, PL_INLAO }   /* block=lao */,
  {     7,   184,   750,   2,  22, PL_ENCLOSEDIDEOGRAPHICSUP }   /* isenclosedideographicsup */,
  {     0,  3129,    78,  17,   6, PL_ARAB }   /* scriptextensions=arabic */,
  {     2,   184,  8931,   2,   2, PL_L_AMP_ }   /* isl& */,
  {     6,   117,   448,   3,  31, PL_IDEOGRAPHICSYMBOLS }   /* inideographicsymbolsandpunctuation */,
  {     0,  6890,  3057,   4,  18, PL_ORNAMENTALDINGBATS }   /* blk=ornamentaldingbats */,
  {     1,  8816,  7709,   3,   2, PL_NV__16 }   /* nv=16 */,
  {     0,  8240,    18,   3,   1, PL_BC__R }   /* bc=r */,
  {     1,  8816,  8164,   3,   4, PL_NV__15_SLASH_2 }   /* nv=15/2 */,
  {    72,  6219,     0,  11,   0, PL_JOINC }   /* joincontrol */,
  {     3,  2229,     0,  17,   1, PL_LU }   /* generalcategory=lu */,
  {     0,  6706,  7702,  10,   1, PL_IN__2 }   /* presentin=2 */,
  {     0,  7136,  7956,   6,   5, PL_INADLAM }   /* block=adlam */,
  {     3,  7226,  7986,   6,   5, PL_XPOSIXBLANK }   /* xposixblank */,
  {    18,  6554,  7145,   3,   7, PL_INBUGINESE }   /* inbuginese */,
  {     0,  6989,     0,   9,   0, PL_TALU }   /* newtailue */,
  {     1,  2128,     0,  21,   0, PL_YIJING }   /* yijinghexagramsymbols */,
  {     0,  7288,  8588,   7,   4, PL_SC__YI }   /* script=yiii */,
  {     0,  7288,  8264,   7,   4, PL_CANS }   /* script=cans */,
  {     1,   184,  7971,   2,   5, PL_BATK }   /* isbatak */,
  {     4,  8196,  7732,   4,   1, PL_AGE__5 }   /* age=5 */,
  {    72,  6890,   479,   4,  31, PL_MATHALPHANUM }   /* blk=mathematicalalphanumericsymbols */,
  {     0,  1887,  7768,   5,   2, -PL_XPOSIXLOWER }   /* lower=f */,
  {     5,  4314,  4384,  13,   5, PL_JG__SADHE }   /* joininggroup=sadhe */,
  {    17,  3914,     0,  16,   0, PL_PO }   /* otherpunctuation */,
  {     1,  2229,  2169,  16,  20, PL_PC }   /* generalcategory=connectorpunctuation */,
  {    16,  1426,  5191,  24,  14, PL_INSC__INVISIBLESTACKER }   /* indicsyllabiccategory=invisiblestacker */,
  {     0,  7288,  7450,   7,   7, PL_SC__HANO }   /* script=hanunoo */,
  {     1,  1855,  7997,  21,   4, PL_CWCM }   /* changeswhencasemapped=yes */,
  {     1,  7344,  7997,   4,   4, PL_XIDS }   /* xids=yes */,
  {     0,  1746,    36,  21,   1, PL_GCB__T }   /* graphemeclusterbreak=t */,
  {     0,  6210,  6587,   3,   9, PL_CJKSTROKES }   /* incjkstrokes */,
  {    14,  6008,     0,   4,   0, PL_HUNG }   /* hung */,
  {     0,  4314,  4995,  13,  14, PL_JG__MANICHAEANRESH }   /* joininggroup=manichaeanresh */,
  {     0,  6890,  3754,   4,  16, PL_LINEARBIDEOGRAMS }   /* blk=linearbideograms */,
  {     1,  7288,  8245,   8,   3, PL_BHKS }   /* script=bhks */,
  {     6,  8101,     0,   5,   0, PL_STERM }   /* sterm */,
  {     0,  6613,  8321,   3,   3, PL_HLUW }   /* ishluw */,
  {     0,  4284,  4026,  14,  16, PL_GCB__L }   /* hangulsyllabletype=leadingjamo */,
  {     2,  7478,  1636,   3,  22, PL_SUPPUNCTUATION }   /* issupplementalpunctuation */,
  {    16,  6890,  7569,   4,   7, PL_INOSMANYA }   /* blk=osmanya */,
  {    26,  5657,  3223,   5,   2, -PL_BIDIM }   /* bidim=n */,
  {     0,  1402,  1704,   4,  20, PL_DIACRITICALSFORSYMBOLS }   /* indiacriticalsforsymbols */,
  {     0,  8504,    33,   3,   2, PL_SB__SE }   /* sb=se */,
  {     2,  8420,     0,   4,   0, PL_NARB }   /* narb */,
  {     0,  1401,     0,   4,   0, PL_SIND }   /* sind */,
  {     0,   184,     3,   3,   1, PL_CF }   /* iscf */,
  {     0,  3424,  3581,   4,   2, PL_IDSB }   /* idsb=t */,
  {     0,  6890,  6944,   4,   9, PL_LATINEXTC }   /* blk=latinextc */,
  {    24,  6613,  4285,   3,  14, PL_INHANGUL }   /* ishangulsyllables */,
  {     0,  6109,  3659,  10,  15, PL_PE }   /* category=closepunctuation */,
  {    82,  8777,     0,   3,   0, PL_CWL }   /* cwl */,
  {     0,   183,     0,  34,   0, PL_MISCPICTOGRAPHS }   /* miscellaneoussymbolsandpictographs */,
  {     2,  7288,  3611,   8,   3, PL_SC__BOPO }   /* script=bopo */,
  {     0,  1929,  7951,   5,   5, PL_XPOSIXUPPER }   /* upper=true */,
  {     0,  2229,  1013,  17,   5, PL_L }   /* generalcategory=letter */,
  {     0,  6890,  3390,   4,  16, PL_ETHIOPICEXT }   /* blk=ethiopicextended */,
  {     0,  7459,  8436,   3,   4, PL_NSHU }   /* sc=nshu */,
  {     1,  8096,  8106,   4,   5, PL_TALE }   /* scx=taile */,
  {     7,  6613,  6009,   3,   3, PL_HUNG }   /* ishung */,
  {     3,   974,  8639,  24,   3, PL_CCC__118 }   /* canonicalcombiningclass=118 */,
  {     6,  8816,  7756,   3,   6, PL_NV__900000 }   /* nv=900000 */,
  {     0,  7226,  1887,   6,   5, PL_XPOSIXLOWER }   /* xposixlower */,
  {     0,  8816,  1335,   3,   3, PL_NV__NAN }   /* nv=nan */,
  {     4,  1448,  1791,   3,  21, PL_MODIFIERLETTERS }   /* inspacingmodifierletters */,
  {     3,  7288,  6736,   7,  10, PL_SAUR }   /* script=saurashtra */,
  {     2,  4813,     0,   7,   0, PL_KANASUP }   /* kanasup */,
  {     0,   184,  4883,   2,  14, PL_LATINEXTE }   /* islatinextendede */,
  {    15,  7459,  7520,   3,   7, PL_MARC }   /* sc=marchen */,
  {     2,  8304,     0,   4,   0, PL_GUJR }   /* gujr */,
  {     5,  1503,  3391,   3,  16, PL_ETHIOPICEXTA }   /* inethiopicextendeda */,
  {     0,  8096,  7653,   4,   7, PL_TIBT }   /* scx=tibetan */,
  {     2,  7459,  7912,   3,   4, PL_SC__TELU }   /* sc=telu */,
  {     0,  6890,  7429,   4,   7, PL_DSRT }   /* blk=deseret */,
  {     0,  8894,  3201,   3,  18, PL_VO__TU }   /* vo=transformedupright */,
  {     0,  8344,     0,   4,   0, PL_JT__L }   /* jt=l */,
  {    32,  7136,  6439,   6,  11, PL_INSYLOTINAGRI }   /* block=sylotinagri */,
  {     0,  7288,  7520,   7,   7, PL_MARC }   /* script=marchen */,
  {     0,  2841,     0,   6,   0, PL_COPT }   /* coptic */,
  {    64,  8009,     0,   2,   0, PL_CF }   /* cf */,
  {    14,  7288,  1108,   8,   4, PL_BATK }   /* script=batak */,
  {     2,  4198,  2969,   4,  16, PL_GEORGIANSUP }   /* ingeorgiansupplement */,
  {     1,  7689,  8233,   3,   3, PL_AVST }   /* isavst */,
  {     1,  6890,  3866,   4,  16, PL_MISCMATHSYMBOLSB }   /* blk=miscmathsymbolsb */,
  {     1,  4314,   218,  13,   2, PL_JG__PE }   /* joininggroup=pe */,
  {     0,  8816,  5219,   3,   3, PL_NV__100 }   /* nv=100 */,
  {    63,  3424,  7768,   4,   2, -PL_IDSB }   /* idsb=f */,
  {     1,  8816,  7720,   3,   1, PL_NV__4 }   /* nv=4 */,
  {     1,   974,  3254,  24,  13, PL_CCC__202 }   /* canonicalcombiningclass=attachedbelow */,
  {    32,  2541,     0,  10,   0, PL_JAMO }   /* hanguljamo */,
  {     3,  5544,  7756,  13,   3, PL_NV__900 }   /* numericvalue=900 */,
  {    18,  6890,  7618,   4,   7, PL_SUPPUAA }   /* blk=suppuaa */,
  {     0,  7136,  7492,   6,   7, PL_INKANNADA }   /* block=kannada */,
  {    10,  7681,     0,   7,   0, PL_ZZZZ }   /* unknown */,
  {    10,  7136,  1658,   6,  19, PL_CJKCOMPATIDEOGRAPHS }   /* block=cjkcompatideographs */,
  {     0,  4010,     0,   4,   0, PL_TANG }   /* tang */,
  {     8,   974,  4976,  24,   2, PL_CCC__7 }   /* canonicalcombiningclass=nk */,
  {    16,  7882,     0,   6,   0, PL_LYDI }   /* lydian */,
  {     0,  7224,  3521,   8,   5, PL_XPOSIXSPACE }   /* isxposixspace */,
  {     0,  6263,  1083,  10,   2, PL_LB__LF }   /* linebreak=lf */,
  {     4,  6713,  7702,   3,   1, PL_IN__2 }   /* in=2 */,
  {     0,  7288,  8528,   7,   4, PL_SC__SYRC }   /* script=syrc */,
  {    68,  3129,  8061,  17,   5, PL_OGAM }   /* scriptextensions=ogham */,
  {     1,  8276,     0,   4,   0, PL_CWCM }   /* cwcm */,
  {     0,  5544,  7714,  13,   3, PL_NV__300 }   /* numericvalue=300 */,
  {     1,  7478,   837,   3,  27, PL_SUPPUAA }   /* issupplementaryprivateuseareaa */,
  {    17,  5544,  8762,  13,   3, PL_NV__7_SLASH_8 }   /* numericvalue=7/8 */,
  {    10,    21,  4813,   2,  14, PL_KANASUP }   /* inkanasupplement */,
  {     0,  8011,     7,   4,   1, PL_SC }   /* gc=sc */,
  {     6,  5544,  8640,  13,   2, PL_NV__18 }   /* numericvalue=18 */,
  {     1,  8096,  4105,   5,   3, PL_BAMU }   /* scx=bamu */,
  {    11,  7345,  7768,   7,   6, -PL_IDS }   /* idstart=false */,
  {     0,  3129,  8448,  17,   4, PL_ORKH }   /* scriptextensions=orkh */,
  {    29,  7288,  8548,   7,   4, PL_TFNG }   /* script=tfng */,
  {     0,  6890,  6646,   4,  10, PL_MISCARROWS }   /* blk=miscarrows */,
  {     1,     0,     0,  34,   0, PL_UCAS }   /* unifiedcanadianaboriginalsyllabics */,
  {     1,  7459,  7604,   3,   7, PL_SIDD }   /* sc=siddham */,
  {     0,  1876,  3223,  21,   3, -PL_CWL }   /* changeswhenlowercased=no */,
  {     2,  6263,    34,  10,   2, PL_LB__EX }   /* linebreak=ex */,
  {     3,  1402,  3069,   4,   6, PL_DINGBATS }   /* indingbats */,
  {     5,  7344,     0,   4,   0, PL_XIDS }   /* xids */,
  {     0,  8340,  6072,   3,   4, PL_JG__NOON }   /* jg=noon */,
  {     4,  7136,  7061,   6,   9, PL_INSAMARITAN }   /* block=samaritan */,
  {     0,  5544,  7720,  13,   1, PL_NV__4 }   /* numericvalue=4 */,
  {     2,  7380,  8897,   4,   2, PL_CCC__19 }   /* ccc=19 */,
  {    76,  2750,  7768,  19,   6, -PL_TERM }   /* terminalpunctuation=false */,
  {     7,  8288,   568,   3,   2, PL_DT__NB }   /* dt=nb */,
  {   136,  7248,     0,   8,   0, PL_JAVA }   /* javanese */,
  {     0,  8376,  6186,   3,  11, PL_LB__IN }   /* lb=inseparable */,
  {     3,  8572,   698,   3,   2, PL_WB__MN }   /* wb=mn */,
  {     0,  7459,  2249,   3,   4, PL_SC__GLAG }   /* sc=glag */,
  {     6,  8204,  7951,   4,   5, PL_POSIXXDIGIT }   /* ahex=true */,
  {    12,  5192,   416,   3,  31, PL_INIDC }   /* isideographicdescriptioncharacters */,
  {     2,   184,   122,   2,   9, PL_DIA }   /* isdiacritic */,
  {     1,  4314,  5849,  13,  12, PL_JG__MALAYALAMLLA }   /* joininggroup=malayalamlla */,
  {     1,  8300,     0,   4,   0, PL_GREK }   /* grek */,
  {     0,  8096,  7583,   4,   7, PL_PHAG }   /* scx=phagspa */,
  {    68,  7288,  6882,   8,   8, PL_BHKS }   /* script=bhaiksuki */,
  {     0,  6109,     3,  10,   1, PL_CF }   /* category=cf */,
  {    96,  2985,  3223,   4,   2, -PL_IDST }   /* idst=n */,
  {     0,  7226,  3521,   6,   5, PL_XPOSIXSPACE }   /* xposixspace */,
  {     0,  5645,  2289,  10,  11, PL_BC__L }   /* bidiclass=lefttoright */,
  {     0,  8816,  8907,   3,   2, PL_NV__44 }   /* nv=44 */,
  {     0,  2229,  3658,  16,  16, PL_PE }   /* generalcategory=closepunctuation */,
  {     4,  6890,  4644,   4,  15, PL_INZANABAZARSQUARE }   /* blk=zanabazarsquare */,
  {    10,  3129,  6373,  17,  11, PL_HMNG }   /* scriptextensions=pahawhhmong */,
  {     4,   184,  1797,   2,   4, PL_MODI }   /* ismodi */,
  {     1,  3129,  8046,  17,   4, PL_LIMB }   /* scriptextensions=limb */,
  {     0,  5134,   809,   3,  10, PL_PHONETICEXT }   /* isphoneticext */,
  {     0,  7288,  1540,   7,   4, PL_SC__PHAG }   /* script=phag */,
  {     0,  4402,  2046,   4,  12, PL_MEETEIMAYEKEXT }   /* inmeeteimayekext */,
  {     0,   148,     0,  35,   0, PL_DIACRITICALSSUP }   /* combiningdiacriticalmarkssupplement */,
  {     0,  8096,  8568,   4,   3, PL_VAI }   /* scx=vai */,
  {    49,  8376,  7828,   3,   2, PL_LB__HY }   /* lb=hy */,
  {     0,  7136,  1724,   6,  22, PL_EARLYDYNASTICCUNEIFORM }   /* block=earlydynasticcuneiform */,
  {     0,   184,  8596,   2,   4, PL_ZANB }   /* iszanb */,
  {    12,  5544,  7726,  13,   2, PL_NV__43 }   /* numericvalue=43 */,
  {     1,  6263,  3526,  10,  17, PL_RI }   /* linebreak=regionalindicator */,
  {     3,  7288,  2787,   7,   8, PL_CHER }   /* script=cherokee */,
  {     1,  5693,     0,  12,   0, PL_CYRILLICEXTB }   /* cyrillicextb */,
  {     0,  8596,     0,   4,   0, PL_ZANB }   /* zanb */,
  {     1,  1635,     0,  23,   0, PL_SUPPUNCTUATION }   /* supplementalpunctuation */,
  {     3,  6776,     0,  10,   0, PL_SUPARROWSB }   /* suparrowsb */,
  {     0,  7380,  8168,   4,   2, PL_CCC__17 }   /* ccc=17 */,
  {     1,  3610,     0,  11,   0, PL_BOPOMOFOEXT }   /* bopomofoext */,
  {     0,  3424,  7951,   4,   5, PL_IDSB }   /* idsb=true */,
  {     0,  4479,     1,  15,   1, PL_NFKCQC__N }   /* nfkcquickcheck=n */,
  {     2,   974,  3743,  24,   1, PL_CCC__1 }   /* canonicalcombiningclass=1 */,
  {     1,  5253,     0,   5,   0, PL_XPOSIXDIGIT }   /* digit */,
  {     2,  5968,  4495,   3,  14, PL_NARB }   /* inoldnortharabian */,
  {     0,  6890,  1081,   4,  26, PL_HALFANDFULLFORMS }   /* blk=halfwidthandfullwidthforms */,
  {     1,   217,  8077,   7,   4, PL_PATWS }   /* _perl_patws */,
  {     0,   974,  7944,  27,   2, PL_CCC__12 }   /* canonicalcombiningclass=ccc12 */,
  {    50,  8816,  7756,   3,   3, PL_NV__900 }   /* nv=900 */,
  {     0,  6890,  3994,   4,   9, PL_SYRIACSUP }   /* blk=syriacsup */,
  {     0,  7136,  2712,   6,  19, PL_SUPARROWSB }   /* block=supplementalarrowsb */,
  {     0,  2229,  4330,  17,  14, PL_LL }   /* generalcategory=lowercaseletter */,
  {     1,  8376,  3658,   3,  16, PL_LB__CL }   /* lb=closepunctuation */,
  {     0,  8340,  5741,   3,  12, PL_JG__FINALSEMKATH }   /* jg=finalsemkath */,
  {     1,  4134,     0,   4,   0, PL_BRAI }   /* brai */,
  {     0,  7457,  4164,   5,  15, PL_INSC__CONSONANTKILLER }   /* insc=consonantkiller */,
  {     0,  8096,  1540,   4,   4, PL_PHAG }   /* scx=phag */,
  {     0,  8096,  3674,   4,   7, PL_CPRT }   /* scx=cypriot */,
  {     7,  7224,    96,   8,   5, PL_XPOSIXALPHA }   /* isxposixalpha */,
  {     8,  1159,     0,  25,   0, PL_CWKCF }   /* changeswhennfkccasefolded */,
  {     0,  3129,  7639,  17,   7, PL_LANA }   /* scriptextensions=taitham */,
  {    48,  8096,  5801,   4,   5, PL_KHMR }   /* scx=khmer */,
  {     0,   974,  8699,  24,   3, PL_CCC__DB }   /* canonicalcombiningclass=233 */,
  {     2,  8252,     0,   4,   0, PL_BUHD }   /* buhd */,
  {     0,  1426,  4058,  22,  16, PL_INSC__VOWELINDEPENDENT }   /* indicsyllabiccategory=vowelindependent */,
  {     2,  7906,  6629,   6,   7, PL_KHAR }   /* sc=kharoshthi */,
  {    34,  5544,  7756,  13,   4, PL_NV__9000 }   /* numericvalue=9000 */,
  {     0,  1612,     0,  23,   0, PL_SHORTHANDFORMATCONTROLS }   /* shorthandformatcontrols */,
  {     0,  8121,  7768,   5,   6, -PL_UIDEO }   /* uideo=false */,
  {     0,   184,  7882,   2,   6, PL_LYDI }   /* islydian */,
  {    67,  4554,  7966,  14,   5, PL_SB__AT }   /* sentencebreak=aterm */,
  {    10,  8248,     7,   4,   1, PL_BPT__C }   /* bpt=c */,
  {     1,  6890,  5245,   4,   5, PL_ASCII }   /* blk=ascii */,
  {     1,  7288,  8544,   7,   4, PL_TAVT }   /* script=tavt */,
  {    10,  6263,  1392,  10,   9, PL_LB__SG }   /* linebreak=surrogate */,
  {     2,   184,  7423,   3,   6, PL_CJKEXTF }   /* iscjkextf */,
  {     1,  5134,  1340,   4,   2, PL_PAUC }   /* ispauc */,
  {     3,   184,  3882,   2,   7, PL_MYMR }   /* ismyanmar */,
  {    40,   184,  6120,   2,   6, PL_DOMINO }   /* isdomino */,
  {     2,  7380,  8617,   7,   2, PL_CCC__31 }   /* ccc=ccc31 */,
  {     8,  7136,  7918,   6,   6, PL_INTHAANA }   /* block=thaana */,
  {    18,  8572,  2284,   3,   2, PL_LB__HL }   /* wb=hl */,
  {    19,  6706,  6796,  10,  10, PL_AGE__NA }   /* presentin=unassigned */,
  {    38,  8816,  7710,   3,   4, PL_NV__6000 }   /* nv=6000 */,
  {    11,  1354,  3581,  24,   2, PL_COMPEX }   /* fullcompositionexclusion=t */,
  {     6,  6796,     0,  10,   0, PL_CN }   /* unassigned */,
  {     2,  8196,  8738,   4,   3, PL_AGE__5_DOT_2 }   /* age=5.2 */,
  {     1,   184,  4134,   2,   7, PL_BRAI }   /* isbraille */,
  {    10,  2369,    18,  20,   1, PL_VO__R }   /* verticalorientation=r */,
  {     0,  5192,  4300,   3,  14, PL_ARMI }   /* isimperialaramaic */,
  {     0,  8941,     0,   2,   0, PL_ZS }   /* zs */,
  {     2,   974,  7727,  27,   2, PL_CCC__32 }   /* canonicalcombiningclass=ccc32 */,
  {     0,  4314,  3492,  13,  17, PL_JG__MANICHAEANTHAMEDH }   /* joininggroup=manichaeanthamedh */,
  {    11,  3129,  8544,  17,   4, PL_TAVT }   /* scriptextensions=tavt */,
  {    43,  1503,  5718,   3,  11, PL_ETHIOPICEXTA }   /* inethiopicexta */,
  {     1,   184,  2877,   2,  18, PL_DEVANAGARIEXT }   /* isdevanagariextended */,
  {     1,  4314,  4374,  13,  15, PL_JG__MANICHAEANSADHE }   /* joininggroup=manichaeansadhe */,
  {     0,  8288,   974,   3,   9, PL_DT__CAN }   /* dt=canonical */,
  {     3,  6613,  5251,   3,   7, PL_XPOSIXXDIGIT }   /* ishexdigit */,
  {     0,  1448,  1638,   5,  20, PL_SUPPUNCTUATION }   /* insupplementalpunctuation */,
  {    16,  2229,  5310,  16,  13, PL_XPOSIXDIGIT }   /* generalcategory=decimalnumber */,
  {     0,  8777,  7951,   3,   5, PL_CWL }   /* cwl=true */,
  {     0,   184,  8007,   3,   4, PL_CWKCF }   /* iscwkcf */,
  {     2,  6890,  3738,   4,  16, PL_LATIN1 }   /* blk=latin1supplement */,
  {     0,   974,  8691,  27,   2, PL_CCC__28 }   /* canonicalcombiningclass=ccc28 */,
  {     0,  5645,  3407,  10,  17, PL_BC__ES }   /* bidiclass=europeanseparator */,
  {    19,  4630,    58,   3,   4, PL_UIDEO }   /* isuideo */,
  {    21,  6890,  6676,   4,  10, PL_INOLDPERSIAN }   /* blk=oldpersian */,
  {     2,  8096,  2674,   4,   9, PL_SUND }   /* scx=sundanese */,
  {     0,  6890,  2408,   4,   6, PL_INBRAHMI }   /* blk=brahmi */,
  {    24,  8340,  5861,   3,  12, PL_JG__MALAYALAMNGA }   /* jg=malayalamnga */,
  {     1,  4757,  7768,  14,   6, -PL_GREXT }   /* graphemeextend=false */,
  {     1,   184,  8263,   2,   2, PL_MC }   /* ismc */,
  {     0,    42,     0,  16,   0, PL_CJKCOMPAT }   /* cjkcompatibility */,
  {     0,  3129,  5777,  17,   4, PL_HEBR }   /* scriptextensions=hebr */,
  {     0,   184,  1724,   2,  22, PL_EARLYDYNASTICCUNEIFORM }   /* isearlydynasticcuneiform */,
  {    11,  2877,     0,  10,   0, PL_DEVA }   /* devanagari */,
  {     0,  8376,   373,   3,   2, PL_LB__OP }   /* lb=op */,
  {     0,  2750,  7768,   4,   2, -PL_TERM }   /* term=f */,
  {     4,  6613,  4561,   3,   3, PL_HEBR }   /* ishebr */,
  {     1,  1503,  3391,   3,  15, PL_ETHIOPICEXT }   /* inethiopicextended */,
  {     0,  7906,  7500,   4,   6, PL_SC__KALI }   /* sc=kayahli */,
  {     0,  4254,     0,  15,   0, PL_DIACRITICALSEXT }   /* diacriticalsext */,
  {     6,  1426,  3978,  22,  16, PL_INSC__SYLLABLEMODIFIER }   /* indicsyllabiccategory=syllablemodifier */,
  {    20,  6221,   115,   4,  23, PL_DIACRITICALS }   /* incombiningdiacriticalmarks */,
  {     2,  5544,  7936,  13,   4, PL_NV__1_SLASH_16 }   /* numericvalue=1/16 */,
  {    49,  6713,  8747,   3,   3, PL_IN__6 }   /* in=6.0 */,
  {     2,  1133,  7951,  26,   5, PL_PCM }   /* prependedconcatenationmark=true */,
  {     2,  8011,   849,   3,  10, PL_CO }   /* gc=privateuse */,
  {     5,   436,  3223,   5,   3, -PL_NCHAR }   /* nchar=no */,
  {     4,  8272,  7951,   4,   5, PL_CWCF }   /* cwcf=true */,
  {     0,  7136,  5336,   6,   8, PL_GREEKEXT }   /* block=greekext */,
  {     4,  7288,  2409,   8,   5, PL_BRAH }   /* script=brahmi */,
  {     1,  1981,     0,  18,   0, PL_CYRILLICSUP }   /* cyrillicsupplement */,
  {     0,  2100,  4511,   4,  13, PL_SARB }   /* isoldsoutharabian */,
  {     7,  8011,  1886,   3,   2, PL_NL }   /* gc=nl */,
  {     2,  5645,  2289,  10,  20, PL_BC__LRE }   /* bidiclass=lefttorightembedding */,
  {     0,  8384,     0,   4,   0, PL_LINB }   /* linb */,
  {     0,  7689,  5246,   3,   4, PL_ASCII }   /* isascii */,
  {    43,  8783,  3581,   3,   2, PL_CWU }   /* cwu=t */,
  {     9,  8096,  7436,   4,   4, PL_ELBA }   /* scx=elba */,
  {     0,  8340,  8837,   3,   3, PL_JG__TAH }   /* jg=tah */,
  {     3,  2229,  4239,  16,  15, PL_PD }   /* generalcategory=dashpunctuation */,
  {     4,  7136,  6944,   6,   9, PL_LATINEXTC }   /* block=latinextc */,
  {    10,   184,  7506,   2,   7, PL_LINA }   /* islineara */,
  {     0,  8096,  7992,   5,   4, PL_BUHD }   /* scx=buhid */,
  {     3,   184,  8476,   2,   4, PL_COPT }   /* isqaac */,
  {    45,  8376,  5583,   3,   9, PL_LB__QU }   /* lb=quotation */,
  {     0,  5134,     0,   3,   0, PL_P }   /* isp */,
  {     7,  6890,  6746,   4,  10, PL_SMALLFORMS }   /* blk=smallforms */,
  {     5,    18,  7997,   2,   2, PL_RI }   /* ri=y */,
  {     0,  7136,  2967,   6,   8, PL_INGEORGIAN }   /* block=georgian */,
  {     2,  8016,  4649,   5,   2, PL_WB__GAZ }   /* gcb=gaz */,
  {     1,  6713,  8735,   3,   3, PL_IN__5_DOT_1 }   /* in=5.1 */,
  {     1,  8096,  2484,   4,  19, PL_EGYP }   /* scx=egyptianhieroglyphs */,
  {     2,  7459,  8066,   3,   5, PL_SC__ORYA }   /* sc=oriya */,
  {     0,   184,  2895,   2,   8, PL_ETHI }   /* isethiopic */,
  {    37,  8096,  6439,   4,   4, PL_SYLO }   /* scx=sylo */,
  {     1,   184,  4254,   2,  15, PL_DIACRITICALSEXT }   /* isdiacriticalsext */,
  {    11,   184,  8046,   2,   5, PL_LIMB }   /* islimbu */,
  {     0,   184,  3111,   2,  18, PL_RUMI }   /* isruminumeralsymbols */,
  {    24,  5645,  4729,  10,  14, PL_BC__EN }   /* bidiclass=europeannumber */,
  {     4,   974,  4538,  24,   2, PL_CCC__0 }   /* canonicalcombiningclass=nr */,
  {     1,  8011,  6340,   3,  11, PL_LO }   /* gc=otherletter */,
  {     2,  5645,   102,  10,   2, PL_BC__ET }   /* bidiclass=et */,
  {     3,  6263,  3521,  10,   5, PL_LB__SP }   /* linebreak=space */,
  {     1,  8340,  5439,   4,   4, PL_JG__GAMAL }   /* jg=gamal */,
  {     0,  6890,   510,   4,  20, PL_CJK }   /* blk=cjkunifiedideographs */,
  {     2,  8096,  8440,   4,   4, PL_OGAM }   /* scx=ogam */,
  {     8,  7625,     0,   7,   0, PL_SUPPUAB }   /* suppuab */,
  {     3,  5544,  8161,  13,   3, PL_NV__3_SLASH_2 }   /* numericvalue=3/2 */,
  {     1,  3129,  2895,  17,   4, PL_ETHI }   /* scriptextensions=ethi */,
  {     1,  8816,  8758,   3,   2, PL_NV__37 }   /* nv=37 */,
  {     0,  7660,     0,   4,   0, PL_TIRH }   /* tirh */,
  {    14,  6890,  7422,   4,   7, PL_CJKEXTF }   /* blk=cjkextf */,
  {     0,  6554,  7992,   3,   4, PL_INBUHID }   /* inbuhid */,
  {     5,  1417,  2521,   9,   2, PL_PF }   /* category=pf */,
  {     0,  1417,    38,   9,   2, PL_XPOSIXDIGIT }   /* category=nd */,
  {     1,  6890,  2967,   4,  11, PL_GEORGIANSUP }   /* blk=georgiansup */,
  {     1,  4198,  2952,   5,  15, PL_INPUNCTUATION }   /* ingeneralpunctuation */,
  {     0,  4104,     0,   4,   0, PL_BAMU }   /* bamu */,
  {    20,  8096,  7681,   4,   7, PL_ZZZZ }   /* scx=unknown */,
  {     2,  8816,  7732,   3,   5, PL_NV__50000 }   /* nv=50000 */,
  {     0,  4314,  4935,  13,   4, PL_JG__BETH }   /* joininggroup=beth */,
  {     0,  1133,     0,  26,   0, PL_PCM }   /* prependedconcatenationmark */,
  {    44,  6472,  5753,  10,  12, PL_WB__GAZ }   /* wordbreak=glueafterzwj */,
  {     5,  8204,  3581,   4,   2, PL_POSIXXDIGIT }   /* ahex=t */,
  {   121,  8096,  8046,   4,   5, PL_LIMB }   /* scx=limbu */,
  {     0,  7840,   893,   3,  27, PL_VSSUP }   /* isvariationselectorssupplement */,
  {     6,  1372,     0,   2,   0, PL_LU }   /* lu */,
  {     5,  7136,  4590,   6,   2, PL_INVS }   /* block=vs */,
  {     0,  8264,     0,   4,   0, PL_CANS }   /* cans */,
  {     0,  7816,  3223,   6,   2, -PL_GRBASE }   /* grbase=n */,
  {     1,  7136,  6980,   6,   9, PL_INNABATAEAN }   /* block=nabataean */,
  {     5,   184,   221,   2,   2, PL_L_AMP_ }   /* isl_ */,
  {     0,   974,  7944,  24,   2, PL_CCC__12 }   /* canonicalcombiningclass=12 */,
  {     0,   184,  8372,   2,   4, PL_LATN }   /* islatn */,
  {     1,  5121,     0,  14,   0, PL_PHLP }   /* psalterpahlavi */,
  {    56,  6890,  4224,   4,  15, PL_CURRENCYSYMBOLS }   /* blk=currencysymbols */,
  {    33,  8096,  7632,   4,   7, PL_TGLG }   /* scx=tagalog */,
  {    10,  6713,  8864,   3,   3, PL_IN__5 }   /* in=v50 */,
  {     0,  7569,     0,   4,   0, PL_OSMA }   /* osma */,
  {   120,  5544,  8905,  13,   2, PL_NV__39 }   /* numericvalue=39 */,
  {     0,  6890,  1209,   4,  25, PL_SUPERANDSUB }   /* blk=superscriptsandsubscripts */,
  {     3,  8240,  2655,   3,  19, PL_BC__RLO }   /* bc=righttoleftoverride */,
  {     3,  7136,  3441,   6,  17, PL_LETTERLIKESYMBOLS }   /* block=letterlikesymbols */,
  {     1,  6263,  4898,  11,  13, PL_LB__BK }   /* linebreak=mandatorybreak */,
  {    27,  1812,     0,  15,   0, PL_TRANSPORTANDMAP }   /* transportandmap */,
  {   128,   119,  7193,   3,   7, PL_INGUJARATI }   /* ingujarati */,
  {     7,  7288,  4010,   7,   6, PL_TANG }   /* script=tangut */,
  {     0,   184,  7366,   2,   4, PL_BENG }   /* isbeng */,
  {     1,  6890,  4419,   4,  15, PL_MISCPICTOGRAPHS }   /* blk=miscpictographs */,
  {     0,  7288,  8046,   7,   4, PL_SC__LIMB }   /* script=limb */,
  {     2,  3690,     0,  16,   0, PL_PF }   /* finalpunctuation */,
  {    35,  4855,     0,  14,   0, PL_LATINEXTC }   /* latinextendedc */,
  {     2,  1184,  7951,  25,   5, PL_DI }   /* defaultignorablecodepoint=true */,
  {     0,  7459,  7918,   3,   6, PL_SC__THAA }   /* sc=thaana */,
  {     0,  6439,     0,   4,   0, PL_SYLO }   /* sylo */,
  {     0,  8096,  6626,   4,   4, PL_KHAR }   /* scx=khar */,
  {     0,  2531,     0,   4,   0, PL_MULT }   /* mult */,
  {     0,  8016,  5754,   5,  11, PL_WB__GAZ }   /* gcb=glueafterzwj */,
  {     3,  8816,  7720,   3,   4, PL_NV__4000 }   /* nv=4000 */,
  {     9,  5134,   473,   3,   2, PL_PUA }   /* ispua */,
  {    29,  7459,  7822,   3,   6, PL_HATR }   /* sc=hatran */,
  {     8,  7288,  5825,   7,   4, PL_SC__MAHJ }   /* script=mahj */,
  {     0,  8504,  1929,   3,   5, PL_SB__UP }   /* sb=upper */,
  {     1,  6890,  1258,   4,  24, PL_ARABICPFB }   /* blk=arabicpresentationformsb */,
  {     0,  6076,  7997,  11,   2, PL_BIDIC }   /* bidicontrol=y */,
  {     1,  5192,   448,   3,  31, PL_IDEOGRAPHICSYMBOLS }   /* isideographicsymbolsandpunctuation */,
  {    11,  2985,  3223,  18,   3, -PL_IDST }   /* idstrinaryoperator=no */,
  {     0,  2967,     0,  11,   0, PL_GEORGIANSUP }   /* georgiansup */,
  {     8,  8376,  5570,   3,  13, PL_LB__PR }   /* lb=prefixnumeric */,
  {     2,  5596,     0,  13,   0, PL_VERTICALFORMS }   /* verticalforms */,
  {     3,  1855,  3223,  21,   3, -PL_CWCM }   /* changeswhencasemapped=no */,
  {     1,  8011,  8937,   3,   2, PL_ZL }   /* gc=zl */,
  {     1,   808,     0,  11,   0, PL_PHONETICEXT }   /* phoneticext */,
  {     0,   184,  3021,   2,   9, PL_LATINEXTA }   /* islatinexta */,
  {     0,  7288,  8480,   7,   4, PL_SC__QAAI }   /* script=qaai */,
  {     0,  7459,    57,   3,   2, PL_SC__YI }   /* sc=yi */,
  {     1,  2249,     0,  13,   0, PL_GLAGOLITICSUP }   /* glagoliticsup */,
  {     6,  7224,    62,   8,   5, PL_XPOSIXGRAPH }   /* isxposixgraph */,
  {     2,  4542,  7654,   3,   6, PL_TIBT }   /* istibetan */,
  {     2,  8340,  5453,   3,  13, PL_JG__MANICHAEANMEM }   /* jg=manichaeanmem */,
  {     0,    11,  7768,   3,   2, -PL_DIA }   /* dia=f */,
  {     4,  1963,  7951,   7,   5, PL_RADICAL }   /* radical=true */,
  {     1,  1417,  1797,   9,  14, PL_LM }   /* category=modifierletter */,
  {     2,  8340,  8774,   3,   3, PL_JG__BEH }   /* jg=beh */,
  {     0,  3339,     0,  17,   0, PL_CYRILLICEXTB }   /* cyrillicextendedb */,
  {    49,  6613,    34,   3,   2, PL_XPOSIXXDIGIT }   /* ishex */,
  {     0,  8276,  3223,   4,   3, -PL_CWCM }   /* cwcm=no */,
  {     0,  6890,  1543,   4,  23, PL_GEOMETRICSHAPESEXT }   /* blk=geometricshapesextended */,
  {     0,  3129,  4010,  17,   6, PL_TANG }   /* scriptextensions=tangut */,
  {     4,  6890,  1589,   4,  23, PL_LATINEXTADDITIONAL }   /* blk=latinextendedadditional */,
  {     1,   184,  4134,   2,  15, PL_BRAI }   /* isbraillepatterns */,
  {     2,   750,     0,  22,   0, PL_ENCLOSEDIDEOGRAPHICSUP }   /* enclosedideographicsup */,
  {   176,  8240,   435,   3,   2, PL_BC__ON }   /* bc=on */,
  {     1,  7459,  8604,   3,   4, PL_SC__ZYYY }   /* sc=zyyy */,
  {     2,   184,  7882,   2,   4, PL_LYDI }   /* islydi */,
  {     0,  7136,   779,   6,  29, PL_MISCARROWS }   /* block=miscellaneoussymbolsandarrows */,
  {     0,  8016,    70,   4,   2, PL_GCB__PP }   /* gcb=pp */,
  {     7,  6483,  3581,   4,   2, PL_XIDC }   /* xidc=t */,
  {     0,  6210,  1982,   3,  20, PL_CYRILLICSUP }   /* incyrillicsupplementary */,
  {     1,  7025,     0,   9,   0, PL_ORKH }   /* oldturkic */,
  {     0,  5544,  8172,  13,   4, PL_NV__3_SLASH_16 }   /* numericvalue=3/16 */,
  {    17,  6263,  1886,  10,   2, PL_LB__NL }   /* linebreak=nl */,
  {     3,  7459,  2841,   3,   4, PL_SC__COPT }   /* sc=copt */,
  {     0,  5544,  8758,  13,   2, PL_NV__37 }   /* numericvalue=37 */,
  {     0,  8816,  7936,   3,   5, PL_NV__1_SLASH_160 }   /* nv=1/160 */,
  {    33,  1448,   839,   5,  25, PL_SUPPUAA }   /* insupplementaryprivateuseareaa */,
  {     0,  8016,  1083,   4,   2, PL_LB__LF }   /* gcb=lf */,
  {     4,  7459,  8296,   3,   4, PL_GONM }   /* sc=gonm */,
  {     2,  8340,  3458,   3,  17, PL_JG__MANICHAEANDHAMEDH }   /* jg=manichaeandhamedh */,
  {     0,  2100,  7018,   4,   7, PL_PERM }   /* isoldpermic */,
  {     4,  3129,  8244,  17,   4, PL_BHKS }   /* scriptextensions=bhks */,
  {     1,  1897,  7997,  21,   2, PL_CWT }   /* changeswhentitlecased=y */,
  {     0,  8272,  3223,   4,   2, -PL_CWCF }   /* cwcf=n */,
  {     0,  1724,     0,  22,   0, PL_EARLYDYNASTICCUNEIFORM }   /* earlydynasticcuneiform */,
  {    71,  6890,  1612,   4,  23, PL_SHORTHANDFORMATCONTROLS }   /* blk=shorthandformatcontrols */,
  {     6,  7459,  8056,   3,   5, PL_NSHU }   /* sc=nushu */,
  {     0,  8816,  8691,   3,   2, PL_NV__28 }   /* nv=28 */,
  {    11,  8376,  1479,   3,   2, PL_LB__AI }   /* lb=ai */,
  {     0,  6890,  7296,   4,   8, PL_SPECIALS }   /* blk=specials */,
  {     0,   184,  2788,   3,   7, PL_CHER }   /* ischerokee */,
  {     0,  6263,  5789,  10,  12, PL_LB__IS }   /* linebreak=infixnumeric */,
  {   113,  7457,  2625,   5,  10, PL_INSC__TONELETTER }   /* insc=toneletter */,
  {     1,   184,  4813,   2,  14, PL_KANASUP }   /* iskanasupplement */,
  {     4,  5245,  7951,  13,   5, PL_POSIXXDIGIT }   /* asciihexdigit=true */,
  {     0,  8340,  6523,   3,   3, PL_JG__FEH }   /* jg=feh */,
  {     2,  4314,  4389,  13,  15, PL_JG__MANICHAEANZAYIN }   /* joininggroup=manichaeanzayin */,
  {     1,  1402,  3171,  24,  12, PL_INPC__LEFTANDRIGHT }   /* indicpositionalcategory=leftandright */,
  {     2,  1417,  5253,   9,   5, PL_XPOSIXDIGIT }   /* category=digit */,
  {     5,  7459,  4134,   3,   4, PL_BRAI }   /* sc=brai */,
  {     1,  1448,  1212,   5,  22, PL_SUPERANDSUB }   /* insuperscriptsandsubscripts */,
  {     1,   184,  1543,   2,  23, PL_GEOMETRICSHAPESEXT }   /* isgeometricshapesextended */,
  {     8,  7136,  7367,   7,   6, PL_INBENGALI }   /* block=bengali */,
  {    62,  1206,  3148,   3,  10, PL_TAIXUANJING }   /* intaixuanjing */,
  {     0,  1081,     0,  26,   0, PL_HALFANDFULLFORMS }   /* halfwidthandfullwidthforms */,
  {     0,  6890,  3237,   4,  10, PL_ALCHEMICAL }   /* blk=alchemical */,
  {     2,  6713,  8849,   3,   3, PL_IN__3 }   /* in=v30 */,
  {     5,  2859,    45,  18,   3, PL_DT__COM }   /* decompositiontype=com */,
  {     0,  7380,  7944,   7,   2, PL_CCC__12 }   /* ccc=ccc12 */,
  {   129,  5645,  7951,   5,   5, PL_BIDIC }   /* bidic=true */,
  {     0,  7288,  7312,   7,   8, PL_SC__TAGB }   /* script=tagbanwa */,
  {     0,  8786,  7888,   3,   6, PL_EA__NA }   /* ea=narrow */,
  {     0,  7478,  1194,   3,   3, PL_SORA }   /* issora */,
  {    35,   974,  8916,  27,   2, PL_CCC__84 }   /* canonicalcombiningclass=ccc84 */,
  {     1,  7344,  3223,   4,   3, -PL_XIDS }   /* xids=no */,
  {    17,  3129,  8280,  17,   4, PL_CYRL }   /* scriptextensions=cyrl */,
  {     0,  2877,     0,  18,   0, PL_DEVANAGARIEXT }   /* devanagariextended */,
  {     0,  3424,  3223,   4,   2, -PL_IDSB }   /* idsb=n */,
  {     0,    11,  3581,   3,   2, PL_DIA }   /* dia=t */,
  {    73,  8508,     8,   4,   3, PL_LANA }   /* sc=lana */,
  {     2,  8096,  3288,   4,  17, PL_AGHB }   /* scx=caucasianalbanian */,
  {    68,  7471,  6472,   7,   4, PL_POSIXWORD }   /* isposixword */,
  {     0,  3129,  7858,  17,   4, PL_KHOJ }   /* scriptextensions=khoj */,
  {    16,  7136,  7660,   6,   7, PL_INTIRHUTA }   /* block=tirhuta */,
  {     2,    21,   948,   3,  16, PL_ANCIENTGREEKMUSIC }   /* inancientgreekmusic */,
  {    33,  7288,  5957,   7,   4, PL_MEND }   /* script=mend */,
  {     1,  8376,  8925,   3,   2, PL_LB__H3 }   /* lb=h3 */,
  {     4,  8572,  6971,   3,   9, PL_WB__MB }   /* wb=midnumlet */,
  {    18,  3084,     0,   9,   0, PL_Z }   /* separator */,
  {     2,  8096,  8264,   4,   4, PL_CANS }   /* scx=cans */,
  {     0,   184,   361,   2,  21, PL_MATHOPERATORS }   /* ismathematicaloperators */,
  {     0,  7471,  7986,   7,   5, PL_POSIXBLANK }   /* isposixblank */,
  {    10,  8116,     0,   5,   0, PL_TAML }   /* tamil */,
  {     0,  4402,  4420,   3,  14, PL_MISCPICTOGRAPHS }   /* inmiscpictographs */,
  {     1,  5134,  8465,   3,   3, PL_PHNX }   /* isphnx */,
  {     0,  8240,  2289,   3,  20, PL_BC__LRE }   /* bc=lefttorightembedding */,
  {     0,  6210,    43,   3,   8, PL_CJKCOMPAT }   /* incjkcompat */,
  {     0,  8340,  5466,   3,  13, PL_JG__MANICHAEANNUN }   /* jg=manichaeannun */,
  {     0,  6208,     0,   5,   0, PL_JOINC }   /* joinc */,
  {     1,   974,    16,  24,   1, PL_CCC__B }   /* canonicalcombiningclass=b */,
  {     0,  8786,     8,   3,   1, PL_EA__A }   /* ea=a */,
  {     0,   849,     0,  10,   0, PL_CO }   /* privateuse */,
  {     0,   184,  1702,   2,  12, PL_DIACRITICALS }   /* isdiacriticals */,
  {    20,  7136,  1001,   6,  27, PL_ENCLOSEDCJK }   /* block=enclosedcjklettersandmonths */,
  {     2,  7457,  1330,   5,  24, PL_INSC__CONSONANTSUCCEEDINGREPHA }   /* insc=consonantsucceedingrepha */,
  {     0,  5134,  7036,   4,   7, PL_PALM }   /* ispalmyrene */,
  {   128,  7459,  8412,   3,   4, PL_MTEI }   /* sc=mtei */,
  {     1,  8196,  8152,   4,   4, PL_AGE__10 }   /* age=10.0 */,
  {    57,  7457,  3305,   5,  17, PL_INSC__CONSONANTPREFIXED }   /* insc=consonantprefixed */,
  {     1,  5657,  7768,  12,   6, -PL_BIDIM }   /* bidimirrored=false */,
  {    17,  7696,     0,   6,   0, PL_XPOSIXSPACE }   /* wspace */,
  {     2,  6263,    18,  10,   2, PL_RI }   /* linebreak=ri */,
  {     0,  8816,  8168,   3,   2, PL_NV__17 }   /* nv=17 */,
  {     1,  8240,    25,   3,   1, PL_BC__S }   /* bc=s */,
  {     8,  7459,  8284,   3,   4, PL_DSRT }   /* sc=dsrt */,
  {     4,  7136,   849,   6,  10, PL_PUA }   /* block=privateuse */,
  {    23,  4314,  4785,  13,  14, PL_JG__HAMZAONHEHGOAL }   /* joininggroup=hamzaonhehgoal */,
  {     5,  5544,  7702,  13,   2, PL_NV__20 }   /* numericvalue=20 */,
  {     1,  7459,  8216,   3,   4, PL_ARMI }   /* sc=armi */,
  {    24,   184,  3610,   2,   4, PL_BOPO }   /* isbopo */,
  {     0,  8016,  3526,   4,  17, PL_RI }   /* gcb=regionalindicator */,
  {     8,  8026,  2355,   5,   6, PL_INPC__BOTTOM }   /* inpc=bottom */,
  {    10,  8196,  7702,   4,   1, PL_AGE__2 }   /* age=2 */,
  {     2,  6890,  2877,   4,  18, PL_DEVANAGARIEXT }   /* blk=devanagariextended */,
  {     0,   184,  4104,   2,   4, PL_BAMU }   /* isbamu */,
  {     1,  3129,  7971,  17,   5, PL_BATK }   /* scriptextensions=batak */,
  {   130,  2229,    36,  17,   1, PL_LT }   /* generalcategory=lt */,
  {     1,  3129,  7956,  17,   5, PL_ADLM }   /* scriptextensions=adlam */,
  {    11,    11,  3223,   2,   2, -PL_DI }   /* di=n */,
  {     0,  8312,     0,   4,   0, PL_HAN }   /* hani */,
  {     5,  7136,  6736,   6,  10, PL_INSAURASHTRA }   /* block=saurashtra */,
  {     0,  7387,     0,   7,   0, PL_CJKEXTA }   /* cjkexta */,
  {     1,  2229,  1452,  16,   2, PL_PS }   /* generalcategory=ps */,
  {     0,  1834,     0,  21,   0, PL_CWCF }   /* changeswhencasefolded */,
  {     2,  6890,   947,   4,  27, PL_ANCIENTGREEKMUSIC }   /* blk=ancientgreekmusicalnotation */,
  {     3,   974,    24,  24,   1, PL_CCC__L }   /* canonicalcombiningclass=l */,
  {     8,  7344,  3223,   8,   3, -PL_XIDS }   /* xidstart=no */,
  {     0,  4542,  2117,   3,   3, PL_THAI }   /* isthai */,
  {     4,   217,  7052,   6,   9, PL__PERL_QUOTEMETA }   /* _perl_quotemeta */,
  {     1,   698,     0,   2,   0, PL_MN }   /* mn */,
  {     0,  7689,    80,   4,  33, PL_ARABICMATH }   /* isarabicmathematicalalphabeticsymbols */,
  {     1,  7471,  5315,   7,   5, PL_POSIXALNUM }   /* isposixalnum */,
  {     1,  2617,     0,  19,   0, PL_MODIFIERTONELETTERS }   /* modifiertoneletters */,
  {    40,  7136,  3390,   6,  11, PL_ETHIOPICEXT }   /* block=ethiopicext */,
  {     0,    32,     0,   2,   0, PL_CS }   /* cs */,
  {    68,  7380,  8632,   4,   2, PL_CCC__91 }   /* ccc=91 */,
  {     1,  3129,  7583,  17,   7, PL_PHAG }   /* scriptextensions=phagspa */,
  {    20,  7478,  3561,   3,  16, PL_SUTTONSIGNWRITING }   /* issuttonsignwriting */,
  {     0,  8240,  2931,   3,  18, PL_BC__FSI }   /* bc=firststrongisolate */,
  {     1,  2229,  1106,  16,   2, PL_SK }   /* generalcategory=sk */,
  {    23,  8096,  5933,   4,  12, PL_GONM }   /* scx=masaramgondi */,
  {    64,  6484,  3223,  10,   3, -PL_IDC }   /* idcontinue=no */,
  {    82,  8016,  5082,   4,  11, PL_GCB__SM }   /* gcb=spacingmark */,
  {    80,  7288,  8324,   7,   4, PL_HMNG }   /* script=hmng */,
  {    81,  4314,  8828,  13,   3, PL_JG__REH }   /* joininggroup=reh */,
  {   100,  7288,  8312,   7,   4, PL_SC__HAN }   /* script=hani */,
  {     0,  6890,  6935,   4,   9, PL_LATINEXTB }   /* blk=latinextb */,
  {     1,  8096,  8492,   4,   4, PL_RUNR }   /* scx=runr */,
  {     0,  7136,  1960,   6,  14, PL_CJKRADICALSSUP }   /* block=cjkradicalssup */,
  {    13,  7894,  3581,   6,   2, PL_PATSYN }   /* patsyn=t */,
  {     0,  8011,   132,   3,   2, PL_LM }   /* gc=lm */,
  {     1,  1929,  7997,   9,   2, PL_XPOSIXUPPER }   /* uppercase=y */,
  {     7,  7459,  6439,   3,   4, PL_SC__SYLO }   /* sc=sylo */,
  {     1,  1426,  7112,  22,   8, PL_INSC__AVAGRAHA }   /* indicsyllabiccategory=avagraha */,
  {     2,  2560,     0,  19,   0, PL_JAMOEXTB }   /* hanguljamoextendedb */,
  {     6,  6613,  2542,   3,  18, PL_JAMOEXTA }   /* ishanguljamoextendeda */,
  {     1,  8232,     0,   4,   0, PL_AVST }   /* avst */,
  {     0,  8396,     0,   4,   0, PL_MERC }   /* merc */,
  {     7,  8046,     0,   5,   0, PL_LIMB }   /* limbu */,
  {     0,  3610,     0,   4,   0, PL_BOPO }   /* bopo */,
  {    11,  5134,  1541,   3,   3, PL_PHAG }   /* isphag */,
  {    15,   415,  7997,  11,   2, PL_IDEO }   /* ideographic=y */,
  {     1,  8340,  4963,   3,   4, PL_JG__HETH }   /* jg=heth */,
  {     0,  8340,  5502,   3,   3, PL_JG__TAW }   /* jg=taw */,
  {     0,  7459,  4404,   3,  15, PL_MERC }   /* sc=meroiticcursive */,
  {    22,  7136,  6120,   6,   6, PL_DOMINO }   /* block=domino */,
  {     0,  7136,  2249,   6,  13, PL_GLAGOLITICSUP }   /* block=glagoliticsup */,
  {     0,    21,  3738,   2,  16, PL_LATIN1 }   /* inlatin1supplement */,
  {     2,  7471,     0,   4,   0, PL_PO }   /* ispo */,
  {     3,  4402,  6308,   3,  10, PL_MYANMAREXTA }   /* inmyanmarexta */,
  {     0,  1402,  2295,  24,   5, PL_INPC__RIGHT }   /* indicpositionalcategory=right */,
  {     0,  7906,   498,   5,   3, PL_KHMR }   /* sc=khmer */,
  {     1,  7457,  4179,   5,  15, PL_INSC__CONSONANTMEDIAL }   /* insc=consonantmedial */,
  {    10,   184,  4869,   2,  14, PL_LATINEXTD }   /* islatinextendedd */,
  {     7,  7994,   966,   4,   2, -PL_IDC }   /* idc=no */,
  {     2,  7459,  4300,   4,  14, PL_ARMI }   /* sc=imperialaramaic */,
  {     3,  3946,  7997,  16,   2, PL_STERM }   /* sentenceterminal=y */,
  {     9,  7459,  8316,   3,   4, PL_SC__HANO }   /* sc=hano */,
  {     4,  8026,  2349,   5,   3, PL_INPC__TOP }   /* inpc=top */,
  {    94,  8376,  6880,   3,   2, PL_LB__BB }   /* lb=bb */,
  {     5,  7471,  5252,   7,   6, PL_POSIXXDIGIT }   /* isposixxdigit */,
  {     0,  3129,  6736,  17,   4, PL_SAUR }   /* scriptextensions=saur */,
  {     2,  6890,  7611,   4,   7, PL_INSOYOMBO }   /* blk=soyombo */,
  {     1,   974,  8933,  24,   2, PL_CCC__9 }   /* canonicalcombiningclass=vr */,
  {    10,  5544,  7756,  13,   1, PL_NV__9 }   /* numericvalue=9 */,
  {     1,  8816,  7714,   3,   1, PL_NV__3 }   /* nv=3 */,
  {     1,  2107,     0,   7,   0, PL_SINH }   /* sinhala */,
  {     2,  6005,     0,  12,   0, PL_HUNG }   /* oldhungarian */,
  {     0,  7136,  5933,   6,  12, PL_INMASARAMGONDI }   /* block=masaramgondi */,
  {     0,  7136,    78,   6,  35, PL_ARABICMATH }   /* block=arabicmathematicalalphabeticsymbols */,
  {     0,  6472,  6971,  10,   6, PL_WB__MN }   /* wordbreak=midnum */,
  {     0,  5544,  7941,  13,   5, PL_NV__11_SLASH_12 }   /* numericvalue=11/12 */,
  {     0,  6890,  7625,   4,   7, PL_SUPPUAB }   /* blk=suppuab */,
  {     4,  4299,     0,  15,   0, PL_ARMI }   /* imperialaramaic */,
  {     1,   892,  3223,  17,   2, -PL_VS }   /* variationselector=n */,
  {     5,  8604,     0,   4,   0, PL_ZYYY }   /* zyyy */,
  {    11,  7459,  4494,   3,  15, PL_NARB }   /* sc=oldnortharabian */,
  {     0,  6890,  6546,   4,  10, PL_ASCII }   /* blk=basiclatin */,
  {     1,  7478,   865,   3,  27, PL_SUPPUAB }   /* issupplementaryprivateuseareab */,
  {     8,  6890,  6989,   4,   9, PL_INNEWTAILUE }   /* blk=newtailue */,
  {     1,  7288,  7604,   7,   4, PL_SIDD }   /* script=sidd */,
  {     0,   184,  5933,   2,  12, PL_GONM }   /* ismasaramgondi */,
  {     9,  8816,  8917,   3,   2, PL_NV__49 }   /* nv=49 */,
  {     2,  6890,  1107,   4,  26, PL_KATAKANAEXT }   /* blk=katakanaphoneticextensions */,
  {    56,   184,  6616,   2,  10, PL_DEP }   /* isdeprecated */,
  {     1,  6263,  7828,  10,   6, PL_LB__HY }   /* linebreak=hyphen */,
  {     0,  7136,  7436,   6,   7, PL_INELBASAN }   /* block=elbasan */,
  {     7,  2674,     0,   9,   0, PL_SUND }   /* sundanese */,
  {     0,    57,     0,   2,   0, PL_YI }   /* yi */,
  {    32,  1448,  7628,   5,   4, PL_SUPPUAB }   /* insuppuab */,
  {     1,  8026,  3171,   5,  12, PL_INPC__LEFTANDRIGHT }   /* inpc=leftandright */,
  {     4,  8096,  8448,   4,   4, PL_ORKH }   /* scx=orkh */,
  {     6,  5968,  7026,   3,   8, PL_INOLDTURKIC }   /* inoldturkic */,
  {    11,  5544,  8897,  13,   2, PL_NV__19 }   /* numericvalue=19 */,
  {     0,  4402,  7528,   3,   6, PL_INMULTANI }   /* inmultani */,
  {     2,   949,  3581,   2,   2, PL_CI }   /* ci=t */,
  {     2,  7459,  3674,   3,   7, PL_SC__CPRT }   /* sc=cypriot */,
  {     2,  6713,  8885,   3,   3, PL_IN__7 }   /* in=v70 */,
  {     1,  7224,   468,   8,   5, PL_XPOSIXPUNCT }   /* isxposixpunct */,
  {     4,  8026,     9,   5,   2, PL_INPC__NA }   /* inpc=na */,
  {    10,  1426,  3305,  22,  17, PL_INSC__CONSONANTPREFIXED }   /* indicsyllabiccategory=consonantprefixed */,
  {     0,  4757,  3223,  14,   3, -PL_GREXT }   /* graphemeextend=no */,
  {    34,  8096,  7882,   4,   4, PL_LYDI }   /* scx=lydi */,
  {     2,    78,     0,   4,   0, PL_ARAB }   /* arab */,
  {   198,  7459,  8556,   3,   4, PL_THAI }   /* sc=thai */,
  {     1,  7380,  8640,   4,   2, PL_CCC__18 }   /* ccc=18 */,
  {     3,  7689,  3238,   3,  16, PL_ALCHEMICAL }   /* isalchemicalsymbols */,
  {     0,  8376,   202,   3,   2, PL_LB__SA }   /* lb=sa */,
  {     1,  7136,  1543,   6,  15, PL_GEOMETRICSHAPES }   /* block=geometricshapes */,
  {     4,  8328,  5260,   4,  11, PL_BLOCKELEMENTS }   /* inblockelements */,
  {     0,  7136,  7621,   6,   3, PL_PUA }   /* block=pua */,
  {     2,  5705,     0,  12,   0, PL_CYRILLICEXTC }   /* cyrillicextc */,
  {     6,  7344,  7768,   4,   6, -PL_XIDS }   /* xids=false */,
  {   102,  5192,  6485,   3,   9, PL_IDC }   /* isidcontinue */,
  {   171,  5134,  5559,   4,  11, PL_PATSYN }   /* ispatternsyntax */,
  {     0,  8572,   125,   3,   2, PL_LB__CR }   /* wb=cr */,
  {     0,  7288,  2877,   7,   4, PL_SC__DEVA }   /* script=deva */,
  {     0,  8011,  4524,   3,  15, PL_PS }   /* gc=openpunctuation */,
  {     1,  3129,  8260,  17,   4, PL_CAKM }   /* scriptextensions=cakm */,
  {     1,   184,  2466,   3,  18, PL_COUNTINGROD }   /* iscountingrodnumerals */,
  {     1,  1448,  6407,   3,  10, PL_INSORASOMPENG }   /* insorasompeng */,
  {     0,  8816,  8913,   3,   2, PL_NV__47 }   /* nv=47 */,
  {     0,  7344,  3223,   8,   2, -PL_XIDS }   /* xidstart=n */,
  {     0,  6340,     0,  11,   0, PL_LO }   /* otherletter */,
  {     0,  8248,   722,   4,   5, PL_BPT__C }   /* bpt=close */,
  {     0,  6219,  3223,  11,   3, -PL_JOINC }   /* joincontrol=no */,
  {     0,  1855,  7768,  21,   2, -PL_CWCM }   /* changeswhencasemapped=f */,
  {     0,   974,  5220,  24,   1, PL_CCC__0 }   /* canonicalcombiningclass=0 */,
  {     4,  7380,  7709,   4,   2, PL_CCC__16 }   /* ccc=16 */,
  {     1,  7459,  8464,   3,   4, PL_PHNX }   /* sc=phnx */,
  {     2,  8340,  4792,   3,   3, PL_JG__HEH }   /* jg=heh */,
  {     0,  4314,  5427,  13,  13, PL_JG__MALAYALAMLLLA }   /* joininggroup=malayalamllla */,
  {     2,  1402,  3165,  24,  10, PL_INPC__TOPANDLEFT }   /* indicpositionalcategory=topandleft */,
  {     0,  2408,     0,   4,   0, PL_BRAH }   /* brah */,
  {     5,  5544,  8674,  13,   2, PL_NV__42 }   /* numericvalue=42 */,
  {     0,  7288,  8584,   7,   4, PL_XSUX }   /* script=xsux */,
  {     0,  7288,  8091,   7,   5, PL_RUNR }   /* script=runic */,
  {     1,  8096,  6406,   4,   4, PL_SORA }   /* scx=sora */,
  {   104,  3129,  7786,  17,   6, PL_CAKM }   /* scriptextensions=chakma */,
  {     0,  7459,  1566,   3,   6, PL_SC__HANG }   /* sc=hangul */,
  {     1,  8508,  7871,   4,   3, PL_LEPC }   /* sc=lepc */,
  {     1,  7136,  7359,   6,   7, PL_INAVESTAN }   /* block=avestan */,
  {     7,  3114,  1174,   3,   3, PL_UCAS }   /* inucas */,
  {     1,  7288,  4010,   7,   4, PL_TANG }   /* script=tang */,
  {    23,  7459,  7366,   3,   7, PL_SC__BENG }   /* sc=bengali */,
  {     0,  1834,  3581,  21,   2, PL_CWCF }   /* changeswhencasefolded=t */,
  {     2,  6786,     0,  10,   0, PL_SUPARROWSC }   /* suparrowsc */,
  {     1,  7136,   479,   6,  31, PL_MATHALPHANUM }   /* block=mathematicalalphanumericsymbols */,
  {     0,  8288,  8292,   3,   4, PL_DT__FONT }   /* dt=font */,
  {     2,  8126,     0,   5,   0, PL_VSSUP }   /* vssup */,
  {     2,  8572,  5772,   3,   5, PL_WB__EB }   /* wb=ebase */,
  {     0,  6713,  7714,   3,   1, PL_IN__3 }   /* in=3 */,
  {     3,  4402,  2637,   3,  11, PL_MONGOLIANSUP }   /* inmongoliansup */,
  {     2,  7136,   750,   6,  22, PL_ENCLOSEDIDEOGRAPHICSUP }   /* block=enclosedideographicsup */,
  {     1,   184,  7128,   2,   8, PL_BASS }   /* isbassavah */,
  {     2,  7459,  5121,   3,  14, PL_SC__PHLP }   /* sc=psalterpahlavi */,
  {     0,  8340,  5492,   3,  13, PL_JG__MANICHAEANTAW }   /* jg=manichaeantaw */,
  {     0,  7136,  2731,   6,  19, PL_SUPARROWSC }   /* block=supplementalarrowsc */,
  {     0,  2990,    80,   4,  33, PL_ARABICMATH }   /* inarabicmathematicalalphabeticsymbols */,
  {     9,  3129,  7016,  17,   9, PL_PERM }   /* scriptextensions=oldpermic */,
  {     0,  3129,  8560,  17,   4, PL_TIBT }   /* scriptextensions=tibt */,
  {     0,  8021,     0,   5,   0, PL_GREXT }   /* grext */,
  {     6,  6890,  4010,   4,   6, PL_INTANGUT }   /* blk=tangut */,
  {     5,  4479,    26,  15,   1, PL_NFKCQC__Y }   /* nfkcquickcheck=y */,
  {     1,   949,  7768,   2,   2, -PL_CI }   /* ci=f */,
  {     0,  1855,  3581,  21,   2, PL_CWCM }   /* changeswhencasemapped=t */,
  {     0,   974,  8702,  24,   3, PL_CCC__DA }   /* canonicalcombiningclass=234 */,
  {     0,  1426,  8051,  22,   5, PL_INSC__NUKTA }   /* indicsyllabiccategory=nukta */,
  {     1,  7136,   630,   6,  30, PL_CJKEXTE }   /* block=cjkunifiedideographsextensione */,
  {     8,   436,  7768,   5,   2, -PL_NCHAR }   /* nchar=f */,
  {    15,  8276,  7768,   4,   2, -PL_CWCM }   /* cwcm=f */,
  {     0,  1402,  4271,   4,  13, PL_DIACRITICALSSUP }   /* indiacriticalssup */,
  {     2,  4479,  8256,   5,   4, PL_NFKCQC__N }   /* nfkcqc=no */,
  {    25,  1159,  7768,  25,   2, -PL_CWKCF }   /* changeswhennfkccasefolded=f */,
  {     0,    21,  7846,   2,   6, PL_INKAITHI }   /* inkaithi */,
  {     3,  5192,   416,   3,  10, PL_IDEO }   /* isideographic */,
  {     3,  1892,  3581,   5,   2, PL_CASED }   /* cased=t */,
  {     0,  8344,  6053,   3,  12, PL_JT__R }   /* jt=rightjoining */,
  {    41,   184,  5945,   2,  12, PL_MATHALPHANUM }   /* ismathalphanum */,
  {     4,  7136,  1612,   6,  23, PL_SHORTHANDFORMATCONTROLS }   /* block=shorthandformatcontrols */,
  {    16,  4402,  2046,   4,  19, PL_MEETEIMAYEKEXT }   /* inmeeteimayekextensions */,
  {     1,  5645,  2309,  10,  20, PL_BC__PDF }   /* bidiclass=popdirectionalformat */,
  {     2,  7459,  4509,   3,  15, PL_SARB }   /* sc=oldsoutharabian */,
  {     0,  6483,  3223,  11,   2, -PL_XIDC }   /* xidcontinue=n */,
  {     3,  7345,  3223,   7,   2, -PL_IDS }   /* idstart=n */,
  {     7,  6890,  1543,   4,  18, PL_GEOMETRICSHAPESEXT }   /* blk=geometricshapesext */,
  {     1,   184,  3390,   2,  16, PL_ETHIOPICEXT }   /* isethiopicextended */,
  {     0,  8340,  4792,   3,   7, PL_JG__HEHGOAL }   /* jg=hehgoal */,
  {     3,   184,  7810,   2,   6, PL_GOTH }   /* isgothic */,
  {     5,  7478,  3544,   3,  16, PL_SMALLFORMS }   /* issmallformvariants */,
  {     2,  7136,  3738,   6,   6, PL_LATIN1 }   /* block=latin1 */,
  {     8,  8340,  5897,   3,  12, PL_JG__MALAYALAMSSA }   /* jg=malayalamssa */,
  {     5,  7478,  5150,   3,  13, PL_SUPPUNCTUATION }   /* issuppunctuation */,
  {     0,  7288,  2841,   7,   4, PL_SC__COPT }   /* script=copt */,
  {     2,  6806,     0,   4,   0, PL_WARA }   /* wara */,
  {     2,  8939,     0,   2,   0, PL_ZP }   /* zp */,
  {     1,  4554,   235,  14,   2, PL_SB__LO }   /* sentencebreak=lo */,
  {     4,  1358,  7768,  20,   2, -PL_CE }   /* compositionexclusion=f */,
  {     0,  1701,     0,   2,   0, PL_SD }   /* sd */,
  {     0,  8196,  8879,   4,   3, PL_AGE__6_DOT_2 }   /* age=v62 */,
  {     1,   974,  8617,  27,   2, PL_CCC__31 }   /* canonicalcombiningclass=ccc31 */,
  {     0,  4542,  7661,   3,   3, PL_TIRH }   /* istirh */,
  {     0,  7136,  1658,   6,  22, PL_CJKCOMPATIDEOGRAPHSSUP }   /* block=cjkcompatideographssup */,
  {     8,   184,  8388,   2,   4, PL_LISU }   /* islisu */,
  {    12,  7459,  8548,   3,   4, PL_TFNG }   /* sc=tfng */,
  {     2,   974,  8646,  27,   2, PL_CCC__29 }   /* canonicalcombiningclass=ccc29 */,
  {     0,    96,  7768,  10,   2, -PL_XPOSIXALPHA }   /* alphabetic=f */,
  {     0,  8340,  7304,   3,   8, PL_JG__SWASHKAF }   /* jg=swashkaf */,
  {     5,    76,  2876,   2,   3, PL_XPOSIXDIGIT }   /* nt=de */,
  {    33,  6263,  5570,  10,  13, PL_LB__PR }   /* linebreak=prefixnumeric */,
  {     0,  6706,  8714,  10,   3, PL_IN__3_DOT_2 }   /* presentin=3.2 */,
  {     0,   184,     0,   3,   0, PL_C }   /* isc */,
  {     4,  7380,  7702,   4,   2, PL_CCC__20 }   /* ccc=20 */,
  {     0,   184,  1189,   2,   2, PL_LT }   /* islt */,
  {   116,  4314,  6533,  13,   3, PL_JG__QAF }   /* joininggroup=qaf */,
  {    16,  6221,   252,   4,  31, PL_DIACRITICALSEXT }   /* incombiningdiacriticalmarksextended */,
  {    66,  1358,  3581,  20,   2, PL_CE }   /* compositionexclusion=t */,
  {    76,  1426,  6716,  22,  10, PL_INSC__PUREKILLER }   /* indicsyllabiccategory=purekiller */,
  {    30,  8376,  1306,   3,  13, PL_LB__CM }   /* lb=combiningmark */,
  {     9,   184,  1628,   3,   6, PL_XPOSIXCNTRL }   /* iscontrol */,
  {     0,  8786,  1081,   3,   9, PL_EA__H }   /* ea=halfwidth */,
  {     0,  6890,  6826,   4,  10, PL_YIRADICALS }   /* blk=yiradicals */,
  {     0,   184,  7520,   2,   7, PL_MARC }   /* ismarchen */,
  {     8,  7288,  5777,   7,   4, PL_HEBR }   /* script=hebr */,
  {     1,  6713,  8750,   3,   3, PL_IN__6_DOT_1 }   /* in=6.1 */,
  {     2,  7136,  6908,   6,   9, PL_EMOTICONS }   /* block=emoticons */,
  {     4,  7136,  3390,   6,  17, PL_ETHIOPICEXTA }   /* block=ethiopicextendeda */,
  {    94,  7459,  8456,   3,   4, PL_OSGE }   /* sc=osge */,
  {   105,  2985,  7997,  18,   4, PL_IDST }   /* idstrinaryoperator=yes */,
  {    37,  6713,  8564,   3,   4, PL_IN__10 }   /* in=v100 */,
  {    49,    21,  3111,   2,   4, PL_RUMI }   /* inrumi */,
  {     2,  4542,  1161,   3,   3, PL_TANG }   /* istang */,
  {     0,  7136,  3770,   6,  16, PL_LINEARBSYLLABARY }   /* block=linearbsyllabary */,
  {     2,  2229,  3084,  20,   9, PL_ZL }   /* generalcategory=lineseparator */,
  {     4,  8340,  4389,   3,  15, PL_JG__MANICHAEANZAYIN }   /* jg=manichaeanzayin */,
  {    20,  7168,  3223,   8,   3, -PL_EXT }   /* extender=no */,
  {     4,  3129,  8584,  17,   4, PL_XSUX }   /* scriptextensions=xsux */,
  {    76,  4590,     0,   2,   0, PL_VS }   /* vs */,
  {    22,  8894,  3183,   3,  18, PL_VO__TR }   /* vo=transformedrotated */,
  {     1,   217,  1074,  33,   5, PL__PERL_PROBLEMATIC_LOCALE_FOLDEDS_START }   /* _perl_problematic_locale_foldeds_start */,
  {     0,  8026,  6042,   3,  11, PL_PLAYINGCARDS }   /* inplayingcards */,
  {     0,    58,  7768,   4,   2, -PL_IDEO }   /* ideo=f */,
  {   161,  4314,  5476,  13,   3, PL_JG__NUN }   /* joininggroup=nun */,
  {     0,  6890,  4590,   4,   2, PL_INVS }   /* blk=vs */,
  {     2,  7894,  7768,   6,   6, -PL_PATSYN }   /* patsyn=false */,
  {     0,  7136,  6935,   6,   9, PL_LATINEXTB }   /* block=latinextb */,
  {   128,  8121,  3581,   5,   2, PL_UIDEO }   /* uideo=t */,
  {     2,  8380,     0,   4,   0, PL_LINA }   /* lina */,
  {    42,   974,   184,  24,   2, PL_CCC__IS }   /* canonicalcombiningclass=is */,
  {     1,  4239,     0,  15,   0, PL_PD }   /* dashpunctuation */,
  {     0,  7906,  6928,   5,   7, PL_SC__SIND }   /* sc=khudawadi */,
  {     1,  8240,     8,   3,   2, PL_BC__AN }   /* bc=an */,
  {     1,  8011,   966,   3,   2, PL_NO }   /* gc=no */,
  {     4,  8336,  7322,   4,   6, PL_INTIFINAGH }   /* intifinagh */,
  {     1,  4630,  7337,   3,   7, PL_UGAR }   /* isugaritic */,
  {     1,  7345,  7997,   7,   4, PL_IDS }   /* idstart=yes */,
  {    33,  1768,     0,  22,   0, PL_MISCTECHNICAL }   /* miscellaneoustechnical */,
  {    12,  7478,  3947,   3,  15, PL_STERM }   /* issentenceterminal */,
  {     0,  1001,     0,  11,   0, PL_ENCLOSEDCJK }   /* enclosedcjk */,
  {     0,  8096,     7,   4,  18, PL_CANS }   /* scx=canadianaboriginal */,
  {    33,  5544,  7710,  13,   4, PL_NV__6000 }   /* numericvalue=6000 */,
  {     0,   184,  2249,   2,  13, PL_GLAGOLITICSUP }   /* isglagoliticsup */,
  {    23,  2985,  3223,   4,   3, -PL_IDST }   /* idst=no */,
  {    65,  7288,  2249,   7,   4, PL_SC__GLAG }   /* script=glag */,
  {     0,   184,  1659,   3,  18, PL_CJKCOMPATIDEOGRAPHS }   /* iscjkcompatideographs */,
  {     0,   184,  8056,   2,   5, PL_NSHU }   /* isnushu */,
  {     2,   184,  1856,   3,  20, PL_CWCM }   /* ischangeswhencasemapped */,
  {    88,  7478,  1402,   3,   3, PL_SIND }   /* issind */,
  {    28,  7136,   415,   6,  32, PL_INIDC }   /* block=ideographicdescriptioncharacters */,
  {     3,  7136,  4010,   6,  16, PL_TANGUTCOMPONENTS }   /* block=tangutcomponents */,
  {     4,   974,  6230,  24,  11, PL_CCC__8 }   /* canonicalcombiningclass=kanavoicing */,
  {    15,  6890,  7415,   4,   7, PL_CJKEXTE }   /* blk=cjkexte */,
  {     0,  2859,  7184,  18,   8, PL_DT__FRA }   /* decompositiontype=fraction */,
  {     1,  8096,  7527,   4,   7, PL_MULT }   /* scx=multani */,
  {     7,  6439,     0,  11,   0, PL_SYLO }   /* sylotinagri */,
  {     1,    58,  3581,   4,   2, PL_IDEO }   /* ideo=t */,
  {    15,  8777,  3223,   3,   2, -PL_CWL }   /* cwl=n */,
  {     0,  8816,  7714,   3,   2, PL_NV__30 }   /* nv=30 */,
  {     8,  7136,  6596,   6,  10, PL_COMPATJAMO }   /* block=compatjamo */,
  {     2,  7226,  1929,   6,   5, PL_XPOSIXUPPER }   /* xposixupper */,
  {     0,  1746,  1690,  21,   2, PL_GCB__CN }   /* graphemeclusterbreak=cn */,
  {     3,  5250,  7997,   8,   2, PL_XPOSIXXDIGIT }   /* hexdigit=y */,
  {     4,   184,  7858,   2,   6, PL_KHOJ }   /* iskhojki */,
  {     1,  8096,  4404,   4,  15, PL_MERC }   /* scx=meroiticcursive */,
  {    83,   184,  7846,   2,   6, PL_KTHI }   /* iskaithi */,
  {     0,  4402,  2158,  10,  11, PL_MERO }   /* inmeroitichieroglyphs */,
  {    10,  6713,  8714,   3,   3, PL_IN__3_DOT_2 }   /* in=3.2 */,
  {     0,  1417,   206,   9,   2, PL_PI }   /* category=pi */,
  {    11,  8096,  8536,   4,   4, PL_TALU }   /* scx=talu */,
  {     1,   974,    78,  24,   2, PL_CCC__AR }   /* canonicalcombiningclass=ar */,
  {     9,  7816,     0,   6,   0, PL_GRBASE }   /* grbase */,
  {    16,  6706,  8885,  10,   3, PL_IN__7 }   /* presentin=v70 */,
  {     3,  7288,  7900,   7,   6, PL_RJNG }   /* script=rejang */,
  {     1,  8011,  1204,   3,   2, PL_PO }   /* gc=po */,
  {    32,  6616,     0,  10,   0, PL_DEP }   /* deprecated */,
  {     0,  6706,  8660,  10,   3, PL_IN__2_DOT_1 }   /* presentin=2.1 */,
  {     0,  7991,     0,   5,   0, PL_BUHD }   /* buhid */,
  {   154,  7136,  7513,   6,   7, PL_INMANDAIC }   /* block=mandaic */,
  {     0,   974,  8160,  24,   2, PL_CCC__13 }   /* canonicalcombiningclass=13 */,
  {     0,  7478,     7,   3,   1, PL_SC }   /* issc */,
  {    16,  7478,  7298,   4,   6, PL_SPECIALS }   /* isspecials */,
  {     8,  5544,  7756,  13,   6, PL_NV__900000 }   /* numericvalue=900000 */,
  {     1,  7136,  6241,   6,  11, PL_KATAKANAEXT }   /* block=katakanaext */,
  {     1,  7136,  2002,   6,  21, PL_ININSCRIPTIONALPARTHIAN }   /* block=inscriptionalparthian */,
  {     0,   974,  8642,  24,   3, PL_CCC__122 }   /* canonicalcombiningclass=122 */,
  {   135,  7136,  8066,   6,   5, PL_INORIYA }   /* block=oriya */,
  {     0,  7136,  5427,   6,   9, PL_INMALAYALAM }   /* block=malayalam */,
  {     0,  5245,  7997,  13,   2, PL_POSIXXDIGIT }   /* asciihexdigit=y */,
  {     2,   184,  1963,   2,   7, PL_RADICAL }   /* isradical */,
  {     0,  8216,     0,   4,   0, PL_ARMI }   /* armi */,
  {     0,  8376,  8923,   3,   2, PL_LB__H2 }   /* lb=h2 */,
  {     1,  7459,  8528,   3,   4, PL_SC__SYRC }   /* sc=syrc */,
  {    32,  4542,  7661,   3,   6, PL_TIRH }   /* istirhuta */,
  {     2,  8026,  4629,   5,  15, PL_LOE }   /* inpc=visualorderleft */,
  {     1,  8240,  8804,   3,   3, PL_BC__LRI }   /* bc=lri */,
  {     0,  8572,  7804,   4,   6, PL_WB__NL }   /* wb=newline */,
  {     1,  8376,  2163,   3,   2, PL_LB__GL }   /* lb=gl */,
  {     0,  4841,     0,  14,   0, PL_LATINEXTB }   /* latinextendedb */,
  {     7,  6596,     0,  10,   0, PL_COMPATJAMO }   /* compatjamo */,
  {     2,  8096,  6806,   4,  10, PL_WARA }   /* scx=warangciti */,
  {     0,  6554,  4135,   3,   6, PL_BRAI }   /* inbraille */,
  {     2,  6329,  2876,  11,   3, PL_XPOSIXDIGIT }   /* numerictype=de */,
  {     1,  7457,  1330,   5,   9, PL_INSC__CONSONANT }   /* insc=consonant */,
  {     1,    21,  6953,   2,   9, PL_LATINEXTD }   /* inlatinextd */,
  {    32,  5645,  3446,  10,   3, PL_BC__RLI }   /* bidiclass=rli */,
  {     0,  6713,  8732,   3,   3, PL_IN__5 }   /* in=5.0 */,
  {     1,  7136,  7618,   6,   7, PL_SUPPUAA }   /* block=suppuaa */,
  {     1,  6263,    58,  10,   2, PL_LB__ID }   /* linebreak=id */,
  {     1,  8340,  6606,   3,  10, PL_JG__DALATHRISH }   /* jg=dalathrish */,
  {     2,  6076,  7768,  11,   2, -PL_BIDIC }   /* bidicontrol=f */,
  {   224,  6484,  3223,  10,   2, -PL_IDC }   /* idcontinue=n */,
  {    10,  7136,  3594,   6,   9, PL_ARABICSUP }   /* block=arabicsup */,
  {     0,  8240,  2914,   4,  17, PL_BC__ET }   /* bc=europeanterminator */,
  {     1,  4284,  5177,  14,   6, PL_GCB__V }   /* hangulsyllabletype=v */,
  {     2,  7466,  3521,   5,   5, PL_XPOSIXBLANK }   /* horizspace */,
  {     0,  3129,  2895,  17,   8, PL_ETHI }   /* scriptextensions=ethiopic */,
  {     2,  6076,  3581,  11,   2, PL_BIDIC }   /* bidicontrol=t */,
  {    39,  3129,  7034,  17,   9, PL_PALM }   /* scriptextensions=palmyrene */,
  {     5,  7136,  4771,   6,  14, PL_INGREEK }   /* block=greekandcoptic */,
  {     0,  7852,     0,   6,   0, PL_KANBUN }   /* kanbun */,
  {     0,  7459,  8500,   3,   4, PL_SARB }   /* sc=sarb */,
  {     1,  8340,  3818,   3,  16, PL_JG__MANICHAEANSAMEKH }   /* jg=manichaeansamekh */,
  {     0,  8376,   125,   3,   2, PL_LB__CR }   /* lb=cr */,
  {     0,  3738,     0,   6,   0, PL_LATIN1 }   /* latin1 */,
  {    18,  7136,  8056,   6,   5, PL_INNUSHU }   /* block=nushu */,
  {     5,  7136,  7429,   6,   7, PL_DSRT }   /* block=deseret */,
  {     4,  8816,  8729,   3,   3, PL_NV__4_SLASH_5 }   /* nv=4/5 */,
  {    20,  6890,  4404,   4,  15, PL_INMEROITICCURSIVE }   /* blk=meroiticcursive */,
  {    29,  7840,  4616,   4,  13, PL_VEDICEXT }   /* isvedicextensions */,
  {     6,  3129,  2636,  17,   9, PL_MONG }   /* scriptextensions=mongolian */,
  {     0,  8376,  4452,   3,   2, PL_LB__QU }   /* lb=qu */,
  {     0,  4314,  5163,  13,  10, PL_JG__TEHMARBUTA }   /* joininggroup=tehmarbuta */,
  {     1,  8096,  2149,   4,  20, PL_HLUW }   /* scx=anatolianhieroglyphs */,
  {     0,  7459,  7660,   3,   7, PL_SC__TIRH }   /* sc=tirhuta */,
  {     0,  3356,     0,  17,   0, PL_CYRILLICEXTC }   /* cyrillicextendedc */,
  {     4,  4464,    26,  14,   1, PL_NFDQC__Y }   /* nfdquickcheck=y */,
  {    24,  7380,  8690,   4,   3, PL_CCC__AL }   /* ccc=228 */,
  {    21,   184,  3111,   2,   4, PL_RUMI }   /* isrumi */,
  {     1,   184,  6806,   2,  10, PL_WARA }   /* iswarangciti */,
  {    59,  8096,  2002,   4,  21, PL_PRTI }   /* scx=inscriptionalparthian */,
  {     1,  6756,  3223,  10,   3, -PL_SD }   /* softdotted=no */,
  {     5,  2985,     0,   3,   0, PL_IDS }   /* ids */,
  {    12,   974,  8636,  24,   3, PL_CCC__107 }   /* canonicalcombiningclass=107 */,
  {     0,  8436,     0,   4,   0, PL_NSHU }   /* nshu */,
  {    56,  6210,  1982,   3,  17, PL_CYRILLICSUP }   /* incyrillicsupplement */,
  {     1,  8263,     0,   2,   0, PL_MC }   /* mc */,
  {     0,  1448,  2734,   5,  16, PL_SUPARROWSC }   /* insupplementalarrowsc */,
  {     2,  6263,  6880,  10,   2, PL_LB__BB }   /* linebreak=bb */,
  {     0,    21,  4827,   2,   6, PL_KANGXI }   /* inkangxi */,
  {     5,   959,     0,   5,   0, PL_MUSIC }   /* music */,
  {   136,  7459,  7034,   3,   4, PL_PALM }   /* sc=palm */,
  {     0,  6506,     2,   3,   1, PL_YI }   /* isyi */,
  {     0,  8376,  3985,   3,   9, PL_LB__EM }   /* lb=emodifier */,
  {     2,  7459,  7436,   3,   7, PL_ELBA }   /* sc=elbasan */,
  {    56,  8376,  1392,   3,   9, PL_LB__SG }   /* lb=surrogate */,
  {     0,  6890,  7590,   4,   7, PL_INSHARADA }   /* blk=sharada */,
  {     2,   184,  7852,   2,   6, PL_KANBUN }   /* iskanbun */,
  {     2,  7906,    18,   6,   1, PL_KHAR }   /* sc=khar */,
  {     2,   184,  1982,   3,  20, PL_CYRILLICSUP }   /* iscyrillicsupplementary */,
  {     0,  8011,  3658,   3,  16, PL_PE }   /* gc=closepunctuation */,
  {     0,   186,  7997,   2,   2, PL_CE }   /* ce=y */,
  {    48,  7043,     0,   4,   0, PL_PAUC }   /* pauc */,
  {     0,  6890,  5363,   5,  12, PL_IPAEXT }   /* blk=ipaextensions */,
  {     7,  7226,  5253,   6,   5, PL_XPOSIXDIGIT }   /* xposixdigit */,
  {    19,  6890,  7653,   4,   7, PL_INTIBETAN }   /* blk=tibetan */,
  {     4,  8096,  2895,   4,   8, PL_ETHI }   /* scx=ethiopic */,
  {     0,  8816,  8187,   3,   2, PL_NV__27 }   /* nv=27 */,
  {     1,  4757,  7951,  14,   5, PL_GREXT }   /* graphemeextend=true */,
  {     0,  7120,     0,   4,   0, PL_BALI }   /* bali */,
  {     0,  7459,  2598,   3,   4, PL_MERO }   /* sc=mero */,
  {     1,  5134,  6030,   3,   7, PL_PHAISTOS }   /* isphaistos */,
  {     2,  4923,  7522,   4,   5, PL_INMARCHEN }   /* inmarchen */,
  {     1,  8240,  6017,   3,  12, PL_BC__ON }   /* bc=otherneutral */,
  {     9,  8572,    24,   4,   1, PL_WB__NL }   /* wb=nl */,
  {     3,  4134,     0,   7,   0, PL_BRAI }   /* braille */,
  {     0,  3129,  4104,  17,   5, PL_BAMU }   /* scriptextensions=bamum */,
  {   144,  4314,  8334,  13,   4, PL_JG__SHIN }   /* joininggroup=shin */,
  {     0,  7459,  8408,   3,   4, PL_MRO }   /* sc=mroo */,
  {     0,  6706,  8564,  10,   4, PL_IN__10 }   /* presentin=v100 */,
  {     1,  3129,  1401,  17,   4, PL_SIND }   /* scriptextensions=sind */,
  {     0,  8340,  5163,   3,  10, PL_JG__TEHMARBUTA }   /* jg=tehmarbuta */,
  {     0,  7380,  8160,   7,   2, PL_CCC__13 }   /* ccc=ccc13 */,
  {     1,  7457,  5999,   5,   6, PL_LB__ZWJ }   /* insc=joiner */,
  {     0,  2221,  2244,   3,   2, PL_GCB__L }   /* hst=l */,
  {     3,   184,   966,   2,   2, PL_NO }   /* isno */,
  {    44,  3129,  8268,  17,   4, PL_CPRT }   /* scriptextensions=cprt */,
  {    39,   184,  8408,   2,   4, PL_MRO }   /* ismroo */,
  {     0,  8572,  3985,   3,   9, PL_LB__EM }   /* wb=emodifier */,
  {     0,  8096,  4135,   5,   6, PL_BRAI }   /* scx=braille */,
  {     8,  5557,  7951,  13,   5, PL_PATSYN }   /* patternsyntax=true */,
  {     1,  7380,  8687,   4,   3, PL_CCC__R }   /* ccc=226 */,
  {     0,  7459,  3610,   3,   8, PL_SC__BOPO }   /* sc=bopomofo */,
  {     3,   184,  1589,   2,   5, PL_LATN }   /* islatin */,
  {     0,    21,  5246,   3,   4, PL_ASCII }   /* inascii */,
  {     0,  2236,  1013,  10,   5, PL_L }   /* category=letter */,
  {     0,  5968,  8072,   3,   4, PL_INOSAGE }   /* inosage */,
  {     3,  4554,    24,  15,   1, PL_SB__CL }   /* sentencebreak=cl */,
  {     3,  2229,  1690,  16,   2, PL_CN }   /* generalcategory=cn */,
  {     0,  4010,     0,   6,   0, PL_TANG }   /* tangut */,
  {     0,  7459,  7144,   3,   4, PL_SC__BUGI }   /* sc=bugi */,
  {    56,  8272,  7997,   4,   2, PL_CWCF }   /* cwcf=y */,
  {     6,  7918,     0,   6,   0, PL_THAA }   /* thaana */,
  {     0,  4314,  6606,  13,  10, PL_JG__DALATHRISH }   /* joininggroup=dalathrish */,
  {     3,  2750,  3223,   4,   2, -PL_TERM }   /* term=n */,
  {     3,  6109,  2170,  10,  19, PL_PC }   /* category=connectorpunctuation */,
  {    54,  7994,     1,   4,   1, -PL_IDC }   /* idc=n */,
  {     1,  6472,  6395,  10,  11, PL_WB__SQ }   /* wordbreak=singlequote */,
  {     1,  6890,  7660,   4,   7, PL_INTIRHUTA }   /* blk=tirhuta */,
  {     0,   974,     8,  24,   1, PL_CCC__A }   /* canonicalcombiningclass=a */,
  {     0,  1876,     0,  21,   0, PL_CWL }   /* changeswhenlowercased */,
  {     1,  1354,  7768,  24,   6, -PL_COMPEX }   /* fullcompositionexclusion=false */,
  {     3,  7136,  2877,   6,  10, PL_INDEVANAGARI }   /* block=devanagari */,
  {    64,  4554,  7070,  14,   9, PL_SB__SC }   /* sentencebreak=scontinue */,
  {     3,  8076,  7951,   5,   5, PL_PATWS }   /* patws=true */,
  {    98,  1417,   295,   9,   2, PL_SM }   /* category=sm */,
  {     0,  4542,  8553,   3,   3, PL_TGLG }   /* istglg */,
  {     0,  7380,     8,   4,   1, PL_CCC__A }   /* ccc=a */,
  {     0,  8096,  7359,   4,   7, PL_AVST }   /* scx=avestan */,
  {     2,   720,     0,  30,   0, PL_ENCLOSEDALPHANUMSUP }   /* enclosedalphanumericsupplement */,
  {     0,  7689,  6538,   4,   8, PL_ARABICEXTA }   /* isarabicexta */,
  {     1,  3129,  7597,  17,   7, PL_SHAW }   /* scriptextensions=shavian */,
  {     1,    78,     0,  35,   0, PL_ARABICMATH }   /* arabicmathematicalalphabeticsymbols */,
  {     1,  7288,  1107,   7,   8, PL_SC__KANA }   /* script=katakana */,
  {     0,  8011,  1797,   3,  14, PL_LM }   /* gc=modifierletter */,
  {     1,  7380,  8916,   7,   2, PL_CCC__84 }   /* ccc=ccc84 */,
  {     0,  7471,   468,   7,   5, PL_POSIXPUNCT }   /* isposixpunct */,
  {     2,  6219,  7997,  11,   4, PL_JOINC }   /* joincontrol=yes */,
  {     1,  5336,     0,   8,   0, PL_GREEKEXT }   /* greekext */,
  {    69,  8096,  7145,   5,   3, PL_BUGI }   /* scx=bugi */,
  {    21,  6554,  6547,   3,   9, PL_ASCII }   /* inbasiclatin */,
  {    71,  6029,     0,   8,   0, PL_PHAISTOS }   /* phaistos */,
  {     1,    96,  7997,  10,   4, PL_XPOSIXALPHA }   /* alphabetic=yes */,
  {     3,  7689,  6874,   4,   7, PL_ARABICPFB }   /* isarabicpfb */,
  {     5,  5544,  8187,  13,   2, PL_NV__27 }   /* numericvalue=27 */,
  {    59,  1402,  6450,  24,  11, PL_INPC__TOPANDRIGHT }   /* indicpositionalcategory=topandright */,
  {     0,  8096,  8388,   4,   4, PL_LISU }   /* scx=lisu */,
  {     0,  6554,  4105,   3,  14, PL_BAMUMSUP }   /* inbamumsupplement */,
  {     7,  2100,  8062,   3,   4, PL_OGAM }   /* isogham */,
  {     0,  1503,   751,   3,  28, PL_ENCLOSEDIDEOGRAPHICSUP }   /* inenclosedideographicsupplement */,
  {     0,  8560,     0,   4,   0, PL_TIBT }   /* tibt */,
  {     1,  8816,  8673,   3,   2, PL_NV__14 }   /* nv=14 */,
  {     0,  8572,  1107,   3,   2, PL_WB__KA }   /* wb=ka */,
  {     0,  3129,  8476,  17,   4, PL_COPT }   /* scriptextensions=qaac */,
  {     3,  8196,  7714,   4,   1, PL_AGE__3 }   /* age=3 */,
  {     5,  1746,  4561,  21,   2, PL_WB__EB }   /* graphemeclusterbreak=eb */,
  {     1,   184,   954,   2,   5, PL_GREK }   /* isgreek */,
  {     4,  6890,  6041,   4,  12, PL_PLAYINGCARDS }   /* blk=playingcards */,
  {     9,  7136,  5681,   6,  12, PL_CYRILLICEXTA }   /* block=cyrillicexta */,
  {     0,  5557,  3223,  13,   2, -PL_PATSYN }   /* patternsyntax=n */,
  {     0,  7459,  7956,   3,   5, PL_SC__ADLM }   /* sc=adlam */,
  {     0,  7380,   184,   4,   2, PL_CCC__IS }   /* ccc=is */,
  {     2,  7256,     0,   8,   0, PL_KANAEXTA }   /* kanaexta */,
  {   198,  1797,     0,   4,   0, PL_MODI }   /* modi */,
  {     3,  6890,  1939,   4,  21, PL_CJKCOMPATFORMS }   /* blk=cjkcompatibilityforms */,
  {     5,  8096,  8556,   4,   4, PL_THAI }   /* scx=thai */,
  {     1,  7034,     0,   4,   0, PL_PALM }   /* palm */,
  {     2,   415,  3581,  11,   2, PL_IDEO }   /* ideographic=t */,
  {     0,  7136,  2128,   6,  21, PL_YIJING }   /* block=yijinghexagramsymbols */,
  {     0,  2503,     0,  19,   0, PL_ENCLOSEDALPHANUMSUP }   /* enclosedalphanumsup */,
  {     1,   283,     0,  33,   0, PL_MISCMATHSYMBOLSA }   /* miscellaneousmathematicalsymbolsa */,
  {     0,  7288,  7499,   7,   7, PL_SC__KALI }   /* script=kayahli */,
  {    14,  8096,  8548,   4,   4, PL_TFNG }   /* scx=tfng */,
  {    55,  7822,     0,   6,   0, PL_HATR }   /* hatran */,
  {     0,  7168,     0,   8,   0, PL_EXT }   /* extender */,
  {    14,   184,  8424,   2,   4, PL_NBAT }   /* isnbat */,
  {     9,  4542,  1813,   3,  14, PL_TRANSPORTANDMAP }   /* istransportandmap */,
  {     1,  6890,  4687,   4,  14, PL_CJKCOMPATFORMS }   /* blk=cjkcompatforms */,
  {     1,  8340,  4967,   3,  14, PL_JG__MANICHAEANKAPH }   /* jg=manichaeankaph */,
  {     1,  7459,  7016,   3,   9, PL_SC__PERM }   /* sc=oldpermic */,
  {     4,  7288,  7443,   7,   4, PL_SC__GRAN }   /* script=gran */,
  {     0,  8016,    34,   4,   6, PL_GREXT }   /* gcb=extend */,
  {    12,  6890,  3674,   4,  16, PL_CYPRIOTSYLLABARY }   /* blk=cypriotsyllabary */,
  {     1,  7136,  7569,   6,   7, PL_INOSMANYA }   /* block=osmanya */,
  {     0,  5414,     0,  13,   0, PL_LOWSURROGATES }   /* lowsurrogates */,
  {     0,  8011,    27,   3,   2, PL_LL }   /* gc=ll */,
  {     6,  8096,  8348,   4,   4, PL_KALI }   /* scx=kali */,
  {     0,  8096,  3994,   4,   6, PL_SYRC }   /* scx=syriac */,
  {     2,  6890,  3021,   4,   9, PL_LATINEXTA }   /* blk=latinexta */,
  {     0,  4314,  7176,  13,   8, PL_JG__FARSIYEH }   /* joininggroup=farsiyeh */,
  {    69,  2985,  3223,   3,   2, -PL_IDS }   /* ids=n */,
  {    24,  6554,  1108,   3,   4, PL_INBATAK }   /* inbatak */,
  {     7,  4464,    17,  15,   1, PL_DT__CAN }   /* nfdquickcheck=no */,
  {     0,   186,  7951,   2,   5, PL_CE }   /* ce=true */,
  {     6,   382,     0,  33,   0, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* supplementalsymbolsandpictographs */,
  {     1,  6554,  6567,   3,   9, PL_BOXDRAWING }   /* inboxdrawing */,
  {     2,  6890,  3722,   4,  16, PL_HIGHPUSURROGATES }   /* blk=highpusurrogates */,
  {     0,  6210,  2788,   3,   7, PL_INCHEROKEE }   /* incherokee */,
  {    35,  7478,  6440,   3,  10, PL_SYLO }   /* issylotinagri */,
  {     0,  7380,  2777,   4,  10, PL_CCC__AR }   /* ccc=aboveright */,
  {    21,  8016,    24,   4,   1, PL_GCB__L }   /* gcb=l */,
  {     0,  7459,  8588,   3,   4, PL_SC__YI }   /* sc=yiii */,
  {     6,  6263,  8457,  10,   2, PL_LB__SG }   /* linebreak=sg */,
  {     0,   415,  7768,  11,   2, -PL_IDEO }   /* ideographic=f */,
  {     0,  7828,  7768,   6,   2, -PL_HYPHEN }   /* hyphen=f */,
  {   130,  2787,     0,  11,   0, PL_CHEROKEESUP }   /* cherokeesup */,
  {     2,  8096,  8316,   4,   4, PL_HANO }   /* scx=hano */,
  {    37,  8552,     0,   4,   0, PL_TGLG }   /* tglg */,
  {    15,  6890,  2107,   4,   7, PL_INSINHALA }   /* blk=sinhala */,
  {     1,  1448,  7297,   3,   7, PL_SPECIALS }   /* inspecials */,
  {     0,  6890,  6307,   4,  11, PL_MYANMAREXTA }   /* blk=myanmarexta */,
  {    46,  4284,     0,  15,   0, PL_INHANGUL }   /* hangulsyllables */,
  {    15,  7288,  1566,   7,   6, PL_SC__HANG }   /* script=hangul */,
  {     5,   184,  3458,   2,   4, PL_MANI }   /* ismani */,
  {    15,  8798,  7768,   3,   6, -PL_LOE }   /* loe=false */,
  {     1,  7288,  1981,   7,   8, PL_SC__CYRL }   /* script=cyrillic */,
  {     0,  1746,  5083,  22,  10, PL_GCB__SM }   /* graphemeclusterbreak=spacingmark */,
  {     6,  6554,  1498,   3,  22, PL_BYZANTINEMUSIC }   /* inbyzantinemusicalsymbols */,
  {     0,  8096,  7129,   5,   7, PL_BASS }   /* scx=bassavah */,
  {     1,  6890,   113,   4,  25, PL_DIACRITICALS }   /* blk=combiningdiacriticalmarks */,
  {     2,  6472,    73,  10,   2, PL_LB__EM }   /* wordbreak=em */,
  {     0,  8376,    21,   3,   2, PL_LB__IN }   /* lb=in */,
  {     0,  8816,  7702,   3,   1, PL_NV__2 }   /* nv=2 */,
  {     1,  5544,  7750,  13,   1, PL_NV__8 }   /* numericvalue=8 */,
  {     2,  4542,  8545,   3,   3, PL_TAVT }   /* istavt */,
  {     0,  4314,  5897,  13,  12, PL_JG__MALAYALAMSSA }   /* joininggroup=malayalamssa */,
  {     0,  4089,     0,  15,   0, PL_ARABICEXTA }   /* arabicextendeda */,
  {     0,  7136,  2465,   6,  19, PL_COUNTINGROD }   /* block=countingrodnumerals */,
  {     0,  1887,  7768,   5,   6, -PL_XPOSIXLOWER }   /* lower=false */,
  {     1,  2229,    38,  16,   2, PL_XPOSIXDIGIT }   /* generalcategory=nd */,
  {   135,  2859,  7792,  18,   6, PL_DT__ENC }   /* decompositiontype=circle */,
  {     1,  3147,     0,  18,   0, PL_TAIXUANJING }   /* taixuanjingsymbols */,
  {     0,  8572,   108,   3,   2, PL_WB__MB }   /* wb=mb */,
  {    10,  8340,  6636,   3,  10, PL_JG__KNOTTEDHEH }   /* jg=knottedheh */,
  {     1,  7136,  7043,   6,   9, PL_INPAUCINHAU }   /* block=paucinhau */,
  {    68,  7034,     0,   9,   0, PL_PALM }   /* palmyrene */,
  {    37,  7136,  4299,   6,  15, PL_INIMPERIALARAMAIC }   /* block=imperialaramaic */,
  {    26,  1354,  3223,  24,   2, -PL_COMPEX }   /* fullcompositionexclusion=n */,
  {     0,  8816,  8915,   3,   2, PL_NV__48 }   /* nv=48 */,
  {     6,   184,   133,   2,   4, PL_M }   /* ismark */,
  {     0,  8096,  7443,   4,   7, PL_GRAN }   /* scx=grantha */,
  {    64,  5544,  7709,  13,   2, PL_NV__16 }   /* numericvalue=16 */,
  {     0,  8196,  8657,   4,   3, PL_AGE__2 }   /* age=2.0 */,
  {    37,  1426,  4179,  22,  15, PL_INSC__CONSONANTMEDIAL }   /* indicsyllabiccategory=consonantmedial */,
  {   130,  2100,  6007,   4,  10, PL_HUNG }   /* isoldhungarian */,
  {     1,  8376,    96,   3,  10, PL_LB__AL }   /* lb=alphabetic */,
  {     0,  8011,  8009,   3,   2, PL_CF }   /* gc=cf */,
  {     4,  4554,   138,  14,   2, PL_SB__FO }   /* sentencebreak=fo */,
  {    88,  6890,  6536,   4,  10, PL_ARABICEXTA }   /* blk=arabicexta */,
  {     5,   184,  8281,   3,   3, PL_CYRL }   /* iscyrl */,
  {     0,  7136,  4269,   6,  15, PL_DIACRITICALSSUP }   /* block=diacriticalssup */,
  {     0,  6890,     0,   4,  42, PL_UCASEXT }   /* blk=unifiedcanadianaboriginalsyllabicsextended */,
  {     0,  8011,  3854,   3,  10, PL_SM }   /* gc=mathsymbol */,
  {     0,  3509,     0,  17,   0, PL_PATWS }   /* patternwhitespace */,
  {     9,  4314,  8392,  13,   4, PL_JG__MEEM }   /* joininggroup=meem */,
  {     0,  7689,  7106,   4,   6, PL_ARMN }   /* isarmenian */,
  {     0,  4590,  3581,   2,   2, PL_VS }   /* vs=t */,
  {    50,  6890,  3594,   4,  16, PL_ARABICSUP }   /* blk=arabicsupplement */,
  {     0,   184,  8937,   2,   2, PL_ZL }   /* iszl */,
  {     0,  8096,  7810,   4,   4, PL_GOTH }   /* scx=goth */,
  {     9,  7136,  3390,   6,  16, PL_ETHIOPICEXT }   /* block=ethiopicextended */,
  {    66,  2100,  1487,   4,   2, PL_OLCK }   /* isolck */,
  {     4,  8096,  3458,   4,  10, PL_MANI }   /* scx=manichaean */,
  {   124,  8340,  7176,   3,   8, PL_JG__FARSIYEH }   /* jg=farsiyeh */,
  {    15,  7459,  7436,   3,   4, PL_ELBA }   /* sc=elba */,
  {     2,    21,  5801,   2,  12, PL_KHMERSYMBOLS }   /* inkhmersymbols */,
  {    19,  6890,  2249,   4,  10, PL_INGLAGOLITIC }   /* blk=glagolitic */,
  {     2,  5825,     0,   4,   0, PL_MAHJ }   /* mahj */,
  {     6,  7689,   948,   3,  26, PL_ANCIENTGREEKMUSIC }   /* isancientgreekmusicalnotation */,
  {     0,  7689,    97,   3,   9, PL_XPOSIXALPHA }   /* isalphabetic */,
  {    96,  7459,  7025,   3,   9, PL_ORKH }   /* sc=oldturkic */,
  {     8,  8208,     0,   4,   0, PL_AHOM }   /* ahom */,
  {     1,  7288,  7043,   7,   4, PL_PAUC }   /* script=pauc */,
  {     0,  7136,  3057,   6,  18, PL_ORNAMENTALDINGBATS }   /* block=ornamentaldingbats */,
  {     0,  8572,  5435,   3,   2, PL_WB__ML }   /* wb=ml */,
  {     1,  8096,  7822,   4,   6, PL_HATR }   /* scx=hatran */,
  {    21,  8816,  8911,   3,   2, PL_NV__46 }   /* nv=46 */,
  {     0,   974,  8651,  27,   3, PL_CCC__132 }   /* canonicalcombiningclass=ccc132 */,
  {     0,  7478,   383,   3,  32, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* issupplementalsymbolsandpictographs */,
  {   170,  7136,  4224,   6,  15, PL_CURRENCYSYMBOLS }   /* block=currencysymbols */,
  {     0,  3962,     0,  16,   0, PL_SUPMATHOPERATORS }   /* supmathoperators */,
  {     0,  7136,  2541,   6,  10, PL_JAMO }   /* block=hanguljamo */,
  {     0,  6706,  8759,  10,   3, PL_IN__7 }   /* presentin=7.0 */,
  {     0,  7288,  8237,   8,   3, PL_BATK }   /* script=batk */,
  {     0,   184,  1359,   3,  19, PL_CE }   /* iscompositionexclusion */,
  {     0,  6263,  3658,  10,  16, PL_LB__CL }   /* linebreak=closepunctuation */,
  {     4,  7136,   690,   6,  30, PL_CUNEIFORMNUMBERS }   /* block=cuneiformnumbersandpunctuation */,
  {    15,  8340,  7448,   3,   3, PL_JG__HAH }   /* jg=hah */,
  {     0,  7226,   468,   6,   5, PL_XPOSIXPUNCT }   /* xposixpunct */,
  {    51,  5544,  8630,  13,   3, PL_NV__1_SLASH_9 }   /* numericvalue=1/9 */,
  {     1,  8324,     0,   4,   0, PL_HMNG }   /* hmng */,
  {     2,  7492,     0,   7,   0, PL_KNDA }   /* kannada */,
  {     0,  1417,  5135,   9,  14, PL_ZS }   /* category=spaceseparator */,
  {     0,  8240,     1,   4,   1, PL_BC__EN }   /* bc=en */,
  {    86,  3738,     0,  16,   0, PL_LATIN1 }   /* latin1supplement */,
  {    35,   217,  7345,   6,   7, PL__PERL_IDSTART }   /* _perl_idstart */,
  {     6,  6890,  6806,   4,  10, PL_INWARANGCITI }   /* blk=warangciti */,
  {     4,  6472,   108,  10,   2, PL_WB__MB }   /* wordbreak=mb */,
  {     0,  7288,  4299,   7,  15, PL_ARMI }   /* script=imperialaramaic */,
  {     7,  2859,  4653,  18,   6, PL_DT__SQR }   /* decompositiontype=square */,
  {    53,  6483,     0,   4,   0, PL_XIDC }   /* xidc */,
  {     1,  6263,    23,  10,   2, PL_LB__AL }   /* linebreak=al */,
  {    29,  8096,  7611,   4,   7, PL_SOYO }   /* scx=soyombo */,
  {     0,  8036,  6798,   4,   8, PL_CN }   /* isunassigned */,
  {     0,   974,  8642,  27,   3, PL_CCC__122 }   /* canonicalcombiningclass=ccc122 */,
  {     2,  7696,  7768,   6,   2, -PL_XPOSIXSPACE }   /* wspace=f */,
  {     1,  6263,  6197,  10,  11, PL_LB__IN }   /* linebreak=inseperable */,
  {    77,   974,  7744,  24,   1, PL_CCC__7 }   /* canonicalcombiningclass=7 */,
  {     1,  3946,  7997,  16,   4, PL_STERM }   /* sentenceterminal=yes */,
  {     3,  6208,  7951,   5,   5, PL_JOINC }   /* joinc=true */,
  {     2,  7136,  7780,   6,   6, PL_INCARIAN }   /* block=carian */,
  {    20,  1306,     0,  13,   0, PL_M }   /* combiningmark */,
  {    37,  6109,  4225,  10,  13, PL_SC }   /* category=currencysymbol */,
  {     1,  7459,  5777,   3,   4, PL_HEBR }   /* sc=hebr */,
  {     0,  1417,   468,   9,   5, PL_P }   /* category=punct */,
  {     0,  6890,  7971,   4,   5, PL_INBATAK }   /* blk=batak */,
  {     1,  7459,  7007,   3,   9, PL_ITAL }   /* sc=olditalic */,
  {     1,  6208,  7997,   5,   2, PL_JOINC }   /* joinc=y */,
  {     4,  8096,  2636,   4,   9, PL_MONG }   /* scx=mongolian */,
  {     0,   184,  2598,   2,   4, PL_MERO }   /* ismero */,
  {     3,  7136,   283,   6,  33, PL_MISCMATHSYMBOLSA }   /* block=miscellaneousmathematicalsymbolsa */,
  {     3,    11,  3223,   2,   3, -PL_DI }   /* di=no */,
  {     9,  7459,  3994,   3,   6, PL_SC__SYRC }   /* sc=syriac */,
  {     9,  8240,  5079,   3,  14, PL_BC__NSM }   /* bc=nonspacingmark */,
  {     3,  3516,  7997,  10,   4, PL_XPOSIXSPACE }   /* whitespace=yes */,
  {     2,  7224,  5252,   8,   6, PL_XPOSIXXDIGIT }   /* isxposixxdigit */,
  {     3,   974,  8685,  27,   2, PL_CCC__24 }   /* canonicalcombiningclass=ccc24 */,
  {   170,  7168,  3581,   8,   2, PL_EXT }   /* extender=t */,
  {    25,  7136,   600,   6,  30, PL_CJKEXTD }   /* block=cjkunifiedideographsextensiond */,
  {     0,  7478,  7598,   3,   6, PL_SHAW }   /* isshavian */,
  {     5,  7144,     0,   4,   0, PL_BUGI }   /* bugi */,
  {     1,  1686,     0,  16,   0, PL_INDICNUMBERFORMS }   /* indicnumberforms */,
  {     2,  8288,  3003,   3,   4, PL_DT__INIT }   /* dt=init */,
  {    12,   184,  6546,   2,  10, PL_ASCII }   /* isbasiclatin */,
  {    25,   184,  3610,   2,   8, PL_BOPO }   /* isbopomofo */,
  {     0,  8240,  8813,   3,   3, PL_BC__NSM }   /* bc=nsm */,
  {     7,  8011,  6362,   3,  11, PL_SO }   /* gc=othersymbol */,
  {     1,  7288,  8296,   7,   4, PL_GONM }   /* script=gonm */,
  {     5,  7136,    42,   6,  16, PL_CJKCOMPAT }   /* block=cjkcompatibility */,
  {     8,  6210,   601,   3,  29, PL_CJKEXTD }   /* incjkunifiedideographsextensiond */,
  {    16,  4402,  1798,   3,  14, PL_MODIFIERLETTERS }   /* inmodifierletters */,
  {     3,  8816,  7720,   3,   5, PL_NV__40000 }   /* nv=40000 */,
  {     2,  7168,  7768,   8,   6, -PL_EXT }   /* extender=false */,
  {     0,  6713,  8768,   3,   3, PL_IN__9 }   /* in=9.0 */,
  {    53,  7689,  6799,   3,   7, PL_ASSIGNED }   /* isassigned */,
  {     1,  8572,    72,   3,   2, PL_WB__LE }   /* wb=le */,
  {     2,  7168,  7768,   8,   2, -PL_EXT }   /* extender=f */,
  {     1,  7689,  4660,   3,  13, PL_ANCIENTSYMBOLS }   /* isancientsymbols */,
  {     0,  8816,  7744,   3,   2, PL_NV__70 }   /* nv=70 */,
  {     0,    96,  7768,   5,   6, -PL_XPOSIXALPHA }   /* alpha=false */,
  {    23,   974,  8646,  24,   2, PL_CCC__29 }   /* canonicalcombiningclass=29 */,
  {   134,  8340,  5009,   3,  14, PL_JG__MANICHAEANTETH }   /* jg=manichaeanteth */,
  {    56,   184,  7144,   2,   8, PL_BUGI }   /* isbuginese */,
  {     1,    18,  7951,   2,   5, PL_RI }   /* ri=true */,
  {     0,  6428,     0,  11,   0, PL_SUPERANDSUB }   /* superandsub */,
  {     2,  8196,  8882,   4,   3, PL_AGE__6_DOT_3 }   /* age=v63 */,
  {     0,   974,  7714,  27,   2, PL_CCC__30 }   /* canonicalcombiningclass=ccc30 */,
  {    32,  8504,    72,   3,   2, PL_SB__LE }   /* sb=le */,
  {    12,  7828,  7951,   6,   5, PL_HYPHEN }   /* hyphen=true */,
  {     8,  7380,  3254,   4,  13, PL_CCC__202 }   /* ccc=attachedbelow */,
  {     1,  5362,     0,   6,   0, PL_IPAEXT }   /* ipaext */,
  {     0,  7288,  2636,   7,   4, PL_SC__MONG }   /* script=mong */,
  {    32,   184,  3738,   2,  16, PL_LATIN1 }   /* islatin1supplement */,
  {     0,  8096,  7152,   4,   4, PL_DUPL }   /* scx=dupl */,
  {     1,  3129,  2598,  17,   4, PL_MERO }   /* scriptextensions=mero */,
  {    15,  3129,  8388,  17,   4, PL_LISU }   /* scriptextensions=lisu */,
  {     1,  7136,  6646,   6,  10, PL_MISCARROWS }   /* block=miscarrows */,
  {   133,   184,    24,   2,   1, PL_L }   /* isl */,
  {     1,  4464,  7996,   4,   3, PL_NFDQC__Y }   /* nfdqc=y */,
  {     0,  7380,  7708,   4,   3, PL_CCC__216 }   /* ccc=216 */,
  {     0,  7459,  4134,   3,   7, PL_BRAI }   /* sc=braille */,
  {     0,  7380,  7708,   4,   2, PL_CCC__21 }   /* ccc=21 */,
  {   178,  1426,  4715,  22,  14, PL_INSC__CONSONANTFINAL }   /* indicsyllabiccategory=consonantfinal */,
  {     0,  4757,  7997,  14,   2, PL_GREXT }   /* graphemeextend=y */,
  {    13,   184,  1372,   2,   2, PL_LU }   /* islu */,
  {     5,    21,  3738,   2,   9, PL_LATIN1 }   /* inlatin1sup */,
  {     0,  8376,  5669,   3,  12, PL_LB__SY }   /* lb=breaksymbols */,
  {     0,  2246,  2486,   4,  17, PL_INEGYPTIANHIEROGLYPHS }   /* inegyptianhieroglyphs */,
  {     0,  4554,    49,  14,   2, PL_SB__AT }   /* sentencebreak=at */,
  {     1,  6506,  2129,   3,  20, PL_YIJING }   /* isyijinghexagramsymbols */,
  {     4,  3509,  3223,  17,   2, -PL_PATWS }   /* patternwhitespace=n */,
  {     2,  2369,  3212,  20,   7, PL_VO__U }   /* verticalorientation=upright */,
  {     0,  7345,  7997,   7,   2, PL_IDS }   /* idstart=y */,
  {     0,  8376,  1204,   3,   2, PL_LB__PO }   /* lb=po */,
  {     6,  8096,  6406,   4,  11, PL_SORA }   /* scx=sorasompeng */,
  {    76,  8016,   125,   4,   2, PL_LB__CR }   /* gcb=cr */,
  {   154,  3290,     0,   4,   0, PL_UCAS }   /* ucas */,
  {    14,   184,  4225,   3,  13, PL_SC }   /* iscurrencysymbol */,
  {    25,  8011,  3914,   3,   5, PL_C }   /* gc=other */,
  {     4,  2128,     0,   6,   0, PL_YIJING }   /* yijing */,
  {     0,  2108,  1812,   4,   4, PL_INHATRAN }   /* inhatran */,
  {     0,  6647,  6100,   4,   9, PL_L_AMP_ }   /* iscasedletter */,
  {     3,  8340,  6274,   3,  11, PL_JG__MALAYALAMJA }   /* jg=malayalamja */,
  {     1,  7136,  1960,   6,  21, PL_CJKRADICALSSUP }   /* block=cjkradicalssupplement */,
  {    29,  3003,     0,  18,   0, PL_PI }   /* initialpunctuation */,
  {     7,  2221,  4046,   3,   4, PL_LB__H3 }   /* hst=lvt */,
  {    12,  1417,  1392,   9,   9, PL_CS }   /* category=surrogate */,
  {     1,   974,  8632,  24,   2, PL_CCC__91 }   /* canonicalcombiningclass=91 */,
  {    47,  7380,  8224,   4,   4, PL_CCC__216 }   /* ccc=atar */,
  {     0,  4687,     0,  14,   0, PL_CJKCOMPATFORMS }   /* cjkcompatforms */,
  {     0,  8044,     0,   4,   0, PL_PHLI }   /* phli */,
  {     8,  8096,  4784,   4,   4, PL_CHAM }   /* scx=cham */,
  {    60,  7007,     0,   9,   0, PL_ITAL }   /* olditalic */,
  {     0,  7380,  5220,   4,   1, PL_CCC__0 }   /* ccc=0 */,
  {    25,  1876,  7997,  21,   2, PL_CWL }   /* changeswhenlowercased=y */,
  {     0,  6890,  1635,   4,  23, PL_SUPPUNCTUATION }   /* blk=supplementalpunctuation */,
  {   324,  3129,  3288,  17,  17, PL_AGHB }   /* scriptextensions=caucasianalbanian */,
  {     0,  7136,  8400,   6,   4, PL_INMIAO }   /* block=miao */,
  {     4,  7136,  1589,   6,   9, PL_LATINEXTE }   /* block=latinexte */,
  {     0,  6890,  5957,   4,  12, PL_INMENDEKIKAKUI }   /* blk=mendekikakui */,
  {     0,  7478,  2675,   3,   3, PL_SUND }   /* issund */,
  {     0,  8608,     0,   4,   0, PL_ZZZZ }   /* zzzz */,
  {     0,  1746,  4047,  21,   3, PL_LB__H3 }   /* graphemeclusterbreak=lvt */,
  {     2,   184,   982,   2,   2, PL_L_AMP_ }   /* islc */,
  {    52,   184,  8492,   2,   4, PL_RUNR }   /* isrunr */,
  {     1,  7136,   892,   6,  18, PL_INVS }   /* block=variationselectors */,
  {   135,  3129,  2002,  17,  21, PL_PRTI }   /* scriptextensions=inscriptionalparthian */,
  {    72,  1876,  7997,  21,   4, PL_CWL }   /* changeswhenlowercased=yes */,
  {    82,  8288,  2369,   3,   8, PL_DT__VERT }   /* dt=vertical */,
  {    13,  7226,  8001,   6,   5, PL_XPOSIXCNTRL }   /* xposixcntrl */,
  {     5,  6890,  1282,   4,  24, PL_CJKSYMBOLS }   /* blk=cjksymbolsandpunctuation */,
  {     0,  6890,  6926,   4,   9, PL_INKHUDAWADI }   /* blk=khudawadi */,
  {     1,  3129,  7272,  17,   8, PL_MAHJ }   /* scriptextensions=mahajani */,
  {     4,  8468,     0,   4,   0, PL_MIAO }   /* plrd */,
  {     3,  8096,  2598,   4,  19, PL_MERO }   /* scx=meroitichieroglyphs */,
  {     2,  3129,  6626,  17,   4, PL_KHAR }   /* scriptextensions=khar */,
  {     4,   974,  8681,  24,   3, PL_CCC__BR }   /* canonicalcombiningclass=222 */,
  {     2,  6890,  6881,   4,   9, PL_INBHAIKSUKI }   /* blk=bhaiksuki */,
  {     2,  8096,  8071,   4,   5, PL_OSGE }   /* scx=osage */,
  {     3,  8894,  1548,   3,   2, PL_VO__TR }   /* vo=tr */,
  {     3,  7366,     0,   4,   0, PL_BENG }   /* beng */,
  {    10,  4449,    26,  14,   1, PL_NFCQC__Y }   /* nfcquickcheck=y */,
  {     1,  4542,  7633,   3,   6, PL_TGLG }   /* istagalog */,
  {     0,  2229,  5253,  16,   5, PL_XPOSIXDIGIT }   /* generalcategory=digit */,
  {    14,  1448,  6737,   3,   9, PL_INSAURASHTRA }   /* insaurashtra */,
  {     0,  6890,  7408,   4,   7, PL_CJKEXTD }   /* blk=cjkextd */,
  {     0,  8816,  8617,   3,   2, PL_NV__31 }   /* nv=31 */,
  {     4,  6210,  1659,   3,  21, PL_CJKCOMPATIDEOGRAPHSSUP }   /* incjkcompatideographssup */,
  {     2,  2787,     0,   4,   0, PL_CHER }   /* cher */,
  {    26,  8816,  7726,   3,   6, PL_NV__432000 }   /* nv=432000 */,
  {     0,  7380,  2289,   4,   4, PL_CCC__L }   /* ccc=left */,
  {     2,  8376,   496,   3,   2, PL_LB__NU }   /* lb=nu */,
  {     3,   184,  7499,   2,   7, PL_KALI }   /* iskayahli */,
  {   129,  7136,  3271,   6,  17, PL_UCAS }   /* block=canadiansyllabics */,
  {     1,  2229,   699,  16,   6, PL_N }   /* generalcategory=number */,
  {   226,  6554,  2409,   3,   5, PL_INBRAHMI }   /* inbrahmi */,
  {     4,  1206,  7647,   3,   6, PL_INTAIVIET }   /* intaiviet */,
  {     0,  5765,  7997,  12,   4, PL_GRBASE }   /* graphemebase=yes */,
  {    50,  4419,     0,  15,   0, PL_MISCPICTOGRAPHS }   /* miscpictographs */,
  {     0,  7288,  5400,   8,   7, PL_BALI }   /* script=balinese */,
  {     1,  8011,  3690,   3,  16, PL_PF }   /* gc=finalpunctuation */,
  {     0,  7459,  8424,   3,   4, PL_NBAT }   /* sc=nbat */,
  {     0,  7136,  6776,   6,  10, PL_SUPARROWSB }   /* block=suparrowsb */,
  {     0,  8021,  7997,   5,   2, PL_GREXT }   /* grext=y */,
  {     0,  6713,  8711,   3,   3, PL_IN__3_DOT_1 }   /* in=3.1 */,
  {     1,  6706,  8657,  10,   3, PL_IN__2 }   /* presentin=2.0 */,
  {   131,  7459,  8432,   3,   4, PL_NKO }   /* sc=nkoo */,
  {     0,  8016,  1690,   4,   2, PL_GCB__CN }   /* gcb=cn */,
  {     0,  5134,  6042,   3,  11, PL_PLAYINGCARDS }   /* isplayingcards */,
  {     5,  4440,  2251,   4,  18, PL_GLAGOLITICSUP }   /* inglagoliticsupplement */,
  {   263,  6263,  7264,  10,   8, PL_LB__LF }   /* linebreak=linefeed */,
  {     0,  4614,     0,  15,   0, PL_VEDICEXT }   /* vedicextensions */,
  {     2,  6506,  2129,   3,   5, PL_YIJING }   /* isyijing */,
  {     1,   974,  5219,  24,   2, PL_CCC__10 }   /* canonicalcombiningclass=10 */,
  {     0,  7380,  2769,   4,  18, PL_CCC__216 }   /* ccc=attachedaboveright */,
  {     0,  5544,  7750,  13,   2, PL_NV__80 }   /* numericvalue=80 */,
  {   177,  3129,  1107,  17,   8, PL_KANA }   /* scriptextensions=katakana */,
  {     0,   184,  6944,   2,   9, PL_LATINEXTC }   /* islatinextc */,
  {     4,  7459,  7971,   3,   5, PL_BATK }   /* sc=batak */,
  {     2,  3129,  7810,  17,   6, PL_GOTH }   /* scriptextensions=gothic */,
  {     0,   184,  7787,   3,   5, PL_CAKM }   /* ischakma */,
  {     0,  2249,     0,   4,   0, PL_GLAG }   /* glag */,
  {    67,  7870,     0,   4,   0, PL_LEPC }   /* lepc */,
  {    32,  6890,  2787,   4,  18, PL_CHEROKEESUP }   /* blk=cherokeesupplement */,
  {    73,  2990,  6865,   4,   7, PL_ARABICPFA }   /* inarabicpfa */,
  {     1,  5544,  7744,  13,   2, PL_NV__70 }   /* numericvalue=70 */,
  {    71,  7798,  7768,   6,   2, -PL_COMPEX }   /* compex=f */,
  {     0,  7459,  6806,   3,   4, PL_WARA }   /* sc=wara */,
  {    14,  7774,  7548,   3,   7, PL_SD }   /* _canondcij */,
  {     3,  5192,  2003,   3,  20, PL_PRTI }   /* isinscriptionalparthian */,
  {     0,  8440,     0,   4,   0, PL_OGAM }   /* ogam */,
  {     2,  8036,   516,   5,  13, PL_UIDEO }   /* isunifiedideograph */,
  {     1,  1589,     0,  14,   0, PL_LATINEXTA }   /* latinextendeda */,
  {     0,  8204,     0,   4,   0, PL_POSIXXDIGIT }   /* ahex */,
  {     1,  6890,  6373,   4,  11, PL_INPAHAWHHMONG }   /* blk=pahawhhmong */,
  {    10,  4314,  6417,  13,  11, PL_JG__STRAIGHTWAW }   /* joininggroup=straightwaw */,
  {     2,  7136,  2636,   6,   9, PL_INMONGOLIAN }   /* block=mongolian */,
  {   155,  3129,  7443,  17,   7, PL_GRAN }   /* scriptextensions=grantha */,
  {     1,  7459,  8304,   3,   4, PL_SC__GUJR }   /* sc=gujr */,
  {     4,  5645,  6017,  10,  12, PL_BC__ON }   /* bidiclass=otherneutral */,
  {    40,  7689,  8209,   3,   3, PL_AHOM }   /* isahom */,
  {     2,  5258,     0,  13,   0, PL_BLOCKELEMENTS }   /* blockelements */,
  {    10,  3424,  3223,  17,   2, -PL_IDSB }   /* idsbinaryoperator=n */,
  {    14,  2229,    32,  16,   2, PL_CS }   /* generalcategory=cs */,
  {     4,  6713,  8765,   3,   3, PL_IN__8 }   /* in=8.0 */,
  {     3,  8504,  1621,   3,   6, PL_SB__FO }   /* sb=format */,
  {     1,  7380,  8651,   4,   3, PL_CCC__132 }   /* ccc=132 */,
  {    10,  7227,  5252,   5,   6, PL_POSIXXDIGIT }   /* posixxdigit */,
  {     3,  5082,     0,  11,   0, PL_MC }   /* spacingmark */,
  {    13,  3129,  1540,  17,   4, PL_PHAG }   /* scriptextensions=phag */,
  {     0,  5388,     0,  13,   0, PL_KANAEXTA }   /* kanaextendeda */,
  {     1,  3129,  8368,  17,   4, PL_LAO }   /* scriptextensions=laoo */,
  {     2,  8816,  8160,   3,   4, PL_NV__13_SLASH_2 }   /* nv=13/2 */,
  {    82,  6472,  5762,  10,   3, PL_LB__ZWJ }   /* wordbreak=zwj */,
  {     7,  4554,    34,  14,   6, PL_SB__EX }   /* sentencebreak=extend */,
  {     1,  3521,  7768,   5,   6, -PL_XPOSIXSPACE }   /* space=false */,
  {     5,  6210,  7787,   3,   5, PL_INCHAKMA }   /* inchakma */,
  {     1,  1452,     0,   2,   0, PL_PS }   /* ps */,
  {     2,  4314,  5894,  13,   3, PL_JG__NYA }   /* joininggroup=nya */,
  {     0,  3458,     0,   4,   0, PL_MANI }   /* mani */,
  {     0,   184,  1028,   3,   3, PL_COPT }   /* iscopt */,
  {   256,    21,  1589,   2,   9, PL_LATINEXTE }   /* inlatinexte */,
  {    18,    21,  8428,   2,   4, PL_INNEWA }   /* innewa */,
  {    81,  4630,  1930,   3,   8, PL_XPOSIXUPPER }   /* isuppercase */,
  {    32,  4314,  6285,  13,  11, PL_JG__MALAYALAMRA }   /* joininggroup=malayalamra */,
  {    35,  5134,  2371,   3,   3, PL_PRTI }   /* isprti */,
  {     0,   436,  7997,   5,   4, PL_NCHAR }   /* nchar=yes */,
  {   144,  7906,  7860,   5,   4, PL_SC__KHOJ }   /* sc=khojki */,
  {     0,  3129,  7492,  17,   7, PL_KNDA }   /* scriptextensions=kannada */,
  {   259,  5544,  7744,  13,   5, PL_NV__70000 }   /* numericvalue=70000 */,
  {     4,  8011,  1393,   4,   8, PL_CS }   /* gc=surrogate */,
  {     1,  6890,  1566,   4,  23, PL_COMPATJAMO }   /* blk=hangulcompatibilityjamo */,
  {     0,  1448,  2715,   5,  16, PL_SUPARROWSB }   /* insupplementalarrowsb */,
  {     1,  7459,  7034,   3,   9, PL_PALM }   /* sc=palmyrene */,
  {     2,  6554,  3611,   3,  15, PL_BOPOMOFOEXT }   /* inbopomofoextended */,
  {     3,  2229,  3075,  16,  18, PL_ZP }   /* generalcategory=paragraphseparator */,
  {     0,  7288,  8253,   8,   3, PL_SC__BUHD }   /* script=buhd */,
  {     2,  6483,  7997,  11,   4, PL_XIDC }   /* xidcontinue=yes */,
  {     0,  7136,  5609,   6,  12, PL_ALPHABETICPF }   /* block=alphabeticpf */,
  {     2,  7459,  3882,   3,   7, PL_SC__MYMR }   /* sc=myanmar */,
  {     0,  5557,  7997,  13,   4, PL_PATSYN }   /* patternsyntax=yes */,
  {     3,  3129,  6926,  17,   9, PL_SIND }   /* scriptextensions=khudawadi */,
  {     7,  1892,  7768,   5,   6, -PL_CASED }   /* cased=false */,
  {     0,  7457,   699,   5,   6, PL_INSC__NUMBER }   /* insc=number */,
  {    65,  3129,  1680,  17,   6, PL_ZYYY }   /* scriptextensions=common */,
  {    45,  2100,  6352,   3,  10, PL_NO }   /* isothernumber */,
  {     6,  4239,  7997,   4,   2, PL_DASH }   /* dash=y */,
  {    18,  4063,  2879,   4,  11, PL_DEVANAGARIEXT }   /* indevanagariext */,
  {    12,  7288,  2841,   7,   6, PL_SC__COPT }   /* script=coptic */,
  {     0,  2065,  3223,  21,   3, -PL_NCHAR }   /* noncharactercodepoint=no */,
  {     0,  4542,  5552,   3,   3, PL_TALU }   /* istalu */,
  {     0,  7459,  8448,   3,   4, PL_ORKH }   /* sc=orkh */,
  {     1,  7288,  2360,   7,   4, PL_SC__MAND }   /* script=mand */,
  {   114,   184,  8091,   2,   5, PL_RUNR }   /* isrunic */,
  {     0,  7288,  8352,   7,   4, PL_KHMR }   /* script=khmr */,
  {     2,  8816,  8688,   3,   2, PL_NV__26 }   /* nv=26 */,
  {     0,  3521,  7997,   5,   2, PL_XPOSIXSPACE }   /* space=y */,
  {     0,  6890,  4784,   4,   4, PL_INCHAM }   /* blk=cham */,
  {    73,  3129,  8456,  17,   4, PL_OSGE }   /* scriptextensions=osge */,
  {     0,  7288,  8268,   7,   4, PL_SC__CPRT }   /* script=cprt */,
  {     0,  8096,  2967,   4,   4, PL_GEOR }   /* scx=geor */,
  {     0,  8376,   223,   3,   2, PL_LB__PR }   /* lb=pr */,
  {     0,   974,  7924,  24,   6, PL_CCC__9 }   /* canonicalcombiningclass=virama */,
  {     1,  3129,  7846,  17,   6, PL_KTHI }   /* scriptextensions=kaithi */,
  {     0,    21,  7957,   3,   4, PL_INADLAM }   /* inadlam */,
  {    82,  5544,  5219,  13,   3, PL_NV__100 }   /* numericvalue=100 */,
  {     3,  3373,  1093,  15,   9, PL_EA__F }   /* eastasianwidth=fullwidth */,
  {     0,  7136,  4010,   6,   6, PL_INTANGUT }   /* block=tangut */,
  {     0,  8011,  5323,   3,  13, PL_ME }   /* gc=enclosingmark */,
  {     0,  7380,  8673,   7,   2, PL_CCC__14 }   /* ccc=ccc14 */,
  {     0,  5192,  6918,   3,   8, PL_QAAI }   /* isinherited */,
  {    15,  8096,  8091,   4,   5, PL_RUNR }   /* scx=runic */,
  {     0,  6890,  2484,   4,  19, PL_INEGYPTIANHIEROGLYPHS }   /* blk=egyptianhieroglyphs */,
  {     0,  6713,  8855,   3,   3, PL_IN__3_DOT_2 }   /* in=v32 */,
  {     1,   184,  1886,   2,   2, PL_NL }   /* isnl */,
  {    30,    11,  7997,   3,   4, PL_DIA }   /* dia=yes */,
  {     0,  8272,  3223,   4,   3, -PL_CWCF }   /* cwcf=no */,
  {    22,  8572,  1107,   3,   8, PL_WB__KA }   /* wb=katakana */,
  {   261,  5557,  7997,  13,   2, PL_PATSYN }   /* patternsyntax=y */,
  {     2,  4542,  1372,   4,   2, PL_TELU }   /* istelu */,
  {     2,  8101,  7951,   5,   5, PL_STERM }   /* sterm=true */,
  {     4,  4402,  2637,   3,  18, PL_MONGOLIANSUP }   /* inmongoliansupplement */,
  {     0,  1159,  7997,  25,   4, PL_CWKCF }   /* changeswhennfkccasefolded=yes */,
  {    28,  8016,  4047,   4,   2, PL_LB__H2 }   /* gcb=lv */,
  {     3,  2229,    45,  16,   2, PL_CO }   /* generalcategory=co */,
  {    29,   947,     0,  27,   0, PL_ANCIENTGREEKMUSIC }   /* ancientgreekmusicalnotation */,
  {    35,  6263,  6899,  10,   9, PL_LB__B2 }   /* linebreak=breakboth */,
  {     3,  7380,  7576,   4,   7, PL_CCC__1 }   /* ccc=overlay */,
  {    13,   974,  8705,  24,   3, PL_CCC__IS }   /* canonicalcombiningclass=240 */,
  {     0,  6263,  6186,  10,  11, PL_LB__IN }   /* linebreak=inseparable */,
  {     1,   510,     0,  30,   0, PL_CJKEXTA }   /* cjkunifiedideographsextensiona */,
  {    49,  7380,  5981,   4,  12, PL_CCC__0 }   /* ccc=notreordered */,
  {     0,    21,  8091,   2,   5, PL_INRUNIC }   /* inrunic */,
  {     0,  7136,  5693,   6,  12, PL_CYRILLICEXTB }   /* block=cyrillicextb */,
  {     0,  3706,     0,  16,   0, PL_HALFANDFULLFORMS }   /* halfandfullforms */,
  {     0,  3898,     0,  16,   0, PL_MYANMAREXTB }   /* myanmarextendedb */,
  {     1,  7459,  2107,   3,   4, PL_SC__SINH }   /* sc=sinh */,
  {    30,   117,  2004,   4,  19, PL_ININSCRIPTIONALPARTHIAN }   /* ininscriptionalparthian */,
  {   145,  6706,  8870,  10,   3, PL_IN__5_DOT_2 }   /* presentin=v52 */,
  {    28,  6890,  2541,   4,  10, PL_JAMO }   /* blk=hanguljamo */,
  {     3,  7288,  7583,   7,   7, PL_SC__PHAG }   /* script=phagspa */,
  {     3,  5544,  8744,  13,   3, PL_NV__5_SLASH_8 }   /* numericvalue=5/8 */,
  {     2,  3129,  7336,  17,   8, PL_UGAR }   /* scriptextensions=ugaritic */,
  {    28,  8816,  5219,   3,  11, PL_NV__10000000000 }   /* nv=10000000000 */,
  {     4,  7459,  8200,   3,   4, PL_AGHB }   /* sc=aghb */,
  {     2,  3129,  6005,  17,  12, PL_HUNG }   /* scriptextensions=oldhungarian */,
  {     0,  8076,  7997,   5,   4, PL_PATWS }   /* patws=yes */,
  {    51,  1746,  8789,  21,   3, PL_WB__EBG }   /* graphemeclusterbreak=ebg */,
  {     0,  8816,  7732,   3,   2, PL_NV__50 }   /* nv=50 */,
  {    24,  7459,  6736,   3,  10, PL_SAUR }   /* sc=saurashtra */,
  {    18,  8240,  4149,   3,  15, PL_BC__CS }   /* bc=commonseparator */,
  {     0,  8376,  6197,   3,  11, PL_LB__IN }   /* lb=inseperable */,
  {    65,  7208,     0,   4,   0, PL_HIRA }   /* hira */,
  {     0,  4314,  4967,  13,  14, PL_JG__MANICHAEANKAPH }   /* joininggroup=manichaeankaph */,
  {     0,  6472,  7165,  10,   3, PL_WB__GAZ }   /* wordbreak=gaz */,
  {    32,  6706,  7744,  10,   1, PL_IN__7 }   /* presentin=7 */,
  {    14,  6890,  5363,   5,   5, PL_IPAEXT }   /* blk=ipaext */,
  {     0,  1963,  7997,   7,   4, PL_RADICAL }   /* radical=yes */,
  {     0,  8816,  8164,   3,   2, PL_NV__15 }   /* nv=15 */,
  {   101,  6120,     0,  11,   0, PL_DOMINO }   /* dominotiles */,
  {     0,   184,  2842,   3,  17, PL_COPTICEPACTNUMBERS }   /* iscopticepactnumbers */,
  {     0,  7380,  8051,   4,   5, PL_CCC__7 }   /* ccc=nukta */,
  {     0,  6890,  5825,   4,  12, PL_MAHJONG }   /* blk=mahjongtiles */,
  {     1,  7457,  4743,   5,  14, PL_INSC__GEMINATIONMARK }   /* insc=geminationmark */,
  {     1,  5544,  8688,  13,   2, PL_NV__26 }   /* numericvalue=26 */,
  {     1,  7457,  4539,   5,  15, PL_INSC__REGISTERSHIFTER }   /* insc=registershifter */,
  {     2,   892,     0,  28,   0, PL_VSSUP }   /* variationselectorssupplement */,
  {    45,  6890,   920,   4,  27, PL_ALPHABETICPF }   /* blk=alphabeticpresentationforms */,
  {     0,  6210,  7395,   3,   6, PL_CJKEXTB }   /* incjkextb */,
  {     0,  8096,  6008,   4,   4, PL_HUNG }   /* scx=hung */,
  {     0,  7380,  6836,   4,   9, PL_CCC__AL }   /* ccc=aboveleft */,
  {    38,  6890,  2044,   4,  14, PL_MEETEIMAYEKEXT }   /* blk=meeteimayekext */,
  {     0,  5375,  6461,  12,  11, PL_JT__T }   /* joiningtype=transparent */,
  {     0,  8316,     0,   4,   0, PL_HANO }   /* hano */,
  {     0,  8096,  8412,   4,   4, PL_MTEI }   /* scx=mtei */,
  {     0,  7288,  7436,   7,   7, PL_ELBA }   /* script=elbasan */,
  {   100,  8340,  6417,   3,  11, PL_JG__STRAIGHTWAW }   /* jg=straightwaw */,
  {     0,  6890,  2877,   4,  10, PL_INDEVANAGARI }   /* blk=devanagari */,
  {   101,    96,  3223,   5,   2, -PL_XPOSIXALPHA }   /* alpha=n */,
  {     0,  7401,     0,   7,   0, PL_CJKEXTC }   /* cjkextc */,
  {     0,  7478,  6737,   3,   9, PL_SAUR }   /* issaurashtra */,
  {     1,    21,  8046,   2,   5, PL_INLIMBU }   /* inlimbu */,
  {    49,  7459,  7200,   3,   8, PL_SC__GURU }   /* sc=gurmukhi */,
  {     0,   974,    18,  24,   1, PL_CCC__R }   /* canonicalcombiningclass=r */,
  {     0,  7459,  7611,   3,   7, PL_SOYO }   /* sc=soyombo */,
  {     0,   184,  7256,   2,   8, PL_KANAEXTA }   /* iskanaexta */,
  {     1,  8096,  1981,   4,   8, PL_CYRL }   /* scx=cyrillic */,
  {     0,  8006,  3223,   5,   2, -PL_CWKCF }   /* cwkcf=n */,
  {    11,  6472,   125,  10,   2, PL_LB__CR }   /* wordbreak=cr */,
  {    29,  8096,  7499,   4,   7, PL_KALI }   /* scx=kayahli */,
  {     3,  2229,  8001,  16,   5, PL_XPOSIXCNTRL }   /* generalcategory=cntrl */,
  {    90,  3129,  5121,  17,  14, PL_PHLP }   /* scriptextensions=psalterpahlavi */,
  {     3,  8340,  8212,   3,   4, PL_JG__ALEF }   /* jg=alef */,
  {     0,  6890,  7320,   4,   8, PL_INTIFINAGH }   /* blk=tifinagh */,
  {     0,  3129,  8608,  17,   4, PL_ZZZZ }   /* scriptextensions=zzzz */,
  {   128,  7459,  8044,   3,   4, PL_PHLI }   /* sc=phli */,
  {     4,  6472,  5729,  10,  12, PL_WB__EX }   /* wordbreak=extendnumlet */,
  {     0,  2674,     0,  12,   0, PL_SUNDANESESUP }   /* sundanesesup */,
  {     5,  1497,     0,  23,   0, PL_BYZANTINEMUSIC }   /* byzantinemusicalsymbols */,
  {     0,  7136,  1498,   7,  22, PL_BYZANTINEMUSIC }   /* block=byzantinemusicalsymbols */,
  {     2,  3129,  1566,  17,   6, PL_HANG }   /* scriptextensions=hangul */,
  {     1,  7534,     0,   7,   0, PL_NB }   /* noblock */,
  {     0,  3914,     0,   5,   0, PL_C }   /* other */,
  {    37,  8026,   809,   3,  27, PL_PHONETICEXTSUP }   /* inphoneticextensionssupplement */,
  {     2,  5544,  7936,  13,   5, PL_NV__1_SLASH_160 }   /* numericvalue=1/160 */,
  {     0,  7459,  7786,   3,   6, PL_SC__CAKM }   /* sc=chakma */,
  {   256,  3424,  7997,   4,   2, PL_IDSB }   /* idsb=y */,
  {   265,  6483,     0,  11,   0, PL_XIDC }   /* xidcontinue */,
  {     0,  6890,  5336,   4,  13, PL_GREEKEXT }   /* blk=greekextended */,
  {     6,  1184,  3223,  25,   2, -PL_DI }   /* defaultignorablecodepoint=n */,
  {     0,  7459,  8608,   3,   4, PL_ZZZZ }   /* sc=zzzz */,
  {    10,   974,  8228,  24,   3, PL_CCC__202 }   /* canonicalcombiningclass=atb */,
  {    38,  8376,  6845,   3,   9, PL_LB__AI }   /* lb=ambiguous */,
  {     0,   184,     7,   3,   1, PL_XPOSIXCNTRL }   /* iscc */,
  {   280,  1589,     0,   9,   0, PL_LATINEXTE }   /* latinexte */,
  {     0,  7136,  4089,   6,  15, PL_ARABICEXTA }   /* block=arabicextendeda */,
  {     1,  2750,  3223,  19,   3, -PL_TERM }   /* terminalpunctuation=no */,
  {   263,  7136,  2389,   6,  19, PL_ANCIENTGREEKNUMBERS }   /* block=ancientgreeknumbers */,
  {     1,  1746,    73,  21,   2, PL_LB__EM }   /* graphemeclusterbreak=em */,
  {     1,  5645,  5079,  10,  14, PL_BC__NSM }   /* bidiclass=nonspacingmark */,
  {    65,  7798,  3223,   6,   3, -PL_COMPEX }   /* compex=no */,
  {     0,  3129,  7152,  17,   4, PL_DUPL }   /* scriptextensions=dupl */,
  {     0,  3129,  7120,  17,   4, PL_BALI }   /* scriptextensions=bali */,
  {   288,  7459,  6373,   3,  11, PL_HMNG }   /* sc=pahawhhmong */,
  {     6,  2229,  1679,  16,   2, PL_PC }   /* generalcategory=pc */,
  {     0,  3129,  7822,  17,   4, PL_HATR }   /* scriptextensions=hatr */,
  {     0,   974,  8632,  27,   2, PL_CCC__91 }   /* canonicalcombiningclass=ccc91 */,
  {     4,  5134,     2,   3,   1, PL_PI }   /* ispi */,
  {    29,   184,  8941,   2,   2, PL_ZS }   /* iszs */,
  {    15,  7288,  7858,   7,   6, PL_SC__KHOJ }   /* script=khojki */,
  {     0,    96,  7951,   5,   5, PL_XPOSIXALPHA }   /* alpha=true */,
  {     0,  8288,  5969,   3,   8, PL_DT__NONCANON }   /* dt=noncanon */,
  {     0,   184,  2249,   2,  10, PL_GLAG }   /* isglagolitic */,
  {     1,  6890,  6318,   4,  11, PL_MYANMAREXTB }   /* blk=myanmarextb */,
  {    64,  7459,  8312,   3,   4, PL_SC__HAN }   /* sc=hani */,
  {    81,  1897,  7768,  21,   6, -PL_CWT }   /* changeswhentitlecased=false */,
  {     0,  6890,  1702,   4,  12, PL_DIACRITICALS }   /* blk=diacriticals */,
  {     0,  8504,  1074,   3,   2, PL_SB__ST }   /* sb=st */,
  {     0,   447,     0,  32,   0, PL_IDEOGRAPHICSYMBOLS }   /* ideographicsymbolsandpunctuation */,
  {     0,   599,     0,   2,   0, PL_XPOSIXCNTRL }   /* cc */,
  {     0,  5544,  5219,  13,   9, PL_NV__100000000 }   /* numericvalue=100000000 */,
  {     0,  8816,  8161,   3,   3, PL_NV__3_SLASH_2 }   /* nv=3/2 */,
  {     0,  8376,     3,   4,   1, PL_LB__LF }   /* lb=lf */,
  {    23,  7288,  1680,   7,   6, PL_SC__ZYYY }   /* script=common */,
  {    82,  8816,  3743,   3,   1, PL_NV__1 }   /* nv=1 */,
  {   259,   184,  6296,   2,  11, PL_MISCSYMBOLS }   /* ismiscsymbols */,
  {    28,  8086,  7997,   5,   2, PL_QMARK }   /* qmark=y */,
  {     0,  7288,  8316,   7,   4, PL_SC__HANO }   /* script=hano */,
  {     0,  6472,  1107,  10,   2, PL_WB__KA }   /* wordbreak=ka */,
  {     1,  4479,  7998,  15,   3, PL_NFKCQC__Y }   /* nfkcquickcheck=yes */,
  {     0,  3674,     0,  16,   0, PL_CYPRIOTSYLLABARY }   /* cypriotsyllabary */,
  {    65,  3114,  7675,   3,   6, PL_UCASEXT }   /* inucasext */,
  {    74,  3129,  1479,  18,   2, PL_VAI }   /* scriptextensions=vai */,
  {     9,  5192,  5363,   3,  12, PL_IPAEXT }   /* isipaextensions */,
  {     0,  6613,  2561,   3,  18, PL_JAMOEXTB }   /* ishanguljamoextendedb */,
  {     0,  7380,  8168,   7,   2, PL_CCC__17 }   /* ccc=ccc17 */,
  {     0,  8196,  8660,   4,   3, PL_AGE__2_DOT_1 }   /* age=2.1 */,
  {    16,   184,  4210,   3,  14, PL_CONTROLPICTURES }   /* iscontrolpictures */,
  {    24,  8376,  2284,   3,   2, PL_LB__HL }   /* lb=hl */,
  {     1,  7136,  5149,   6,  14, PL_SUPPUNCTUATION }   /* block=suppunctuation */,
  {     1,  8340,  7079,   3,   9, PL_JG__SYRIACWAW }   /* jg=syriacwaw */,
  {     3,  5544,  7720,  13,   4, PL_NV__4000 }   /* numericvalue=4000 */,
  {    14,  8076,  3581,   5,   2, PL_PATWS }   /* patws=t */,
  {     0,  6109,     0,  10,   0, PL_C }   /* category=c */,
  {     1,   184,  3390,   2,  17, PL_ETHIOPICEXTA }   /* isethiopicextendeda */,
  {     1,  7459,  7351,   3,   4, PL_SC__TALE }   /* sc=tale */,
  {     2,  2229,  6098,  16,  11, PL_L_AMP_ }   /* generalcategory=casedletter */,
  {     0,  8096,  8476,   4,   4, PL_COPT }   /* scx=qaac */,
  {     0,  8081,     0,   5,   0, PL_XPOSIXPRINT }   /* print */,
  {    42,  3129,  8540,  17,   4, PL_TAML }   /* scriptextensions=taml */,
  {     6,  5544,  8168,  13,   2, PL_NV__17 }   /* numericvalue=17 */,
  {     0,  8096,  6676,   4,  10, PL_XPEO }   /* scx=oldpersian */,
  {     1,  1448,  7612,   3,   6, PL_INSOYOMBO }   /* insoyombo */,
  {     0,  8288,  8831,   3,   3, PL_DT__SML }   /* dt=sml */,
  {     0,   184,  5336,   2,   8, PL_GREEKEXT }   /* isgreekext */,
  {    18,  5134,  5122,   3,  13, PL_PHLP }   /* ispsalterpahlavi */,
  {    48,   974,  2295,  24,   5, PL_CCC__R }   /* canonicalcombiningclass=right */,
  {    20,  6221,  2807,   4,  16, PL_HALFMARKS }   /* incombininghalfmarks */,
  {    81,   974,  7702,  24,   3, PL_CCC__133 }   /* canonicalcombiningclass=200 */,
  {     1,  6263,   496,  10,   7, PL_LB__NU }   /* linebreak=numeric */,
  {    66,  6890,  1797,   4,   4, PL_INMODI }   /* blk=modi */,
  {    72,  1133,  3581,  26,   2, PL_PCM }   /* prependedconcatenationmark=t */,
  {     6,  8076,  3223,   5,   3, -PL_PATWS }   /* patws=no */,
  {     0,  7288,  3994,   7,   6, PL_SC__SYRC }   /* script=syriac */,
  {    17,  6890,  7240,   4,   8, PL_JAMOEXTB }   /* blk=jamoextb */,
  {     8,  8096,  8588,   4,   4, PL_YI }   /* scx=yiii */,
  {     3,   510,     0,  20,   0, PL_CJK }   /* cjkunifiedideographs */,
  {     0,   184,  8277,   3,   3, PL_CWCM }   /* iscwcm */,
  {     2,  3516,     0,  10,   0, PL_XPOSIXSPACE }   /* whitespace */,
  {     1,  1499,     0,   1,   0, PL_Z }   /* z */,
  {     0,  8816,  7702,   3,   5, PL_NV__20000 }   /* nv=20000 */,
  {    16,   184,  8236,   2,   4, PL_BATK }   /* isbatk */,
  {     1,   974,  8654,  27,   3, PL_CCC__133 }   /* canonicalcombiningclass=ccc133 */,
  {     0,  8816,  8663,   3,   3, PL_NV__2_SLASH_3 }   /* nv=2/3 */,
  {     0,  7459,  8116,   3,   5, PL_SC__TAML }   /* sc=tamil */,
  {    31,  5801,     0,  12,   0, PL_KHMERSYMBOLS }   /* khmersymbols */,
  {     0,  8036,     3,   5,  39, PL_UCASEXT }   /* isunifiedcanadianaboriginalsyllabicsextended */,
  {     0,  1402,  2289,  24,   4, PL_INPC__LEFT }   /* indicpositionalcategory=left */,
  {     1,   184,  4757,   2,  14, PL_GREXT }   /* isgraphemeextend */,
  {     0,  8096,  2044,   4,  11, PL_MTEI }   /* scx=meeteimayek */,
  {     1,  6890,  2895,   4,  11, PL_ETHIOPICSUP }   /* blk=ethiopicsup */,
  {    44,  8096,  8608,   4,   4, PL_ZZZZ }   /* scx=zzzz */,
  {     0,  6472,  4561,  10,   2, PL_WB__EB }   /* wordbreak=eb */,
  {     0,  1354,  7997,  24,   2, PL_COMPEX }   /* fullcompositionexclusion=y */,
  {     0,  6210,  5682,   3,  11, PL_CYRILLICEXTA }   /* incyrillicexta */,
  {     0,  4479,    47,  15,   1, PL_NFCQC__M }   /* nfkcquickcheck=m */,
  {     1,  1107,     0,   8,   0, PL_KANA }   /* katakana */,
  {     0,  7780,     0,   4,   0, PL_CARI }   /* cari */,
  {     1,  3373,     1,  15,   1, PL_EA__N }   /* eastasianwidth=n */,
  {     0,  4314,  4925,  13,  14, PL_JG__MANICHAEANBETH }   /* joininggroup=manichaeanbeth */,
  {     2,  5544,  8627,  13,   3, PL_NV__1_SLASH_8 }   /* numericvalue=1/8 */,
  {    16,  7136,  7597,   6,   7, PL_SHAW }   /* block=shavian */,
  {     4,  6890,  4134,   4,   7, PL_BRAI }   /* blk=braille */,
  {     0,  7136,  3674,   6,  16, PL_CYPRIOTSYLLABARY }   /* block=cypriotsyllabary */,
  {     0,  8096,  7043,   4,   9, PL_PAUC }   /* scx=paucinhau */,
  {     3,  1402,  6121,   3,  10, PL_DOMINO }   /* indominotiles */,
  {     8,  7227,  8001,   5,   5, PL_POSIXCNTRL }   /* posixcntrl */,
  {    13,  7459,  7443,   3,   7, PL_SC__GRAN }   /* sc=grantha */,
  {     0,   184,  7870,   2,   4, PL_LEPC }   /* islepc */,
  {     0,  7136,  1258,   6,  24, PL_ARABICPFB }   /* block=arabicpresentationformsb */,
  {    19,  6472,  3914,  10,   5, PL_WB__XX }   /* wordbreak=other */,
  {    94,  1855,     0,  21,   0, PL_CWCM }   /* changeswhencasemapped */,
  {     0,  1887,  7997,   5,   4, PL_XPOSIXLOWER }   /* lower=yes */,
  {     1,  6766,     0,  10,   0, PL_SUPARROWSA }   /* suparrowsa */,
  {   257,  7828,  7997,   6,   2, PL_HYPHEN }   /* hyphen=y */,
  {     3,   184,  2895,   2,  18, PL_ETHIOPICSUP }   /* isethiopicsupplement */,
  {    74,  7136,  4254,   6,  15, PL_DIACRITICALSEXT }   /* block=diacriticalsext */,
  {    32,  6616,  7951,  10,   5, PL_DEP }   /* deprecated=true */,
  {     1,  7459,  8560,   3,   4, PL_TIBT }   /* sc=tibt */,
  {     0,  5645,   806,  10,   2, PL_BC__WS }   /* bidiclass=ws */,
  {     6,  8388,     0,   4,   0, PL_LISU }   /* lisu */,
  {   177,   184,  5682,   3,  11, PL_CYRILLICEXTA }   /* iscyrillicexta */,
  {     1,  7136,  8532,   6,   4, PL_TAGS }   /* block=tags */,
  {   150,  1887,  7951,   5,   5, PL_XPOSIXLOWER }   /* lower=true */,
  {     0,  8076,  7768,   5,   2, -PL_PATWS }   /* patws=f */,
  {   258,  1417,   133,   9,   4, PL_M }   /* category=mark */,
  {    81,  8288,  2100,   3,   3, PL_DT__ISO }   /* dt=iso */,
  {     0,  8096,  7858,   4,   4, PL_KHOJ }   /* scx=khoj */,
  {     1,  4464,  8256,   4,   3, PL_DT__CAN }   /* nfdqc=n */,
  {     2,  8096,  7336,   4,   8, PL_UGAR }   /* scx=ugaritic */,
  {     0,  6472,  6153,  10,  11, PL_WB__DQ }   /* wordbreak=doublequote */,
  {     0,  3129,    78,  17,   4, PL_ARAB }   /* scriptextensions=arab */,
  {     0,  1184,  7997,  25,   4, PL_DI }   /* defaultignorablecodepoint=yes */,
  {     3,  7136,  7232,   6,   8, PL_JAMOEXTA }   /* block=jamoexta */,
  {     0,  6554,  5400,   3,   7, PL_INBALINESE }   /* inbalinese */,
  {     0,  2787,     0,  18,   0, PL_CHEROKEESUP }   /* cherokeesupplement */,
  {     0,  3129,  8352,  17,   4, PL_KHMR }   /* scriptextensions=khmr */,
  {     0,  7478,  1393,   3,   8, PL_CS }   /* issurrogate */,
  {     0,  7478,  8525,   3,   3, PL_SHRD }   /* isshrd */,
  {     0,   974,  8740,  27,   2, PL_CCC__25 }   /* canonicalcombiningclass=ccc25 */,
  {     0,  7288,  7492,   7,   7, PL_SC__KNDA }   /* script=kannada */,
  {   275,   184,  1797,   2,  15, PL_MODIFIERLETTERS }   /* ismodifierletters */,
  {    11,  8819,     0,   3,   0, PL_OCR }   /* ocr */,
  {     1,  7248,     0,   4,   0, PL_JAVA }   /* java */,
  {     1,  8568,     0,   4,   0, PL_VAI }   /* vaii */,
  {     4,  6890,    42,   4,   9, PL_CJKCOMPAT }   /* blk=cjkcompat */,
  {     5,  7459,   954,   3,   5, PL_SC__GREK }   /* sc=greek */,
  {     0,  2108,  1568,   4,  21, PL_COMPATJAMO }   /* inhangulcompatibilityjamo */,
  {     0,  7459,  6439,   3,  11, PL_SC__SYLO }   /* sc=sylotinagri */,
  {     0,  6210,   631,   3,  29, PL_CJKEXTE }   /* incjkunifiedideographsextensione */,
  {     2,  6890,  6241,   4,  11, PL_KATAKANAEXT }   /* blk=katakanaext */,
  {     3,  7689,   921,   3,  26, PL_ALPHABETICPF }   /* isalphabeticpresentationforms */,
  {     2,  4314,  4963,  13,   4, PL_JG__HETH }   /* joininggroup=heth */,
  {     5,  5544,  7738,  13,   6, PL_NV__600000 }   /* numericvalue=600000 */,
  {     1,  8572,  1083,   3,   2, PL_LB__LF }   /* wb=lf */,
  {     2,  7459,  7208,   3,   4, PL_SC__HIRA }   /* sc=hira */,
  {    34,  7459,  8480,   3,   4, PL_SC__QAAI }   /* sc=qaai */,
  {     3,  6890,   849,   4,  14, PL_PUA }   /* blk=privateusearea */,
  {    65,  7136,    78,   6,  10, PL_ARABICMATH }   /* block=arabicmath */,
  {     1,  8340,  5505,   3,  13, PL_JG__MANICHAEANTEN }   /* jg=manichaeanten */,
  {    16,  1503,  1002,   3,  26, PL_ENCLOSEDCJK }   /* inenclosedcjklettersandmonths */,
  {    13,   974,  8691,  24,   2, PL_CCC__28 }   /* canonicalcombiningclass=28 */,
  {     0,  1184,  7768,  25,   6, -PL_DI }   /* defaultignorablecodepoint=false */,
  {     6,  8504,  1083,   3,   2, PL_LB__LF }   /* sb=lf */,
  {     3,  8777,  3581,   3,   2, PL_CWL }   /* cwl=t */,
  {     1,  2134,     0,   3,   0, PL_XPOSIXXDIGIT }   /* hex */,
  {     8,  3129,  8412,  17,   4, PL_MTEI }   /* scriptextensions=mtei */,
  {     6,  8196,  8873,   4,   3, PL_AGE__6 }   /* age=v60 */,
  {     0,   184,    43,   3,   2, PL_CJK }   /* iscjk */,
  {     0,  8096,  8116,   4,   5, PL_TAML }   /* scx=tamil */,
  {     0,  3946,  7951,  16,   5, PL_STERM }   /* sentenceterminal=true */,
  {     0,  7136,  7653,   6,   7, PL_INTIBETAN }   /* block=tibetan */,
  {     0,  2841,     0,   4,   0, PL_COPT }   /* copt */,
  {     8,  4284,  4584,  14,  15, PL_LB__H2 }   /* hangulsyllabletype=lvsyllable */,
  {     0,  1402,  2349,  24,   3, PL_INPC__TOP }   /* indicpositionalcategory=top */,
  {     1,  2859,  5488,  18,   4, PL_DT__NONE }   /* decompositiontype=none */,
  {     0,   184,    47,   2,   1, PL_M }   /* ism */,
  {     0,  6890,  2949,   4,  18, PL_INPUNCTUATION }   /* blk=generalpunctuation */,
  {     0,  6890,   954,   4,   5, PL_INGREEK }   /* blk=greek */,
  {     0,   974,  2777,  24,  10, PL_CCC__AR }   /* canonicalcombiningclass=aboveright */,
  {    17,  7288,  6439,   7,   4, PL_SC__SYLO }   /* script=sylo */,
  {     0,  4542,  1813,   3,  21, PL_TRANSPORTANDMAP }   /* istransportandmapsymbols */,
  {    36,  7380,  8643,   4,   2, PL_CCC__22 }   /* ccc=22 */,
  {    65,  8016,  8935,   4,   2, PL_GCB__XX }   /* gcb=xx */,
  {   323,  6890,  2787,   4,   8, PL_INCHEROKEE }   /* blk=cherokee */,
  {     0,  5544,  7756,  13,   5, PL_NV__90000 }   /* numericvalue=90000 */,
  {    24,  6706,  8708,  10,   3, PL_IN__3 }   /* presentin=3.0 */,
  {     0,  5134,  7503,   3,   3, PL_PHLI }   /* isphli */,
  {     0,  3271,     0,  17,   0, PL_UCAS }   /* canadiansyllabics */,
  {   128,  4554,  1074,  14,   2, PL_SB__ST }   /* sentencebreak=st */,
  {     1,  8240,  8792,   3,   3, PL_BC__FSI }   /* bc=fsi */,
  {   206,  4198,  1545,   4,  13, PL_GEOMETRICSHAPES }   /* ingeometricshapes */,
  {     0,  5645,  8792,  10,   3, PL_BC__FSI }   /* bidiclass=fsi */,
  {   384,  7288,  7870,   7,   6, PL_LEPC }   /* script=lepcha */,
  {    35,  1448,  2743,   5,   7, PL_SUPARROWSC }   /* insuparrowsc */,
  {     0,  8096,  8452,   4,   4, PL_ORYA }   /* scx=orya */,
  {     0,  1426,  2209,  22,  20, PL_INSC__CONSONANTWITHSTACKER }   /* indicsyllabiccategory=consonantwithstacker */,
  {     0,  8096,  2107,   4,   7, PL_SINH }   /* scx=sinhala */,
  {   109,  7136,    42,   6,   9, PL_CJKCOMPAT }   /* block=cjkcompat */,
  {     2,  6890,  6406,   4,  11, PL_INSORASOMPENG }   /* blk=sorasompeng */,
  {     1,  8816,  5219,   3,   9, PL_NV__100000000 }   /* nv=100000000 */,
  {     0,   720,     0,  16,   0, PL_ENCLOSEDALPHANUM }   /* enclosedalphanum */,
  {     1,    11,     0,   2,   0, PL_DI }   /* di */,
  {     1,    58,  7997,   4,   4, PL_IDEO }   /* ideo=yes */,
  {    16,  7459,   690,   3,   9, PL_XSUX }   /* sc=cuneiform */,
  {     1,  1701,  7997,   2,   4, PL_SD }   /* sd=yes */,
  {     0,  7288,  8260,   7,   4, PL_SC__CAKM }   /* script=cakm */,
  {     7,   184,  3754,   2,   7, PL_LINB }   /* islinearb */,
  {     0,   184,  2895,   2,   4, PL_ETHI }   /* isethi */,
  {     0,  2859,  8576,  18,   4, PL_EA__F }   /* decompositiontype=wide */,
  {     1,  6890,  5232,   4,  13, PL_AEGEANNUMBERS }   /* blk=aegeannumbers */,
  {     0,  7380,  3743,   4,   1, PL_CCC__1 }   /* ccc=1 */,
  {     0,  1417,   966,   9,   2, PL_NO }   /* category=no */,
  {     4,  7136,  6953,   6,   9, PL_LATINEXTD }   /* block=latinextd */,
  {   243,  1184,  3223,  25,   3, -PL_DI }   /* defaultignorablecodepoint=no */,
  {     0,  7478,     0,   3,   0, PL_S }   /* iss */,
  {     0,   184,  2636,   2,  19, PL_MONGOLIANSUP }   /* ismongoliansupplement */,
  {     0,  7527,     0,   7,   0, PL_MULT }   /* multani */,
  {     4,    21,  7876,   2,   6, PL_INLYCIAN }   /* inlycian */,
  {     3,  8096,  8111,   4,   4, PL_TAKR }   /* scx=takr */,
  {     0,  7344,  7951,   8,   5, PL_XIDS }   /* xidstart=true */,
  {     4,  7288,  7129,   8,   7, PL_BASS }   /* script=bassavah */,
  {     0,  2859,    68,  18,   3, PL_DT__SUP }   /* decompositiontype=sup */,
  {    74,  7696,  7997,   6,   4, PL_XPOSIXSPACE }   /* wspace=yes */,
  {     1,  8376,  6899,   3,   9, PL_LB__B2 }   /* lb=breakboth */,
  {     2,  2787,     0,   8,   0, PL_CHER }   /* cherokee */,
  {    85,  1746,  7160,  21,   8, PL_WB__EBG }   /* graphemeclusterbreak=ebasegaz */,
  {     1,  8096,  7145,   5,   7, PL_BUGI }   /* scx=buginese */,
  {   160,  7136,  5825,   6,  12, PL_MAHJONG }   /* block=mahjongtiles */,
  {     0,    18,  3581,   2,   2, PL_RI }   /* ri=t */,
  {     0,  1448,  2696,   5,  16, PL_SUPARROWSA }   /* insupplementalarrowsa */,
  {     0,  7136,  3738,   6,   9, PL_LATIN1 }   /* block=latin1sup */,
  {   105,  8816,  7738,   3,   5, PL_NV__60000 }   /* nv=60000 */,
  {    31,  8096,  7912,   4,   6, PL_TELU }   /* scx=telugu */,
  {    49,  3129,  2484,  17,   4, PL_EGYP }   /* scriptextensions=egyp */,
  {   100,  7478,  1794,   6,  18, PL_MODIFIERLETTERS }   /* isspacingmodifierletters */,
  {    18,   349,     0,  33,   0, PL_SUPMATHOPERATORS }   /* supplementalmathematicaloperators */,
  {    42,  8786,  4127,   3,   7, PL_EA__N }   /* ea=neutral */,
  {    71,  4063,  2879,   4,  16, PL_DEVANAGARIEXT }   /* indevanagariextended */,
  {     0,  8046,     0,   4,   0, PL_LIMB }   /* limb */,
  {     0,  7288,  7876,   7,   6, PL_LYCI }   /* script=lycian */,
  {     0,  4923,  3967,   4,  11, PL_MATHOPERATORS }   /* inmathoperators */,
  {     0,  8816,  7727,   3,   2, PL_NV__32 }   /* nv=32 */,
  {     0,  7618,     0,   7,   0, PL_SUPPUAA }   /* suppuaa */,
  {     3,    21,  1585,   2,   4, PL_JAMO }   /* injamo */,
  {    12,  8096,  8472,   4,   4, PL_PRTI }   /* scx=prti */,
  {     0,  7136,  1001,   6,  11, PL_ENCLOSEDCJK }   /* block=enclosedcjk */,
  {     1,  5375,     0,  12,   1, PL_JT__U }   /* joiningtype=u */,
  {     1,  5134,  7584,   3,   6, PL_PHAG }   /* isphagspa */,
  {   106,  2895,     0,  18,   0, PL_ETHIOPICSUP }   /* ethiopicsupplement */,
  {     0,  3441,     0,  17,   0, PL_LETTERLIKESYMBOLS }   /* letterlikesymbols */,
  {     0,  7380,  8645,   4,   3, PL_CCC__129 }   /* ccc=129 */,
  {     0,  7696,  7951,   6,   5, PL_XPOSIXSPACE }   /* wspace=true */,
  {     0,  8376,  3526,   3,  17, PL_RI }   /* lb=regionalindicator */,
  {   128,  3129,  8252,  17,   4, PL_BUHD }   /* scriptextensions=buhd */,
  {     2,  7136,  7296,   6,   8, PL_SPECIALS }   /* block=specials */,
  {     0,  8376,  5763,   3,   2, PL_LB__WJ }   /* lb=wj */,
  {     2,  7459,  6696,   3,  10, PL_PHNX }   /* sc=phoenician */,
  {     0,  6713,  8708,   3,   3, PL_IN__3 }   /* in=3.0 */,
  {     0,  4827,     0,  14,   0, PL_KANGXI }   /* kangxiradicals */,
  {    49,  8816,  8744,   3,   3, PL_NV__5_SLASH_8 }   /* nv=5/8 */,
  {     0,  7136,  6786,   6,  10, PL_SUPARROWSC }   /* block=suparrowsc */,
  {   129,  2859,  1224,  18,   3, PL_DT__SUB }   /* decompositiontype=sub */,
  {     0,  8096,  2249,   4,   4, PL_GLAG }   /* scx=glag */,
  {     0,  1746,  7165,  21,   3, PL_WB__GAZ }   /* graphemeclusterbreak=gaz */,
  {     0,  2023,  3223,  21,   3, -PL_LOE }   /* logicalorderexception=no */,
  {   102,  3129,  7569,  17,   7, PL_OSMA }   /* scriptextensions=osmanya */,
  {    12,  1012,     0,   6,   0, PL_L }   /* letter */,
  {     0,  7478,    47,   3,   1, PL_SM }   /* issm */,
  {    15,  6890,   802,   4,   6, PL_ARROWS }   /* blk=arrows */,
  {   219,  2895,     0,  11,   0, PL_ETHIOPICSUP }   /* ethiopicsup */,
  {     0,  8096,  7786,   4,   6, PL_CAKM }   /* scx=chakma */,
  {     3,  6890,  2465,   4,  11, PL_COUNTINGROD }   /* blk=countingrod */,
  {     1,  8036,     3,   5,  31, PL_UCAS }   /* isunifiedcanadianaboriginalsyllabics */,
  {     0,  7689,  7360,   3,   6, PL_AVST }   /* isavestan */,
  {     1,   974,  7941,  24,   2, PL_CCC__11 }   /* canonicalcombiningclass=11 */,
  {     0,  8572,  7160,   3,   8, PL_WB__EBG }   /* wb=ebasegaz */,
  {     1,  7136,  6989,   6,   9, PL_INNEWTAILUE }   /* block=newtailue */,
  {    33,  8504,    24,   4,   1, PL_SB__CL }   /* sb=cl */,
  {     1,  6890,  7527,   4,   7, PL_INMULTANI }   /* blk=multani */,
  {     1,  6263,  6175,  10,  11, PL_LB__EX }   /* linebreak=exclamation */,
  {     0,  8096,   494,   4,   3, PL_HAN }   /* scx=han */,
  {     0,  6713,  8738,   3,   3, PL_IN__5_DOT_2 }   /* in=5.2 */,
  {   217,  6616,  7768,  10,   2, -PL_DEP }   /* deprecated=f */,
  {     1,  6890,  8061,   4,   5, PL_INOGHAM }   /* blk=ogham */,
  {    44,   184,   511,   3,  29, PL_CJKEXTA }   /* iscjkunifiedideographsextensiona */,
  {     7,  7380,  8684,   4,   3, PL_CCC__L }   /* ccc=224 */,
  {   257,  7436,     0,   4,   0, PL_ELBA }   /* elba */,
  {    28,  7459,  8568,   3,   3, PL_VAI }   /* sc=vai */,
  {     0,  5645,  5413,  10,   3, PL_BC__RLO }   /* bidiclass=rlo */,
  {     0,  7288,  8428,   7,   4, PL_NEWA }   /* script=newa */,
  {     0,  2221,  3145,   3,   2, PL_GCB__V }   /* hst=v */,
  {   432,  6890,  1812,   4,  15, PL_TRANSPORTANDMAP }   /* blk=transportandmap */,
  {     0,  7288,  8208,   7,   4, PL_AHOM }   /* script=ahom */,
  {     0,  3129,  8066,  17,   5, PL_ORYA }   /* scriptextensions=oriya */,
  {     0,   184,  6935,   2,   9, PL_LATINEXTB }   /* islatinextb */,
  {     2,  6890,  1585,   4,   4, PL_JAMO }   /* blk=jamo */,
  {     0,  8096,  4644,   4,  15, PL_ZANB }   /* scx=zanabazarsquare */,
  {     1,  5192,  7346,   3,   6, PL_IDS }   /* isidstart */,
  {     1,  3373,     9,  15,   2, PL_EA__NA }   /* eastasianwidth=na */,
  {     6,  7380,  8654,   4,   3, PL_CCC__133 }   /* ccc=133 */,
  {     0,  7459,  1797,   3,   4, PL_SC__MODI }   /* sc=modi */,
  {   133,  3129,  7681,  17,   7, PL_ZZZZ }   /* scriptextensions=unknown */,
  {     9,   184,  4134,   2,   4, PL_BRAI }   /* isbrai */,
  {   264,  6890,  1282,   4,  10, PL_CJKSYMBOLS }   /* blk=cjksymbols */,
  {    33,  1426,  4058,  22,   5, PL_INSC__VOWEL }   /* indicsyllabiccategory=vowel */,
  {    21,   184,  5253,   2,   5, PL_XPOSIXDIGIT }   /* isdigit */,
  {    18,   184,  6646,   2,  10, PL_MISCARROWS }   /* ismiscarrows */,
  {    58,  7136,  5260,   8,  11, PL_BLOCKELEMENTS }   /* block=blockelements */,
  {     8,  2750,  3581,   4,   2, PL_TERM }   /* term=t */,
  {     7,  7136,  7520,   6,   7, PL_INMARCHEN }   /* block=marchen */,
  {     1,  7136,  1702,   6,  22, PL_DIACRITICALSFORSYMBOLS }   /* block=diacriticalsforsymbols */,
  {     0,  6890,  7520,   4,   7, PL_INMARCHEN }   /* blk=marchen */,
  {     0,  6616,  3581,  10,   2, PL_DEP }   /* deprecated=t */,
  {     0,  7828,     0,   6,   0, PL_HYPHEN }   /* hyphen */,
  {     0,  8822,  7997,   3,   2, PL_PCM }   /* pcm=y */,
  {     1,  6554,  7129,   3,   7, PL_INBASSAVAH }   /* inbassavah */,
  {    33,  3129,  6917,  17,   9, PL_QAAI }   /* scriptextensions=inherited */,
  {     0,  8504,   723,   4,   4, PL_SB__CL }   /* sb=close */,
  {   258,  1417,   698,   9,   2, PL_MN }   /* category=mn */,
  {     4,  6109,  8002,  10,   4, PL_XPOSIXCNTRL }   /* category=cntrl */,
  {     1,  6890,   892,   4,  28, PL_VSSUP }   /* blk=variationselectorssupplement */,
  {     1,  7457,  2823,   5,  18, PL_INSC__CONSONANTSUBJOINED }   /* insc=consonantsubjoined */,
  {     0,  8816,  8180,   3,   4, PL_NV__3_SLASH_80 }   /* nv=3/80 */,
  {    50,  6626,     0,   4,   0, PL_KHAR }   /* khar */,
  {     0,  3129,  7506,  17,   7, PL_LINA }   /* scriptextensions=lineara */,
  {     0,  2985,  3581,   3,   2, PL_IDS }   /* ids=t */,
  {     0,  7380,  8693,   4,   3, PL_CCC__A }   /* ccc=230 */,
  {     7,  8816,  7702,   3,   4, PL_NV__2000 }   /* nv=2000 */,
  {     2,  6472,     0,   4,   0, PL_XPOSIXWORD }   /* word */,
  {     0,   184,  8364,   2,   4, PL_LANA }   /* islana */,
  {     0,  7288,  7681,   7,   7, PL_ZZZZ }   /* script=unknown */,
  {     1,  7459,  8440,   3,   4, PL_OGAM }   /* sc=ogam */,
  {    11,  5645,  3223,   5,   2, -PL_BIDIC }   /* bidic=n */,
  {     1,  7471,    62,   7,   5, PL_POSIXGRAPH }   /* isposixgraph */,
  {     0,  6483,  7997,   4,   2, PL_XIDC }   /* xidc=y */,
  {     7,   184,   750,   2,  29, PL_ENCLOSEDIDEOGRAPHICSUP }   /* isenclosedideographicsupplement */,
  {     0,  2990,    29,   4,   4, PL_INARABIC }   /* inarabic */,
  {    56,  1448,   867,   5,  25, PL_SUPPUAB }   /* insupplementaryprivateuseareab */,
  {    10,   184,  1283,   3,  23, PL_CJKSYMBOLS }   /* iscjksymbolsandpunctuation */,
  {     2,  7288,  7527,   7,   7, PL_SC__MULT }   /* script=multani */,
  {     2,  6472,   138,  10,   2, PL_WB__FO }   /* wordbreak=fo */,
  {     7,  7288,  6926,   7,   9, PL_SC__SIND }   /* script=khudawadi */,
  {   128,  6263,    42,  10,   2, PL_LB__CJ }   /* linebreak=cj */,
  {    37,    11,  7997,   3,   2, PL_DIA }   /* dia=y */,
  {     2,  4314,  4953,  13,  14, PL_JG__MANICHAEANHETH }   /* joininggroup=manichaeanheth */,
  {     2,  8096,  7208,   4,   4, PL_HIRA }   /* scx=hira */,
  {     6,  3129,  7120,  17,   8, PL_BALI }   /* scriptextensions=balinese */,
  {     1,  7227,   468,   5,   5, PL_POSIXPUNCT }   /* posixpunct */,
  {     3,   184,  2877,   2,   4, PL_DEVA }   /* isdeva */,
  {    27,  7136,  1939,   6,  21, PL_CJKCOMPATFORMS }   /* block=cjkcompatibilityforms */,
  {     0,  8332,  7592,   4,   5, PL_INSHARADA }   /* insharada */,
  {     2,  6626,     0,  10,   0, PL_KHAR }   /* kharoshthi */,
  {     0,  8096,  6736,   4,   4, PL_SAUR }   /* scx=saur */,
  {     1,  7288,  8404,   7,   4, PL_SC__MLYM }   /* script=mlym */,
  {     0,  1897,  3581,  21,   2, PL_CWT }   /* changeswhentitlecased=t */,
  {     1,  5645,  3223,   5,   3, -PL_BIDIC }   /* bidic=no */,
  {     1,  8376,    23,   3,   2, PL_LB__AL }   /* lb=al */,
  {     0,  1918,  3223,  21,   2, -PL_CWU }   /* changeswhenuppercased=n */,
  {     1,  3129,  7366,  17,   4, PL_BENG }   /* scriptextensions=beng */,
  {    12,  2229,  3854,  16,  10, PL_SM }   /* generalcategory=mathsymbol */,
  {     0,    21,  3754,   2,  16, PL_LINEARBIDEOGRAMS }   /* inlinearbideograms */,
  {     8,  6221,  2843,   4,  16, PL_COPTICEPACTNUMBERS }   /* incopticepactnumbers */,
  {    38,  8026,  2355,   5,  14, PL_INPC__BOTTOMANDRIGHT }   /* inpc=bottomandright */,
  {     1,  7971,     0,   5,   0, PL_BATK }   /* batak */,
  {    89,  8816,  8740,   3,   2, PL_NV__25 }   /* nv=25 */,
  {     0,  7288,  2269,   7,  20, PL_PHLI }   /* script=inscriptionalpahlavi */,
  {     0,  6210,  1961,   3,  13, PL_CJKRADICALSSUP }   /* incjkradicalssup */,
  {     0,  7288,  8066,   7,   5, PL_SC__ORYA }   /* script=oriya */,
  {    72,  7136,  7822,   6,   6, PL_INHATRAN }   /* block=hatran */,
  {     2,  7288,  7248,   7,   8, PL_SC__JAVA }   /* script=javanese */,
  {    98,  7380,  8164,   7,   2, PL_CCC__15 }   /* ccc=ccc15 */,
  {     2,  6890,  3882,   4,   7, PL_INMYANMAR }   /* blk=myanmar */,
  {    27,  1426,  7924,  22,   6, PL_INSC__VIRAMA }   /* indicsyllabiccategory=virama */,
  {     6,   184,    62,   2,   5, PL_XPOSIXGRAPH }   /* isgraph */,
  {     0,  1960,     0,  14,   0, PL_CJKRADICALSSUP }   /* cjkradicalssup */,
  {   322,  4813,     0,  14,   0, PL_KANASUP }   /* kanasupplement */,
  {     4,  6263,  8935,  10,   2, PL_LB__XX }   /* linebreak=xx */,
  {     0,  6890,  7499,   4,   7, PL_KALI }   /* blk=kayahli */,
  {     1,  5051,  7996,   5,   3, PL_DT__NONE }   /* nfkdqc=y */,
  {     0,   974,  8654,  24,   3, PL_CCC__133 }   /* canonicalcombiningclass=133 */,
  {   594,  7478,  6737,   3,   3, PL_SAUR }   /* issaur */,
  {     0,  6713,  8723,   3,   3, PL_IN__4 }   /* in=4.0 */,
  {     1,  7380,  8642,   7,   3, PL_CCC__122 }   /* ccc=ccc122 */,
  {     2,  6826,     0,  10,   0, PL_YIRADICALS }   /* yiradicals */,
  {     4,  7459,  8568,   3,   4, PL_VAI }   /* sc=vaii */,
  {     0,  8106,     0,   5,   0, PL_TALE }   /* taile */,
  {     2,  7136,  7646,   6,   7, PL_INTAIVIET }   /* block=taiviet */,
  {   109,  1417,  1027,   9,   2, PL_SO }   /* category=so */,
  {     5,  2229,     7,  17,   1, PL_L_AMP_ }   /* generalcategory=lc */,
  {     1,  7136,  7555,   6,   7, PL_OLCK }   /* block=olchiki */,
  {     6,  4314,  5518,  13,  13, PL_JG__MANICHAEANWAW }   /* joininggroup=manichaeanwaw */,
  {     0,  3129,  5825,  17,   4, PL_MAHJ }   /* scriptextensions=mahj */,
  {   521,  4590,  7951,   2,   5, PL_VS }   /* vs=true */,
  {     3,   699,     0,   6,   0, PL_N }   /* number */,
  {     0,  8016,   852,   4,   1, PL_GCB__V }   /* gcb=v */,
  {     0,  3521,  3223,   5,   2, -PL_XPOSIXSPACE }   /* space=n */,
  {     3,  2985,  3223,  18,   2, -PL_IDST }   /* idstrinaryoperator=n */,
  {     1,  8786,  6845,   3,   9, PL_EA__A }   /* ea=ambiguous */,
  {     0,  3129,  1160,  17,   4, PL_HANG }   /* scriptextensions=hang */,
  {    77,  7459,  6919,   5,   7, PL_SC__QAAI }   /* sc=inherited */,
  {     0,  1897,  7768,  21,   2, -PL_CWT }   /* changeswhentitlecased=f */,
  {   124,  6613,  2542,   3,   9, PL_JAMO }   /* ishanguljamo */,
  {     2,  8798,  7997,   3,   4, PL_LOE }   /* loe=yes */,
  {     0,   974,  8636,  27,   3, PL_CCC__107 }   /* canonicalcombiningclass=ccc107 */,
  {   258,  3129,  8472,  17,   4, PL_PRTI }   /* scriptextensions=prti */,
  {   226,  8016,   295,   4,   2, PL_GCB__SM }   /* gcb=sm */,
  {    66,  4239,  7768,   4,   6, -PL_DASH }   /* dash=false */,
  {     1,  8816,  8624,   3,   3, PL_NV__1_SLASH_7 }   /* nv=1/7 */,
  {   128,  4314,  2427,  13,  19, PL_JG__BURUSHASKIYEHBARREE }   /* joininggroup=burushaskiyehbarree */,
  {    85,  1855,  7951,  21,   5, PL_CWCM }   /* changeswhencasemapped=true */,
  {     3,  1887,  3581,   9,   2, PL_XPOSIXLOWER }   /* lowercase=t */,
  {    30,  6706,  7710,  10,   1, PL_IN__6 }   /* presentin=6 */,
  {     0,  5645,  2329,  10,  20, PL_BC__RLE }   /* bidiclass=righttoleftembedding */,
  {     0,  5544,  8740,  13,   2, PL_NV__25 }   /* numericvalue=25 */,
  {     0,  8021,  7997,   5,   4, PL_GREXT }   /* grext=yes */,
  {     0,  8196,  8888,   4,   3, PL_AGE__8 }   /* age=v80 */,
  {     2,  8096,  7007,   4,   9, PL_ITAL }   /* scx=olditalic */,
  {     0,  8096,  8380,   4,   4, PL_LINA }   /* scx=lina */,
  {    20,  1184,  7997,  25,   2, PL_DI }   /* defaultignorablecodepoint=y */,
  {     2,  2990,  1260,   4,  22, PL_ARABICPFB }   /* inarabicpresentationformsb */,
  {     1,  7457,  2408,   5,  19, PL_INSC__BRAHMIJOININGNUMBER }   /* insc=brahmijoiningnumber */,
  {   256,   184,  2806,   3,  17, PL_HALFMARKS }   /* iscombininghalfmarks */,
  {   259,  6263,  3985,  10,   9, PL_LB__EM }   /* linebreak=emodifier */,
  {   408,   184,  3067,   2,   8, PL_DINGBATS }   /* isdingbats */,
  {    18,  7136,  5705,   6,  12, PL_CYRILLICEXTC }   /* block=cyrillicextc */,
  {   152,  6756,     0,  10,   0, PL_SD }   /* softdotted */,
  {     0,  2229,    74,  16,   2, PL_ME }   /* generalcategory=me */,
  {    16,  7288,  7016,   7,   9, PL_SC__PERM }   /* script=oldpermic */,
  {   384,  4554,  3914,  14,   5, PL_SB__XX }   /* sentencebreak=other */,
  {     2,  2859,  3003,  18,   4, PL_DT__INIT }   /* decompositiontype=init */,
  {     0,  6210,  7402,   3,   6, PL_CJKEXTC }   /* incjkextc */,
  {   283,  5583,  3223,  13,   2, -PL_QMARK }   /* quotationmark=n */,
  {     1,   974,  7714,  24,   2, PL_CCC__30 }   /* canonicalcombiningclass=30 */,
  {   152,  7459,  8308,   3,   4, PL_SC__GURU }   /* sc=guru */,
  {    58,    38,     0,   2,   0, PL_XPOSIXDIGIT }   /* nd */,
  {    92,  2229,   468,  16,  11, PL_P }   /* generalcategory=punctuation */,
  {    15,  7288,  7611,   7,   7, PL_SOYO }   /* script=soyombo */,
  {    78,  4590,  3223,   2,   2, -PL_VS }   /* vs=n */,
  {     0,  8096,  8232,   4,   4, PL_AVST }   /* scx=avst */,
  {   150,  3129,  6406,  17,   4, PL_SORA }   /* scriptextensions=sora */,
  {    30,   184,  4688,   3,  13, PL_CJKCOMPATFORMS }   /* iscjkcompatforms */,
  {     0,  8816,  8630,   3,   3, PL_NV__1_SLASH_9 }   /* nv=1/9 */,
  {     1,  6890,   750,   4,  29, PL_ENCLOSEDIDEOGRAPHICSUP }   /* blk=enclosedideographicsupplement */,
  {     2,  2229,  6362,  16,  11, PL_SO }   /* generalcategory=othersymbol */,
  {    32,  8364,     0,   4,   0, PL_LANA }   /* lana */,
  {     0,  2221,  3581,   3,  13, PL_GCB__T }   /* hst=trailingjamo */,
  {    49,  6472,    24,  11,   1, PL_WB__NL }   /* wordbreak=nl */,
  {    40,   513,  3581,  16,   2, PL_UIDEO }   /* unifiedideograph=t */,
  {     0,  6890,  3770,   4,  16, PL_LINEARBSYLLABARY }   /* blk=linearbsyllabary */,
  {     2,  2990,  3596,   4,   7, PL_ARABICSUP }   /* inarabicsup */,
  {     8,  3946,  3223,  16,   2, -PL_STERM }   /* sentenceterminal=n */,
  {     2,    21,  5801,   2,   5, PL_INKHMER }   /* inkhmer */,
  {     1,  2859,  2100,  18,   3, PL_DT__ISO }   /* decompositiontype=iso */,
  {     0,    18,  7997,   2,   4, PL_RI }   /* ri=yes */,
  {     2,  8376,   929,   3,   2, PL_LB__CP }   /* lb=cp */,
  {     0,  7459,  8324,   3,   4, PL_HMNG }   /* sc=hmng */,
  {     1,  6263,  5583,  10,   9, PL_LB__QU }   /* linebreak=quotation */,
  {    21,  7288,  7876,   7,   4, PL_LYCI }   /* script=lyci */,
  {     0,  4314,  7079,  13,   9, PL_JG__SYRIACWAW }   /* joininggroup=syriacwaw */,
  {     0,   513,  7768,  16,   2, -PL_UIDEO }   /* unifiedideograph=f */,
  {     0,  7394,     0,   7,   0, PL_CJKEXTB }   /* cjkextb */,
  {     0,  7471,  1887,   7,   5, PL_POSIXLOWER }   /* isposixlower */,
  {     2,  7611,     0,   7,   0, PL_SOYO }   /* soyombo */,
  {     0,   184,  2967,   2,  18, PL_GEORGIANSUP }   /* isgeorgiansupplement */,
  {     1,  8822,  7951,   3,   5, PL_PCM }   /* pcm=true */,
  {    65,  3390,     0,  16,   0, PL_ETHIOPICEXT }   /* ethiopicextended */,
  {     0,  8096,  4105,   5,   4, PL_BAMU }   /* scx=bamum */,
  {     0,   184,  6472,   2,   4, PL_XPOSIXWORD }   /* isword */,
  {     0,  7136,  8071,   6,   5, PL_INOSAGE }   /* block=osage */,
  {    16,  6890,  1981,   4,   8, PL_INCYRILLIC }   /* blk=cyrillic */,
  {    67,  2229,   849,  16,  10, PL_CO }   /* generalcategory=privateuse */,
  {    46,  6953,     0,   9,   0, PL_LATINEXTD }   /* latinextd */,
  {    35,    21,  6505,   2,  11, PL_YISYLLABLES }   /* inyisyllables */,
  {     0,  8340,  5909,   3,  12, PL_JG__MALAYALAMTTA }   /* jg=malayalamtta */,
  {     0,  3129,  7858,  17,   6, PL_KHOJ }   /* scriptextensions=khojki */,
  {    32,  6210,  2788,   3,  17, PL_CHEROKEESUP }   /* incherokeesupplement */,
  {     0,  1929,     0,   5,   0, PL_XPOSIXUPPER }   /* upper */,
  {     0,  6890,  7200,   4,   8, PL_INGURMUKHI }   /* blk=gurmukhi */,
  {     0,  8096,  7956,   4,   5, PL_ADLM }   /* scx=adlam */,
  {     0,  8340,  8592,   3,   4, PL_JG__ZAIN }   /* jg=zain */,
  {     0,  8544,     0,   4,   0, PL_TAVT }   /* tavt */,
  {    41,  4402,  6319,   3,  10, PL_MYANMAREXTB }   /* inmyanmarextb */,
  {     1,  3129,  8296,  17,   4, PL_GONM }   /* scriptextensions=gonm */,
  {     5,    21,  4869,   2,  14, PL_LATINEXTD }   /* inlatinextendedd */,
  {     0,  7136,   250,   6,  33, PL_DIACRITICALSEXT }   /* block=combiningdiacriticalmarksextended */,
  {     1,    78,     0,  10,   0, PL_ARABICMATH }   /* arabicmath */,
  {     1,  1206,  4011,   3,  15, PL_TANGUTCOMPONENTS }   /* intangutcomponents */,
  {     1,  4440,  2251,   4,   8, PL_INGLAGOLITIC }   /* inglagolitic */,
  {    11,   184,  3266,   3,   2, PL_CWL }   /* iscwl */,
  {     8,  7822,     0,   4,   0, PL_HATR }   /* hatr */,
  {     5,  8240,  2329,   3,  20, PL_BC__RLE }   /* bc=righttoleftembedding */,
  {   180,   184,  8939,   2,   2, PL_ZP }   /* iszp */,
  {     0,  4402,  2046,   4,   9, PL_INMEETEIMAYEK }   /* inmeeteimayek */,
  {     3,  2754,  5612,   5,   9, PL_ALPHABETICPF }   /* inalphabeticpf */,
  {     0,  6890,  7016,   4,   9, PL_INOLDPERMIC }   /* blk=oldpermic */,
  {     0,  8816,  8720,   3,   3, PL_NV__3_SLASH_5 }   /* nv=3/5 */,
  {    39,  7136,  2967,   6,  11, PL_GEORGIANSUP }   /* block=georgiansup */,
  {     1,  8816,  7756,   3,   5, PL_NV__90000 }   /* nv=90000 */,
  {    20,  8816,  5220,   3,   1, PL_NV__0 }   /* nv=0 */,
  {    34,  7136,   382,   6,  33, PL_SUPSYMBOLSANDPICTOGRAPHS }   /* block=supplementalsymbolsandpictographs */,
  {     0,  7459,  8408,   3,   3, PL_MRO }   /* sc=mro */,
  {    10,  6472,  6971,  10,   9, PL_WB__MB }   /* wordbreak=midnumlet */,
  {    65,  6472,  3526,  10,  17, PL_RI }   /* wordbreak=regionalindicator */,
  {   322,  8026,  2349,   5,  20, PL_INPC__TOPANDBOTTOMANDRIGHT }   /* inpc=topandbottomandright */,
  {     7,  7296,     0,   8,   0, PL_SPECIALS }   /* specials */,
  {     1,  7136,  4494,   6,  15, PL_NARB }   /* block=oldnortharabian */,
  {    22,  8011,  5310,   3,  13, PL_XPOSIXDIGIT }   /* gc=decimalnumber */,
  {     1,  8096,  7900,   4,   6, PL_RJNG }   /* scx=rejang */,
  {   642,   184,  7436,   2,   7, PL_ELBA }   /* iselbasan */,
  {     0,  7288,  7810,   7,   6, PL_GOTH }   /* script=gothic */,
  {     0,  4314,  2437,  13,   9, PL_JG__YEHBARREE }   /* joininggroup=yehbarree */,
  {     0,  6210,  3291,   5,  14, PL_INCAUCASIANALBANIAN }   /* incaucasianalbanian */,
  {     1,  1448,  2676,   4,  17, PL_SUNDANESESUP }   /* insundanesesupplement */,
  {     0,   184,  5583,   2,  13, PL_QMARK }   /* isquotationmark */,
  {    17,  7459,  7646,   3,   7, PL_TAVT }   /* sc=taiviet */,
  {     0,  7136,   808,   6,  11, PL_PHONETICEXT }   /* block=phoneticext */,
  {     5,   184,  7991,   2,   5, PL_BUHD }   /* isbuhid */,
  {     0,  6890,  5933,   4,  12, PL_INMASARAMGONDI }   /* blk=masaramgondi */,
  {     4,  6890,   959,   4,   5, PL_MUSIC }   /* blk=music */,
  {     0,  6076,  3223,  11,   3, -PL_BIDIC }   /* bidicontrol=no */,
  {     0,  8011,    17,   4,   1, PL_SO }   /* gc=so */,
  {     0,  2169,     0,  20,   0, PL_PC }   /* connectorpunctuation */,
  {     0,  3129,  7918,  17,   4, PL_THAA }   /* scriptextensions=thaa */,
  {     1,  7380,  8672,   4,   3, PL_CCC__214 }   /* ccc=214 */,
  {   149,  6890,  8116,   4,   5, PL_INTAMIL }   /* blk=tamil */,
  {    18,  4314,  6494,  13,  11, PL_JG__YEHWITHTAIL }   /* joininggroup=yehwithtail */,
  {     3,  5544,  8673,  13,   2, PL_NV__14 }   /* numericvalue=14 */,
  {     2,  6890,  7534,   4,   7, PL_NB }   /* blk=noblock */,
  {     0,   949,  7997,   2,   2, PL_CI }   /* ci=y */,
  {     0,  6647,   725,   4,   3, PL_CASED }   /* iscased */,
  {     0,  5544,  8917,  13,   2, PL_NV__49 }   /* numericvalue=49 */,
  {     2,   184,  1961,   3,  20, PL_CJKRADICALSSUP }   /* iscjkradicalssupplement */,
  {     0,  6890,  4104,   4,  15, PL_BAMUMSUP }   /* blk=bamumsupplement */,
  {     0,  7380,  7708,   7,   2, PL_CCC__21 }   /* ccc=ccc21 */,
  {    21,   892,  7997,  17,   2, PL_VS }   /* variationselector=y */,
  {    97,  8816,  5219,   3,   7, PL_NV__1000000 }   /* nv=1000000 */,
  {   138,   184,   149,   3,  34, PL_DIACRITICALSSUP }   /* iscombiningdiacriticalmarkssupplement */,
  {   207,  6890,  7858,   4,   6, PL_INKHOJKI }   /* blk=khojki */,
  {     0,   184,   571,   3,  29, PL_CJKEXTC }   /* iscjkunifiedideographsextensionc */,
  {     5,  1417,  8941,   9,   2, PL_ZS }   /* category=zs */,
  {     1,  7344,  7997,   4,   2, PL_XIDS }   /* xids=y */,
  {     1,  6890,  2044,   4,  21, PL_MEETEIMAYEKEXT }   /* blk=meeteimayekextensions */,
  {     1,  6613,  1567,   3,  22, PL_COMPATJAMO }   /* ishangulcompatibilityjamo */,
  {    14,  7380,  8632,   7,   2, PL_CCC__91 }   /* ccc=ccc91 */,
  {   194,   974,   727,  24,   2, PL_CCC__DA }   /* canonicalcombiningclass=da */,
  {    19,  7136,  3288,   6,  17, PL_INCAUCASIANALBANIAN }   /* block=caucasianalbanian */,
  {    20,  7894,  3223,   6,   3, -PL_PATSYN }   /* patsyn=no */,
  {     5,  6890,  7674,   4,   7, PL_UCASEXT }   /* blk=ucasext */,
  {     2,   184,  6926,   2,   9, PL_SIND }   /* iskhudawadi */,
  {     8,   184,  2249,   2,  20, PL_GLAGOLITICSUP }   /* isglagoliticsupplement */,
  {    19,  8096,  7513,   4,   7, PL_MAND }   /* scx=mandaic */,
  {     0,  8121,  3223,   5,   3, -PL_UIDEO }   /* uideo=no */,
  {     5,   974,  8648,  27,   3, PL_CCC__130 }   /* canonicalcombiningclass=ccc130 */,
  {   147,   974,  2769,  24,  13, PL_CCC__214 }   /* canonicalcombiningclass=attachedabove */,
  {     8,  4542,  8112,   3,   3, PL_TAKR }   /* istakr */,
  {     1,  7136,   720,   6,  30, PL_ENCLOSEDALPHANUMSUP }   /* block=enclosedalphanumericsupplement */,
  {     0,  7136,  2484,   6,  19, PL_INEGYPTIANHIEROGLYPHS }   /* block=egyptianhieroglyphs */,
  {   577,  1133,  7997,  26,   2, PL_PCM }   /* prependedconcatenationmark=y */,
  {    44,  3129,  1797,  17,   4, PL_MODI }   /* scriptextensions=modi */,
  {     1,  7288,  8424,   7,   4, PL_NBAT }   /* script=nbat */,
  {     0,  1426,  2823,  22,  18, PL_INSC__CONSONANTSUBJOINED }   /* indicsyllabiccategory=consonantsubjoined */,
  {     0,  5583,  7768,  13,   6, -PL_QMARK }   /* quotationmark=false */,
  {     0,  3521,     0,   5,   0, PL_XPOSIXSPACE }   /* space */,
  {     5,  3129,  7043,  17,   9, PL_PAUC }   /* scriptextensions=paucinhau */,
  {     0,  7459,  2895,   3,   8, PL_ETHI }   /* sc=ethiopic */,
  {     1,  7288,  8216,   7,   4, PL_ARMI }   /* script=armi */,
  {   385,  8096,  4494,   4,  15, PL_NARB }   /* scx=oldnortharabian */,
  {     0,    21,  5414,   2,  13, PL_LOWSURROGATES }   /* inlowsurrogates */,
  {     1,  5134,  6697,   3,   9, PL_PHNX }   /* isphoenician */,
  {     1,   184,  3516,   2,  10, PL_XPOSIXSPACE }   /* iswhitespace */,
  {    18,  8376,  1496,   3,   2, PL_LB__CB }   /* lb=cb */,
  {     0,  6890,  7492,   4,   7, PL_INKANNADA }   /* blk=kannada */,
  {    28,  6713,  7710,   3,   1, PL_IN__6 }   /* in=6 */,
  {    51,  6483,  7997,  11,   2, PL_XIDC }   /* xidcontinue=y */,
  {     0,  5945,     0,  12,   0, PL_MATHALPHANUM }   /* mathalphanum */,
  {    28,  7136,  1234,   6,  24, PL_ARABICPFA }   /* block=arabicpresentationformsa */,
  {     0,   184,  7120,   2,   4, PL_BALI }   /* isbali */,
  {     1,  8196,  8858,   4,   3, PL_AGE__4 }   /* age=v40 */,
  {     0,  5801,     0,   5,   0, PL_KHMR }   /* khmer */,
  {     0,  6890,  8532,   4,   4, PL_TAGS }   /* blk=tags */,
  {     0,  8340,  5476,   3,   3, PL_JG__NUN }   /* jg=nun */,
  {     0,   974,  5981,  24,  12, PL_CCC__0 }   /* canonicalcombiningclass=notreordered */,
  {   282,   117,  5363,   3,  12, PL_IPAEXT }   /* inipaextensions */,
  {   107,   184,  5825,   2,   7, PL_MAHJONG }   /* ismahjong */,
  {    79,   184,  8408,   2,   3, PL_MRO }   /* ismro */,
  {     0,   184,  5401,   2,  13, PL_ZL }   /* islineseparator */,
  {     0,  5375,    36,  12,   1, PL_JT__T }   /* joiningtype=t */,
  {     2,  6890,   690,   4,   9, PL_INCUNEIFORM }   /* blk=cuneiform */,
  {     4,   184,  5694,   3,  11, PL_CYRILLICEXTB }   /* iscyrillicextb */,
  {   196,   184,    11,   2,   3, PL_DIA }   /* isdia */,
  {     0,  5134,   469,   3,  10, PL_P }   /* ispunctuation */,
  {   309,  3129,  7520,  17,   7, PL_MARC }   /* scriptextensions=marchen */,
  {   712,  7136,   660,   6,  30, PL_CJKEXTF }   /* block=cjkunifiedideographsextensionf */,
  {     0,  6890,  6439,   4,  11, PL_INSYLOTINAGRI }   /* blk=sylotinagri */,
  {     0,  8011,  6796,   3,  10, PL_CN }   /* gc=unassigned */,
  {   146,  8096,  2598,   4,   4, PL_MERO }   /* scx=mero */,
  {     1,   184,  3458,   2,  10, PL_MANI }   /* ismanichaean */,
  {    66,  7288,  8464,   7,   4, PL_PHNX }   /* script=phnx */,
  {     0,  6329,  7946,  11,   5, PL_NV__NAN }   /* numerictype=none */,
  {     0,  7136,  7240,   6,   8, PL_JAMOEXTB }   /* block=jamoextb */,
  {     0,  3129,  2967,  17,   8, PL_GEOR }   /* scriptextensions=georgian */,
  {     0,  8031,  4647,   5,  12, PL_INZANABAZARSQUARE }   /* inzanabazarsquare */,
  {     0,   974,  8688,  27,   2, PL_CCC__26 }   /* canonicalcombiningclass=ccc26 */,
  {    11,  8091,     0,   5,   0, PL_RUNR }   /* runic */,
  {     2,  6890,  2636,   4,   9, PL_INMONGOLIAN }   /* blk=mongolian */,
  {   171,  4542,    47,   5,   1, PL_TERM }   /* isterm */,
  {     1,  7136,  5362,   6,   6, PL_IPAEXT }   /* block=ipaext */,
  {     3,  8492,     0,   4,   0, PL_RUNR }   /* runr */,
  {    33,  8011,  6098,   3,  11, PL_L_AMP_ }   /* gc=casedletter */,
  {     0,  8111,     0,   5,   0, PL_TAKR }   /* takri */,
  {     0,  1892,  7997,   5,   2, PL_CASED }   /* cased=y */,
  {     0,  7136,  6926,   6,   9, PL_INKHUDAWADI }   /* block=khudawadi */,
  {     0,  7478,  2108,   3,   6, PL_SINH }   /* issinhala */,
  {     2,   184,  3854,   2,  10, PL_SM }   /* ismathsymbol */,
  {     0,  8196,  8876,   4,   3, PL_AGE__6_DOT_1 }   /* age=v61 */,
  {     0,  1133,  3223,  26,   3, -PL_PCM }   /* prependedconcatenationmark=no */,
  {     9,  6613,  5869,   3,   3, PL_HMNG }   /* ishmng */,
  {     1,  8011,  5253,   3,   5, PL_XPOSIXDIGIT }   /* gc=digit */,
  {     4,  1503,  7437,   3,   6, PL_INELBASAN }   /* inelbasan */,
  {     6,   184,  7900,   2,   6, PL_RJNG }   /* isrejang */,
  {     0,  7459,  2967,   3,   4, PL_SC__GEOR }   /* sc=geor */,
  {     1,  8096,  8520,   4,   4, PL_SHAW }   /* scx=shaw */,
  {     0,   184,  7168,   2,   8, PL_EXT }   /* isextender */,
  {   293,  4542,  7313,   3,   3, PL_TAGB }   /* istagb */,
  {     0,  7136,   183,   6,  20, PL_MISCSYMBOLS }   /* block=miscellaneoussymbols */,
  {     0,  2693,     0,  19,   0, PL_SUPARROWSA }   /* supplementalarrowsa */,
  {   132,  6890,    42,   4,  26, PL_CJKCOMPATIDEOGRAPHS }   /* blk=cjkcompatibilityideographs */,
  {    65,  6210,   661,   3,  29, PL_CJKEXTF }   /* incjkunifiedideographsextensionf */,
  {    11,  1358,  7768,  20,   6, -PL_CE }   /* compositionexclusion=false */,
  {     2,  5250,  7768,   8,   2, -PL_XPOSIXXDIGIT }   /* hexdigit=f */,
  {   267,  8196,  8759,   4,   3, PL_AGE__7 }   /* age=7.0 */,
  {     0,  4402,   184,   3,  33, PL_MISCPICTOGRAPHS }   /* inmiscellaneoussymbolsandpictographs */,
  {    17,  6706,  8711,  10,   3, PL_IN__3_DOT_1 }   /* presentin=3.1 */,
  {     4,  8096,  7858,   4,   6, PL_KHOJ }   /* scx=khojki */,
  {   268,  4542,  4570,   3,  14, PL_LT }   /* istitlecaseletter */,
  {     3,  5968,  4510,   3,  14, PL_SARB }   /* inoldsoutharabian */,
  {     3,  5250,  3581,   8,   2, PL_XPOSIXXDIGIT }   /* hexdigit=t */,
  {     0,    58,  3223,   4,   3, -PL_IDEO }   /* ideo=no */,
  {    25,  8096,  6926,   4,   9, PL_SIND }   /* scx=khudawadi */,
  {     0,  7288,    78,   7,   6, PL_SC__ARAB }   /* script=arabic */,
  {     0,  1417,     1,   9,   1, PL_N }   /* category=n */,
  {     1,  7900,     0,   6,   0, PL_RJNG }   /* rejang */,
  {     2,  8340,     5,   3,   1, PL_JG__E }   /* jg=e */,
  {     4,  3129,  7248,  17,   8, PL_JAVA }   /* scriptextensions=javanese */,
  {    32,   184,     1,   2,   1, PL_N }   /* isn */,
  {    17,  8340,  4939,   3,  14, PL_JG__MANICHAEANFIVE }   /* jg=manichaeanfive */,
  {    24,  7136,  5596,   6,  13, PL_VERTICALFORMS }   /* block=verticalforms */,
  {     0,  7380,  3262,   4,   5, PL_CCC__B }   /* ccc=below */,
  {    48,  4569,     0,  15,   0, PL_LT }   /* titlecaseletter */,
  {     0,  7478,  2694,   3,  18, PL_SUPARROWSA }   /* issupplementalarrowsa */,
  {     0,  1834,  3223,  21,   3, -PL_CWCF }   /* changeswhencasefolded=no */,
  {     0,  6221,  1682,   4,  20, PL_INDICNUMBERFORMS }   /* incommonindicnumberforms */,
  {     0,  7288,  6696,   7,  10, PL_PHNX }   /* script=phoenician */,
  {    24,    11,  7951,   2,   5, PL_DI }   /* di=true */,
  {     0,   184,  4329,   2,  15, PL_LL }   /* islowercaseletter */,
  {     0,  8096,  8568,   4,   4, PL_VAI }   /* scx=vaii */,
  {     1,  1448,  2724,   5,   7, PL_SUPARROWSB }   /* insuparrowsb */,
  {     0,  7345,  3223,   7,   3, -PL_IDS }   /* idstart=no */,
  {     0,  6483,  7768,   4,   6, -PL_XIDC }   /* xidc=false */,
  {    29,  3129,  8208,  17,   4, PL_AHOM }   /* scriptextensions=ahom */,
  {   261,  2023,  3223,  21,   2, -PL_LOE }   /* logicalorderexception=n */,
  {     0,  1354,  3223,  24,   3, -PL_COMPEX }   /* fullcompositionexclusion=no */,
  {     0,  3516,  7951,  10,   5, PL_XPOSIXSPACE }   /* whitespace=true */,
  {     8,  6890,  2814,   4,   9, PL_HALFMARKS }   /* blk=halfmarks */,
  {     2,  5825,     0,  12,   0, PL_MAHJONG }   /* mahjongtiles */,
  {     1,  8822,  7768,   3,   6, -PL_PCM }   /* pcm=false */,
  {     3,  7459,  7043,   3,   9, PL_PAUC }   /* sc=paucinhau */,
  {   136,  1358,  7997,  20,   2, PL_CE }   /* compositionexclusion=y */,
  {   160,  1834,  7997,  21,   4, PL_CWCF }   /* changeswhencasefolded=yes */,
  {    92,  8096,  7520,   4,   7, PL_MARC }   /* scx=marchen */,
  {     7,  5544,  7942,  13,   4, PL_NV__1_SLASH_12 }   /* numericvalue=1/12 */,
  {     1,  4314,    87,  13,   2, PL_JG__HE }   /* joininggroup=he */,
  {     0,  8340,  5873,   3,  12, PL_JG__MALAYALAMNNA }   /* jg=malayalamnna */,
  {     3,   184,  1898,   3,  20, PL_CWT }   /* ischangeswhentitlecased */,
  {    32,  7380,  8171,   4,   2, PL_CCC__23 }   /* ccc=23 */,
  {   304,  2859,  7216,  18,   8, PL_DT__ISO }   /* decompositiontype=isolated */,
  {    32,  7288,  3583,   8,   3, PL_BRAI }   /* script=brai */,
  {     0,  8340,  4977,   3,   4, PL_JG__KAPH }   /* jg=kaph */,
  {     1,    21,  8056,   2,   5, PL_INNUSHU }   /* innushu */,
  {     8,  8340,  4384,   3,   5, PL_JG__SADHE }   /* jg=sadhe */,
  {     7,  4239,  3223,   4,   3, -PL_DASH }   /* dash=no */,
  {     4,  3129,  8436,  17,   4, PL_NSHU }   /* scriptextensions=nshu */,
  {     0,  1746,  1627,  21,   7, PL_GCB__CN }   /* graphemeclusterbreak=control */,
  {     0,  1503,  1002,   3,  10, PL_ENCLOSEDCJK }   /* inenclosedcjk */,
  {    85,  3129,  8356,  17,   4, PL_KNDA }   /* scriptextensions=knda */,
  {     1,  3129,  8528,  17,   4, PL_SYRC }   /* scriptextensions=syrc */,
  {   724,  6890,   448,   5,  31, PL_IDEOGRAPHICSYMBOLS }   /* blk=ideographicsymbolsandpunctuation */,
  {     1,  2674,     0,   4,   0, PL_SUND }   /* sund */,
  {    11,    84,  7997,   4,   2, PL_MATH }   /* math=y */,
  {   167,    84,  7768,   4,   6, -PL_MATH }   /* math=false */,
  {     1,  6221,  2467,   4,  17, PL_COUNTINGROD }   /* incountingrodnumerals */,
  {    16,  8204,  3223,   4,   2, -PL_POSIXXDIGIT }   /* ahex=n */,
  {     0,  3129,  2598,  17,  19, PL_MERO }   /* scriptextensions=meroitichieroglyphs */,
  {   686,  4314,  4939,  13,  14, PL_JG__MANICHAEANFIVE }   /* joininggroup=manichaeanfive */,
  {     0,   184,  2895,   2,  11, PL_ETHIOPICSUP }   /* isethiopicsup */,
  {    61,  8344,  6164,   3,  11, PL_JT__D }   /* jt=dualjoining */,
  {     0,  5362,     0,  13,   0, PL_IPAEXT }   /* ipaextensions */,
  {    10,  7288,  8552,   7,   4, PL_SC__TGLG }   /* script=tglg */,
  {    41,  4554,   112,  14,   2, PL_SB__SC }   /* sentencebreak=sc */,
  {   309,  7288,  1111,   7,   4, PL_SC__KANA }   /* script=kana */,
  {     0,  8011,  6351,   3,  11, PL_NO }   /* gc=othernumber */,
  {     8,  5051,  7996,   5,   5, PL_DT__NONE }   /* nfkdqc=yes */,
  {   418,   974,  8678,  24,   3, PL_CCC__B }   /* canonicalcombiningclass=220 */,
  {     0,  5245,  3223,  13,   2, -PL_POSIXXDIGIT }   /* asciihexdigit=n */,
  {   599,  7380,  8639,   7,   3, PL_CCC__118 }   /* ccc=ccc118 */,
  {     0,  8096,  7780,   4,   4, PL_CARI }   /* scx=cari */,
  {     0,  7604,     0,   7,   0, PL_SIDD }   /* siddham */,
  {     3,  2100,  3058,   3,  17, PL_ORNAMENTALDINGBATS }   /* isornamentaldingbats */,
  {     1,  8244,     0,   4,   0, PL_BHKS }   /* bhks */,
  {   194,   415,     0,  32,   0, PL_INIDC }   /* ideographicdescriptioncharacters */,
  {     0,  4314,  5871,  13,   5, PL_JG__GAMAL }   /* joininggroup=gamal */,
  {    14,  7288,  7569,   7,   7, PL_OSMA }   /* script=osmanya */,
  {     6,  4402,     0,  17,   0, PL_INMEROITICCURSIVE }   /* inmeroiticcursive */,
  {     4,  8816,  8655,   3,   2, PL_NV__33 }   /* nv=33 */,
  {     0,    58,  7768,   4,   6, -PL_IDEO }   /* ideo=false */,
  {     9,  6613,  1161,   3,   3, PL_HANG }   /* ishang */,
  {     1,  7288,  8500,   7,   4, PL_SARB }   /* script=sarb */,
  {     2,  3129,  7248,  17,   4, PL_JAVA }   /* scriptextensions=java */,
  {     2,  7136,  1378,   6,  24, PL_HIGHPUSURROGATES }   /* block=highprivateusesurrogates */,
  {     0,   184,  8356,   2,   4, PL_KNDA }   /* isknda */,
  {   869,  6076,     0,  11,   0, PL_BIDIC }   /* bidicontrol */,
  {     0,  1159,  3223,  25,   3, -PL_CWKCF }   /* changeswhennfkccasefolded=no */,
  {   282,  7136,  7415,   6,   7, PL_CJKEXTE }   /* block=cjkexte */,
  {   197,  1506,     0,  14,   0, PL_MUSIC }   /* musicalsymbols */,
  {     0,  7774,  1191,   6,   9, PL_CI }   /* _case_ignorable */,
  {     0,  7457,  4434,   5,  15, PL_INSC__MODIFYINGLETTER }   /* insc=modifyingletter */,
  {   661,  2108,  3709,   5,  13, PL_HALFANDFULLFORMS }   /* inhalfandfullforms */,
  {     0,  5544,  8156,  13,   4, PL_NV__11_SLASH_2 }   /* numericvalue=11/2 */,
  {     1,  3129,  7007,  17,   9, PL_ITAL }   /* scriptextensions=olditalic */,
  {     6,  7288,  4404,   7,  15, PL_MERC }   /* script=meroiticcursive */,
  {     0,  8240,  5633,   3,  12, PL_BC__AN }   /* bc=arabicnumber */,
  {     1,  7312,     0,   8,   0, PL_TAGB }   /* tagbanwa */,
  {    22,  3129,  6626,  17,  10, PL_KHAR }   /* scriptextensions=kharoshthi */,
  {    35,    11,  7768,   2,   6, -PL_DI }   /* di=false */,
  {     1,  7780,     0,   6,   0, PL_CARI }   /* carian */,
  {     0,  8822,  7768,   3,   2, -PL_PCM }   /* pcm=f */,
  {     0,  4590,  7997,   2,   4, PL_VS }   /* vs=yes */,
  {     5,  8340,  8828,   3,   3, PL_JG__REH }   /* jg=reh */,
  {     0,  3516,  7997,  10,   2, PL_XPOSIXSPACE }   /* whitespace=y */,
  {     4,  3129,  8464,  17,   4, PL_PHNX }   /* scriptextensions=phnx */,
  {   640,  4314,  7864,  13,   6, PL_JG__LAMADH }   /* joininggroup=lamadh */,
  {     5,  6221,  6598,   4,   8, PL_COMPATJAMO }   /* incompatjamo */,
  {     0,  7136,  3962,   6,  16, PL_SUPMATHOPERATORS }   /* block=supmathoperators */,
  {   454,  3129,  8216,  17,   4, PL_ARMI }   /* scriptextensions=armi */,
  {     0,  6890,  6586,   4,  10, PL_CJKSTROKES }   /* blk=cjkstrokes */,
  {     2,  6872,     0,   9,   0, PL_ARABICPFB }   /* arabicpfb */,
  {     3,  8780,  3223,   3,   2, -PL_CWT }   /* cwt=n */,
  {     1,  7136,  7852,   6,   6, PL_KANBUN }   /* block=kanbun */,
  {     4,  4614,     0,   8,   0, PL_VEDICEXT }   /* vedicext */,
  {    24,  1918,  7997,  21,   2, PL_CWU }   /* changeswhenuppercased=y */,
  {     1,  6890,  2044,   4,  11, PL_INMEETEIMAYEK }   /* blk=meeteimayek */,
  {   738,  5531,     0,  13,   0, PL_MISCTECHNICAL }   /* misctechnical */,
  {     1,  7136,  7870,   6,   6, PL_INLEPCHA }   /* block=lepcha */,
  {     3,  2859,  7541,  18,   7, PL_DT__NB }   /* decompositiontype=nobreak */,
  {     0,  7136,  1691,   6,  11, PL_NUMBERFORMS }   /* block=numberforms */,
  {    38,  8572,  8789,   3,   3, PL_WB__EBG }   /* wb=ebg */,
  {     0,  6647,  5286,   4,  11, PL_CI }   /* iscaseignorable */,
  {     0,  3526,  7997,  17,   4, PL_RI }   /* regionalindicator=yes */,
  {     2,  3129,  7569,  17,   4, PL_OSMA }   /* scriptextensions=osma */,
  {     1,  8096,  7918,   4,   6, PL_THAA }   /* scx=thaana */,
  {     0,  8096,  1797,   4,   4, PL_MODI }   /* scx=modi */,
  {     1,  7136,  1768,   6,  22, PL_MISCTECHNICAL }   /* block=miscellaneoustechnical */,
  {    12,  6890,  2712,   4,  19, PL_SUPARROWSB }   /* blk=supplementalarrowsb */,
  {    64,  8196,  8753,   4,   3, PL_AGE__6_DOT_2 }   /* age=6.2 */,
  {     8,  5968,  8062,   3,   4, PL_INOGHAM }   /* inogham */,
  {     3,  8504,    34,   3,   6, PL_SB__EX }   /* sb=extend */,
  {     0,  7380,  8648,   4,   3, PL_CCC__130 }   /* ccc=130 */,
  {   339,   218,  3521,   4,   5, PL_POSIXSPACE }   /* perlspace */,
  {   206,  8011,  1499,   3,   1, PL_Z }   /* gc=z */,
  {   256,  6890,  2636,   4,  19, PL_MONGOLIANSUP }   /* blk=mongoliansupplement */,
  {     5,   184,  8604,   2,   4, PL_ZYYY }   /* iszyyy */,
  {     3,  2107,     0,  21,   0, PL_SINHALAARCHAICNUMBERS }   /* sinhalaarchaicnumbers */,
  {   916,  7288,  7010,   7,   4, PL_ITAL }   /* script=ital */,
  {  1090,   184,  2408,   2,   4, PL_BRAH }   /* isbrah */,
  {     0,  1417,  4239,   9,  15, PL_PD }   /* category=dashpunctuation */,
  {   165,  7689,  8193,   3,   3, PL_ADLM }   /* isadlm */,
  {    12,  1929,  7951,   9,   5, PL_XPOSIXUPPER }   /* uppercase=true */,
  {     1,  3129,  1981,  17,   8, PL_CYRL }   /* scriptextensions=cyrillic */,
  {    38,  8240,  6328,   3,   2, PL_BC__BN }   /* bc=bn */,
  {    18,  7380,  8699,   4,   3, PL_CCC__DB }   /* ccc=233 */,
  {     1,  5134,   809,   3,  27, PL_PHONETICEXTSUP }   /* isphoneticextensionssupplement */,
  {     0,    42,     0,  26,   0, PL_CJKCOMPATIDEOGRAPHS }   /* cjkcompatibilityideographs */,
  {    10,  1897,  7951,  21,   5, PL_CWT }   /* changeswhentitlecased=true */,
  {    23,  7288,  6373,   7,  11, PL_HMNG }   /* script=pahawhhmong */,
  {     0,  3560,     0,  17,   0, PL_SUTTONSIGNWRITING }   /* suttonsignwriting */,
  {  1728,  2044,     0,  14,   0, PL_MEETEIMAYEKEXT }   /* meeteimayekext */,
  {     0,  6263,  3642,  10,  16, PL_LB__CP }   /* linebreak=closeparenthesis */,
  {    17,  6263,  8927,  10,   2, PL_GCB__L }   /* linebreak=jl */,
  {   266,  6263,  5762,  10,   3, PL_LB__ZWJ }   /* linebreak=zwj */,
  {    65,  8556,     0,   4,   0, PL_THAI }   /* thai */,
  {     0,  8816,  8156,   3,   4, PL_NV__11_SLASH_2 }   /* nv=11/2 */,
  {     3,  6890,  4827,   4,   6, PL_KANGXI }   /* blk=kangxi */,
  {     0,  1503,   721,   3,  15, PL_ENCLOSEDALPHANUM }   /* inenclosedalphanum */,
  {    40,  6263,  2440,  10,   2, PL_LB__BA }   /* linebreak=ba */,
  {     1,  2100,  8453,   3,   3, PL_ORYA }   /* isorya */,
  {     9,  7499,     0,   7,   0, PL_KALI }   /* kayahli */,
  {   276,    21,  7232,   2,   8, PL_JAMOEXTA }   /* injamoexta */,
  {     0,  4314,  4792,  13,   7, PL_JG__HEHGOAL }   /* joininggroup=hehgoal */,
  {     1,  6890,  1981,   4,  18, PL_CYRILLICSUP }   /* blk=cyrillicsupplement */,
  {   922,  4314,  6526,  13,  10, PL_JG__AFRICANQAF }   /* joininggroup=africanqaf */,
  {     6,  4554,  3084,  14,   3, PL_SB__SE }   /* sentencebreak=sep */,
  {     0,  6890,   568,   4,   2, PL_NB }   /* blk=nb */,
  {     0,  4554,   496,  14,   2, PL_LB__NU }   /* sentencebreak=nu */,
  {     0,  7689,    29,   4,   4, PL_ARAB }   /* isarabic */,
  {    10,  1426,  2408,  22,  19, PL_INSC__BRAHMIJOININGNUMBER }   /* indicsyllabiccategory=brahmijoiningnumber */,
  {     1,  6263,    83,  10,   2, PL_LB__CM }   /* linebreak=cm */,
  {   191,  7459,  3566,   3,  11, PL_SGNW }   /* sc=signwriting */,
  {     0,  2229,   599,  16,   2, PL_XPOSIXCNTRL }   /* generalcategory=cc */,
  {     0,  4402,  1507,   3,  13, PL_MUSIC }   /* inmusicalsymbols */,
  {  1837,  5135,     0,  14,   0, PL_ZS }   /* spaceseparator */,
  {    11,  2100,  3915,   3,  15, PL_PO }   /* isotherpunctuation */,
  {  2565,   184,  2044,   2,  11, PL_MTEI }   /* ismeeteimayek */,
  {     0,  8340,  6384,   3,  11, PL_JG__ROHINGYAYEH }   /* jg=rohingyayeh */,
  {     0,  7136,  4687,   6,  14, PL_CJKCOMPATFORMS }   /* block=cjkcompatforms */,
  {     0,  3129,  7632,  17,   7, PL_TGLG }   /* scriptextensions=tagalog */,
  {     0,  7344,  7768,   4,   2, -PL_XIDS }   /* xids=f */,
  {     0,  7288,  7520,   7,   4, PL_MARC }   /* script=marc */,
  {     0,  6890,  2841,   4,   6, PL_INCOPTIC }   /* blk=coptic */,
  {   525,  8096,   690,   4,   9, PL_XSUX }   /* scx=cuneiform */,
  {    23,  8816,  8685,   3,   2, PL_NV__24 }   /* nv=24 */,
  {     0,  2100,  8457,   3,   3, PL_OSGE }   /* isosge */,
  {     1,  4542,  4011,   3,   5, PL_TANG }   /* istangut */,
  {     1,  8340,  4925,   3,  14, PL_JG__MANICHAEANBETH }   /* jg=manichaeanbeth */,
  {     0,   184,  7858,   2,   4, PL_KHOJ }   /* iskhoj */,
  {     0,  6890,  4799,   4,  14, PL_HIGHSURROGATES }   /* blk=highsurrogates */,
  {     0,  1417,  3075,   9,  18, PL_ZP }   /* category=paragraphseparator */,
  {     0,  8340,  8810,   3,   3, PL_JG__MIM }   /* jg=mim */,
  {     0,  1679,     0,   2,   0, PL_PC }   /* pc */,
  {     0,  8786,   806,   3,   1, PL_EA__W }   /* ea=w */,
  {     7,  6926,     0,   9,   0, PL_SIND }   /* khudawadi */,
  {     0,  7344,  7997,   8,   4, PL_XIDS }   /* xidstart=yes */,
  {     0,  6713,  5219,   3,   2, PL_IN__10 }   /* in=10 */,
  {   625,  7459,  8516,   3,   4, PL_SGNW }   /* sc=sgnw */,
  {     2,  3129,  7611,  17,   7, PL_SOYO }   /* scriptextensions=soyombo */,
  {    30,  7136,  3237,   6,  17, PL_ALCHEMICAL }   /* block=alchemicalsymbols */,
  {  1077,  3129,  8111,  17,   5, PL_TAKR }   /* scriptextensions=takri */,
  {     0,  7380,  7709,   7,   2, PL_CCC__16 }   /* ccc=ccc16 */,
  {  1105,  8096,  8416,   4,   4, PL_MYMR }   /* scx=mymr */,
  {     1,  7136,  4659,   6,  14, PL_ANCIENTSYMBOLS }   /* block=ancientsymbols */,
  {     0,  5284,  7997,  13,   4, PL_CI }   /* caseignorable=yes */,
  {     1,  5192,  5363,   3,   5, PL_IPAEXT }   /* isipaext */,
  {     3,  6483,  7768,   4,   2, -PL_XIDC }   /* xidc=f */,
  {   644,   184,  5813,   2,  12, PL_NL }   /* isletternumber */,
  {     0,  5657,     0,   5,   0, PL_BIDIM }   /* bidim */,
  {     2,   974,  8651,  24,   3, PL_CCC__132 }   /* canonicalcombiningclass=132 */,
  {     0,  8340,  4384,   3,   3, PL_JG__SAD }   /* jg=sad */,
  {     0,   513,  7951,  16,   5, PL_UIDEO }   /* unifiedideograph=true */,
  {     1,  2859,  3543,  18,   5, PL_DT__SML }   /* decompositiontype=small */,
  {     4,   184,    84,   2,   4, PL_MATH }   /* ismath */,
  {     0,  5557,  7768,  13,   6, -PL_PATSYN }   /* patternsyntax=false */,
  {  2240,  3067,     0,   8,   0, PL_DINGBATS }   /* dingbats */,
  {    17,  7840,    67,   3,   4, PL_VSSUP }   /* isvssup */,
  {    69,  5051,  3223,  14,   3, PL_NFKDQC__N }   /* nfkdquickcheck=no */,
  {     9,  7485,  3521,   7,   5, PL_XPOSIXSPACE }   /* isxperlspace */,
  {     3,  7459,  2895,   3,   4, PL_ETHI }   /* sc=ethi */,
  {     3,  4542,   238,   3,   3, PL_TALE }   /* istale */,
  {     0,   570,     0,  30,   0, PL_CJKEXTC }   /* cjkunifiedideographsextensionc */,
  {     4,  6713,  8726,   3,   3, PL_IN__4_DOT_1 }   /* in=4.1 */,
  {   914,  7288,  2967,   7,   8, PL_SC__GEOR }   /* script=georgian */,
  {  2121,  6706,  8864,  10,   3, PL_IN__5 }   /* presentin=v50 */,
  {   666,  6908,     0,   9,   0, PL_EMOTICONS }   /* emoticons */,
  {   928,  7288,  8284,   7,   4, PL_DSRT }   /* script=dsrt */,
  {   394,  3129,  8588,  17,   4, PL_YI }   /* scriptextensions=yiii */,
  {    96,  7288,  8468,   7,   4, PL_MIAO }   /* script=plrd */,
  {     0,  2236,  3084,  13,   9, PL_ZL }   /* category=lineseparator */,
  {   403,  8011,  1012,   3,   6, PL_L }   /* gc=letter */,
  {     0,  7344,  3581,   4,   2, PL_XIDS }   /* xids=t */,
  {     2,  1392,     0,   9,   0, PL_CS }   /* surrogate */,
  {     4,   117,  5363,   3,   5, PL_IPAEXT }   /* inipaext */,
  {    29,  5645,  7997,   5,   2, PL_BIDIC }   /* bidic=y */,
  {     1,   513,  7997,  16,   4, PL_UIDEO }   /* unifiedideograph=yes */,
  {   145,   184,  1589,   2,  23, PL_LATINEXTADDITIONAL }   /* islatinextendedadditional */,
  {    12,  5544,  8741,  13,   3, PL_NV__5_SLASH_6 }   /* numericvalue=5/6 */,
  {     0,  7288,  8488,   7,   4, PL_RJNG }   /* script=rjng */,
  {     0,  8288,  3191,   3,   3, PL_DT__MED }   /* dt=med */,
  {     0,  1939,     0,  21,   0, PL_CJKCOMPATFORMS }   /* cjkcompatibilityforms */,
  {     0,  1417,  4569,   9,  15, PL_LT }   /* category=titlecaseletter */,
  {   136,  4314,  8774,  13,   3, PL_JG__BEH }   /* joininggroup=beh */,
  {     0,  7320,     0,   8,   0, PL_TFNG }   /* tifinagh */,
  {     1,  8572,  6395,   3,  11, PL_WB__SQ }   /* wb=singlequote */,
  {   945,  6890,  1981,   4,  11, PL_CYRILLICSUP }   /* blk=cyrillicsup */,
  {     0,  6890,  6029,   4,   8, PL_PHAISTOS }   /* blk=phaistos */,
  {   323,  7459,  1680,   3,   6, PL_SC__ZYYY }   /* sc=common */,
  {     0,  7689,  6865,   4,   7, PL_ARABICPFA }   /* isarabicpfa */,
  {     7,  5134,  3077,   4,  16, PL_ZP }   /* isparagraphseparator */,
  {  1281,  1402,  6686,  24,  10, PL_INPC__OVERSTRUCK }   /* indicpositionalcategory=overstruck */,
  {    25,  8096,  8596,   4,   4, PL_ZANB }   /* scx=zanb */,
  {     0,  1929,  7768,   9,   6, -PL_XPOSIXUPPER }   /* uppercase=false */,
  {  1152,  6210,  2788,   3,  10, PL_CHEROKEESUP }   /* incherokeesup */,
  {     0,  8096,  8384,   4,   4, PL_LINB }   /* scx=linb */,
  {  1846,  7471,  8001,   7,   5, PL_POSIXCNTRL }   /* isposixcntrl */,
  {     3,  2229,  1499,  16,   1, PL_Z }   /* generalcategory=z */,
  {     0,  5544,  8685,  13,   2, PL_NV__24 }   /* numericvalue=24 */,
  {     0,  7288,  7200,   7,   8, PL_SC__GURU }   /* script=gurmukhi */,
  {  1472,  6706,  7732,  10,   1, PL_IN__5 }   /* presentin=5 */,
  {    44,  7689,   183,   4,   2, PL_ARMI }   /* isarmi */,
  {     1,  8340,  5019,   3,   4, PL_JG__TETH }   /* jg=teth */,
  {     4,   974,  8617,  24,   2, PL_CCC__31 }   /* canonicalcombiningclass=31 */,
  {     6,  7459,  7780,   3,   4, PL_CARI }   /* sc=cari */,
  {     0,  7415,     0,   7,   0, PL_CJKEXTE }   /* cjkexte */,
  {     0,  8572,  7352,   3,   7, PL_WB__LE }   /* wb=aletter */,
  {     0,  3129,  2787,  17,   8, PL_CHER }   /* scriptextensions=cherokee */,
  {     0,   184,  5310,   2,  13, PL_XPOSIXDIGIT }   /* isdecimalnumber */,
  {   771,  1448,   352,   5,  30, PL_SUPMATHOPERATORS }   /* insupplementalmathematicaloperators */,
  {  1156,  7136,  2044,   6,  21, PL_MEETEIMAYEKEXT }   /* block=meeteimayekextensions */,
  {     0,    42,     0,   9,   0, PL_CJKCOMPAT }   /* cjkcompat */,
  {     0,  7136,  7876,   6,   6, PL_INLYCIAN }   /* block=lycian */,
  {     0,  7136,  2787,   6,  11, PL_CHEROKEESUP }   /* block=cherokeesup */,
  {     0,  5315,     0,   5,   0, PL_XPOSIXALNUM }   /* alnum */,
  {     0,  8816,  8627,   3,   3, PL_NV__1_SLASH_8 }   /* nv=1/8 */,
  {  2179,   184,  8252,   2,   4, PL_BUHD }   /* isbuhd */,
  {     0,   184,  8284,   2,   4, PL_DSRT }   /* isdsrt */,
  {     0,   316,     0,  33,   0, PL_MISCMATHSYMBOLSB }   /* miscellaneousmathematicalsymbolsb */,
  {     0,  8096,  8360,   4,   4, PL_KTHI }   /* scx=kthi */,
  {   848,  5544,  7708,  13,   6, PL_NV__216000 }   /* numericvalue=216000 */,
  {   322,    45,     0,   2,   0, PL_CO }   /* co */,
  {  1221,  7689,  1260,   4,  22, PL_ARABICPFB }   /* isarabicpresentationformsb */,
  {     0,  7136,  3067,   6,   8, PL_DINGBATS }   /* block=dingbats */,
  {     0,   184,  6566,   2,  10, PL_BOXDRAWING }   /* isboxdrawing */,
  {     4,  2750,  7951,   4,   5, PL_TERM }   /* term=true */,
  {     5,  6890,  5093,   4,  14, PL_PHONETICEXTSUP }   /* blk=phoneticextsup */,
  {   516,  8816,  7750,   3,   3, PL_NV__800 }   /* nv=800 */,
  {     5,  7288,  6626,   7,   4, PL_KHAR }   /* script=khar */,
  {    16,  8026,  2349,   5,  12, PL_INPC__TOPANDBOTTOM }   /* inpc=topandbottom */,
  {   259,  8376,  4561,   3,   2, PL_LB__EB }   /* lb=eb */,
  {     0,  6890,  5801,   4,  12, PL_KHMERSYMBOLS }   /* blk=khmersymbols */,
  {  2692,   836,     0,  28,   0, PL_SUPPUAA }   /* supplementaryprivateuseareaa */,
  {     0,  8376,   184,   3,   2, PL_LB__IS }   /* lb=is */,
  {    17,  1206,  7313,   3,   7, PL_INTAGBANWA }   /* intagbanwa */,
  {   606,  8011,    74,   3,   2, PL_ME }   /* gc=me */,
  {     1,  1111,     0,   4,   0, PL_KANA }   /* kana */,
  {     0,  6263,  1306,  10,  13, PL_LB__CM }   /* linebreak=combiningmark */,
  {  2861,  8376,  5762,   3,   2, PL_LB__ZW }   /* lb=zw */,
  {    32,  7224,  5315,   8,   5, PL_XPOSIXALNUM }   /* isxposixalnum */,
  {   128,  8086,  3223,   5,   2, -PL_QMARK }   /* qmark=n */,
  {     0,  4449,  7373,   4,   7, PL_NFCQC__M }   /* nfcqc=maybe */,
  {     0,  7816,  3223,   6,   3, -PL_GRBASE }   /* grbase=no */,
  {    30,  4827,     0,   6,   0, PL_KANGXI }   /* kangxi */,
  {   264,  8096,  8516,   4,   4, PL_SGNW }   /* scx=sgnw */,
  {    18,  1701,  7768,   2,   2, -PL_SD }   /* sd=f */,
  {     2,   184,  7366,   2,   7, PL_BENG }   /* isbengali */,
  {    10,   122,  7768,   9,   2, -PL_DIA }   /* diacritic=f */,
  {   184,  3866,     0,  16,   0, PL_MISCMATHSYMBOLSB }   /* miscmathsymbolsb */,
  {    40,  1892,     0,   5,   0, PL_CASED }   /* cased */,
  {     3,  8096,  7104,   4,   8, PL_ARMN }   /* scx=armenian */,
  {     4,  7459,  7597,   3,   7, PL_SHAW }   /* sc=shavian */,
  {  1676,  2636,     0,  12,   0, PL_MONGOLIANSUP }   /* mongoliansup */,
  {  3109,   892,  7997,  17,   4, PL_VS }   /* variationselector=yes */,
  {     0,  7478,  8529,   3,   3, PL_SYRC }   /* issyrc */,
  {   145,  8344,     0,   3,   1, PL_JT__U }   /* jt=u */,
  {     0,  2229,   218,  16,   2, PL_PE }   /* generalcategory=pe */,
  {     0,    21,  6989,   2,   9, PL_INNEWTAILUE }   /* innewtailue */,
  {   664,    21,  4883,   2,  14, PL_LATINEXTE }   /* inlatinextendede */,
  {     0,  6706,  8152,  10,   4, PL_IN__10 }   /* presentin=10.0 */,
  {    21,   184,  3441,   2,  17, PL_LETTERLIKESYMBOLS }   /* isletterlikesymbols */,
  {    13,  6890,  8066,   4,   5, PL_INORIYA }   /* blk=oriya */,
  {  2823,  8021,  7951,   5,   5, PL_GREXT }   /* grext=true */,
  {     0,  8340,   727,   3,   3, PL_JG__DAL }   /* jg=dal */,
  {     2,  8931,     0,   2,   0, PL_L_AMP_ }   /* l& */,
  {     0,  1855,  7768,  21,   6, -PL_CWCM }   /* changeswhencasemapped=false */,
  {     1,   892,     0,  17,   0, PL_VS }   /* variationselector */,
  {     0,  1202,  7768,   3,   6, -PL_DEP }   /* dep=false */,
  {    75,  8340,  5885,   3,  12, PL_JG__MALAYALAMNYA }   /* jg=malayalamnya */,
  {     0,  8816,  8717,   3,   3, PL_NV__3_SLASH_4 }   /* nv=3/4 */,
  {     0,  7136,  2636,   6,  19, PL_MONGOLIANSUP }   /* block=mongoliansupplement */,
  {     0,    11,  3223,   3,   3, -PL_DIA }   /* dia=no */,
  {     0,  1426,  5297,  22,  13, PL_INSC__CONSONANTDEAD }   /* indicsyllabiccategory=consonantdead */,
  {     0,  2221,  3581,   3,   2, PL_GCB__T }   /* hst=t */,
  {     1,  7136,  3458,   6,  10, PL_INMANICHAEAN }   /* block=manichaean */,
  {     0,  8288,    68,   3,   3, PL_DT__SUP }   /* dt=sup */,
  {     0,  6297,     0,   4,   0, PL_CS }   /* iscs */,
  {     0,  7894,  7768,   6,   2, -PL_PATSYN }   /* patsyn=f */,
  {     0,  7136,  6296,   6,  11, PL_MISCSYMBOLS }   /* block=miscsymbols */,
  {     5,  8816,  8621,   3,   3, PL_NV__1_SLASH_6 }   /* nv=1/6 */,
  {   920,  7288,  8372,   7,   4, PL_SC__LATN }   /* script=latn */,
  {     0,  6890,  2107,   4,  21, PL_SINHALAARCHAICNUMBERS }   /* blk=sinhalaarchaicnumbers */,
  {    56,  8086,  7951,   5,   5, PL_QMARK }   /* qmark=true */,
  {     0,  6713,  8612,   3,   3, PL_IN__1_DOT_1 }   /* in=1.1 */,
  {     3,  2859,  7184,  18,   3, PL_DT__FRA }   /* decompositiontype=fra */,
  {     0,   122,  3581,   9,   2, PL_DIA }   /* diacritic=t */,
  {  2244,  7136,  6120,   6,  11, PL_DOMINO }   /* block=dominotiles */,
  {     0,  4314,  6065,  13,  11, PL_JG__AFRICANNOON }   /* joininggroup=africannoon */,
  {     0,  1658,     0,  22,   0, PL_CJKCOMPATIDEOGRAPHSSUP }   /* cjkcompatideographssup */,
  {     0,  4314,  4911,  13,  14, PL_JG__MANICHAEANAYIN }   /* joininggroup=manichaeanayin */,
  {   130,  6208,  3223,   5,   2, -PL_JOINC }   /* joinc=n */,
  {     0,  8432,     0,   4,   0, PL_NKO }   /* nkoo */,
  {  2070,  8096,  8424,   4,   4, PL_NBAT }   /* scx=nbat */,
  {     0,  8096,  8524,   4,   4, PL_SHRD }   /* scx=shrd */,
  {     1,  5284,     0,  13,   0, PL_CI }   /* caseignorable */,
  {     4,  3129,  2531,  17,   4, PL_MULT }   /* scriptextensions=mult */,
  {     0,  1206,  8107,   3,   4, PL_INTAILE }   /* intaile */,
  {     3,  4542,  1909,   3,   8, PL_LT }   /* istitlecase */,
  {     0,  7288,  3754,   7,   7, PL_SC__LINB }   /* script=linearb */,
  {     9,  8011,  8939,   3,   2, PL_ZP }   /* gc=zp */,
  {    10,  8432,     0,   3,   0, PL_NKO }   /* nko */,
  {     0,  5544,  8915,  13,   2, PL_NV__48 }   /* numericvalue=48 */,
  {     0,  5544,  8164,  13,   2, PL_NV__15 }   /* numericvalue=15 */,
  {     0,  6210,  3357,   3,  16, PL_CYRILLICEXTC }   /* incyrillicextendedc */,
  {     3,  8056,     0,   5,   0, PL_NSHU }   /* nushu */,
  {  4768,  8240,  5621,   3,  12, PL_BC__AL }   /* bc=arabicletter */,
  {     0,  7136,  8388,   6,   4, PL_LISU }   /* block=lisu */,
  {    84,  1834,  3223,  21,   2, -PL_CWCF }   /* changeswhencasefolded=n */,
  {  4004,  5192,  2270,   3,  19, PL_PHLI }   /* isinscriptionalpahlavi */,
  {     0,  7380,  7702,   7,   2, PL_CCC__20 }   /* ccc=ccc20 */,
  {     0,  8376,  5107,   3,  14, PL_LB__PO }   /* lb=postfixnumeric */,
  {     0,   974,  8669,  24,   3, PL_CCC__202 }   /* canonicalcombiningclass=202 */,
  {    51,   974,  8645,  27,   3, PL_CCC__129 }   /* canonicalcombiningclass=ccc129 */,
  {  1225,  8816,  8666,   3,   3, PL_NV__2_SLASH_5 }   /* nv=2/5 */,
  {   653,  7168,  7997,   8,   2, PL_EXT }   /* extender=y */,
  {   205,  5657,  7768,  12,   2, -PL_BIDIM }   /* bidimirrored=f */,
  {  2067,  8288,  1224,   3,   3, PL_DT__SUB }   /* dt=sub */,
  {     4,  8372,     0,   4,   0, PL_LATN }   /* latn */,
  {  3077,  8376,  7695,   3,   7, PL_LB__ZW }   /* lb=zwspace */,
  {     0,  5544,  7750,  13,   5, PL_NV__80000 }   /* numericvalue=80000 */,
  {  1552,  5134,  8078,   4,   3, PL_PATWS }   /* ispatws */,
  {     0,  7459,  6881,   3,   9, PL_BHKS }   /* sc=bhaiksuki */,
  {   584,  4542,  7321,   3,   7, PL_TFNG }   /* istifinagh */,
  {   130,  6890,   849,   4,  10, PL_PUA }   /* blk=privateuse */,
  {   162,  6263,  4524,  10,  15, PL_LB__OP }   /* linebreak=openpunctuation */,
  {   603,  1918,  3223,  21,   3, -PL_CWU }   /* changeswhenuppercased=no */,
  {    10,  6890,    78,   4,  35, PL_ARABICMATH }   /* blk=arabicmathematicalalphabeticsymbols */,
  {     0,   119,  7811,   3,   5, PL_INGOTHIC }   /* ingothic */,
  {     1,  3129,  2967,  17,   4, PL_GEOR }   /* scriptextensions=geor */,
  {   307,  1202,  3223,   3,   2, -PL_DEP }   /* dep=n */,
  {     0,  5427,     0,   9,   0, PL_MLYM }   /* malayalam */,
  {     6,  8428,     0,   4,   0, PL_NEWA }   /* newa */,
  {     2,  8096,  8468,   4,   4, PL_MIAO }   /* scx=plrd */,
  {    78,  2269,     0,  20,   0, PL_PHLI }   /* inscriptionalpahlavi */,
  {     4,   184,  7443,   2,   7, PL_GRAN }   /* isgrantha */,
  {     2,  6210,  5706,   3,  11, PL_CYRILLICEXTC }   /* incyrillicextc */,
  {    12,  5250,  7951,   8,   5, PL_XPOSIXXDIGIT }   /* hexdigit=true */,
  {  1539,  7457,  7688,   5,   7, PL_INSC__VISARGA }   /* insc=visarga */,
  {  1301,  7224,  5253,   8,   5, PL_XPOSIXDIGIT }   /* isxposixdigit */,
  {     0,  6890,  3067,   4,   8, PL_DINGBATS }   /* blk=dingbats */,
  {  2595,  1206,  1813,   3,  21, PL_TRANSPORTANDMAP }   /* intransportandmapsymbols */,
  {    13,    21,  2150,   3,  19, PL_INANATOLIANHIEROGLYPHS }   /* inanatolianhieroglyphs */,
  {  1105,  4542,  3148,   3,  10, PL_TAIXUANJING }   /* istaixuanjing */,
  {  1414,  3373,     0,  16,   0, PL_EA__H }   /* eastasianwidth=h */,
  {   585,  7136,  3611,   7,   7, PL_INBOPOMOFO }   /* block=bopomofo */,
  {     3,  7288,  8568,   7,   4, PL_VAI }   /* script=vaii */,
  {    49,  8196,  8861,   4,   3, PL_AGE__4_DOT_1 }   /* age=v41 */,
  {     3,  6713,  7744,   3,   1, PL_IN__7 }   /* in=7 */,
  {     0,  7152,     0,   8,   0, PL_DUPL }   /* duployan */,
  {     7,  7689,    97,   3,   4, PL_XPOSIXALPHA }   /* isalpha */,
  {   124,  7288,  2895,   7,   8, PL_ETHI }   /* script=ethiopic */,
  {  2386,  5645,  2579,  10,  19, PL_BC__LRO }   /* bidiclass=lefttorightoverride */,
  {  1088,  7136,  2895,   6,  18, PL_ETHIOPICSUP }   /* block=ethiopicsupplement */,
  {     2,  1746,  5772,  21,   5, PL_WB__EB }   /* graphemeclusterbreak=ebase */,
  {     9,  7136,  4813,   6,   7, PL_KANASUP }   /* block=kanasup */,
  {     0,   184,  3610,   2,  16, PL_BOPOMOFOEXT }   /* isbopomofoextended */,
  {     3,  1746,  5753,  21,  12, PL_WB__GAZ }   /* graphemeclusterbreak=glueafterzwj */,
  {     0,  2065,  7768,  21,   6, -PL_NCHAR }   /* noncharactercodepoint=false */,
  {     0,  1346,  4774,   5,  11, PL_INGREEK }   /* ingreekandcoptic */,
  {     0,  3129,  6676,  17,  10, PL_XPEO }   /* scriptextensions=oldpersian */,
  {     0,  2108,  3723,   3,  15, PL_HIGHPUSURROGATES }   /* inhighpusurrogates */,
  {   934,  1892,  3223,   5,   2, -PL_CASED }   /* cased=n */,
  {  4292,  7459,  7061,   3,   9, PL_SAMR }   /* sc=samaritan */,
  {    32,  7288,  4644,   7,  15, PL_ZANB }   /* script=zanabazarsquare */,
  {     0,  8508,  7877,   4,   5, PL_LYCI }   /* sc=lycian */,
  {    22,   184,  5706,   3,  11, PL_CYRILLICEXTC }   /* iscyrillicextc */,
  {     0,  5284,  7768,  13,   2, -PL_CI }   /* caseignorable=f */,
  {    12,  7136,   510,   6,  30, PL_CJKEXTA }   /* block=cjkunifiedideographsextensiona */,
  {     0,  8076,  7768,   5,   6, -PL_PATWS }   /* patws=false */,
  {     0,  1417,    25,   9,   1, PL_S }   /* category=s */,
  {  2714,  7136,  6484,   6,   3, PL_INIDC }   /* block=idc */,
  {  1157,  7136,   316,   6,  33, PL_MISCMATHSYMBOLSB }   /* block=miscellaneousmathematicalsymbolsb */,
  {  3411,   974,  8187,  27,   2, PL_CCC__27 }   /* canonicalcombiningclass=ccc27 */,
  {    32,  7227,  3521,   5,   5, PL_POSIXSPACE }   /* posixspace */,
  {     0,  7136,  5945,   6,  12, PL_MATHALPHANUM }   /* block=mathalphanum */,
  {     7,  7136,   447,   6,  32, PL_IDEOGRAPHICSYMBOLS }   /* block=ideographicsymbolsandpunctuation */,
  {     0,   540,     0,  30,   0, PL_CJKEXTB }   /* cjkunifiedideographsextensionb */,
  {   606,  7288,  6406,   7,   4, PL_SORA }   /* script=sora */,
  {  4224,  4630,  2883,   3,   3, PL_UGAR }   /* isugar */,
  {     0,  8096,  7248,   4,   8, PL_JAVA }   /* scx=javanese */,
  {     1,  6890,  5945,   4,  12, PL_MATHALPHANUM }   /* blk=mathalphanum */,
  {   176,  4757,  3223,  14,   2, -PL_GREXT }   /* graphemeextend=n */,
  {  1564,  1202,     0,   3,   0, PL_DEP }   /* dep */,
  {     0,    21,  7248,   2,   8, PL_INJAVANESE }   /* injavanese */,
  {     7,  6736,     0,   4,   0, PL_SAUR }   /* saur */,
  {    32,  8572,  5729,   3,  12, PL_WB__EX }   /* wb=extendnumlet */,
  {     0,  8011,  5083,   4,  10, PL_MC }   /* gc=spacingmark */,
  {  2661,  7288,  7025,   7,   9, PL_ORKH }   /* script=oldturkic */,
  {     0,  8816,  7714,   3,   5, PL_NV__30000 }   /* nv=30000 */,
  {     0,  6890,  3738,   4,   6, PL_LATIN1 }   /* blk=latin1 */,
  {     2,  7478,  2713,   3,  18, PL_SUPARROWSB }   /* issupplementalarrowsb */,
  {    33,  6210,  1283,   3,  23, PL_CJKSYMBOLS }   /* incjksymbolsandpunctuation */,
  {     0,  2229,  1797,  16,  14, PL_LM }   /* generalcategory=modifierletter */,
  {   906,  1001,     0,  27,   0, PL_ENCLOSEDCJK }   /* enclosedcjklettersandmonths */,
  {     0,  3129,  8200,  17,   4, PL_AGHB }   /* scriptextensions=aghb */,
  {     0,  6756,  3581,  10,   2, PL_SD }   /* softdotted=t */,
  {     0,  7288,  8320,   7,   4, PL_HLUW }   /* script=hluw */,
  {     0,  7459,  2967,   3,   8, PL_SC__GEOR }   /* sc=georgian */,
  {     0,  6890,  2636,   4,  12, PL_MONGOLIANSUP }   /* blk=mongoliansup */,
  {     7,  6890,  2389,   4,  19, PL_ANCIENTGREEKNUMBERS }   /* blk=ancientgreeknumbers */,
  {  1394,  1426,  1330,  22,   9, PL_INSC__CONSONANT }   /* indicsyllabiccategory=consonant */,
  {  2048,  2712,     0,  19,   0, PL_SUPARROWSB }   /* supplementalarrowsb */,
  {     4,    21,  6241,   2,  11, PL_KATAKANAEXT }   /* inkatakanaext */,
  {     0,   184,  5388,   2,  13, PL_KANAEXTA }   /* iskanaextendeda */,
  {    64,  2229,  3690,  16,  16, PL_PF }   /* generalcategory=finalpunctuation */,
  {     0,  7288,  7555,   7,   7, PL_OLCK }   /* script=olchiki */,
  {     0,  7894,  7997,   6,   4, PL_PATSYN }   /* patsyn=yes */,
  {     1,  6890,  3390,   4,  17, PL_ETHIOPICEXTA }   /* blk=ethiopicextendeda */,
  {   351,  3373,  7888,  15,   6, PL_EA__NA }   /* eastasianwidth=narrow */,
  {     4,  8340,    87,   3,   2, PL_JG__HE }   /* jg=he */,
  {    21,  3129,  1111,  17,   4, PL_KANA }   /* scriptextensions=kana */,
  {   545,  3129,  8071,  17,   5, PL_OSGE }   /* scriptextensions=osage */,
  {     2,  1417,    47,   9,   1, PL_M }   /* category=m */,
  {   226,  7288,  8556,   7,   4, PL_THAI }   /* script=thai */,
  {     0,  8260,     0,   4,   0, PL_CAKM }   /* cakm */,
  {  6864,  6713,  8657,   3,   3, PL_IN__2 }   /* in=2.0 */,
  {  2188,  6706,  8849,  10,   3, PL_IN__3 }   /* presentin=v30 */,
  {     0,  8066,     0,   5,   0, PL_ORYA }   /* oriya */,
  {   520,  7876,     0,   4,   0, PL_LYCI }   /* lyci */,
  {    12,  7380,  8228,   4,   4, PL_CCC__133 }   /* ccc=atbl */,
  {   321,  5401,     0,  13,   0, PL_ZL }   /* lineseparator */,
  {  5897,  2859,  2369,  18,   8, PL_DT__VERT }   /* decompositiontype=vertical */,
  {     3,   184,   720,   2,  30, PL_ENCLOSEDALPHANUMSUP }   /* isenclosedalphanumericsupplement */,
  {  4182,    21,  7256,   2,   8, PL_KANAEXTA }   /* inkanaexta */,
  {     0,  6263,  7695,  10,   7, PL_LB__ZW }   /* linebreak=zwspace */,
  {     0,  6263,  6087,  10,  11, PL_LB__BB }   /* linebreak=breakbefore */,
  {  2459,  2750,  7768,  19,   2, -PL_TERM }   /* terminalpunctuation=f */,
  {  3875,  7459,  7991,   3,   5, PL_SC__BUHD }   /* sc=buhid */,
  {     5,  7136,  1498,   7,  13, PL_BYZANTINEMUSIC }   /* block=byzantinemusic */,
  {     0,  7136,  6626,   6,  10, PL_INKHAROSHTHI }   /* block=kharoshthi */,
  {  3113,  8016,  7160,   4,   8, PL_WB__EBG }   /* gcb=ebasegaz */,
  {     0,  3129,  7520,  17,   4, PL_MARC }   /* scriptextensions=marc */,
  {     1,  2967,     0,   4,   0, PL_GEOR }   /* geor */,
  {     0,  7288,  7443,   7,   7, PL_SC__GRAN }   /* script=grantha */,
  {     4,  3424,  3223,  17,   3, -PL_IDSB }   /* idsbinaryoperator=no */,
  {     8,  8340,  5894,   3,   3, PL_JG__NYA }   /* jg=nya */,
  {  2824,  1448,  2705,   5,   7, PL_SUPARROWSA }   /* insuparrowsa */,
  {    32,  6756,  7768,  10,   2, -PL_SD }   /* softdotted=f */,
  {     0,  7380,  8685,   4,   2, PL_CCC__24 }   /* ccc=24 */,
  {     0,  7689,  1236,   4,  22, PL_ARABICPFA }   /* isarabicpresentationformsa */,
  {     0,  7380,  8696,   4,   3, PL_CCC__AR }   /* ccc=232 */,
  {     0,  3424,  3223,   4,   3, -PL_IDSB }   /* idsb=no */,
  {     0,  5544,  7714,  13,   5, PL_NV__30000 }   /* numericvalue=30000 */,
  {     0,  2229,  1886,  16,   2, PL_NL }   /* generalcategory=nl */,
  {     0,  1503,   751,   3,  21, PL_ENCLOSEDIDEOGRAPHICSUP }   /* inenclosedideographicsup */,
  {     0,  7380,  5349,   4,  13, PL_CCC__IS }   /* ccc=iotasubscript */,
  {   225,  3882,     0,  16,   0, PL_MYANMAREXTA }   /* myanmarextendeda */,
  {  6178,  6483,  7951,   4,   5, PL_XIDC }   /* xidc=true */,
  {  2484,    34,  7997,   3,   4, PL_EXT }   /* ext=yes */,
  {     1,    96,  3581,  10,   2, PL_XPOSIXALPHA }   /* alphabetic=t */,
  {   768,  7288,  2409,   8,   3, PL_BRAH }   /* script=brah */,
  {     0,   184,    11,   2,   2, PL_DI }   /* isdi */,
  {     7,  8096,  7520,   4,   4, PL_MARC }   /* scx=marc */,
  {     0,  5645,     0,  11,   0, PL_BC__B }   /* bidiclass=b */,
  {     4,  8508,  4630,   4,   3, PL_LISU }   /* sc=lisu */,
  {     7,  7380,  7744,   4,   1, PL_CCC__7 }   /* ccc=7 */,
  {     1,  7136,     0,   6,  42, PL_UCASEXT }   /* block=unifiedcanadianaboriginalsyllabicsextended */,
  {     9,  1790,     0,  22,   0, PL_MODIFIERLETTERS }   /* spacingmodifierletters */,
  {    15,  8021,  3581,   5,   2, PL_GREXT }   /* grext=t */,
  {   320,   184,  1982,   3,  10, PL_CYRILLICSUP }   /* iscyrillicsup */,
  {  7211,   974,  3254,  24,  17, PL_CCC__133 }   /* canonicalcombiningclass=attachedbelowleft */,
  {  2082,  6890,  6296,   4,  11, PL_MISCSYMBOLS }   /* blk=miscsymbols */,
  {    74,  8096,  7248,   4,   4, PL_JAVA }   /* scx=java */,
  {  5236,    27,     0,   2,   0, PL_LL }   /* ll */,
  {     4,  2134,  3223,   3,   2, -PL_XPOSIXXDIGIT }   /* hex=n */,
  {     0,  8376,  5789,   3,  12, PL_LB__IS }   /* lb=infixnumeric */,
  {  5204,  1892,  7997,   5,   4, PL_CASED }   /* cased=yes */,
  {  1290,  2859,  7888,  18,   6, PL_DT__NAR }   /* decompositiontype=narrow */,
  {     0,  8777,  7768,   3,   6, -PL_CWL }   /* cwl=false */,
  {     1,  7288,  1589,   7,   5, PL_SC__LATN }   /* script=latin */,
  {     0,  6756,  7951,  10,   5, PL_SD }   /* softdotted=true */,
  {     8,  6890,   720,   4,  30, PL_ENCLOSEDALPHANUMSUP }   /* blk=enclosedalphanumericsupplement */,
  {     1,  7136,  2107,   6,  21, PL_SINHALAARCHAICNUMBERS }   /* block=sinhalaarchaicnumbers */,
  {     0,  6472,  2284,  10,   2, PL_LB__HL }   /* wordbreak=hl */,
  {     4,  3114,     1,   3,  41, PL_UCASEXT }   /* inunifiedcanadianaboriginalsyllabicsextended */,
  {     0,   184,   114,   3,  34, PL_DIACRITICALSFORSYMBOLS }   /* iscombiningdiacriticalmarksforsymbols */,
  {     0,  4542,  4011,   3,  15, PL_TANGUTCOMPONENTS }   /* istangutcomponents */,
  {     0,   974,    23,  24,   2, PL_CCC__AL }   /* canonicalcombiningclass=al */,
  {     0,  7288,   994,   8,   3, PL_BASS }   /* script=bass */,
  {     0,  8096,  2877,   4,   4, PL_DEVA }   /* scx=deva */,
  {     0,  8096,  6373,   4,  11, PL_HMNG }   /* scx=pahawhhmong */,
  {  4836,  7136,  7408,   6,   7, PL_CJKEXTD }   /* block=cjkextd */,
  {    10,  7459,  5777,   3,   6, PL_HEBR }   /* sc=hebrew */,
  {  1144,   184,  8273,   3,   3, PL_CWCF }   /* iscwcf */,
  {     1,  1746,   125,  21,   2, PL_LB__CR }   /* graphemeclusterbreak=cr */,
  {  2132,  3129,  7019,  17,   4, PL_PERM }   /* scriptextensions=perm */,
  {     0,    84,  3223,   4,   2, -PL_MATH }   /* math=n */,
  {     3,   184,  7810,   2,   4, PL_GOTH }   /* isgoth */,
  {     0,  7380,  8633,   7,   3, PL_CCC__103 }   /* ccc=ccc103 */,
  {     1,  6890,  1768,   4,  22, PL_MISCTECHNICAL }   /* blk=miscellaneoustechnical */,
  {   801,  7478,  6777,   3,   9, PL_SUPARROWSB }   /* issuparrowsb */,
  {  2049,  7043,     0,   9,   0, PL_PAUC }   /* paucinhau */,
  {     8,  8021,  7768,   5,   2, -PL_GREXT }   /* grext=f */,
  {  3472,  8548,     0,   4,   0, PL_TFNG }   /* tfng */,
  {     0,  8572,  6962,   3,   9, PL_WB__ML }   /* wb=midletter */,
  {     1,  6263,   929,  10,   2, PL_LB__CP }   /* linebreak=cp */,
  {    57,   184,  2788,   3,  17, PL_CHEROKEESUP }   /* ischerokeesupplement */,
  {  6591,  6263,   496,  10,   2, PL_LB__NU }   /* linebreak=nu */,
  {  1984,  3129,  5957,  17,   4, PL_MEND }   /* scriptextensions=mend */,
  {     2,  7136,  6766,   6,  10, PL_SUPARROWSA }   /* block=suparrowsa */,
  {     2,  3129,  7144,  17,   4, PL_BUGI }   /* scriptextensions=bugi */,
  {     1,  3129,  8552,  17,   4, PL_TGLG }   /* scriptextensions=tglg */,
  {    20,  7136,  5717,   6,  12, PL_ETHIOPICEXTA }   /* block=ethiopicexta */,
  {  1285,  8096,  8604,   4,   4, PL_ZYYY }   /* scx=zyyy */,
  {     8,  7459,  8544,   3,   4, PL_TAVT }   /* sc=tavt */,
  {     0,  8121,  7768,   5,   2, -PL_UIDEO }   /* uideo=f */,
  {   135,    11,  7768,   3,   6, -PL_DIA }   /* dia=false */,
  {   100,  3129,  2877,  17,   4, PL_DEVA }   /* scriptextensions=deva */,
  {     0,  7689,   804,   4,   4, PL_ARROWS }   /* isarrows */,
  {   377,  7478,    17,   3,   1, PL_SO }   /* isso */,
  {  4933,  8196,  8843,   4,   3, PL_AGE__2 }   /* age=v20 */,
  {    29,  8096,  8356,   4,   4, PL_KNDA }   /* scx=knda */,
  {  4185,  7288,  8432,   7,   4, PL_NKO }   /* script=nkoo */,
  {     1,  8196,  8756,   4,   3, PL_AGE__6_DOT_3 }   /* age=6.3 */,
  {     5,  6484,  7997,  10,   4, PL_IDC }   /* idcontinue=yes */,
  {  4384,  7136,  7208,   6,   8, PL_INHIRAGANA }   /* block=hiragana */,
  {     0,  7689,   948,   3,  16, PL_ANCIENTGREEKMUSIC }   /* isancientgreekmusic */,
  {     3,   184,   183,   2,  34, PL_MISCPICTOGRAPHS }   /* ismiscellaneoussymbolsandpictographs */,
  {    15,    11,     0,   3,   0, PL_DIA }   /* dia */,
  {     0,  8096,  6980,   4,   9, PL_NBAT }   /* scx=nabataean */,
  {     0,  3129,  7450,  17,   7, PL_HANO }   /* scriptextensions=hanunoo */,
  {     0,  7380,  8681,   4,   3, PL_CCC__BR }   /* ccc=222 */,
  {     0,  8096,  7506,   4,   7, PL_LINA }   /* scx=lineara */,
  {     1,  6263,  4194,  10,  15, PL_LB__CB }   /* linebreak=contingentbreak */,
  {     0,  6219,  3223,  11,   2, -PL_JOINC }   /* joincontrol=n */,
  {    14,   217,  2522,   6,  19, PL__PERL_FOLDS_TO_MULTI_CHAR }   /* _perl_folds_to_multi_char */,
  {  5481,  7459,  8252,   3,   4, PL_SC__BUHD }   /* sc=buhd */,
  {     0,  2990,  6874,   4,   7, PL_ARABICPFB }   /* inarabicpfb */,
  {     0,  7459,  7810,   3,   6, PL_GOTH }   /* sc=gothic */,
  {     0,  7380,  8655,   4,   2, PL_CCC__33 }   /* ccc=33 */,
  {   103,  3521,  3223,   5,   3, -PL_XPOSIXSPACE }   /* space=no */,
  {     0,    21,  7852,   2,   6, PL_KANBUN }   /* inkanbun */,
  {  2239,  3129,  7876,  17,   6, PL_LYCI }   /* scriptextensions=lycian */,
  {     0,  6263,   415,  10,  11, PL_LB__ID }   /* linebreak=ideographic */
};

MPH_VALt match_uniprop( const unsigned char * const key, const U16 key_len ) {
    const unsigned char * ptr= key;
    const unsigned char * ptr_end= key + key_len;
    U32 h= MPH_SEED1;
    U32 s;
    U32 n;
    do {
        h ^= *ptr;
        h *= MPH_FNV_CONST;
    } while ( ++ptr < ptr_end );
    n= h % MPH_BUCKETS;
    s = mph_table[n].seed2;
    if (s) {
        h= (h >> MPH_RSHIFT) ^ s;
        n = h % MPH_BUCKETS;
        if (
            ( mph_table[n].pfx_len + mph_table[n].sfx_len == key_len ) &&
            ( memcmp(mph_blob + mph_table[n].pfx, key, mph_table[n].pfx_len) == 0 ) &&
            ( !mph_table[n].sfx_len || memcmp(mph_blob + mph_table[n].sfx,
                key + mph_table[n].pfx_len, mph_table[n].sfx_len) == 0 )
        ) {
            return mph_table[n].value;
        }
    }
    return 0;
}

/* Generated from:
 * 4d64b650346ff9ddbcd3986f0da13f3be2379d64c574a120ca7f534d8d17934c lib/Unicode/UCD.pm
 * ff4404ec64f308bdf7714c50f9fdf0d1d0bf3c34db4d0a67e58ef0c6f88e818f lib/unicore/ArabicShaping.txt
 * 292171a0a1c13d7e581e8781eb4cdf248243b1ab267354a63c7a14429dea2740 lib/unicore/BidiBrackets.txt
 * 8f2695cc42989a79a715ab0d2892bd0c998759180cfdfb998674447f48231940 lib/unicore/BidiMirroring.txt
 * 5ae1649a42ed8ae8cb885af79563f00a9ae17e602405a56ed8aca214da14eea7 lib/unicore/Blocks.txt
 * 97b43ed3f4b80572c2114200e5e43a6b923d984c74a6caaf27de5b8462c04cb0 lib/unicore/CaseFolding.txt
 * eedcf6932b4081ee65878454588c803af910a5aed7c8c67e3c38701cbee9b9e4 lib/unicore/CompositionExclusions.txt
 * 90e48995643f45b08f0ef67fb90de3bb18e26765272bcc0c35c840cbc10b37c1 lib/unicore/DAge.txt
 * e6ca152259189ec4bc2297e93c6c88f86e162cc52814198263497f3c9b46cbe9 lib/unicore/DCoreProperties.txt
 * 3e255ccdff4b00cfe0be53bbd583e4fe2e7d4039138579543548a5ecfce45242 lib/unicore/DNormalizationProps.txt
 * 9f34e2d3ea27ca82f4f14b62411861d1f07c4b9e296d54da112a09cad5b9a48d lib/unicore/EastAsianWidth.txt
 * 983810c739b56b9ff0fcb5db018c67d584ee515e8a5f4d9348c79ee85167ec37 lib/unicore/HangulSyllableType.txt
 * 7d514a779ee4baf91262bd83c400cb502c3e435dba4b880c876506be32b8e1d0 lib/unicore/IndicPositionalCategory.txt
 * f6acead8f84df5c72f3fb70dfc9375279926e4d8ef3480ffff3723095e9804aa lib/unicore/IndicSyllabicCategory.txt
 * c8ed526f70443535ca6b705980a08c774017ff17e921202dcb7b71ae554047b6 lib/unicore/Jamo.txt
 * 6b204c3727b77699d04a574b22b1e44facab038642095b8565b49762970d9bf8 lib/unicore/LineBreak.txt
 * f2357d2bd3526b9e830de72ab038dcfc65a2dff24bcb4c6325c92071eb341f88 lib/unicore/NameAliases.txt
 * 6c3e6bd1e58b640076a23b83318a8bf6a691d7fc2b2106114d77c5c5a898bced lib/unicore/NamedSequences.txt
 * 58dbf8fedbd5bf67a3bd5c10eda2f2acf2eae59df5f77884a6f158e98f75cf8c lib/unicore/PropList.txt
 * a6b0467c3cc7aa4e57d4e5cc7f6e9562b79cf4426dfe438517c28b368ed3e673 lib/unicore/PropValueAliases.txt
 * 9ca521224e08d30696516ae6bc3d4434659c45df16047c0d31e440783c163a3b lib/unicore/PropertyAliases.txt
 * 3fd0d744a816ddfd06809f92151ae4a73ec970ac2006806c269732d8951f3911 lib/unicore/ScriptExtensions.txt
 * d02e24e4c516e9090b6bc9c2d2c8f4c89510b6ed8c5e859d0a861b0dc5cf372d lib/unicore/Scripts.txt
 * e9947a0e86f27353f0e776403c4826675001210bd39d7114118a8864a57f7472 lib/unicore/SpecialCasing.txt
 * 52423e4d7492167b62f518f68d54db88930abbbff7f11edfcaec8f726498cab1 lib/unicore/UnicodeData.txt
 * f28caf260635cebf25fd58124bdc9aa22af08ba4d039ffc584365fb41a31cda5 lib/unicore/VerticalOrientation.txt
 * 718d174957712410bfad782b10d557e1047574d7ef1642d6bb122f8ca5662c82 lib/unicore/auxiliary/GCBTest.txt
 * 3b66caefc4fa877d0e50dbbbfa39658c86e29b26c6f206f68d7aec192d4c59b6 lib/unicore/auxiliary/GraphemeBreakProperty.txt
 * 2aad3836c37fc4c2fa2a24f21586fb3a931dacaf0a1c845a6dc6395f30bd79a7 lib/unicore/auxiliary/LBTest.txt
 * eacc03e39dddc60cc59ec9bd274b8ac8dfa25d61745ef0d5c8aa1c151a5b68ba lib/unicore/auxiliary/SBTest.txt
 * e45fa8195bb413b901cc1e3772dfea2cead86805d46a51e3480a5a256e8c24d9 lib/unicore/auxiliary/SentenceBreakProperty.txt
 * 95789f62e3b1e781dc9ed78f3983d39ff1a5e36ff0b497d6e610446df902b0f6 lib/unicore/auxiliary/WBTest.txt
 * c207e8ebd06ee591a27b1087f2971f4cd93e960103c453d85d1d9ba26fb8b202 lib/unicore/auxiliary/WordBreakProperty.txt
 * a3c0839826a30166b2bb06ba58df403547b8c3d9eae995ef889d20d115f4b223 lib/unicore/extracted/DBidiClass.txt
 * 280afe22f6c4d56566d17d6d1400f33465a979c96f3d99ff3bff9bd14d17e734 lib/unicore/extracted/DBinaryProperties.txt
 * db7fd6a5e6f068c47dbc3b74fb633fb1d09d17073410fe435295d05ce925c5f6 lib/unicore/extracted/DCombiningClass.txt
 * 8204c07a7c217bdf22525030ad7b4fb991edf463bffcca7e6dba46b9992e0d99 lib/unicore/extracted/DDecompositionType.txt
 * e343113719b660bdd81217ec101ce751f844fca0e8d6f15fb21c8ee7dfe7c14c lib/unicore/extracted/DEastAsianWidth.txt
 * 07c55b0ed7271fe1a5f4d68059291288b1a8ad61940602d18956fd87390c2d9e lib/unicore/extracted/DGeneralCategory.txt
 * d788b9362ec7681e98f8b9d6ef276546e1a6207dda05317ede55bd686b0940a9 lib/unicore/extracted/DJoinGroup.txt
 * ebbea3c93eeb7431378885aebac0490d77f6900239c9176f90b6fee030903d96 lib/unicore/extracted/DJoinType.txt
 * be0f129691d479aa38646e4ca0ec1ee576ae7f75b0300a5624a7fa862fa8abba lib/unicore/extracted/DLineBreak.txt
 * 92449d354d9f6b6f2f97a292ebb59f6344ffdeb83d120d7d23e569c43ba67cd5 lib/unicore/extracted/DNumType.txt
 * e3a319527153b0c6c0c549b40fc6f3a01a7a0dcd6620784391db25901df3b154 lib/unicore/extracted/DNumValues.txt
 * ba5b13123afb59ea004c14fcbac80b5ff428c5b8f1b84bf8602b4ffb7da0407f lib/unicore/mktables
 * 21653d2744fdd071f9ef138c805393901bb9547cf3e777ebf50215a191f986ea lib/unicore/version
 * 913d2f93f3cb6cdf1664db888bf840bc4eb074eef824e082fceda24a9445e60c regen/charset_translations.pl
 * 33533b773e8eb3486472ad21caf90221710a3e0eb12040cf1fd84c24ba53f2dc regen/mk_invlists.pl
 * 784929499a354028e04efcff331847d420beeca7f3f4f22569b59ec160924b72 regen/mph.pl
 * ex: set ro: */
