package PROP::Exception::Configuration;

use strict;
use base qw/PROP::Exception/;

1;

=head1 Name

PROP::Exception::Configuration

=head1 Synopsis

 unless(configured_correctly()) {
     my $msg = "somebody didn't configure the system correctly!";
     die new PROP::Exception::Configuration($msg);
 }

=head1 Description

This particular exception class is for indicating that the framework
was configured incorrectly somehow.  For example, an object table may
lack a primary key field, a link table might not have a dual primary
key, or connection information for a database handle was either wrong
or missing.
