package PROP::Exception::IllegalArgument;

use strict;
use base qw/PROP::Exception/;

sub new {
    my ($class, $msg) = @_;
    my ($pkg, $file, $line) = caller(1); # perspective of illegal invocation
    my $self = $class->SUPER::new($msg, $file, $line);
    return $self;
}

1;

=head1 Name

PROP::Exception::IllegalArgument

=head1 Synopsis

 sub foo {
     my ($arg1, $arg2) = @_;

     unless($arg1 > 3) {
         my $msg = "argh! you fool! arg1 must be greater than 3!";
	 die new PROP::Exception::IllegalArgument($msg);
     }

     unless(defined $arg2) {
         my $msg = "who said that a null arg2 was OK?  Not I!";
	 die new PROP::Exception::IllegalArgument($msg);
     }
 }

=head1 Description

This particular exception is for indicating that a subroutine was
passed an illegal value as a parameter.  Of note is that while most
other exceptions include call stack information from the point at
which the exception object was created, IllegalArgument exceptions
contain call stack information from the perspective of where the
subroutine was illegally invoked.
